
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * - Index : the index/sequence number for the item being associated- UkyId : the LREC Uky of the item being associated- New : the item being associated is new, and so the reference needs to be generated
 - Type : the association action should be applied to all items of the given type

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociationChildReferenceType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Index"/>
 *     &lt;xs:enumeration value="UkyId"/>
 *     &lt;xs:enumeration value="New"/>
 *     &lt;xs:enumeration value="Type"/>
 *     &lt;xs:enumeration value="Static"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum AssociationChildReferenceType implements Serializable {
    INDEX("Index"), UKY_ID("UkyId"), NEW("New"), TYPE("Type"), STATIC("Static");
    private final String value;

    private AssociationChildReferenceType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static AssociationChildReferenceType convert(String value) {
        for (AssociationChildReferenceType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
