
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociationHistoryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AssociationId"/>
 *     &lt;xs:element type="xs:string" name="HistoryAction"/>
 *     &lt;xs:element type="ns:HistoryAssociationElementType" name="HistoryAssociationElement"/>
 *     &lt;xs:element name="Passengers" minOccurs="0">
 *       &lt;!-- Reference to inner class Passengers -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:AssociationHistoryElement" name="AssociationParent" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:AssociationHistoryElement" name="AssociationChild" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AssociationHistoryType implements Serializable
{
    private String associationId;
    private String historyAction;
    private HistoryAssociationElementType historyAssociationElement;
    private Passengers passengers;
    private List<AssociationHistoryElement> associationParentList = new ArrayList<AssociationHistoryElement>();
    private AssociationHistoryElement associationChild;

    /** 
     * Get the 'AssociationId' element value.
     * 
     * @return value
     */
    public String getAssociationId() {
        return associationId;
    }

    /** 
     * Set the 'AssociationId' element value.
     * 
     * @param associationId
     */
    public void setAssociationId(String associationId) {
        this.associationId = associationId;
    }

    /** 
     * Get the 'HistoryAction' element value.
     * 
     * @return value
     */
    public String getHistoryAction() {
        return historyAction;
    }

    /** 
     * Set the 'HistoryAction' element value.
     * 
     * @param historyAction
     */
    public void setHistoryAction(String historyAction) {
        this.historyAction = historyAction;
    }

    /** 
     * Get the 'HistoryAssociationElement' element value.
     * 
     * @return value
     */
    public HistoryAssociationElementType getHistoryAssociationElement() {
        return historyAssociationElement;
    }

    /** 
     * Set the 'HistoryAssociationElement' element value.
     * 
     * @param historyAssociationElement
     */
    public void setHistoryAssociationElement(
            HistoryAssociationElementType historyAssociationElement) {
        this.historyAssociationElement = historyAssociationElement;
    }

    /** 
     * Get the 'Passengers' element value.
     * 
     * @return value
     */
    public Passengers getPassengers() {
        return passengers;
    }

    /** 
     * Set the 'Passengers' element value.
     * 
     * @param passengers
     */
    public void setPassengers(Passengers passengers) {
        this.passengers = passengers;
    }

    /** 
     * Get the list of 'AssociationParent' element items.
     * 
     * @return list
     */
    public List<AssociationHistoryElement> getAssociationParentList() {
        return associationParentList;
    }

    /** 
     * Set the list of 'AssociationParent' element items.
     * 
     * @param list
     */
    public void setAssociationParentList(List<AssociationHistoryElement> list) {
        associationParentList = list;
    }

    /** 
     * Get the 'AssociationChild' element value.
     * 
     * @return value
     */
    public AssociationHistoryElement getAssociationChild() {
        return associationChild;
    }

    /** 
     * Set the 'AssociationChild' element value.
     * 
     * @param associationChild
     */
    public void setAssociationChild(AssociationHistoryElement associationChild) {
        this.associationChild = associationChild;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Name" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Passengers implements Serializable
    {
        private List<String> nameList = new ArrayList<String>();

        /** 
         * Get the list of 'Name' element items.
         * 
         * @return list
         */
        public List<String> getNameList() {
            return nameList;
        }

        /** 
         * Set the list of 'Name' element items.
         * 
         * @param list
         */
        public void setNameList(List<String> list) {
            nameList = list;
        }
    }
}
