
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * - NameNumber e.g. 1.1, only type currently supported
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociationParentType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="NameNumber"/>
 *     &lt;xs:enumeration value="NameSeqId"/>
 *     &lt;xs:enumeration value="FOP"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum AssociationParentType implements Serializable {
    NAME_NUMBER("NameNumber"), NAME_SEQ_ID("NameSeqId"), FOP("FOP");
    private final String value;

    private AssociationParentType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static AssociationParentType convert(String value) {
        for (AssociationParentType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
