
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BSGHistoryType">
 *   &lt;xs:sequence>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BSGHistoryType implements Serializable
{
    private Choice choice;

    /** 
     * Get the 'BSGHistoryType' complexType value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the 'BSGHistoryType' complexType value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:BSGRefHistoryType" name="BSGReference" minOccurs="0"/>
     *   &lt;xs:element type="ns:BSGCounterHistoryType" name="BSGCounter" minOccurs="0"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int BSG_REFERENCE_CHOICE = 0;
        private static final int BSG_COUNTER_CHOICE = 1;
        private BSGRefHistoryType BSGReference;
        private BSGCounterHistoryType BSGCounter;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if BSGReference is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifBSGReference() {
            return choiceSelect == BSG_REFERENCE_CHOICE;
        }

        /** 
         * Get the 'BSGReference' element value.
         * 
         * @return value
         */
        public BSGRefHistoryType getBSGReference() {
            return BSGReference;
        }

        /** 
         * Set the 'BSGReference' element value.
         * 
         * @param BSGReference
         */
        public void setBSGReference(BSGRefHistoryType BSGReference) {
            setChoiceSelect(BSG_REFERENCE_CHOICE);
            this.BSGReference = BSGReference;
        }

        /** 
         * Check if BSGCounter is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifBSGCounter() {
            return choiceSelect == BSG_COUNTER_CHOICE;
        }

        /** 
         * Get the 'BSGCounter' element value.
         * 
         * @return value
         */
        public BSGCounterHistoryType getBSGCounter() {
            return BSGCounter;
        }

        /** 
         * Set the 'BSGCounter' element value.
         * 
         * @param BSGCounter
         */
        public void setBSGCounter(BSGCounterHistoryType BSGCounter) {
            setChoiceSelect(BSG_COUNTER_CHOICE);
            this.BSGCounter = BSGCounter;
        }
    }
}
