
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BasicAncillaryServicesDataGroup.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CommercialName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="RficCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="RficSubcode"/>
 *     &lt;xs:element type="xs:string" name="SSRCode" minOccurs="0"/>
 *     &lt;xs:choice>
 *       &lt;xs:element name="ProductTextDetails" minOccurs="0" maxOccurs="1">
 *         &lt;!-- Reference to inner class ProductTextDetails -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="xs:string" name="ProductText" minOccurs="0" maxOccurs="1"/>
 *     &lt;/xs:choice>
 *     &lt;xs:element type="xs:string" name="OwningCarrierCode"/>
 *     &lt;xs:element type="xs:string" name="SsimCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BookingIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Vendor" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="EMDType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="EMDNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="EMDCoupon" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ServiceFeeLineNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="DisplayOnlyIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ConsumptionIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PresentTo" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AtCity" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Endorsements" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="StationIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ServiceCity" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ServiceCityDestination" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ServiceType" minOccurs="0"/>
 *     &lt;xs:element name="RuleSet" minOccurs="0">
 *       &lt;!-- Reference to inner class RuleSet -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="AncillarySequenceNumber" minOccurs="0"/>
 *     &lt;xs:element name="OfferID" minOccurs="0">
 *       &lt;!-- Reference to inner class OfferID -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="OfferSnapId" minOccurs="0"/>
 *     &lt;xs:element name="OriginalPrice" minOccurs="0">
 *       &lt;!-- Reference to inner class OriginalPrice -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:group>
 * </pre>
 */
public class BasicAncillaryServicesDataGroupPNRB implements Serializable
{
    private String commercialName;
    private String rficCode;
    private String rficSubcode;
    private String SSRCode;
    private int choiceSelect = -1;
    private static final int PRODUCT_TEXT_DETAILS_CHOICE = 0;
    private static final int PRODUCT_TEXT_CHOICE = 1;
    private ProductTextDetails productTextDetails;
    private String productText;
    private String owningCarrierCode;
    private String ssimCode;
    private String bookingIndicator;
    private String vendor;
    private String EMDType;
    private String EMDNumber;
    private String EMDCoupon;
    private String serviceFeeLineNumber;
    private Boolean displayOnlyIndicator;
    private String consumptionIndicator;
    private String presentTo;
    private String atCity;
    private String endorsements;
    private String stationIndicator;
    private String serviceCity;
    private String serviceCityDestination;
    private String serviceType;
    private RuleSet ruleSet;
    private String ancillarySequenceNumber;
    private OfferID offerID;
    private String offerSnapId;
    private OriginalPrice originalPrice;

    /** 
     * Get the 'CommercialName' element value. Name of the ancillary service, e.g., Extra Blanket, EXIT ROW AISLE SEAT
                      
     * 
     * @return value
     */
    public String getCommercialName() {
        return commercialName;
    }

    /** 
     * Set the 'CommercialName' element value. Name of the ancillary service, e.g., Extra Blanket, EXIT ROW AISLE SEAT
                      
     * 
     * @param commercialName
     */
    public void setCommercialName(String commercialName) {
        this.commercialName = commercialName;
    }

    /** 
     * Get the 'RficCode' element value. RFIC Code of the service - indicates the reason of issuing the EMD
                          for the service associated to the RficSubcode. Ex."A"
                      
     * 
     * @return value
     */
    public String getRficCode() {
        return rficCode;
    }

    /** 
     * Set the 'RficCode' element value. RFIC Code of the service - indicates the reason of issuing the EMD
                          for the service associated to the RficSubcode. Ex."A"
                      
     * 
     * @param rficCode
     */
    public void setRficCode(String rficCode) {
        this.rficCode = rficCode;
    }

    /** 
     * Get the 'RficSubcode' element value. RFIC subcode of the service - used to identify the individual
                          ancillary service. Ex."0A8"
                      
     * 
     * @return value
     */
    public String getRficSubcode() {
        return rficSubcode;
    }

    /** 
     * Set the 'RficSubcode' element value. RFIC subcode of the service - used to identify the individual
                          ancillary service. Ex."0A8"
                      
     * 
     * @param rficSubcode
     */
    public void setRficSubcode(String rficSubcode) {
        this.rficSubcode = rficSubcode;
    }

    /** 
     * Get the 'SSRCode' element value. IATA-defined SSR code for the RficSubcode applicable to this record.
                      
     * 
     * @return value
     */
    public String getSSRCode() {
        return SSRCode;
    }

    /** 
     * Set the 'SSRCode' element value. IATA-defined SSR code for the RficSubcode applicable to this record.
                      
     * 
     * @param SSRCode
     */
    public void setSSRCode(String SSRCode) {
        this.SSRCode = SSRCode;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if ProductTextDetails is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProductTextDetails() {
        return choiceSelect == PRODUCT_TEXT_DETAILS_CHOICE;
    }

    /** 
     * Get the 'ProductTextDetails' element value.
     * 
     * @return value
     */
    public ProductTextDetails getProductTextDetails() {
        return productTextDetails;
    }

    /** 
     * Set the 'ProductTextDetails' element value.
     * 
     * @param productTextDetails
     */
    public void setProductTextDetails(ProductTextDetails productTextDetails) {
        setChoiceSelect(PRODUCT_TEXT_DETAILS_CHOICE);
        this.productTextDetails = productTextDetails;
    }

    /** 
     * Check if ProductText is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProductText() {
        return choiceSelect == PRODUCT_TEXT_CHOICE;
    }

    /** 
     * Get the 'ProductText' element value.
     * 
     * @return value
     */
    public String getProductText() {
        return productText;
    }

    /** 
     * Set the 'ProductText' element value.
     * 
     * @param productText
     */
    public void setProductText(String productText) {
        setChoiceSelect(PRODUCT_TEXT_CHOICE);
        this.productText = productText;
    }

    /** 
     * Get the 'OwningCarrierCode' element value. Carrier that owns the service. Ex."XX"
     * 
     * @return value
     */
    public String getOwningCarrierCode() {
        return owningCarrierCode;
    }

    /** 
     * Set the 'OwningCarrierCode' element value. Carrier that owns the service. Ex."XX"
     * 
     * @param owningCarrierCode
     */
    public void setOwningCarrierCode(String owningCarrierCode) {
        this.owningCarrierCode = owningCarrierCode;
    }

    /** 
     * Get the 'SsimCode' element value. Standard Schedules Information Manual (SSIM) code
     * 
     * @return value
     */
    public String getSsimCode() {
        return ssimCode;
    }

    /** 
     * Set the 'SsimCode' element value. Standard Schedules Information Manual (SSIM) code
     * 
     * @param ssimCode
     */
    public void setSsimCode(String ssimCode) {
        this.ssimCode = ssimCode;
    }

    /** 
     * Get the 'BookingIndicator' element value. Booking method requirement e.g. carrier must be contacted.
                          If blank then there is no specific booking requirement
                      
     * 
     * @return value
     */
    public String getBookingIndicator() {
        return bookingIndicator;
    }

    /** 
     * Set the 'BookingIndicator' element value. Booking method requirement e.g. carrier must be contacted.
                          If blank then there is no specific booking requirement
                      
     * 
     * @param bookingIndicator
     */
    public void setBookingIndicator(String bookingIndicator) {
        this.bookingIndicator = bookingIndicator;
    }

    /** 
     * Get the 'Vendor' element value. Indicates service provider like "AA" or "MMGR"(Merchandising manager. Ex."EY"
                      
     * 
     * @return value
     */
    public String getVendor() {
        return vendor;
    }

    /** 
     * Set the 'Vendor' element value. Indicates service provider like "AA" or "MMGR"(Merchandising manager. Ex."EY"
                      
     * 
     * @param vendor
     */
    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    /** 
     * Get the 'EMDType' element value. Type of EMD for the service associated to the "Rfic Subcode". Ex."2"
                      
     * 
     * @return value
     */
    public String getEMDType() {
        return EMDType;
    }

    /** 
     * Set the 'EMDType' element value. Type of EMD for the service associated to the "Rfic Subcode". Ex."2"
                      
     * 
     * @param EMDType
     */
    public void setEMDType(String EMDType) {
        this.EMDType = EMDType;
    }

    /** 
     * Get the 'EMDNumber' element value.
     * 
     * @return value
     */
    public String getEMDNumber() {
        return EMDNumber;
    }

    /** 
     * Set the 'EMDNumber' element value.
     * 
     * @param EMDNumber
     */
    public void setEMDNumber(String EMDNumber) {
        this.EMDNumber = EMDNumber;
    }

    /** 
     * Get the 'EMDCoupon' element value.
     * 
     * @return value
     */
    public String getEMDCoupon() {
        return EMDCoupon;
    }

    /** 
     * Set the 'EMDCoupon' element value.
     * 
     * @param EMDCoupon
     */
    public void setEMDCoupon(String EMDCoupon) {
        this.EMDCoupon = EMDCoupon;
    }

    /** 
     * Get the 'ServiceFeeLineNumber' element value. Line number of the service being reported.
     * 
     * @return value
     */
    public String getServiceFeeLineNumber() {
        return serviceFeeLineNumber;
    }

    /** 
     * Set the 'ServiceFeeLineNumber' element value. Line number of the service being reported.
     * 
     * @param serviceFeeLineNumber
     */
    public void setServiceFeeLineNumber(String serviceFeeLineNumber) {
        this.serviceFeeLineNumber = serviceFeeLineNumber;
    }

    /** 
     * Get the 'DisplayOnlyIndicator' element value. Data is for display purposes and cannot be sold.
     * 
     * @return value
     */
    public Boolean getDisplayOnlyIndicator() {
        return displayOnlyIndicator;
    }

    /** 
     * Set the 'DisplayOnlyIndicator' element value. Data is for display purposes and cannot be sold.
     * 
     * @param displayOnlyIndicator
     */
    public void setDisplayOnlyIndicator(Boolean displayOnlyIndicator) {
        this.displayOnlyIndicator = displayOnlyIndicator;
    }

    /** 
     * Get the 'ConsumptionIndicator' element value.
     * 
     * @return value
     */
    public String getConsumptionIndicator() {
        return consumptionIndicator;
    }

    /** 
     * Set the 'ConsumptionIndicator' element value.
     * 
     * @param consumptionIndicator
     */
    public void setConsumptionIndicator(String consumptionIndicator) {
        this.consumptionIndicator = consumptionIndicator;
    }

    /** 
     * Get the 'PresentTo' element value.
     * 
     * @return value
     */
    public String getPresentTo() {
        return presentTo;
    }

    /** 
     * Set the 'PresentTo' element value.
     * 
     * @param presentTo
     */
    public void setPresentTo(String presentTo) {
        this.presentTo = presentTo;
    }

    /** 
     * Get the 'AtCity' element value.
     * 
     * @return value
     */
    public String getAtCity() {
        return atCity;
    }

    /** 
     * Set the 'AtCity' element value.
     * 
     * @param atCity
     */
    public void setAtCity(String atCity) {
        this.atCity = atCity;
    }

    /** 
     * Get the 'Endorsements' element value.
     * 
     * @return value
     */
    public String getEndorsements() {
        return endorsements;
    }

    /** 
     * Set the 'Endorsements' element value.
     * 
     * @param endorsements
     */
    public void setEndorsements(String endorsements) {
        this.endorsements = endorsements;
    }

    /** 
     * Get the 'StationIndicator' element value.
     * 
     * @return value
     */
    public String getStationIndicator() {
        return stationIndicator;
    }

    /** 
     * Set the 'StationIndicator' element value.
     * 
     * @param stationIndicator
     */
    public void setStationIndicator(String stationIndicator) {
        this.stationIndicator = stationIndicator;
    }

    /** 
     * Get the 'ServiceCity' element value.
     * 
     * @return value
     */
    public String getServiceCity() {
        return serviceCity;
    }

    /** 
     * Set the 'ServiceCity' element value.
     * 
     * @param serviceCity
     */
    public void setServiceCity(String serviceCity) {
        this.serviceCity = serviceCity;
    }

    /** 
     * Get the 'ServiceCityDestination' element value. Destination city or off point, Ex “BLR”
     * 
     * @return value
     */
    public String getServiceCityDestination() {
        return serviceCityDestination;
    }

    /** 
     * Set the 'ServiceCityDestination' element value. Destination city or off point, Ex “BLR”
     * 
     * @param serviceCityDestination
     */
    public void setServiceCityDestination(String serviceCityDestination) {
        this.serviceCityDestination = serviceCityDestination;
    }

    /** 
     * Get the 'ServiceType' element value. Need to know the Service Type to e.g. 'A'llowance - indicate registered bag that
                          is part of allowance; 'C'harges; 'F'light Related; 'P'repaid
                      
     * 
     * @return value
     */
    public String getServiceType() {
        return serviceType;
    }

    /** 
     * Set the 'ServiceType' element value. Need to know the Service Type to e.g. 'A'llowance - indicate registered bag that
                          is part of allowance; 'C'harges; 'F'light Related; 'P'repaid
                      
     * 
     * @param serviceType
     */
    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    /** 
     * Get the 'RuleSet' element value.
     * 
     * @return value
     */
    public RuleSet getRuleSet() {
        return ruleSet;
    }

    /** 
     * Set the 'RuleSet' element value.
     * 
     * @param ruleSet
     */
    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    /** 
     * Get the 'AncillarySequenceNumber' element value. Ancillary sequence number. Maps to Ancillary/SequenceNumber in GAO
     * 
     * @return value
     */
    public String getAncillarySequenceNumber() {
        return ancillarySequenceNumber;
    }

    /** 
     * Set the 'AncillarySequenceNumber' element value. Ancillary sequence number. Maps to Ancillary/SequenceNumber in GAO
     * 
     * @param ancillarySequenceNumber
     */
    public void setAncillarySequenceNumber(String ancillarySequenceNumber) {
        this.ancillarySequenceNumber = ancillarySequenceNumber;
    }

    /** 
     * Get the 'OfferID' element value.
     * 
     * @return value
     */
    public OfferID getOfferID() {
        return offerID;
    }

    /** 
     * Set the 'OfferID' element value.
     * 
     * @param offerID
     */
    public void setOfferID(OfferID offerID) {
        this.offerID = offerID;
    }

    /** 
     * Get the 'OfferSnapId' element value. Identifies the permanent ancillary offer snapshot stored for Business
                          Intelligence purposes.
                      
     * 
     * @return value
     */
    public String getOfferSnapId() {
        return offerSnapId;
    }

    /** 
     * Set the 'OfferSnapId' element value. Identifies the permanent ancillary offer snapshot stored for Business
                          Intelligence purposes.
                      
     * 
     * @param offerSnapId
     */
    public void setOfferSnapId(String offerSnapId) {
        this.offerSnapId = offerSnapId;
    }

    /** 
     * Get the 'OriginalPrice' element value.
     * 
     * @return value
     */
    public OriginalPrice getOriginalPrice() {
        return originalPrice;
    }

    /** 
     * Set the 'OriginalPrice' element value.
     * 
     * @param originalPrice
     */
    public void setOriginalPrice(OriginalPrice originalPrice) {
        this.originalPrice = originalPrice;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProductTextDetails" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="ProductTextDetailsItem" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class ProductTextDetailsItem -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ProductTextDetails implements Serializable
    {
        private List<ProductTextDetailsItem> productTextDetailsItemList = new ArrayList<ProductTextDetailsItem>();

        /** 
         * Get the list of 'ProductTextDetailsItem' element items.
         * 
         * @return list
         */
        public List<ProductTextDetailsItem> getProductTextDetailsItemList() {
            return productTextDetailsItemList;
        }

        /** 
         * Set the list of 'ProductTextDetailsItem' element items.
         * 
         * @param list
         */
        public void setProductTextDetailsItemList(
                List<ProductTextDetailsItem> list) {
            productTextDetailsItemList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProductTextDetailsItem" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="ItemName"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="ItemValue"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ProductTextDetailsItem implements Serializable
        {
            private String itemName;
            private String itemValue;

            /** 
             * Get the 'ItemName' attribute value.
             * 
             * @return value
             */
            public String getItemName() {
                return itemName;
            }

            /** 
             * Set the 'ItemName' attribute value.
             * 
             * @param itemName
             */
            public void setItemName(String itemName) {
                this.itemName = itemName;
            }

            /** 
             * Get the 'ItemValue' attribute value.
             * 
             * @return value
             */
            public String getItemValue() {
                return itemValue;
            }

            /** 
             * Set the 'ItemValue' attribute value.
             * 
             * @param itemValue
             */
            public void setItemValue(String itemValue) {
                this.itemValue = itemValue;
            }
        }
    }
    /** 
     * Needed to keep track of companion benefits for example. Will come from the Rules
                          Processor
                      
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleSet" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="RuleName" minOccurs="0"/>
     *       &lt;xs:element name="Deal" minOccurs="0">
     *         &lt;!-- Reference to inner class Deal -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" name="RuleId"/>
     *     &lt;xs:attribute type="xs:string" default="DR" name="Source"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RuleSet implements Serializable
    {
        private String ruleName;
        private Deal deal;
        private String ruleId;
        private String source;

        /** 
         * Get the 'RuleName' element value.
         * 
         * @return value
         */
        public String getRuleName() {
            return ruleName;
        }

        /** 
         * Set the 'RuleName' element value.
         * 
         * @param ruleName
         */
        public void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        /** 
         * Get the 'Deal' element value.
         * 
         * @return value
         */
        public Deal getDeal() {
            return deal;
        }

        /** 
         * Set the 'Deal' element value.
         * 
         * @param deal
         */
        public void setDeal(Deal deal) {
            this.deal = deal;
        }

        /** 
         * Get the 'RuleId' attribute value.
         * 
         * @return value
         */
        public String getRuleId() {
            return ruleId;
        }

        /** 
         * Set the 'RuleId' attribute value.
         * 
         * @param ruleId
         */
        public void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        /** 
         * Get the 'Source' attribute value. Indicates an origin system that provides the rule
         * 
         * @return value
         */
        public String getSource() {
            return source;
        }

        /** 
         * Set the 'Source' attribute value. Indicates an origin system that provides the rule
         * 
         * @param source
         */
        public void setSource(String source) {
            this.source = source;
        }
        /** 
         * Information about applied discount/markup for this ancillary
                                    
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Deal" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:choice>
         *         &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
         *         &lt;xs:element name="Amount" minOccurs="0">
         *           &lt;!-- Reference to inner class Amount -->
         *         &lt;/xs:element>
         *       &lt;/xs:choice>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute use="required" name="type">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class Type -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Deal implements Serializable
        {
            private int choiceSelect = -1;
            private static final int PERCENTAGE_CHOICE = 0;
            private static final int AMOUNT_CHOICE = 1;
            private BigDecimal percentage;
            private Amount amount;
            private Type type;

            private void setChoiceSelect(int choice) {
                if (choiceSelect == -1) {
                    choiceSelect = choice;
                } else if (choiceSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearChoiceSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearChoiceSelect() {
                choiceSelect = -1;
            }

            /** 
             * Check if Percentage is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifPercentage() {
                return choiceSelect == PERCENTAGE_CHOICE;
            }

            /** 
             * Get the 'Percentage' element value. Percentage as defined in RULE for percentage
                                                          discounts/markups
                                                      
             * 
             * @return value
             */
            public BigDecimal getPercentage() {
                return percentage;
            }

            /** 
             * Set the 'Percentage' element value. Percentage as defined in RULE for percentage
                                                          discounts/markups
                                                      
             * 
             * @param percentage
             */
            public void setPercentage(BigDecimal percentage) {
                setChoiceSelect(PERCENTAGE_CHOICE);
                this.percentage = percentage;
            }

            /** 
             * Check if Amount is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifAmount() {
                return choiceSelect == AMOUNT_CHOICE;
            }

            /** 
             * Get the 'Amount' element value.
             * 
             * @return value
             */
            public Amount getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' element value.
             * 
             * @param amount
             */
            public void setAmount(Amount amount) {
                setChoiceSelect(AMOUNT_CHOICE);
                this.amount = amount;
            }

            /** 
             * Get the 'type' attribute value.
             * 
             * @return value
             */
            public Type getType() {
                return type;
            }

            /** 
             * Set the 'type' attribute value.
             * 
             * @param type
             */
            public void setType(Type type) {
                this.type = type;
            }
            /** 
             * Amount as defined in RULE for monetary
                                                          discounts/markups
                                                      
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amount" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:decimal">
             *         &lt;xs:attribute type="xs:string" name="currency"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Amount implements Serializable
            {
                private BigDecimal decimal;
                private String currency;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public BigDecimal getDecimal() {
                    return decimal;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param decimal
                 */
                public void setDecimal(BigDecimal decimal) {
                    this.decimal = decimal;
                }

                /** 
                 * Get the 'currency' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrency() {
                    return currency;
                }

                /** 
                 * Set the 'currency' attribute value.
                 * 
                 * @param currency
                 */
                public void setCurrency(String currency) {
                    this.currency = currency;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="DISCOUNT"/>
             *     &lt;xs:enumeration value="RISE"/>
             *     &lt;xs:enumeration value="OVERRIDE"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum Type implements Serializable {
                DISCOUNT, RISE, OVERRIDE
            }
        }
    }
    /** 
     * Offer Id from the offer store
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferID" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="OfferItemID" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" name="id"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OfferID implements Serializable
    {
        private String offerItemID;
        private String id;

        /** 
         * Get the 'OfferItemID' element value. Offer Item Id from the offer store
         * 
         * @return value
         */
        public String getOfferItemID() {
            return offerItemID;
        }

        /** 
         * Set the 'OfferItemID' element value. Offer Item Id from the offer store
         * 
         * @param offerItemID
         */
        public void setOfferItemID(String offerItemID) {
            this.offerItemID = offerItemID;
        }

        /** 
         * Get the 'id' attribute value. Maps to Offer Id from the offer store
         * 
         * @return value
         */
        public String getId() {
            return id;
        }

        /** 
         * Set the 'id' attribute value. Maps to Offer Id from the offer store
         * 
         * @param id
         */
        public void setId(String id) {
            this.id = id;
        }
    }
    /** 
     * Original Price from Pricing - will need to be persisted with the waiver code
                      
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginalPrice" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:decimal">
     *         &lt;xs:attribute type="xs:string" use="required" name="WaiverCode"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginalPrice implements Serializable
    {
        private BigDecimal decimal;
        private String waiverCode;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public BigDecimal getDecimal() {
            return decimal;
        }

        /** 
         * Set the extension value.
         * 
         * @param decimal
         */
        public void setDecimal(BigDecimal decimal) {
            this.decimal = decimal;
        }

        /** 
         * Get the 'WaiverCode' attribute value. To override the price, waiver code is required
                                        
         * 
         * @return value
         */
        public String getWaiverCode() {
            return waiverCode;
        }

        /** 
         * Set the 'WaiverCode' attribute value. To override the price, waiver code is required
                                        
         * 
         * @param waiverCode
         */
        public void setWaiverCode(String waiverCode) {
            this.waiverCode = waiverCode;
        }
    }
}
