
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BookingDetails.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Header" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="RecordLocator" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="CreationTimestamp" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="SystemCreationTimestamp" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CreationAgentID" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="UpdateTimestamp" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="PNRSequence" minOccurs="0"/>
 *     &lt;xs:element name="FlightsRange" minOccurs="0">
 *       &lt;!-- Reference to inner class FlightsRange -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ItineraryDate" minOccurs="0">
 *       &lt;!-- Reference to inner class ItineraryDate -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="DivideSplitDetails" minOccurs="0">
 *       &lt;!-- Reference to inner class DivideSplitDetails -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:dateTime" name="EstimatedPurgeTimestamp" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="UpdateToken" minOccurs="0"/>
 *     &lt;xs:element name="TravelPolicy" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class TravelPolicy -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:boolean" name="DisassociatedEMDPresent" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="PQExists" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="ACSIssuedBagTags" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="VeryImportantTraveler" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BookingDetailsPNRB implements Serializable
{
    private List<String> headerList = new ArrayList<String>();
    private String recordLocator;
    private Date creationTimestamp;
    private Date systemCreationTimestamp;
    private String creationAgentID;
    private Date updateTimestamp;
    private BigInteger PNRSequence;
    private FlightsRange flightsRange;
    private ItineraryDate itineraryDate;
    private DivideSplitDetails divideSplitDetails;
    private Date estimatedPurgeTimestamp;
    private String updateToken;
    private List<TravelPolicy> travelPolicyList = new ArrayList<TravelPolicy>();
    private Boolean disassociatedEMDPresent;
    private Boolean PQExists;
    private Boolean ACSIssuedBagTags;
    private Boolean veryImportantTraveler;

    /** 
     * Get the list of 'Header' element items.
     * 
     * @return list
     */
    public List<String> getHeaderList() {
        return headerList;
    }

    /** 
     * Set the list of 'Header' element items.
     * 
     * @param list
     */
    public void setHeaderList(List<String> list) {
        headerList = list;
    }

    /** 
     * Get the 'RecordLocator' element value. Sabre PNR Locator. Example "XBZVXW"
     * 
     * @return value
     */
    public String getRecordLocator() {
        return recordLocator;
    }

    /** 
     * Set the 'RecordLocator' element value. Sabre PNR Locator. Example "XBZVXW"
     * 
     * @param recordLocator
     */
    public void setRecordLocator(String recordLocator) {
        this.recordLocator = recordLocator;
    }

    /** 
     * Get the 'CreationTimestamp' element value. Date PNR created. Example "2013-07-16T05:06:00"
     * 
     * @return value
     */
    public Date getCreationTimestamp() {
        return creationTimestamp;
    }

    /** 
     * Set the 'CreationTimestamp' element value. Date PNR created. Example "2013-07-16T05:06:00"
     * 
     * @param creationTimestamp
     */
    public void setCreationTimestamp(Date creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    /** 
     * Get the 'SystemCreationTimestamp' element value. Sabre PNR Locator
     * 
     * @return value
     */
    public Date getSystemCreationTimestamp() {
        return systemCreationTimestamp;
    }

    /** 
     * Set the 'SystemCreationTimestamp' element value. Sabre PNR Locator
     * 
     * @param systemCreationTimestamp
     */
    public void setSystemCreationTimestamp(Date systemCreationTimestamp) {
        this.systemCreationTimestamp = systemCreationTimestamp;
    }

    /** 
     * Get the 'CreationAgentID' element value. Agent Sine of the creating agent/individual. Example "H6O/ SSR"
                      
     * 
     * @return value
     */
    public String getCreationAgentID() {
        return creationAgentID;
    }

    /** 
     * Set the 'CreationAgentID' element value. Agent Sine of the creating agent/individual. Example "H6O/ SSR"
                      
     * 
     * @param creationAgentID
     */
    public void setCreationAgentID(String creationAgentID) {
        this.creationAgentID = creationAgentID;
    }

    /** 
     * Get the 'UpdateTimestamp' element value. Date PNR was last filed in Sabre. Example "2013-07-16T05:06:45"
                      
     * 
     * @return value
     */
    public Date getUpdateTimestamp() {
        return updateTimestamp;
    }

    /** 
     * Set the 'UpdateTimestamp' element value. Date PNR was last filed in Sabre. Example "2013-07-16T05:06:45"
                      
     * 
     * @param updateTimestamp
     */
    public void setUpdateTimestamp(Date updateTimestamp) {
        this.updateTimestamp = updateTimestamp;
    }

    /** 
     * Get the 'PNRSequence' element value. PNR sequence number/counter increased with each PNR update. Example "28"
                      
     * 
     * @return value
     */
    public BigInteger getPNRSequence() {
        return PNRSequence;
    }

    /** 
     * Set the 'PNRSequence' element value. PNR sequence number/counter increased with each PNR update. Example "28"
                      
     * 
     * @param PNRSequence
     */
    public void setPNRSequence(BigInteger PNRSequence) {
        this.PNRSequence = PNRSequence;
    }

    /** 
     * Get the 'FlightsRange' element value.
     * 
     * @return value
     */
    public FlightsRange getFlightsRange() {
        return flightsRange;
    }

    /** 
     * Set the 'FlightsRange' element value.
     * 
     * @param flightsRange
     */
    public void setFlightsRange(FlightsRange flightsRange) {
        this.flightsRange = flightsRange;
    }

    /** 
     * Get the 'ItineraryDate' element value.
     * 
     * @return value
     */
    public ItineraryDate getItineraryDate() {
        return itineraryDate;
    }

    /** 
     * Set the 'ItineraryDate' element value.
     * 
     * @param itineraryDate
     */
    public void setItineraryDate(ItineraryDate itineraryDate) {
        this.itineraryDate = itineraryDate;
    }

    /** 
     * Get the 'DivideSplitDetails' element value.
     * 
     * @return value
     */
    public DivideSplitDetails getDivideSplitDetails() {
        return divideSplitDetails;
    }

    /** 
     * Set the 'DivideSplitDetails' element value.
     * 
     * @param divideSplitDetails
     */
    public void setDivideSplitDetails(DivideSplitDetails divideSplitDetails) {
        this.divideSplitDetails = divideSplitDetails;
    }

    /** 
     * Get the 'EstimatedPurgeTimestamp' element value. Estimated Date PNR will purge from Sabre. Example "2013-07-16T05:06:45"
                      
     * 
     * @return value
     */
    public Date getEstimatedPurgeTimestamp() {
        return estimatedPurgeTimestamp;
    }

    /** 
     * Set the 'EstimatedPurgeTimestamp' element value. Estimated Date PNR will purge from Sabre. Example "2013-07-16T05:06:45"
                      
     * 
     * @param estimatedPurgeTimestamp
     */
    public void setEstimatedPurgeTimestamp(Date estimatedPurgeTimestamp) {
        this.estimatedPurgeTimestamp = estimatedPurgeTimestamp;
    }

    /** 
     * Get the 'UpdateToken' element value.
     * 
     * @return value
     */
    public String getUpdateToken() {
        return updateToken;
    }

    /** 
     * Set the 'UpdateToken' element value.
     * 
     * @param updateToken
     */
    public void setUpdateToken(String updateToken) {
        this.updateToken = updateToken;
    }

    /** 
     * Get the list of 'TravelPolicy' element items.
     * 
     * @return list
     */
    public List<TravelPolicy> getTravelPolicyList() {
        return travelPolicyList;
    }

    /** 
     * Set the list of 'TravelPolicy' element items.
     * 
     * @param list
     */
    public void setTravelPolicyList(List<TravelPolicy> list) {
        travelPolicyList = list;
    }

    /** 
     * Get the 'DisassociatedEMDPresent' element value. Indicates if there are any disassociated EMDs present in PNR
     * 
     * @return value
     */
    public Boolean getDisassociatedEMDPresent() {
        return disassociatedEMDPresent;
    }

    /** 
     * Set the 'DisassociatedEMDPresent' element value. Indicates if there are any disassociated EMDs present in PNR
     * 
     * @param disassociatedEMDPresent
     */
    public void setDisassociatedEMDPresent(Boolean disassociatedEMDPresent) {
        this.disassociatedEMDPresent = disassociatedEMDPresent;
    }

    /** 
     * Get the 'PQExists' element value. Display PQExists = "true" or "false"
     * 
     * @return value
     */
    public Boolean getPQExists() {
        return PQExists;
    }

    /** 
     * Set the 'PQExists' element value. Display PQExists = "true" or "false"
     * 
     * @param PQExists
     */
    public void setPQExists(Boolean PQExists) {
        this.PQExists = PQExists;
    }

    /** 
     * Get the 'ACSIssuedBagTags' element value. Display ACSIssuedBagTags = "true" or "false" based on ACS issuing bag
     * 
     * @return value
     */
    public Boolean getACSIssuedBagTags() {
        return ACSIssuedBagTags;
    }

    /** 
     * Set the 'ACSIssuedBagTags' element value. Display ACSIssuedBagTags = "true" or "false" based on ACS issuing bag
     * 
     * @param ACSIssuedBagTags
     */
    public void setACSIssuedBagTags(Boolean ACSIssuedBagTags) {
        this.ACSIssuedBagTags = ACSIssuedBagTags;
    }

    /** 
     * Get the 'VeryImportantTraveler' element value. Display VeryImportantTraveler = "true" or "false" based on presence of frequent flyer
     * 
     * @return value
     */
    public Boolean getVeryImportantTraveler() {
        return veryImportantTraveler;
    }

    /** 
     * Set the 'VeryImportantTraveler' element value. Display VeryImportantTraveler = "true" or "false" based on presence of frequent flyer
     * 
     * @param veryImportantTraveler
     */
    public void setVeryImportantTraveler(Boolean veryImportantTraveler) {
        this.veryImportantTraveler = veryImportantTraveler;
    }
    /** 
     * represents a flights range as in the example: FlightsRange
                          End="2011-08-12T15:45:00" Start="2011-08-12T07:35:00"
                      
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightsRange" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:dateTime" use="optional" name="Start"/>
     *     &lt;xs:attribute type="xs:dateTime" use="optional" name="End"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FlightsRange implements Serializable
    {
        private Date start;
        private Date end;

        /** 
         * Get the 'Start' attribute value. Flight start date. Ex."2013-07-17T09:25:00"
         * 
         * @return value
         */
        public Date getStart() {
            return start;
        }

        /** 
         * Set the 'Start' attribute value. Flight start date. Ex."2013-07-17T09:25:00"
         * 
         * @param start
         */
        public void setStart(Date start) {
            this.start = start;
        }

        /** 
         * Get the 'End' attribute value. Flight end date. Ex."2013-07-17T09:25:00"
         * 
         * @return value
         */
        public Date getEnd() {
            return end;
        }

        /** 
         * Set the 'End' attribute value. Flight end date. Ex."2013-07-17T09:25:00"
         * 
         * @param end
         */
        public void setEnd(Date end) {
            this.end = end;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryDate" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:dateTime" use="optional" name="Start"/>
     *     &lt;xs:attribute type="xs:dateTime" use="optional" name="End"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ItineraryDate implements Serializable
    {
        private Date start;
        private Date end;

        /** 
         * Get the 'Start' attribute value.
         * 
         * @return value
         */
        public Date getStart() {
            return start;
        }

        /** 
         * Set the 'Start' attribute value.
         * 
         * @param start
         */
        public void setStart(Date start) {
            this.start = start;
        }

        /** 
         * Get the 'End' attribute value.
         * 
         * @return value
         */
        public Date getEnd() {
            return end;
        }

        /** 
         * Set the 'End' attribute value.
         * 
         * @param end
         */
        public void setEnd(Date end) {
            this.end = end;
        }
    }
    /** 
     * The original record information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DivideSplitDetails" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:choice minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Choice -->
     *       &lt;/xs:choice>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DivideSplitDetails implements Serializable
    {
        private List<Choice> choiceList = new ArrayList<Choice>();

        /** 
         * Get the list of 'DivideSplitDetails' element items.
         * 
         * @return list
         */
        public List<Choice> getChoiceList() {
            return choiceList;
        }

        /** 
         * Set the list of 'DivideSplitDetails' element items.
         * 
         * @param list
         */
        public void setChoiceList(List<Choice> list) {
            choiceList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:choice xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:element type="ns:DividedRemarkType" name="DividedRecord"/>
         *   &lt;xs:element type="ns:SplitFromRemarkType" name="SplitFromRecord"/>
         *   &lt;xs:element type="ns:SplitToRemarkType" name="SplitToRecord"/>
         * &lt;/xs:choice>
         * </pre>
         */
        public static class Choice implements Serializable
        {
            private int choiceListSelect = -1;
            private static final int DIVIDED_RECORD_CHOICE = 0;
            private static final int SPLIT_FROM_RECORD_CHOICE = 1;
            private static final int SPLIT_TO_RECORD_CHOICE = 2;
            private DividedRemarkType dividedRecord;
            private SplitFromRemarkType splitFromRecord;
            private SplitToRemarkType splitToRecord;

            private void setChoiceListSelect(int choice) {
                if (choiceListSelect == -1) {
                    choiceListSelect = choice;
                } else if (choiceListSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearChoiceListSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearChoiceListSelect() {
                choiceListSelect = -1;
            }

            /** 
             * Check if DividedRecord is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifDividedRecord() {
                return choiceListSelect == DIVIDED_RECORD_CHOICE;
            }

            /** 
             * Get the 'DividedRecord' element value.
             * 
             * @return value
             */
            public DividedRemarkType getDividedRecord() {
                return dividedRecord;
            }

            /** 
             * Set the 'DividedRecord' element value.
             * 
             * @param dividedRecord
             */
            public void setDividedRecord(DividedRemarkType dividedRecord) {
                setChoiceListSelect(DIVIDED_RECORD_CHOICE);
                this.dividedRecord = dividedRecord;
            }

            /** 
             * Check if SplitFromRecord is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifSplitFromRecord() {
                return choiceListSelect == SPLIT_FROM_RECORD_CHOICE;
            }

            /** 
             * Get the 'SplitFromRecord' element value. Indicates if divided from another PNR
             * 
             * @return value
             */
            public SplitFromRemarkType getSplitFromRecord() {
                return splitFromRecord;
            }

            /** 
             * Set the 'SplitFromRecord' element value. Indicates if divided from another PNR
             * 
             * @param splitFromRecord
             */
            public void setSplitFromRecord(SplitFromRemarkType splitFromRecord) {
                setChoiceListSelect(SPLIT_FROM_RECORD_CHOICE);
                this.splitFromRecord = splitFromRecord;
            }

            /** 
             * Check if SplitToRecord is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifSplitToRecord() {
                return choiceListSelect == SPLIT_TO_RECORD_CHOICE;
            }

            /** 
             * Get the 'SplitToRecord' element value. The new record type to which pax is splited.
             * 
             * @return value
             */
            public SplitToRemarkType getSplitToRecord() {
                return splitToRecord;
            }

            /** 
             * Set the 'SplitToRecord' element value. The new record type to which pax is splited.
             * 
             * @param splitToRecord
             */
            public void setSplitToRecord(SplitToRemarkType splitToRecord) {
                setChoiceListSelect(SPLIT_TO_RECORD_CHOICE);
                this.splitToRecord = splitToRecord;
            }
        }
    }
    /** 
     * "TravelPolicy" is used to return the Travel Policy associated with the record if applicable.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelPolicy" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" name="id"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TravelPolicy implements Serializable
    {
        private String string;
        private String id;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'id' attribute value.
         * 
         * @return value
         */
        public String getId() {
            return id;
        }

        /** 
         * Set the 'id' attribute value.
         * 
         * @param id
         */
        public void setId(String id) {
            this.id = id;
        }
    }
}
