
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarrierRefundItem.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:choice>
 *       &lt;xs:element type="xs:string" name="CarrierRecordLocator" maxOccurs="unbounded"/>
 *       &lt;xs:element type="ns:SegmentSubset" name="SegmentSubset"/>
 *     &lt;/xs:choice>
 *     &lt;xs:element type="xs:string" name="PaymentAuthorizationCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CarrierRefundItemPNRB implements Serializable
{
    private int choiceSelect = -1;
    private static final int CARRIER_RECORD_LOCATOR_LIST_CHOICE = 0;
    private static final int SEGMENT_SUBSET_CHOICE = 1;
    private List<String> carrierRecordLocatorList = new ArrayList<String>();
    private SegmentSubset segmentSubset;
    private String paymentAuthorizationCode;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if CarrierRecordLocatorList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCarrierRecordLocatorList() {
        return choiceSelect == CARRIER_RECORD_LOCATOR_LIST_CHOICE;
    }

    /** 
     * Get the list of 'CarrierRecordLocator' element items. Determines which segments will be refunded
     * 
     * @return list
     */
    public List<String> getCarrierRecordLocatorList() {
        return carrierRecordLocatorList;
    }

    /** 
     * Set the list of 'CarrierRecordLocator' element items. Determines which segments will be refunded
     * 
     * @param list
     */
    public void setCarrierRecordLocatorList(List<String> list) {
        setChoiceSelect(CARRIER_RECORD_LOCATOR_LIST_CHOICE);
        carrierRecordLocatorList = list;
    }

    /** 
     * Check if SegmentSubset is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSegmentSubset() {
        return choiceSelect == SEGMENT_SUBSET_CHOICE;
    }

    /** 
     * Get the 'SegmentSubset' element value. Tries to refund all possible segments
     * 
     * @return value
     */
    public SegmentSubset getSegmentSubset() {
        return segmentSubset;
    }

    /** 
     * Set the 'SegmentSubset' element value. Tries to refund all possible segments
     * 
     * @param segmentSubset
     */
    public void setSegmentSubset(SegmentSubset segmentSubset) {
        setChoiceSelect(SEGMENT_SUBSET_CHOICE);
        this.segmentSubset = segmentSubset;
    }

    /** 
     * Get the 'PaymentAuthorizationCode' element value. Code needed to handle payment processing
     * 
     * @return value
     */
    public String getPaymentAuthorizationCode() {
        return paymentAuthorizationCode;
    }

    /** 
     * Set the 'PaymentAuthorizationCode' element value. Code needed to handle payment processing
     * 
     * @param paymentAuthorizationCode
     */
    public void setPaymentAuthorizationCode(String paymentAuthorizationCode) {
        this.paymentAuthorizationCode = paymentAuthorizationCode;
    }
}
