
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Change Number in Party.
 Used when the user wants to increase or reduce the number of passengers in a PNR.
 *NewNbrInParty (mandatory element)
 Contains the desired passenger count; 0-99 are valid.
 *SegmentNumber (optional element(s)). Default is to update all flights in the PNR.
 This is not valid on retrieved PNRs, only on a new PNR that has not been ended yet.
 Each contains an air segment number, to be updated. Used when the itinerary segments
 contain different passenger counts; 1-99 are valid.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ChangeNbrInPartyType.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:integer" name="NewNbrInParty" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:integer" name="SegmentNumber" minOccurs="0" maxOccurs="99"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ChangeNbrInPartyTypePNRB implements Serializable
{
    private BigInteger newNbrInParty;
    private List<BigInteger> segmentNumberList = new ArrayList<BigInteger>();

    /** 
     * Get the 'NewNbrInParty' element value.
     * 
     * @return value
     */
    public BigInteger getNewNbrInParty() {
        return newNbrInParty;
    }

    /** 
     * Set the 'NewNbrInParty' element value.
     * 
     * @param newNbrInParty
     */
    public void setNewNbrInParty(BigInteger newNbrInParty) {
        this.newNbrInParty = newNbrInParty;
    }

    /** 
     * Get the list of 'SegmentNumber' element items.
     * 
     * @return list
     */
    public List<BigInteger> getSegmentNumberList() {
        return segmentNumberList;
    }

    /** 
     * Set the list of 'SegmentNumber' element items.
     * 
     * @param list
     */
    public void setSegmentNumberList(List<BigInteger> list) {
        segmentNumberList = list;
    }
}
