
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Formats for FOP:

 * Form of payment B Number - BSP Netherlands only

 5-(FOP entry).B(number) 5-CHEQUE.B12345

 * add cash FOP

 5-CASH

 * add check FOP

 5-CHECK 5-CK 5-CHEQUE

 * add credit card FOP that generates an approval

 5-*(credit card code)(credit card number)‡(2-digit month
 of exp)(2-digit year of exp) 5-*AX1234567890123456‡XX/XX

 * suppress credit card number on invoice with form of
 payment in remarKs

 5-*(credit card code)(credit card #)‡(2-digit month of
 exp)/(2-digit year of ex)-XN
 5-*AX1234567890123456‡XX/XX-XN

 * add credit card form of payment that does not generate
 an approval

 5-(credit card code)(credit card #)‡(2-digit month of
 exp)/(2-digit year of exp) 5-AX1234567890123456‡XX/XX

 * add credit card with extended payment

 5-*(credit card code)(credit card number)‡(2-digit month
 of exp)/(2-digit year of exp)*(extendede payment entry
 if applicable)

 5-*AX1234567890123456‡XX/XX*E

 * add credit card with card security code

 5-*(credit card code)(credit card number)‡(2-digit month
 of exp)/(2-digit year of exp)(*extended payment entry if
 applicable)‡CSC/(2 letter airline code)
 5-*AX1234567890123456‡XX/XX‡1234/AL

 * add GTR

 5-GR‡(GTR entry) 5-GR‡K19876543002

 * add GTR when using it as a form of payment for travel
 on Delta airlines and you issue the ticket
 electronically

 5-GR(one letter followed by up to seven numbers)
 5-GRD9999999

 * delete form of payment

 5(line number)¤ 51¤

 * modify FOP

 5(line #)¤-(new FOP entry) 51¤-*AX1234567890123456‡XX/XX

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CreditCardPayment.PNRB">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:Payment.PNRB">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="CreditCardNumber" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="CreditCardCode" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="ExpirationMonth" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="ExpirationYear" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="CSC" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="AirlineCode" minOccurs="0"/>
 *         &lt;xs:element type="xs:boolean" name="RequestApprovalCode" minOccurs="0"/>
 *         &lt;xs:element type="xs:integer" name="MonthsExtendedPayments" minOccurs="0"/>
 *         &lt;xs:element type="ns:CardHolderInfo.PNRB" name="CardHolderInfo" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="xs:string" use="optional" name="ShortText"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CreditCardPaymentPNRB extends PaymentPNRB implements Serializable
{
    private String creditCardNumber;
    private String creditCardCode;
    private String expirationMonth;
    private String expirationYear;
    private String CSC;
    private String airlineCode;
    private Boolean requestApprovalCode;
    private BigInteger monthsExtendedPayments;
    private CardHolderInfoPNRB cardHolderInfo;
    private String shortText;

    /** 
     * Get the 'CreditCardNumber' element value. do not enter spaces
     * 
     * @return value
     */
    public String getCreditCardNumber() {
        return creditCardNumber;
    }

    /** 
     * Set the 'CreditCardNumber' element value. do not enter spaces
     * 
     * @param creditCardNumber
     */
    public void setCreditCardNumber(String creditCardNumber) {
        this.creditCardNumber = creditCardNumber;
    }

    /** 
     * Get the 'CreditCardCode' element value. the code for the appropriate credit card company
     * 
     * @return value
     */
    public String getCreditCardCode() {
        return creditCardCode;
    }

    /** 
     * Set the 'CreditCardCode' element value. the code for the appropriate credit card company
     * 
     * @param creditCardCode
     */
    public void setCreditCardCode(String creditCardCode) {
        this.creditCardCode = creditCardCode;
    }

    /** 
     * Get the 'ExpirationMonth' element value.
     * 
     * @return value
     */
    public String getExpirationMonth() {
        return expirationMonth;
    }

    /** 
     * Set the 'ExpirationMonth' element value.
     * 
     * @param expirationMonth
     */
    public void setExpirationMonth(String expirationMonth) {
        this.expirationMonth = expirationMonth;
    }

    /** 
     * Get the 'ExpirationYear' element value.
     * 
     * @return value
     */
    public String getExpirationYear() {
        return expirationYear;
    }

    /** 
     * Set the 'ExpirationYear' element value.
     * 
     * @param expirationYear
     */
    public void setExpirationYear(String expirationYear) {
        this.expirationYear = expirationYear;
    }

    /** 
     * Get the 'CSC' element value.
     * 
     * @return value
     */
    public String getCSC() {
        return CSC;
    }

    /** 
     * Set the 'CSC' element value.
     * 
     * @param CSC
     */
    public void setCSC(String CSC) {
        this.CSC = CSC;
    }

    /** 
     * Get the 'AirlineCode' element value.
     * 
     * @return value
     */
    public String getAirlineCode() {
        return airlineCode;
    }

    /** 
     * Set the 'AirlineCode' element value.
     * 
     * @param airlineCode
     */
    public void setAirlineCode(String airlineCode) {
        this.airlineCode = airlineCode;
    }

    /** 
     * Get the 'RequestApprovalCode' element value. causes credit card form of payment to
                                  make a request for approval. The sabre
                                  system will request verification of the
                                  card and a validation check of the
                                  expiration date. this must be set to
                                  true for credit card masking to work.
                              
     * 
     * @return value
     */
    public Boolean getRequestApprovalCode() {
        return requestApprovalCode;
    }

    /** 
     * Set the 'RequestApprovalCode' element value. causes credit card form of payment to
                                  make a request for approval. The sabre
                                  system will request verification of the
                                  card and a validation check of the
                                  expiration date. this must be set to
                                  true for credit card masking to work.
                              
     * 
     * @param requestApprovalCode
     */
    public void setRequestApprovalCode(Boolean requestApprovalCode) {
        this.requestApprovalCode = requestApprovalCode;
    }

    /** 
     * Get the 'MonthsExtendedPayments' element value.
     * 
     * @return value
     */
    public BigInteger getMonthsExtendedPayments() {
        return monthsExtendedPayments;
    }

    /** 
     * Set the 'MonthsExtendedPayments' element value.
     * 
     * @param monthsExtendedPayments
     */
    public void setMonthsExtendedPayments(BigInteger monthsExtendedPayments) {
        this.monthsExtendedPayments = monthsExtendedPayments;
    }

    /** 
     * Get the 'CardHolderInfo' element value.
     * 
     * @return value
     */
    public CardHolderInfoPNRB getCardHolderInfo() {
        return cardHolderInfo;
    }

    /** 
     * Set the 'CardHolderInfo' element value.
     * 
     * @param cardHolderInfo
     */
    public void setCardHolderInfo(CardHolderInfoPNRB cardHolderInfo) {
        this.cardHolderInfo = cardHolderInfo;
    }

    /** 
     * Get the 'ShortText' attribute value.
     * 
     * @return value
     */
    public String getShortText() {
        return shortText;
    }

    /** 
     * Set the 'ShortText' attribute value.
     * 
     * @param shortText
     */
    public void setShortText(String shortText) {
        this.shortText = shortText;
    }
}
