
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;

/** 
 * Formats:

 3DOCO(segment number)/(place of
 birth)/(document
 type)/(document number)/ (visa place of issue)/(visa
 issue date)/(visa applicable country)/ (lap child
 indicator)-(pnr
 name number)

 * enter visa info 3DOCO2/LYON FR/V/789789/PARIS
 FR/14JUN2005/CH-2.1

 * enter visa info, but omit place of birth
 3DOCO1//V/789789/HOUSTON/14JUN04/USA

 * enter only the place of birth
 (no other visa info is
 expected) 3DOCO1/MANCHESTER-1.1

 * omit visa
 info 3DOCO2/MUNICH/////2.1

 NOTE: If you omit the doc type in the
 entry, you must
 include the place of birth

 * enter visa info with
 multiple segment selection
 3DOCO1,3-5/MUNICH/V/789789/HOUSTON/14JUN04/USA

 * delete a DOCO entry
 3(line/item #)¤ 37¤

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DOCOEntry.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="PlaceOfBirth" minOccurs="0"/>
 *     &lt;xs:element name="DocumentType" minOccurs="0">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class DocumentType -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="DocumentNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="VisaPlaceOfIssue" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="VisaIssueDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="VisaApplicableCountry" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="LapChild" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FreeText" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ActionCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="NumberInParty" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="ns:RequestType.PNRB" name="type"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:string" name="RPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DOCOEntryPNRB implements Serializable
{
    private String placeOfBirth;
    private DocumentType documentType;
    private String documentNumber;
    private String visaPlaceOfIssue;
    private Date visaIssueDate;
    private String visaApplicableCountry;
    private Boolean lapChild;
    private String freeText;
    private String actionCode;
    private BigInteger numberInParty;
    private String id;
    private RequestTypePNRB type;
    private OperationTypePNRB op;
    private String RPH;

    /** 
     * Get the 'PlaceOfBirth' element value. 2-35 chars
     * 
     * @return value
     */
    public String getPlaceOfBirth() {
        return placeOfBirth;
    }

    /** 
     * Set the 'PlaceOfBirth' element value. 2-35 chars
     * 
     * @param placeOfBirth
     */
    public void setPlaceOfBirth(String placeOfBirth) {
        this.placeOfBirth = placeOfBirth;
    }

    /** 
     * Get the 'DocumentType' element value. if included the only valid option is V (visa)TODO - add explanation as to why this can only be a V and what source states
                          this
                      
     * 
     * @return value
     */
    public DocumentType getDocumentType() {
        return documentType;
    }

    /** 
     * Set the 'DocumentType' element value. if included the only valid option is V (visa)TODO - add explanation as to why this can only be a V and what source states
                          this
                      
     * 
     * @param documentType
     */
    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }

    /** 
     * Get the 'DocumentNumber' element value. max 15 chars
     * 
     * @return value
     */
    public String getDocumentNumber() {
        return documentNumber;
    }

    /** 
     * Set the 'DocumentNumber' element value. max 15 chars
     * 
     * @param documentNumber
     */
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    /** 
     * Get the 'VisaPlaceOfIssue' element value. max 35 chars
     * 
     * @return value
     */
    public String getVisaPlaceOfIssue() {
        return visaPlaceOfIssue;
    }

    /** 
     * Set the 'VisaPlaceOfIssue' element value. max 35 chars
     * 
     * @param visaPlaceOfIssue
     */
    public void setVisaPlaceOfIssue(String visaPlaceOfIssue) {
        this.visaPlaceOfIssue = visaPlaceOfIssue;
    }

    /** 
     * Get the 'VisaIssueDate' element value. ddmmmyy or ddmmmyyyy
     * 
     * @return value
     */
    public Date getVisaIssueDate() {
        return visaIssueDate;
    }

    /** 
     * Set the 'VisaIssueDate' element value. ddmmmyy or ddmmmyyyy
     * 
     * @param visaIssueDate
     */
    public void setVisaIssueDate(Date visaIssueDate) {
        this.visaIssueDate = visaIssueDate;
    }

    /** 
     * Get the 'VisaApplicableCountry' element value. 2 or 3 chars
     * 
     * @return value
     */
    public String getVisaApplicableCountry() {
        return visaApplicableCountry;
    }

    /** 
     * Set the 'VisaApplicableCountry' element value. 2 or 3 chars
     * 
     * @param visaApplicableCountry
     */
    public void setVisaApplicableCountry(String visaApplicableCountry) {
        this.visaApplicableCountry = visaApplicableCountry;
    }

    /** 
     * Get the 'LapChild' element value. this would be an "I" in the TPC
                          command
                      
     * 
     * @return value
     */
    public Boolean getLapChild() {
        return lapChild;
    }

    /** 
     * Set the 'LapChild' element value. this would be an "I" in the TPC
                          command
                      
     * 
     * @param lapChild
     */
    public void setLapChild(Boolean lapChild) {
        this.lapChild = lapChild;
    }

    /** 
     * Get the 'FreeText' element value.
     * 
     * @return value
     */
    public String getFreeText() {
        return freeText;
    }

    /** 
     * Set the 'FreeText' element value.
     * 
     * @param freeText
     */
    public void setFreeText(String freeText) {
        this.freeText = freeText;
    }

    /** 
     * Get the 'ActionCode' element value.
     * 
     * @return value
     */
    public String getActionCode() {
        return actionCode;
    }

    /** 
     * Set the 'ActionCode' element value.
     * 
     * @param actionCode
     */
    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    /** 
     * Get the 'NumberInParty' element value.
     * 
     * @return value
     */
    public BigInteger getNumberInParty() {
        return numberInParty;
    }

    /** 
     * Set the 'NumberInParty' element value.
     * 
     * @param numberInParty
     */
    public void setNumberInParty(BigInteger numberInParty) {
        this.numberInParty = numberInParty;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'type' attribute value. A = AFAX G = GFAX
     * 
     * @return value
     */
    public RequestTypePNRB getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. A = AFAX G = GFAX
     * 
     * @param type
     */
    public void setType(RequestTypePNRB type) {
        this.type = type;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="V"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum DocumentType implements Serializable {
        V
    }
}
