
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;

/** 
 * Formats:

 3DOCS(segment number)/(doc type)/(doc
 issue
 country)/(doc #)/(doc nationality country)/
 (DOB)/(gender)/(doc
 exp date)/(last name)/(first
 name)/(middle name or initial)/ H-(pnr
 name number)

 * enter passport, or other various document types, and
 associated info
 3DOCS2/P/FR/123456789/FR/14AUG1947/M/30SEP2011/DELACROIX/DANIEL/STEPHANE/H-2.1

 NOTE: You cannot include Visa information with this
 format; you must
 use the DOCO formats for Visa

 * enter passenger info with multiple
 segment selection
 3DOCS1,3/P/DE/09876543211234/DE/25APR1949/F/04JUL2009/NGUYEN/LAN/M-3.1

 * enter passenger info, indicating a multiple passenger
 passport with
 a middle initial
 3DOCS/P/US/93845039290293/US/26FEB1974/M/10OCT2010/ENGLISH/MICHAEL/R/H-1.1

 * enter the passenger info using mandatory fields only
 3DOCS/P/US/2345928398234/US/12JUN1948/F/01JAN2011/SMITH
 JONES/JANICE-1

 * delete a DOCS entry 3 (line/item)¤ 37¤

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DOCSEntry.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DocumentType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CountryOfIssue" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DocumentNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DocumentNationalityCountry" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="DateOfBirth" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Gender" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="DocumentExpirationDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Surname" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Forename" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MiddleName" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="PrimaryHolder" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FreeText" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ActionCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="NumberInParty" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="VendorCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="ns:RequestType.PNRB" name="type"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:string" name="RPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DOCSEntryPNRB implements Serializable
{
    private String documentType;
    private String countryOfIssue;
    private String documentNumber;
    private String documentNationalityCountry;
    private Date dateOfBirth;
    private String gender;
    private Date documentExpirationDate;
    private String surname;
    private String forename;
    private String middleName;
    private Boolean primaryHolder;
    private String freeText;
    private String actionCode;
    private BigInteger numberInParty;
    private String vendorCode;
    private String id;
    private RequestTypePNRB type;
    private OperationTypePNRB op;
    private String RPH;

    /** 
     * Get the 'DocumentType' element value. Code indicating the type of document the passenger is using for identification
                          purposes. Ex."P"
                      
     * 
     * @return value
     */
    public String getDocumentType() {
        return documentType;
    }

    /** 
     * Set the 'DocumentType' element value. Code indicating the type of document the passenger is using for identification
                          purposes. Ex."P"
                      
     * 
     * @param documentType
     */
    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    /** 
     * Get the 'CountryOfIssue' element value. either 2 or 3 chars
     * 
     * @return value
     */
    public String getCountryOfIssue() {
        return countryOfIssue;
    }

    /** 
     * Set the 'CountryOfIssue' element value. either 2 or 3 chars
     * 
     * @param countryOfIssue
     */
    public void setCountryOfIssue(String countryOfIssue) {
        this.countryOfIssue = countryOfIssue;
    }

    /** 
     * Get the 'DocumentNumber' element value. max 15 chars
     * 
     * @return value
     */
    public String getDocumentNumber() {
        return documentNumber;
    }

    /** 
     * Set the 'DocumentNumber' element value. max 15 chars
     * 
     * @param documentNumber
     */
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    /** 
     * Get the 'DocumentNationalityCountry' element value.
     * 
     * @return value
     */
    public String getDocumentNationalityCountry() {
        return documentNationalityCountry;
    }

    /** 
     * Set the 'DocumentNationalityCountry' element value.
     * 
     * @param documentNationalityCountry
     */
    public void setDocumentNationalityCountry(String documentNationalityCountry) {
        this.documentNationalityCountry = documentNationalityCountry;
    }

    /** 
     * Get the 'DateOfBirth' element value. format ddmmmyyyy or ddmmmyy
     * 
     * @return value
     */
    public Date getDateOfBirth() {
        return dateOfBirth;
    }

    /** 
     * Set the 'DateOfBirth' element value. format ddmmmyyyy or ddmmmyy
     * 
     * @param dateOfBirth
     */
    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    /** 
     * Get the 'Gender' element value. M = Male F = Female X = unspecified gender MI = Male traveling with an
                          infant FI = Female traveling with an infant  U = Unknown at the time of booking, 
    					UI = Unknown at the time of booking for Infant, A-Z gender values
                      
     * 
     * @return value
     */
    public String getGender() {
        return gender;
    }

    /** 
     * Set the 'Gender' element value. M = Male F = Female X = unspecified gender MI = Male traveling with an
                          infant FI = Female traveling with an infant  U = Unknown at the time of booking, 
    					UI = Unknown at the time of booking for Infant, A-Z gender values
                      
     * 
     * @param gender
     */
    public void setGender(String gender) {
        this.gender = gender;
    }

    /** 
     * Get the 'DocumentExpirationDate' element value. format ddmmmyyyy or ddmmmyy
     * 
     * @return value
     */
    public Date getDocumentExpirationDate() {
        return documentExpirationDate;
    }

    /** 
     * Set the 'DocumentExpirationDate' element value. format ddmmmyyyy or ddmmmyy
     * 
     * @param documentExpirationDate
     */
    public void setDocumentExpirationDate(Date documentExpirationDate) {
        this.documentExpirationDate = documentExpirationDate;
    }

    /** 
     * Get the 'Surname' element value. max 30 chars
     * 
     * @return value
     */
    public String getSurname() {
        return surname;
    }

    /** 
     * Set the 'Surname' element value. max 30 chars
     * 
     * @param surname
     */
    public void setSurname(String surname) {
        this.surname = surname;
    }

    /** 
     * Get the 'Forename' element value. max 30 chars
     * 
     * @return value
     */
    public String getForename() {
        return forename;
    }

    /** 
     * Set the 'Forename' element value. max 30 chars
     * 
     * @param forename
     */
    public void setForename(String forename) {
        this.forename = forename;
    }

    /** 
     * Get the 'MiddleName' element value. max 30 chars
     * 
     * @return value
     */
    public String getMiddleName() {
        return middleName;
    }

    /** 
     * Set the 'MiddleName' element value. max 30 chars
     * 
     * @param middleName
     */
    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    /** 
     * Get the 'PrimaryHolder' element value. indicates if this document belongs to a passenger other than the passenger
                          for whom the SSR is being sent. Ex."FALSE"
                      
     * 
     * @return value
     */
    public Boolean getPrimaryHolder() {
        return primaryHolder;
    }

    /** 
     * Set the 'PrimaryHolder' element value. indicates if this document belongs to a passenger other than the passenger
                          for whom the SSR is being sent. Ex."FALSE"
                      
     * 
     * @param primaryHolder
     */
    public void setPrimaryHolder(Boolean primaryHolder) {
        this.primaryHolder = primaryHolder;
    }

    /** 
     * Get the 'FreeText' element value.
     * 
     * @return value
     */
    public String getFreeText() {
        return freeText;
    }

    /** 
     * Set the 'FreeText' element value.
     * 
     * @param freeText
     */
    public void setFreeText(String freeText) {
        this.freeText = freeText;
    }

    /** 
     * Get the 'ActionCode' element value. Indication of the status of the SSR notification.
                          A value of 'HK' indicates the intended carrier has received the message and has confirmed its
                          contents. Ex."HK"
                      
     * 
     * @return value
     */
    public String getActionCode() {
        return actionCode;
    }

    /** 
     * Set the 'ActionCode' element value. Indication of the status of the SSR notification.
                          A value of 'HK' indicates the intended carrier has received the message and has confirmed its
                          contents. Ex."HK"
                      
     * 
     * @param actionCode
     */
    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    /** 
     * Get the 'NumberInParty' element value. Number of passengers for whom the Special Service Request is being requested.
                          Ex."1"
                      
     * 
     * @return value
     */
    public BigInteger getNumberInParty() {
        return numberInParty;
    }

    /** 
     * Set the 'NumberInParty' element value. Number of passengers for whom the Special Service Request is being requested.
                          Ex."1"
                      
     * 
     * @param numberInParty
     */
    public void setNumberInParty(BigInteger numberInParty) {
        this.numberInParty = numberInParty;
    }

    /** 
     * Get the 'VendorCode' element value. Carrier OSI/SSR is being sent to. Ex."EY"
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' element value. Carrier OSI/SSR is being sent to. Ex."EY"
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'type' attribute value. A = AFAX G = GFAX
     * 
     * @return value
     */
    public RequestTypePNRB getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. A = AFAX G = GFAX
     * 
     * @param type
     */
    public void setType(RequestTypePNRB type) {
        this.type = type;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
}
