
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * * a max of 999 emails are allowed in a PNR * you
 cannot
 use an underscore character. if one is \ present it
 needs to be
 replaced by two = (e.g., ==). this can only
 be used before the @
 sign. * to enter an apostrophe
 change it to a / * max num of chars is
 63 in a PNR

 The email formats are:

 * add email address
 PE‡(email@address)‡

 PE‡ajtestcompany@test.com‡

 * add email address
 with name select

 PE‡(email@address)‡-(name
 #),(name #)
 PE‡ajtestcompany@test.com‡-1.1,2.1

 * add email address
 with additional
 data

 PE‡(email@address.com)‡(optional entries)
 PE‡ajtestcompany@test.com‡FR/CHAD KIRIBATI

 (there are several notes
 in format finder regarding this
 entry)

 * create a custom subj line for
 the email msg:

 5V‡SL-(free text) 5V‡SL-YOUR REVISED RESERVATION FOR
 18JUN

 NOTE: free text limited one line of 65 chars

 * include free text
 in email msg

 5V‡EM-(free text) 5V‡EM-JUANITA - PLEASE CALL ME AS SOON
 AS YOU GET THIS EMAIL.

 NOTE: can include 3 lines of free text, each
 line
 limited to 65 chars

 * modify passenger email info

 PE(line #)¤‡(new
 email info)‡ PE2¤‡john_smith@ibm.com‡

 NOTE: line # is opt if only one
 email address line

 * delete a single email address

 PE(line #)¤ PE1¤

 NOTE: line # is opt if only one email address line

 * delete multiple
 email addresses PE(line #),(line
 #),(line #)¤ PE1,3,4¤

 * delete
 multiple email address fields PE(line #)-(line
 #)¤ PE1-4¤

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EmailAddressDataGroup.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Address" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Comment" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OverrideFrom" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:group>
 * </pre>
 */
public class EmailAddressDataGroupPNRB implements Serializable
{
    private String address;
    private String comment;
    private String overrideFrom;

    /** 
     * Get the 'Address' element value. max 63 chars
     * 
     * @return value
     */
    public String getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value. max 63 chars
     * 
     * @param address
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /** 
     * Get the 'Comment' element value. max 63 chars
     * 
     * @return value
     */
    public String getComment() {
        return comment;
    }

    /** 
     * Set the 'Comment' element value. max 63 chars
     * 
     * @param comment
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    /** 
     * Get the 'OverrideFrom' element value.
     * 
     * @return value
     */
    public String getOverrideFrom() {
        return overrideFrom;
    }

    /** 
     * Set the 'OverrideFrom' element value.
     * 
     * @param overrideFrom
     */
    public void setOverrideFrom(String overrideFrom) {
        this.overrideFrom = overrideFrom;
    }
}
