
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBreakdown">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:PassengerQuantity">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="FareBasisCode" minOccurs="0" maxOccurs="unbounded"/>
 *         &lt;xs:element type="xs:string" name="FareCalc" minOccurs="0" maxOccurs="unbounded"/>
 *         &lt;xs:element name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class FlightSegment -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="FareComponent" minOccurs="0" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class FareComponent -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="PassengerTypeRequested" minOccurs="0" maxOccurs="1">
 *           &lt;!-- Reference to inner class PassengerTypeRequested -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="PassengerTypePriced" minOccurs="0" maxOccurs="1">
 *           &lt;!-- Reference to inner class PassengerTypePriced -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareBreakdown extends PassengerQuantity implements Serializable
{
    private List<String> fareBasisCodeList = new ArrayList<String>();
    private List<String> fareCalcList = new ArrayList<String>();
    private List<FlightSegment> flightSegmentList = new ArrayList<FlightSegment>();
    private List<FareComponent> fareComponentList = new ArrayList<FareComponent>();
    private PassengerTypeRequested passengerTypeRequested;
    private PassengerTypePriced passengerTypePriced;

    /** 
     * Get the list of 'FareBasisCode' element items. FBC.
     * 
     * @return list
     */
    public List<String> getFareBasisCodeList() {
        return fareBasisCodeList;
    }

    /** 
     * Set the list of 'FareBasisCode' element items. FBC.
     * 
     * @param list
     */
    public void setFareBasisCodeList(List<String> list) {
        fareBasisCodeList = list;
    }

    /** 
     * Get the list of 'FareCalc' element items. Fare calculation.
     * 
     * @return list
     */
    public List<String> getFareCalcList() {
        return fareCalcList;
    }

    /** 
     * Set the list of 'FareCalc' element items. Fare calculation.
     * 
     * @param list
     */
    public void setFareCalcList(List<String> list) {
        fareCalcList = list;
    }

    /** 
     * Get the list of 'FlightSegment' element items.
     * 
     * @return list
     */
    public List<FlightSegment> getFlightSegmentList() {
        return flightSegmentList;
    }

    /** 
     * Set the list of 'FlightSegment' element items.
     * 
     * @param list
     */
    public void setFlightSegmentList(List<FlightSegment> list) {
        flightSegmentList = list;
    }

    /** 
     * Get the list of 'FareComponent' element items.
     * 
     * @return list
     */
    public List<FareComponent> getFareComponentList() {
        return fareComponentList;
    }

    /** 
     * Set the list of 'FareComponent' element items.
     * 
     * @param list
     */
    public void setFareComponentList(List<FareComponent> list) {
        fareComponentList = list;
    }

    /** 
     * Get the 'PassengerTypeRequested' element value.
     * 
     * @return value
     */
    public PassengerTypeRequested getPassengerTypeRequested() {
        return passengerTypeRequested;
    }

    /** 
     * Set the 'PassengerTypeRequested' element value.
     * 
     * @param passengerTypeRequested
     */
    public void setPassengerTypeRequested(
            PassengerTypeRequested passengerTypeRequested) {
        this.passengerTypeRequested = passengerTypeRequested;
    }

    /** 
     * Get the 'PassengerTypePriced' element value.
     * 
     * @return value
     */
    public PassengerTypePriced getPassengerTypePriced() {
        return passengerTypePriced;
    }

    /** 
     * Set the 'PassengerTypePriced' element value.
     * 
     * @param passengerTypePriced
     */
    public void setPassengerTypePriced(PassengerTypePriced passengerTypePriced) {
        this.passengerTypePriced = passengerTypePriced;
    }
    /** 
     * Flight segment.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence minOccurs="0">
     *       &lt;!-- Reference to inner class Sequence -->
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:anySimpleType" name="RPH"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FlightSegment implements Serializable
    {
        private Sequence departureDateTime;
        private String RPH;

        /** 
         * Get the sequence value.
         * 
         * @return value
         */
        public Sequence getDepartureDateTime() {
            return departureDateTime;
        }

        /** 
         * Set the sequence value.
         * 
         * @param departureDateTime
         */
        public void setDepartureDateTime(Sequence departureDateTime) {
            this.departureDateTime = departureDateTime;
        }

        /** 
         * Get the 'RPH' attribute value. RPH.
         * 
         * @return value
         */
        public String getRPH() {
            return RPH;
        }

        /** 
         * Set the 'RPH' attribute value. RPH.
         * 
         * @param RPH
         */
        public void setRPH(String RPH) {
            this.RPH = RPH;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:sequence xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
         *   &lt;xs:element type="xs:string" name="DepartureDateTime" minOccurs="0"/>
         *   &lt;xs:element type="xs:string" name="ResBookDesigCode" minOccurs="0"/>
         *   &lt;xs:element type="xs:string" name="FlightNumber" minOccurs="0"/>
         *   &lt;xs:element type="xs:string" name="ActionCode" minOccurs="0"/>
         *   &lt;xs:element type="xs:string" name="FlightType" minOccurs="0"/>
         *   &lt;xs:element type="ns:Airport" name="AirPort" minOccurs="0"/>
         *   &lt;xs:element type="xs:string" name="OperatingAirline" minOccurs="0"/>
         *   &lt;xs:element type="xs:string" name="FareBasisCode" minOccurs="0"/>
         *   &lt;xs:element type="ns:ValidityDates" name="ValidityDates" minOccurs="0"/>
         *   &lt;xs:element type="ns:BaggageAllowance" name="BaggageAllowance" minOccurs="0"/>
         * &lt;/xs:sequence>
         * </pre>
         */
        public static class Sequence implements Serializable
        {
            private String departureDateTime;
            private String resBookDesigCode;
            private String flightNumber;
            private String actionCode;
            private String flightType;
            private Airport airPort;
            private String operatingAirline;
            private String fareBasisCode;
            private ValidityDates validityDates;
            private BaggageAllowance baggageAllowance;

            /** 
             * Get the 'DepartureDateTime' element value. Departure date and time.
             * 
             * @return value
             */
            public String getDepartureDateTime() {
                return departureDateTime;
            }

            /** 
             * Set the 'DepartureDateTime' element value. Departure date and time.
             * 
             * @param departureDateTime
             */
            public void setDepartureDateTime(String departureDateTime) {
                this.departureDateTime = departureDateTime;
            }

            /** 
             * Get the 'ResBookDesigCode' element value. Designator code.
             * 
             * @return value
             */
            public String getResBookDesigCode() {
                return resBookDesigCode;
            }

            /** 
             * Set the 'ResBookDesigCode' element value. Designator code.
             * 
             * @param resBookDesigCode
             */
            public void setResBookDesigCode(String resBookDesigCode) {
                this.resBookDesigCode = resBookDesigCode;
            }

            /** 
             * Get the 'FlightNumber' element value.
             * 
             * @return value
             */
            public String getFlightNumber() {
                return flightNumber;
            }

            /** 
             * Set the 'FlightNumber' element value.
             * 
             * @param flightNumber
             */
            public void setFlightNumber(String flightNumber) {
                this.flightNumber = flightNumber;
            }

            /** 
             * Get the 'ActionCode' element value. Indication of the status of the SSR notification.
                                                  A value of 'HK' indicates the intended carrier has received the.
                                              
             * 
             * @return value
             */
            public String getActionCode() {
                return actionCode;
            }

            /** 
             * Set the 'ActionCode' element value. Indication of the status of the SSR notification.
                                                  A value of 'HK' indicates the intended carrier has received the.
                                              
             * 
             * @param actionCode
             */
            public void setActionCode(String actionCode) {
                this.actionCode = actionCode;
            }

            /** 
             * Get the 'FlightType' element value. Flight type.
             * 
             * @return value
             */
            public String getFlightType() {
                return flightType;
            }

            /** 
             * Set the 'FlightType' element value. Flight type.
             * 
             * @param flightType
             */
            public void setFlightType(String flightType) {
                this.flightType = flightType;
            }

            /** 
             * Get the 'AirPort' element value.
             * 
             * @return value
             */
            public Airport getAirPort() {
                return airPort;
            }

            /** 
             * Set the 'AirPort' element value.
             * 
             * @param airPort
             */
            public void setAirPort(Airport airPort) {
                this.airPort = airPort;
            }

            /** 
             * Get the 'OperatingAirline' element value. Operating airline code.
             * 
             * @return value
             */
            public String getOperatingAirline() {
                return operatingAirline;
            }

            /** 
             * Set the 'OperatingAirline' element value. Operating airline code.
             * 
             * @param operatingAirline
             */
            public void setOperatingAirline(String operatingAirline) {
                this.operatingAirline = operatingAirline;
            }

            /** 
             * Get the 'FareBasisCode' element value. FBC.
             * 
             * @return value
             */
            public String getFareBasisCode() {
                return fareBasisCode;
            }

            /** 
             * Set the 'FareBasisCode' element value. FBC.
             * 
             * @param fareBasisCode
             */
            public void setFareBasisCode(String fareBasisCode) {
                this.fareBasisCode = fareBasisCode;
            }

            /** 
             * Get the 'ValidityDates' element value. Validity dates.
             * 
             * @return value
             */
            public ValidityDates getValidityDates() {
                return validityDates;
            }

            /** 
             * Set the 'ValidityDates' element value. Validity dates.
             * 
             * @param validityDates
             */
            public void setValidityDates(ValidityDates validityDates) {
                this.validityDates = validityDates;
            }

            /** 
             * Get the 'BaggageAllowance' element value.
             * 
             * @return value
             */
            public BaggageAllowance getBaggageAllowance() {
                return baggageAllowance;
            }

            /** 
             * Set the 'BaggageAllowance' element value.
             * 
             * @param baggageAllowance
             */
            public void setBaggageAllowance(BaggageAllowance baggageAllowance) {
                this.baggageAllowance = baggageAllowance;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareComponent" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Location" minOccurs="0">
     *         &lt;!-- Reference to inner class Location -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Dates" minOccurs="0">
     *         &lt;!-- Reference to inner class Dates -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FlightSegmentNumbers" minOccurs="0">
     *         &lt;!-- Reference to inner class FlightSegmentNumbers -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="FareBasisCode"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="FareDirectionality"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="TicketDesignator"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="GoverningCarrier"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="FareComponentNumber"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareComponent implements Serializable
    {
        private Location location;
        private Dates dates;
        private FlightSegmentNumbers flightSegmentNumbers;
        private String fareBasisCode;
        private String fareDirectionality;
        private String amount;
        private String ticketDesignator;
        private String governingCarrier;
        private String fareComponentNumber;

        /** 
         * Get the 'Location' element value.
         * 
         * @return value
         */
        public Location getLocation() {
            return location;
        }

        /** 
         * Set the 'Location' element value.
         * 
         * @param location
         */
        public void setLocation(Location location) {
            this.location = location;
        }

        /** 
         * Get the 'Dates' element value.
         * 
         * @return value
         */
        public Dates getDates() {
            return dates;
        }

        /** 
         * Set the 'Dates' element value.
         * 
         * @param dates
         */
        public void setDates(Dates dates) {
            this.dates = dates;
        }

        /** 
         * Get the 'FlightSegmentNumbers' element value.
         * 
         * @return value
         */
        public FlightSegmentNumbers getFlightSegmentNumbers() {
            return flightSegmentNumbers;
        }

        /** 
         * Set the 'FlightSegmentNumbers' element value.
         * 
         * @param flightSegmentNumbers
         */
        public void setFlightSegmentNumbers(
                FlightSegmentNumbers flightSegmentNumbers) {
            this.flightSegmentNumbers = flightSegmentNumbers;
        }

        /** 
         * Get the 'FareBasisCode' attribute value. 
                                            "FareBasisCode" is used to return Fare Basis Code for particular Fare Component.
                                        
         * 
         * @return value
         */
        public String getFareBasisCode() {
            return fareBasisCode;
        }

        /** 
         * Set the 'FareBasisCode' attribute value. 
                                            "FareBasisCode" is used to return Fare Basis Code for particular Fare Component.
                                        
         * 
         * @param fareBasisCode
         */
        public void setFareBasisCode(String fareBasisCode) {
            this.fareBasisCode = fareBasisCode;
        }

        /** 
         * Get the 'FareDirectionality' attribute value. 
                                            "FareDirectionality" is used to return directionality of the fare ("FROM" or
                                            "TO").
                                        
         * 
         * @return value
         */
        public String getFareDirectionality() {
            return fareDirectionality;
        }

        /** 
         * Set the 'FareDirectionality' attribute value. 
                                            "FareDirectionality" is used to return directionality of the fare ("FROM" or
                                            "TO").
                                        
         * 
         * @param fareDirectionality
         */
        public void setFareDirectionality(String fareDirectionality) {
            this.fareDirectionality = fareDirectionality;
        }

        /** 
         * Get the 'Amount' attribute value. 
                                            "Amount" is used to return NUC amount for particular Fare Component.
                                        
         * 
         * @return value
         */
        public String getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' attribute value. 
                                            "Amount" is used to return NUC amount for particular Fare Component.
                                        
         * 
         * @param amount
         */
        public void setAmount(String amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'TicketDesignator' attribute value. 
                                            "TicketDesignator" is used to return Ticket Designator Code attached to Fare
                                            Basis Code.
                                        
         * 
         * @return value
         */
        public String getTicketDesignator() {
            return ticketDesignator;
        }

        /** 
         * Set the 'TicketDesignator' attribute value. 
                                            "TicketDesignator" is used to return Ticket Designator Code attached to Fare
                                            Basis Code.
                                        
         * 
         * @param ticketDesignator
         */
        public void setTicketDesignator(String ticketDesignator) {
            this.ticketDesignator = ticketDesignator;
        }

        /** 
         * Get the 'GoverningCarrier' attribute value. 
                                            "GoverningCarrier" is used to return Governing Carrier Code e.g. EY, AA, LH.
                                        
         * 
         * @return value
         */
        public String getGoverningCarrier() {
            return governingCarrier;
        }

        /** 
         * Set the 'GoverningCarrier' attribute value. 
                                            "GoverningCarrier" is used to return Governing Carrier Code e.g. EY, AA, LH.
                                        
         * 
         * @param governingCarrier
         */
        public void setGoverningCarrier(String governingCarrier) {
            this.governingCarrier = governingCarrier;
        }

        /** 
         * Get the 'FareComponentNumber' attribute value. 
                                            "FareComponentNumber" is used to display number of fare component stored in PQ.
                                        
         * 
         * @return value
         */
        public String getFareComponentNumber() {
            return fareComponentNumber;
        }

        /** 
         * Set the 'FareComponentNumber' attribute value. 
                                            "FareComponentNumber" is used to display number of fare component stored in PQ.
                                        
         * 
         * @param fareComponentNumber
         */
        public void setFareComponentNumber(String fareComponentNumber) {
            this.fareComponentNumber = fareComponentNumber;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Location" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Origin"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Destination"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Location implements Serializable
        {
            private String origin;
            private String destination;

            /** 
             * Get the 'Origin' attribute value. 
                                                          "Origin" is used to return first city of particular Fare Component.
                                                      
             * 
             * @return value
             */
            public String getOrigin() {
                return origin;
            }

            /** 
             * Set the 'Origin' attribute value. 
                                                          "Origin" is used to return first city of particular Fare Component.
                                                      
             * 
             * @param origin
             */
            public void setOrigin(String origin) {
                this.origin = origin;
            }

            /** 
             * Get the 'Destination' attribute value. 
                                                          "Destination" is used to return last city of particular Fare
                                                          Component.
                                                      
             * 
             * @return value
             */
            public String getDestination() {
                return destination;
            }

            /** 
             * Set the 'Destination' attribute value. 
                                                          "Destination" is used to return last city of particular Fare
                                                          Component.
                                                      
             * 
             * @param destination
             */
            public void setDestination(String destination) {
                this.destination = destination;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Dates" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ArrivalDateTime"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Dates implements Serializable
        {
            private String departureDateTime;
            private String arrivalDateTime;

            /** 
             * Get the 'DepartureDateTime' attribute value. 
                                                          "DepartureDateTime" is used to return date and time for departure
                                                          from first city of Fare component.
                                                      
             * 
             * @return value
             */
            public String getDepartureDateTime() {
                return departureDateTime;
            }

            /** 
             * Set the 'DepartureDateTime' attribute value. 
                                                          "DepartureDateTime" is used to return date and time for departure
                                                          from first city of Fare component.
                                                      
             * 
             * @param departureDateTime
             */
            public void setDepartureDateTime(String departureDateTime) {
                this.departureDateTime = departureDateTime;
            }

            /** 
             * Get the 'ArrivalDateTime' attribute value. 
                                                          "ArrivalDateTime" is used to return date and time for arrival to
                                                          last city of Fare component.
                                                      
             * 
             * @return value
             */
            public String getArrivalDateTime() {
                return arrivalDateTime;
            }

            /** 
             * Set the 'ArrivalDateTime' attribute value. 
                                                          "ArrivalDateTime" is used to return date and time for arrival to
                                                          last city of Fare component.
                                                      
             * 
             * @param arrivalDateTime
             */
            public void setArrivalDateTime(String arrivalDateTime) {
                this.arrivalDateTime = arrivalDateTime;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegmentNumbers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="FlightSegmentNumber" minOccurs="0" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightSegmentNumbers implements Serializable
        {
            private List<String> flightSegmentNumberList = new ArrayList<String>();

            /** 
             * Get the list of 'FlightSegmentNumber' element items. 
                                                              "FlightSegmentNumber" is used to display flight segments number
                                                              covered by this particular fare component.
                                                          
             * 
             * @return list
             */
            public List<String> getFlightSegmentNumberList() {
                return flightSegmentNumberList;
            }

            /** 
             * Set the list of 'FlightSegmentNumber' element items. 
                                                              "FlightSegmentNumber" is used to display flight segments number
                                                              covered by this particular fare component.
                                                          
             * 
             * @param list
             */
            public void setFlightSegmentNumberList(List<String> list) {
                flightSegmentNumberList = list;
            }
        }
    }
    /** 
     * Original Passenger Type
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerTypeRequested" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="Code"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PassengerTypeRequested implements Serializable
    {
        private String code;

        /** 
         * Get the 'Code' attribute value.
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' attribute value.
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }
    }
    /** 
     * Priced Passenger Type
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerTypePriced" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="Code"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PassengerTypePriced implements Serializable
    {
        private String code;

        /** 
         * Get the 'Code' attribute value.
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' attribute value.
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }
    }
}
