
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FileInfo.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="File" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class File -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FileInfoPNRB implements Serializable
{
    private List<File> fileList = new ArrayList<File>();

    /** 
     * Get the list of 'File' element items.
     * 
     * @return list
     */
    public List<File> getFileList() {
        return fileList;
    }

    /** 
     * Set the list of 'File' element items.
     * 
     * @param list
     */
    public void setFileList(List<File> list) {
        fileList = list;
    }
    /** 
     * "File" is used to return the file name/identifier
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="File" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" use="optional" name="ProductCode"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class File implements Serializable
    {
        private String string;
        private String productCode;
        private String RPH;
        private String id;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'ProductCode' attribute value. "ProductCode" is used to return the product code.
         * 
         * @return value
         */
        public String getProductCode() {
            return productCode;
        }

        /** 
         * Set the 'ProductCode' attribute value. "ProductCode" is used to return the product code.
         * 
         * @param productCode
         */
        public void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        /** 
         * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                                            in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                                        
         * 
         * @return value
         */
        public String getRPH() {
            return RPH;
        }

        /** 
         * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                                            in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                                        
         * 
         * @param RPH
         */
        public void setRPH(String RPH) {
            this.RPH = RPH;
        }

        /** 
         * Get the 'Id' attribute value.
         * 
         * @return value
         */
        public String getId() {
            return id;
        }

        /** 
         * Set the 'Id' attribute value.
         * 
         * @param id
         */
        public void setId(String id) {
            this.id = id;
        }
    }
}
