
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Schedule Change “From” flight data that is stored in the new PRS 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FormerFlight.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CarrierCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FlightNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="FlightDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BoardPoint" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FormerFlightPNRB implements Serializable
{
    private String carrierCode;
    private String flightNumber;
    private Date flightDate;
    private String boardPoint;

    /** 
     * Get the 'CarrierCode' element value. Preferred format for airline codes. Structure is 2 upper case alpha-numeric characters
                          followed by an optional uppercase letter.
                      
     * 
     * @return value
     */
    public String getCarrierCode() {
        return carrierCode;
    }

    /** 
     * Set the 'CarrierCode' element value. Preferred format for airline codes. Structure is 2 upper case alpha-numeric characters
                          followed by an optional uppercase letter.
                      
     * 
     * @param carrierCode
     */
    public void setCarrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
    }

    /** 
     * Get the 'FlightNumber' element value. The flight number of the associated flight. Ex."0002"
     * 
     * @return value
     */
    public String getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' element value. The flight number of the associated flight. Ex."0002"
     * 
     * @param flightNumber
     */
    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }

    /** 
     * Get the 'FlightDate' element value. Date that service starts for the flight. Ex."2013-07-29"
     * 
     * @return value
     */
    public Date getFlightDate() {
        return flightDate;
    }

    /** 
     * Set the 'FlightDate' element value. Date that service starts for the flight. Ex."2013-07-29"
     * 
     * @param flightDate
     */
    public void setFlightDate(Date flightDate) {
        this.flightDate = flightDate;
    }

    /** 
     * Get the 'BoardPoint' element value.
     * 
     * @return value
     */
    public String getBoardPoint() {
        return boardPoint;
    }

    /** 
     * Set the 'BoardPoint' element value.
     * 
     * @param boardPoint
     */
    public void setBoardPoint(String boardPoint) {
        this.boardPoint = boardPoint;
    }
}
