
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * There should only be one form of payment. However,
 if
 there are more than one then the first one will be used
 by the
 host. The exception to that rule is if there is a
 credit card FOP
 present then it will be used no matter
 when it is entered.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FormsOfPayment.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CreditCardPayment.PNRB" name="CreditCardPayment" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:Payment.PNRB" name="CashPayment" minOccurs="0"/>
 *     &lt;xs:element type="ns:Payment.PNRB" name="CheckPayment" minOccurs="0"/>
 *     &lt;xs:element type="ns:OtherPayment.PNRB" name="OtherPayment" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:BNumberPayment.PNRB" name="BNumberPayment" minOccurs="0"/>
 *     &lt;xs:element type="ns:GTRPayment.PNRB" name="GTRPayment" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FormsOfPaymentPNRB implements Serializable
{
    private List<CreditCardPaymentPNRB> creditCardPaymentList = new ArrayList<CreditCardPaymentPNRB>();
    private PaymentPNRB cashPayment;
    private PaymentPNRB checkPayment;
    private List<OtherPaymentPNRB> otherPaymentList = new ArrayList<OtherPaymentPNRB>();
    private BNumberPaymentPNRB BNumberPayment;
    private GTRPaymentPNRB GTRPayment;

    /** 
     * Get the list of 'CreditCardPayment' element items. CC payment
     * 
     * @return list
     */
    public List<CreditCardPaymentPNRB> getCreditCardPaymentList() {
        return creditCardPaymentList;
    }

    /** 
     * Set the list of 'CreditCardPayment' element items. CC payment
     * 
     * @param list
     */
    public void setCreditCardPaymentList(List<CreditCardPaymentPNRB> list) {
        creditCardPaymentList = list;
    }

    /** 
     * Get the 'CashPayment' element value. Cash payment
     * 
     * @return value
     */
    public PaymentPNRB getCashPayment() {
        return cashPayment;
    }

    /** 
     * Set the 'CashPayment' element value. Cash payment
     * 
     * @param cashPayment
     */
    public void setCashPayment(PaymentPNRB cashPayment) {
        this.cashPayment = cashPayment;
    }

    /** 
     * Get the 'CheckPayment' element value. Check payment
     * 
     * @return value
     */
    public PaymentPNRB getCheckPayment() {
        return checkPayment;
    }

    /** 
     * Set the 'CheckPayment' element value. Check payment
     * 
     * @param checkPayment
     */
    public void setCheckPayment(PaymentPNRB checkPayment) {
        this.checkPayment = checkPayment;
    }

    /** 
     * Get the list of 'OtherPayment' element items. Other payment
     * 
     * @return list
     */
    public List<OtherPaymentPNRB> getOtherPaymentList() {
        return otherPaymentList;
    }

    /** 
     * Set the list of 'OtherPayment' element items. Other payment
     * 
     * @param list
     */
    public void setOtherPaymentList(List<OtherPaymentPNRB> list) {
        otherPaymentList = list;
    }

    /** 
     * Get the 'BNumberPayment' element value. BNumber payment
     * 
     * @return value
     */
    public BNumberPaymentPNRB getBNumberPayment() {
        return BNumberPayment;
    }

    /** 
     * Set the 'BNumberPayment' element value. BNumber payment
     * 
     * @param BNumberPayment
     */
    public void setBNumberPayment(BNumberPaymentPNRB BNumberPayment) {
        this.BNumberPayment = BNumberPayment;
    }

    /** 
     * Get the 'GTRPayment' element value. GTR payment
     * 
     * @return value
     */
    public GTRPaymentPNRB getGTRPayment() {
        return GTRPayment;
    }

    /** 
     * Set the 'GTRPayment' element value. GTR payment
     * 
     * @param GTRPayment
     */
    public void setGTRPayment(GTRPaymentPNRB GTRPayment) {
        this.GTRPayment = GTRPayment;
    }
}
