
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Ticket arrangement, today's date

 7TAW/

 Future ticketing date for Queue 9 placement date format
 (ddmmm) 7TAW(date)/

 7TAW26MAR

 * future ticketing date - queue 9 placement, branch
 7TAW(pseudo city code)(date)/

 7TAWB4T012APR/

 * place a PNR into a pre-assigned special queue for
 future ticketing 7TAW(pseudo city code)(previously
 assigned two-alpha characters agent sign)(date)/

 7TAWB4T0BB05MAY/

 * place a PNR into a pre-assigned special queue for
 current ticketing 7TAW(pseudo city code)(previously
 assigned two-alpha characters agent sign)/

 7TAWB4T0BB/

 * Request queue placement to a specific queue for future
 ticketing 7TAW(date)(queue number)

 7TAW23JUL55/

 * request queue placement to a specific queue with
 immediate queue placement 7TAW(queue number)

 7TAW142/

 * request queue placement to a specific queue at an
 authorized branch for future ticketing 7TAW(pseudo city
 code)(date)(queue number)/

 7TAWB4T023MAY55/

 * request queue placement to a specific queue at an
 authorized branch with immediate queue placement
 7TAW(pseudo city code)(date)(queue number)/

 7TAWB4T055/

 * request queue placement to a specific queue for future
 ticketing 7TAW(date)(queue number)/(time)/

 7TAW23JUL55/0300P/

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FutureTicketing.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Code"/>
 *     &lt;xs:element type="xs:string" name="CityCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BranchPCC" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="QueueCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Date" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Time" minOccurs="0"/>
 *     &lt;xs:element type="xs:short" name="QueueNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Comment" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="xs:integer" name="index"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="elementId"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FutureTicketingPNRB implements Serializable
{
    private String code;
    private String cityCode;
    private String branchPCC;
    private String queueCode;
    private String date;
    private String time;
    private Short queueNumber;
    private String comment;
    private String id;
    private BigInteger index;
    private OperationTypePNRB op;
    private String elementId;
    private String RPH;

    /** 
     * Get the 'Code' element value.
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' element value.
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'CityCode' element value.
     * 
     * @return value
     */
    public String getCityCode() {
        return cityCode;
    }

    /** 
     * Set the 'CityCode' element value.
     * 
     * @param cityCode
     */
    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    /** 
     * Get the 'BranchPCC' element value. The Pseudo City Code of the agent that generated the TK/TE/TR/TV/TM
                          ticketing entry or the Pseudo City Code to whom the PNR has been queued to perform ticketing.
                          Ex."3Z71"
                      
     * 
     * @return value
     */
    public String getBranchPCC() {
        return branchPCC;
    }

    /** 
     * Set the 'BranchPCC' element value. The Pseudo City Code of the agent that generated the TK/TE/TR/TV/TM
                          ticketing entry or the Pseudo City Code to whom the PNR has been queued to perform ticketing.
                          Ex."3Z71"
                      
     * 
     * @param branchPCC
     */
    public void setBranchPCC(String branchPCC) {
        this.branchPCC = branchPCC;
    }

    /** 
     * Get the 'QueueCode' element value. Queue identification code/pic code.
     * 
     * @return value
     */
    public String getQueueCode() {
        return queueCode;
    }

    /** 
     * Set the 'QueueCode' element value. Queue identification code/pic code.
     * 
     * @param queueCode
     */
    public void setQueueCode(String queueCode) {
        this.queueCode = queueCode;
    }

    /** 
     * Get the 'Date' element value. Date of Future Ticketing. Ex. "18OCT"
     * 
     * @return value
     */
    public String getDate() {
        return date;
    }

    /** 
     * Set the 'Date' element value. Date of Future Ticketing. Ex. "18OCT"
     * 
     * @param date
     */
    public void setDate(String date) {
        this.date = date;
    }

    /** 
     * Get the 'Time' element value. Time of Future Ticketing. Ex. "0400A"
     * 
     * @return value
     */
    public String getTime() {
        return time;
    }

    /** 
     * Set the 'Time' element value. Time of Future Ticketing. Ex. "0400A"
     * 
     * @param time
     */
    public void setTime(String time) {
        this.time = time;
    }

    /** 
     * Get the 'QueueNumber' element value.
     * 
     * @return value
     */
    public Short getQueueNumber() {
        return queueNumber;
    }

    /** 
     * Set the 'QueueNumber' element value.
     * 
     * @param queueNumber
     */
    public void setQueueNumber(Short queueNumber) {
        this.queueNumber = queueNumber;
    }

    /** 
     * Get the 'Comment' element value.
     * 
     * @return value
     */
    public String getComment() {
        return comment;
    }

    /** 
     * Set the 'Comment' element value.
     * 
     * @param comment
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'index' attribute value.
     * 
     * @return value
     */
    public BigInteger getIndex() {
        return index;
    }

    /** 
     * Set the 'index' attribute value.
     * 
     * @param index
     */
    public void setIndex(BigInteger index) {
        this.index = index;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'elementId' attribute value.
     * 
     * @return value
     */
    public String getElementId() {
        return elementId;
    }

    /** 
     * Set the 'elementId' attribute value.
     * 
     * @param elementId
     */
    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    /** 
     * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
}
