
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GeneralSegmentType.PNRB">
 *   &lt;xs:sequence minOccurs="0">
 *     &lt;!-- Reference to inner class Sequence -->
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="isPast"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="dayOfWeekInd"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class GeneralSegmentTypePNRB implements Serializable
{
    private Sequence line;
    private Boolean isPast;
    private String dayOfWeekInd;
    private String RPH;

    /** 
     * Get the sequence value.
     * 
     * @return value
     */
    public Sequence getLine() {
        return line;
    }

    /** 
     * Set the sequence value.
     * 
     * @param line
     */
    public void setLine(Sequence line) {
        this.line = line;
    }

    /** 
     * Get the 'isPast' attribute value. It returns information if current element is past or not.
     * 
     * @return value
     */
    public Boolean getIsPast() {
        return isPast;
    }

    /** 
     * Set the 'isPast' attribute value. It returns information if current element is past or not.
     * 
     * @param isPast
     */
    public void setIsPast(Boolean isPast) {
        this.isPast = isPast;
    }

    /** 
     * Get the 'dayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator.
     * 
     * @return value
     */
    public String getDayOfWeekInd() {
        return dayOfWeekInd;
    }

    /** 
     * Set the 'dayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator.
     * 
     * @param dayOfWeekInd
     */
    public void setDayOfWeekInd(String dayOfWeekInd) {
        this.dayOfWeekInd = dayOfWeekInd;
    }

    /** 
     * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:Line" name="Line" minOccurs="0"/>
     *   &lt;xs:element name="Vendor" minOccurs="0">
     *     &lt;!-- Reference to inner class Vendor -->
     *   &lt;/xs:element>
     *   &lt;xs:element type="xs:string" name="NumberInParty" minOccurs="0"/>
     *   &lt;xs:element name="ServiceCity" minOccurs="0">
     *     &lt;!-- Reference to inner class ServiceCity -->
     *   &lt;/xs:element>
     *   &lt;xs:element type="xs:string" name="ArrivalDepartureIdentifier" minOccurs="0"/>
     *   &lt;xs:element type="xs:string" name="POS" minOccurs="0"/>
     *   &lt;xs:element name="Air" minOccurs="0">
     *     &lt;!-- Reference to inner class Air -->
     *   &lt;/xs:element>
     *   &lt;xs:element name="Location" minOccurs="0">
     *     &lt;!-- Reference to inner class Location -->
     *   &lt;/xs:element>
     *   &lt;xs:element name="OriginLocation" minOccurs="0">
     *     &lt;!-- Reference to inner class OriginLocation -->
     *   &lt;/xs:element>
     *   &lt;xs:element name="DestinationLocation" minOccurs="0">
     *     &lt;!-- Reference to inner class DestinationLocation -->
     *   &lt;/xs:element>
     *   &lt;xs:element type="xs:string" name="DateTime" minOccurs="0"/>
     *   &lt;xs:element type="xs:string" name="ArrivalDateTime" minOccurs="0"/>
     *   &lt;xs:element type="xs:string" name="ConfirmationNumber" minOccurs="0"/>
     *   &lt;xs:element type="xs:string" name="ServiceInformation" minOccurs="0" maxOccurs="unbounded"/>
     *   &lt;xs:element type="xs:string" name="SpaceReserved" minOccurs="0"/>
     *   &lt;xs:element type="xs:string" name="ShipOrVehicleName" minOccurs="0"/>
     *   &lt;xs:element name="Tour" minOccurs="0">
     *     &lt;!-- Reference to inner class Tour -->
     *   &lt;/xs:element>
     *   &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
     *   &lt;xs:element type="xs:string" name="LinkCode" minOccurs="0"/>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private Line line;
        private Vendor vendor;
        private String numberInParty;
        private ServiceCity serviceCity;
        private String arrivalDepartureIdentifier;
        private String POS;
        private Air air;
        private Location location;
        private OriginLocation originLocation;
        private DestinationLocation destinationLocation;
        private String dateTime;
        private String arrivalDateTime;
        private String confirmationNumber;
        private List<String> serviceInformationList = new ArrayList<String>();
        private String spaceReserved;
        private String shipOrVehicleName;
        private Tour tour;
        private List<String> textList = new ArrayList<String>();
        private String linkCode;

        /** 
         * Get the 'Line' element value.
         * 
         * @return value
         */
        public Line getLine() {
            return line;
        }

        /** 
         * Set the 'Line' element value.
         * 
         * @param line
         */
        public void setLine(Line line) {
            this.line = line;
        }

        /** 
         * Get the 'Vendor' element value.
         * 
         * @return value
         */
        public Vendor getVendor() {
            return vendor;
        }

        /** 
         * Set the 'Vendor' element value.
         * 
         * @param vendor
         */
        public void setVendor(Vendor vendor) {
            this.vendor = vendor;
        }

        /** 
         * Get the 'NumberInParty' element value.
         * 
         * @return value
         */
        public String getNumberInParty() {
            return numberInParty;
        }

        /** 
         * Set the 'NumberInParty' element value.
         * 
         * @param numberInParty
         */
        public void setNumberInParty(String numberInParty) {
            this.numberInParty = numberInParty;
        }

        /** 
         * Get the 'ServiceCity' element value.
         * 
         * @return value
         */
        public ServiceCity getServiceCity() {
            return serviceCity;
        }

        /** 
         * Set the 'ServiceCity' element value.
         * 
         * @param serviceCity
         */
        public void setServiceCity(ServiceCity serviceCity) {
            this.serviceCity = serviceCity;
        }

        /** 
         * Get the 'ArrivalDepartureIdentifier' element value.
         * 
         * @return value
         */
        public String getArrivalDepartureIdentifier() {
            return arrivalDepartureIdentifier;
        }

        /** 
         * Set the 'ArrivalDepartureIdentifier' element value.
         * 
         * @param arrivalDepartureIdentifier
         */
        public void setArrivalDepartureIdentifier(
                String arrivalDepartureIdentifier) {
            this.arrivalDepartureIdentifier = arrivalDepartureIdentifier;
        }

        /** 
         * Get the 'POS' element value.
         * 
         * @return value
         */
        public String getPOS() {
            return POS;
        }

        /** 
         * Set the 'POS' element value.
         * 
         * @param POS
         */
        public void setPOS(String POS) {
            this.POS = POS;
        }

        /** 
         * Get the 'Air' element value.
         * 
         * @return value
         */
        public Air getAir() {
            return air;
        }

        /** 
         * Set the 'Air' element value.
         * 
         * @param air
         */
        public void setAir(Air air) {
            this.air = air;
        }

        /** 
         * Get the 'Location' element value.
         * 
         * @return value
         */
        public Location getLocation() {
            return location;
        }

        /** 
         * Set the 'Location' element value.
         * 
         * @param location
         */
        public void setLocation(Location location) {
            this.location = location;
        }

        /** 
         * Get the 'OriginLocation' element value.
         * 
         * @return value
         */
        public OriginLocation getOriginLocation() {
            return originLocation;
        }

        /** 
         * Set the 'OriginLocation' element value.
         * 
         * @param originLocation
         */
        public void setOriginLocation(OriginLocation originLocation) {
            this.originLocation = originLocation;
        }

        /** 
         * Get the 'DestinationLocation' element value.
         * 
         * @return value
         */
        public DestinationLocation getDestinationLocation() {
            return destinationLocation;
        }

        /** 
         * Set the 'DestinationLocation' element value.
         * 
         * @param destinationLocation
         */
        public void setDestinationLocation(
                DestinationLocation destinationLocation) {
            this.destinationLocation = destinationLocation;
        }

        /** 
         * Get the 'DateTime' element value. Date policy begins. Ex."2013-10-23T00:00:00"
         * 
         * @return value
         */
        public String getDateTime() {
            return dateTime;
        }

        /** 
         * Set the 'DateTime' element value. Date policy begins. Ex."2013-10-23T00:00:00"
         * 
         * @param dateTime
         */
        public void setDateTime(String dateTime) {
            this.dateTime = dateTime;
        }

        /** 
         * Get the 'ArrivalDateTime' element value.
         * 
         * @return value
         */
        public String getArrivalDateTime() {
            return arrivalDateTime;
        }

        /** 
         * Set the 'ArrivalDateTime' element value.
         * 
         * @param arrivalDateTime
         */
        public void setArrivalDateTime(String arrivalDateTime) {
            this.arrivalDateTime = arrivalDateTime;
        }

        /** 
         * Get the 'ConfirmationNumber' element value.
         * 
         * @return value
         */
        public String getConfirmationNumber() {
            return confirmationNumber;
        }

        /** 
         * Set the 'ConfirmationNumber' element value.
         * 
         * @param confirmationNumber
         */
        public void setConfirmationNumber(String confirmationNumber) {
            this.confirmationNumber = confirmationNumber;
        }

        /** 
         * Get the list of 'ServiceInformation' element items.
         * 
         * @return list
         */
        public List<String> getServiceInformationList() {
            return serviceInformationList;
        }

        /** 
         * Set the list of 'ServiceInformation' element items.
         * 
         * @param list
         */
        public void setServiceInformationList(List<String> list) {
            serviceInformationList = list;
        }

        /** 
         * Get the 'SpaceReserved' element value.
         * 
         * @return value
         */
        public String getSpaceReserved() {
            return spaceReserved;
        }

        /** 
         * Set the 'SpaceReserved' element value.
         * 
         * @param spaceReserved
         */
        public void setSpaceReserved(String spaceReserved) {
            this.spaceReserved = spaceReserved;
        }

        /** 
         * Get the 'ShipOrVehicleName' element value.
         * 
         * @return value
         */
        public String getShipOrVehicleName() {
            return shipOrVehicleName;
        }

        /** 
         * Set the 'ShipOrVehicleName' element value.
         * 
         * @param shipOrVehicleName
         */
        public void setShipOrVehicleName(String shipOrVehicleName) {
            this.shipOrVehicleName = shipOrVehicleName;
        }

        /** 
         * Get the 'Tour' element value.
         * 
         * @return value
         */
        public Tour getTour() {
            return tour;
        }

        /** 
         * Set the 'Tour' element value.
         * 
         * @param tour
         */
        public void setTour(Tour tour) {
            this.tour = tour;
        }

        /** 
         * Get the list of 'Text' element items. Code of the travel protection offering. Ex." CANCELLATION INSURANCE"
                        
         * 
         * @return list
         */
        public List<String> getTextList() {
            return textList;
        }

        /** 
         * Set the list of 'Text' element items. Code of the travel protection offering. Ex." CANCELLATION INSURANCE"
                        
         * 
         * @param list
         */
        public void setTextList(List<String> list) {
            textList = list;
        }

        /** 
         * Get the 'LinkCode' element value. Identifier of accounting line assigned to segment
         * 
         * @return value
         */
        public String getLinkCode() {
            return linkCode;
        }

        /** 
         * Set the 'LinkCode' element value. Identifier of accounting line assigned to segment
         * 
         * @param linkCode
         */
        public void setLinkCode(String linkCode) {
            this.linkCode = linkCode;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vendor" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Vendor implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value. Company marketing the policy. Ex."QF"
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value. Company marketing the policy. Ex."QF"
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceCity" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="CodeContext"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ServiceCity implements Serializable
        {
            private String locationCode;
            private String codeContext;

            /** 
             * Get the 'LocationCode' attribute value.
             * 
             * @return value
             */
            public String getLocationCode() {
                return locationCode;
            }

            /** 
             * Set the 'LocationCode' attribute value.
             * 
             * @param locationCode
             */
            public void setLocationCode(String locationCode) {
                this.locationCode = locationCode;
            }

            /** 
             * Get the 'CodeContext' attribute value.
             * 
             * @return value
             */
            public String getCodeContext() {
                return codeContext;
            }

            /** 
             * Set the 'CodeContext' attribute value.
             * 
             * @param codeContext
             */
            public void setCodeContext(String codeContext) {
                this.codeContext = codeContext;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Air" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="DepartureAirport" minOccurs="0">
         *         &lt;!-- Reference to inner class DepartureAirport -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ArrivalAirport" minOccurs="0">
         *         &lt;!-- Reference to inner class ArrivalAirport -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="MarketingAirline" minOccurs="0">
         *         &lt;!-- Reference to inner class MarketingAirline -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Air implements Serializable
        {
            private DepartureAirport departureAirport;
            private ArrivalAirport arrivalAirport;
            private MarketingAirline marketingAirline;
            private String departureDateTime;
            private String flightNumber;

            /** 
             * Get the 'DepartureAirport' element value.
             * 
             * @return value
             */
            public DepartureAirport getDepartureAirport() {
                return departureAirport;
            }

            /** 
             * Set the 'DepartureAirport' element value.
             * 
             * @param departureAirport
             */
            public void setDepartureAirport(DepartureAirport departureAirport) {
                this.departureAirport = departureAirport;
            }

            /** 
             * Get the 'ArrivalAirport' element value.
             * 
             * @return value
             */
            public ArrivalAirport getArrivalAirport() {
                return arrivalAirport;
            }

            /** 
             * Set the 'ArrivalAirport' element value.
             * 
             * @param arrivalAirport
             */
            public void setArrivalAirport(ArrivalAirport arrivalAirport) {
                this.arrivalAirport = arrivalAirport;
            }

            /** 
             * Get the 'MarketingAirline' element value.
             * 
             * @return value
             */
            public MarketingAirline getMarketingAirline() {
                return marketingAirline;
            }

            /** 
             * Set the 'MarketingAirline' element value.
             * 
             * @param marketingAirline
             */
            public void setMarketingAirline(MarketingAirline marketingAirline) {
                this.marketingAirline = marketingAirline;
            }

            /** 
             * Get the 'DepartureDateTime' attribute value.
             * 
             * @return value
             */
            public String getDepartureDateTime() {
                return departureDateTime;
            }

            /** 
             * Set the 'DepartureDateTime' attribute value.
             * 
             * @param departureDateTime
             */
            public void setDepartureDateTime(String departureDateTime) {
                this.departureDateTime = departureDateTime;
            }

            /** 
             * Get the 'FlightNumber' attribute value. The flight number of the flight.
             * 
             * @return value
             */
            public String getFlightNumber() {
                return flightNumber;
            }

            /** 
             * Set the 'FlightNumber' attribute value. The flight number of the flight.
             * 
             * @param flightNumber
             */
            public void setFlightNumber(String flightNumber) {
                this.flightNumber = flightNumber;
            }
            /** 
             * Departure point of flight segment.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DepartureAirport" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
             *     &lt;xs:attribute type="xs:string" use="optional" default="IATA" name="CodeContext"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class DepartureAirport implements Serializable
            {
                private String locationCode;
                private String codeContext;

                /** 
                 * Get the 'LocationCode' attribute value.
                 * 
                 * @return value
                 */
                public String getLocationCode() {
                    return locationCode;
                }

                /** 
                 * Set the 'LocationCode' attribute value.
                 * 
                 * @param locationCode
                 */
                public void setLocationCode(String locationCode) {
                    this.locationCode = locationCode;
                }

                /** 
                 * Get the 'CodeContext' attribute value. Identifies the context of the identifying code,
                                                    such as IATA, ARC, or internal code, etc.
                                                
                 * 
                 * @return value
                 */
                public String getCodeContext() {
                    return codeContext;
                }

                /** 
                 * Set the 'CodeContext' attribute value. Identifies the context of the identifying code,
                                                    such as IATA, ARC, or internal code, etc.
                                                
                 * 
                 * @param codeContext
                 */
                public void setCodeContext(String codeContext) {
                    this.codeContext = codeContext;
                }
            }
            /** 
             * Arrival airport point of flight segment.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ArrivalAirport" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
             *     &lt;xs:attribute type="xs:string" use="optional" default="IATA" name="CodeContext"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ArrivalAirport implements Serializable
            {
                private String locationCode;
                private String codeContext;

                /** 
                 * Get the 'LocationCode' attribute value.
                 * 
                 * @return value
                 */
                public String getLocationCode() {
                    return locationCode;
                }

                /** 
                 * Set the 'LocationCode' attribute value.
                 * 
                 * @param locationCode
                 */
                public void setLocationCode(String locationCode) {
                    this.locationCode = locationCode;
                }

                /** 
                 * Get the 'CodeContext' attribute value. Identifies the context of the identifying code,
                                                    such as IATA, ARC, or internal code, etc.
                                                
                 * 
                 * @return value
                 */
                public String getCodeContext() {
                    return codeContext;
                }

                /** 
                 * Set the 'CodeContext' attribute value. Identifies the context of the identifying code,
                                                    such as IATA, ARC, or internal code, etc.
                                                
                 * 
                 * @param codeContext
                 */
                public void setCodeContext(String codeContext) {
                    this.codeContext = codeContext;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingAirline" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MarketingAirline implements Serializable
            {
                private String code;

                /** 
                 * Get the 'Code' attribute value. Identifies a company by the company code.
                                                
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value. Identifies a company by the company code.
                                                
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Location" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="CodeContext"/>
         *     &lt;xs:attribute type="xs:string" name="Point"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Location implements Serializable
        {
            private String locationCode;
            private String codeContext;
            private String point;

            /** 
             * Get the 'LocationCode' attribute value.
             * 
             * @return value
             */
            public String getLocationCode() {
                return locationCode;
            }

            /** 
             * Set the 'LocationCode' attribute value.
             * 
             * @param locationCode
             */
            public void setLocationCode(String locationCode) {
                this.locationCode = locationCode;
            }

            /** 
             * Get the 'CodeContext' attribute value.
             * 
             * @return value
             */
            public String getCodeContext() {
                return codeContext;
            }

            /** 
             * Set the 'CodeContext' attribute value.
             * 
             * @param codeContext
             */
            public void setCodeContext(String codeContext) {
                this.codeContext = codeContext;
            }

            /** 
             * Get the 'Point' attribute value.
             * 
             * @return value
             */
            public String getPoint() {
                return point;
            }

            /** 
             * Set the 'Point' attribute value.
             * 
             * @param point
             */
            public void setPoint(String point) {
                this.point = point;
            }
        }
        /** 
         * Associated Itinerary start city. Ex."MEL"
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="CodeContext"/>
         *     &lt;xs:attribute type="xs:string" name="Point"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OriginLocation implements Serializable
        {
            private String locationCode;
            private String codeContext;
            private String point;

            /** 
             * Get the 'LocationCode' attribute value.
             * 
             * @return value
             */
            public String getLocationCode() {
                return locationCode;
            }

            /** 
             * Set the 'LocationCode' attribute value.
             * 
             * @param locationCode
             */
            public void setLocationCode(String locationCode) {
                this.locationCode = locationCode;
            }

            /** 
             * Get the 'CodeContext' attribute value.
             * 
             * @return value
             */
            public String getCodeContext() {
                return codeContext;
            }

            /** 
             * Set the 'CodeContext' attribute value.
             * 
             * @param codeContext
             */
            public void setCodeContext(String codeContext) {
                this.codeContext = codeContext;
            }

            /** 
             * Get the 'Point' attribute value.
             * 
             * @return value
             */
            public String getPoint() {
                return point;
            }

            /** 
             * Set the 'Point' attribute value.
             * 
             * @param point
             */
            public void setPoint(String point) {
                this.point = point;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="CodeContext"/>
         *     &lt;xs:attribute type="xs:string" name="Point"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class DestinationLocation implements Serializable
        {
            private String locationCode;
            private String codeContext;
            private String point;

            /** 
             * Get the 'LocationCode' attribute value.
             * 
             * @return value
             */
            public String getLocationCode() {
                return locationCode;
            }

            /** 
             * Set the 'LocationCode' attribute value.
             * 
             * @param locationCode
             */
            public void setLocationCode(String locationCode) {
                this.locationCode = locationCode;
            }

            /** 
             * Get the 'CodeContext' attribute value.
             * 
             * @return value
             */
            public String getCodeContext() {
                return codeContext;
            }

            /** 
             * Set the 'CodeContext' attribute value.
             * 
             * @param codeContext
             */
            public void setCodeContext(String codeContext) {
                this.codeContext = codeContext;
            }

            /** 
             * Get the 'Point' attribute value.
             * 
             * @return value
             */
            public String getPoint() {
                return point;
            }

            /** 
             * Set the 'Point' attribute value.
             * 
             * @param point
             */
            public void setPoint(String point) {
                this.point = point;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tour" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="Code" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
         *       &lt;xs:element type="xs:int" name="NumberOfNights" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="Price" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="RoomType" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="CarInfo" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="Option" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="xs:string" name="Feature" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="xs:string" name="Meal" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="xs:string" name="Extension" minOccurs="0" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Tour implements Serializable
        {
            private String code;
            private String name;
            private Integer numberOfNights;
            private String price;
            private String roomType;
            private String carInfo;
            private List<String> optionList = new ArrayList<String>();
            private List<String> featureList = new ArrayList<String>();
            private List<String> mealList = new ArrayList<String>();
            private List<String> extensionList = new ArrayList<String>();

            /** 
             * Get the 'Code' element value.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' element value.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }

            /** 
             * Get the 'Name' element value.
             * 
             * @return value
             */
            public String getName() {
                return name;
            }

            /** 
             * Set the 'Name' element value.
             * 
             * @param name
             */
            public void setName(String name) {
                this.name = name;
            }

            /** 
             * Get the 'NumberOfNights' element value.
             * 
             * @return value
             */
            public Integer getNumberOfNights() {
                return numberOfNights;
            }

            /** 
             * Set the 'NumberOfNights' element value.
             * 
             * @param numberOfNights
             */
            public void setNumberOfNights(Integer numberOfNights) {
                this.numberOfNights = numberOfNights;
            }

            /** 
             * Get the 'Price' element value.
             * 
             * @return value
             */
            public String getPrice() {
                return price;
            }

            /** 
             * Set the 'Price' element value.
             * 
             * @param price
             */
            public void setPrice(String price) {
                this.price = price;
            }

            /** 
             * Get the 'RoomType' element value.
             * 
             * @return value
             */
            public String getRoomType() {
                return roomType;
            }

            /** 
             * Set the 'RoomType' element value.
             * 
             * @param roomType
             */
            public void setRoomType(String roomType) {
                this.roomType = roomType;
            }

            /** 
             * Get the 'CarInfo' element value.
             * 
             * @return value
             */
            public String getCarInfo() {
                return carInfo;
            }

            /** 
             * Set the 'CarInfo' element value.
             * 
             * @param carInfo
             */
            public void setCarInfo(String carInfo) {
                this.carInfo = carInfo;
            }

            /** 
             * Get the list of 'Option' element items.
             * 
             * @return list
             */
            public List<String> getOptionList() {
                return optionList;
            }

            /** 
             * Set the list of 'Option' element items.
             * 
             * @param list
             */
            public void setOptionList(List<String> list) {
                optionList = list;
            }

            /** 
             * Get the list of 'Feature' element items.
             * 
             * @return list
             */
            public List<String> getFeatureList() {
                return featureList;
            }

            /** 
             * Set the list of 'Feature' element items.
             * 
             * @param list
             */
            public void setFeatureList(List<String> list) {
                featureList = list;
            }

            /** 
             * Get the list of 'Meal' element items.
             * 
             * @return list
             */
            public List<String> getMealList() {
                return mealList;
            }

            /** 
             * Set the list of 'Meal' element items.
             * 
             * @param list
             */
            public void setMealList(List<String> list) {
                mealList = list;
            }

            /** 
             * Get the list of 'Extension' element items.
             * 
             * @return list
             */
            public List<String> getExtensionList() {
                return extensionList;
            }

            /** 
             * Set the list of 'Extension' element items.
             * 
             * @param list
             */
            public void setExtensionList(List<String> list) {
                extensionList = list;
            }
        }
    }
}
