
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GeneralSegmentUpdate.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Line" name="Line" minOccurs="0"/>
 *     &lt;xs:element name="Vendor" minOccurs="0">
 *       &lt;!-- Reference to inner class Vendor -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="NumberInParty" minOccurs="0"/>
 *     &lt;xs:element name="Location" minOccurs="0">
 *       &lt;!-- Reference to inner class Location -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="DateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class GeneralSegmentUpdatePNRB implements Serializable
{
    private Line line;
    private Vendor vendor;
    private String numberInParty;
    private Location location;
    private String dateTime;
    private List<String> textList = new ArrayList<String>();
    private OperationTypePNRB op;

    /** 
     * Get the 'Line' element value.
     * 
     * @return value
     */
    public Line getLine() {
        return line;
    }

    /** 
     * Set the 'Line' element value.
     * 
     * @param line
     */
    public void setLine(Line line) {
        this.line = line;
    }

    /** 
     * Get the 'Vendor' element value.
     * 
     * @return value
     */
    public Vendor getVendor() {
        return vendor;
    }

    /** 
     * Set the 'Vendor' element value.
     * 
     * @param vendor
     */
    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
    }

    /** 
     * Get the 'NumberInParty' element value.
     * 
     * @return value
     */
    public String getNumberInParty() {
        return numberInParty;
    }

    /** 
     * Set the 'NumberInParty' element value.
     * 
     * @param numberInParty
     */
    public void setNumberInParty(String numberInParty) {
        this.numberInParty = numberInParty;
    }

    /** 
     * Get the 'Location' element value.
     * 
     * @return value
     */
    public Location getLocation() {
        return location;
    }

    /** 
     * Set the 'Location' element value.
     * 
     * @param location
     */
    public void setLocation(Location location) {
        this.location = location;
    }

    /** 
     * Get the 'DateTime' element value. Date policy begins. Ex."2013-10-23T00:00:00"
     * 
     * @return value
     */
    public String getDateTime() {
        return dateTime;
    }

    /** 
     * Set the 'DateTime' element value. Date policy begins. Ex."2013-10-23T00:00:00"
     * 
     * @param dateTime
     */
    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    /** 
     * Get the list of 'Text' element items. Code of the travel protection offering. Ex."CANCELLATION INSURANCE"
                      
     * 
     * @return list
     */
    public List<String> getTextList() {
        return textList;
    }

    /** 
     * Set the list of 'Text' element items. Code of the travel protection offering. Ex."CANCELLATION INSURANCE"
                      
     * 
     * @param list
     */
    public void setTextList(List<String> list) {
        textList = list;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vendor" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Vendor implements Serializable
    {
        private String code;

        /** 
         * Get the 'Code' attribute value. Company marketing the policy. Ex."QF"
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' attribute value. Company marketing the policy. Ex."QF"
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Location" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Location implements Serializable
    {
        private String locationCode;

        /** 
         * Get the 'LocationCode' attribute value.
         * 
         * @return value
         */
        public String getLocationCode() {
            return locationCode;
        }

        /** 
         * Set the 'LocationCode' attribute value.
         * 
         * @param locationCode
         */
        public void setLocationCode(String locationCode) {
            this.locationCode = locationCode;
        }
    }
}
