
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GenericSpecialRequest.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Code" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FreeText" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ActionCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="NumberInParty" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AirlineCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TicketNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FullText" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="ns:RequestType.PNRB" name="type"/>
 *   &lt;xs:attribute type="ns:msgType.PNRB" name="msgType"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:string" name="RPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class GenericSpecialRequestPNRB implements Serializable
{
    private String code;
    private String freeText;
    private String actionCode;
    private BigInteger numberInParty;
    private String airlineCode;
    private String ticketNumber;
    private String fullText;
    private String id;
    private RequestTypePNRB type;
    private MsgTypePNRB msgType;
    private OperationTypePNRB op;
    private String RPH;

    /** 
     * Get the 'Code' element value. Code indicating the type of SSR that was sent. A = AFAX G = GFAX
                      
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' element value. Code indicating the type of SSR that was sent. A = AFAX G = GFAX
                      
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'FreeText' element value. Flight and freetext data. Ex."INFT EY 6883Y17JUL/UWGUT/MAXW/23JUN13 NN1"
                      
     * 
     * @return value
     */
    public String getFreeText() {
        return freeText;
    }

    /** 
     * Set the 'FreeText' element value. Flight and freetext data. Ex."INFT EY 6883Y17JUL/UWGUT/MAXW/23JUN13 NN1"
                      
     * 
     * @param freeText
     */
    public void setFreeText(String freeText) {
        this.freeText = freeText;
    }

    /** 
     * Get the 'ActionCode' element value. Indication of the status of the SSR notification.
                          A value of 'HK' indicates the intended carrier has received the message and has confirmed its
                          contents. Ex. "HK"
                      
     * 
     * @return value
     */
    public String getActionCode() {
        return actionCode;
    }

    /** 
     * Set the 'ActionCode' element value. Indication of the status of the SSR notification.
                          A value of 'HK' indicates the intended carrier has received the message and has confirmed its
                          contents. Ex. "HK"
                      
     * 
     * @param actionCode
     */
    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    /** 
     * Get the 'NumberInParty' element value. Number of passengers for whom the Special Service Request is being requested. Ex.
                          "1"
                      
     * 
     * @return value
     */
    public BigInteger getNumberInParty() {
        return numberInParty;
    }

    /** 
     * Set the 'NumberInParty' element value. Number of passengers for whom the Special Service Request is being requested. Ex.
                          "1"
                      
     * 
     * @param numberInParty
     */
    public void setNumberInParty(BigInteger numberInParty) {
        this.numberInParty = numberInParty;
    }

    /** 
     * Get the 'AirlineCode' element value. Carrier to whom the SSR/OSI message is being sent. Ex. "WS"
     * 
     * @return value
     */
    public String getAirlineCode() {
        return airlineCode;
    }

    /** 
     * Set the 'AirlineCode' element value. Carrier to whom the SSR/OSI message is being sent. Ex. "WS"
     * 
     * @param airlineCode
     */
    public void setAirlineCode(String airlineCode) {
        this.airlineCode = airlineCode;
    }

    /** 
     * Get the 'TicketNumber' element value. Ticket number (or numbers in the case of conjunctive tickets) associated with the
                          indicated ticket issuance/refund/exchange/void activity. SSR ticket number may contain the
                          coupon number at the end of the ticket number. Tickets issued by
                          the hosted airline will not include the three character airline ticket indicator at the
                          beginning of the ticket number. Ex. "8.38218E+12"
                      
     * 
     * @return value
     */
    public String getTicketNumber() {
        return ticketNumber;
    }

    /** 
     * Set the 'TicketNumber' element value. Ticket number (or numbers in the case of conjunctive tickets) associated with the
                          indicated ticket issuance/refund/exchange/void activity. SSR ticket number may contain the
                          coupon number at the end of the ticket number. Tickets issued by
                          the hosted airline will not include the three character airline ticket indicator at the
                          beginning of the ticket number. Ex. "8.38218E+12"
                      
     * 
     * @param ticketNumber
     */
    public void setTicketNumber(String ticketNumber) {
        this.ticketNumber = ticketNumber;
    }

    /** 
     * Get the 'FullText' element value.
     * 
     * @return value
     */
    public String getFullText() {
        return fullText;
    }

    /** 
     * Set the 'FullText' element value.
     * 
     * @param fullText
     */
    public void setFullText(String fullText) {
        this.fullText = fullText;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'type' attribute value. A = AFAX G = GFAX
     * 
     * @return value
     */
    public RequestTypePNRB getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. A = AFAX G = GFAX
     * 
     * @param type
     */
    public void setType(RequestTypePNRB type) {
        this.type = type;
    }

    /** 
     * Get the 'msgType' attribute value. S = SSR O = OSI
     * 
     * @return value
     */
    public MsgTypePNRB getMsgType() {
        return msgType;
    }

    /** 
     * Set the 'msgType' attribute value. S = SSR O = OSI
     * 
     * @param msgType
     */
    public void setMsgType(MsgTypePNRB msgType) {
        this.msgType = msgType;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
}
