
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryPricing.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TicketingInstructionsInfo.PNRB" name="TicketingInstructionsInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:FuturePriceInfo.PNRB" name="FuturePriceInfo" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="ns:PACInfo.PNRB" name="PACInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PricedItinerary.PNRB" name="PricedItinerary" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:integer" name="numberInParty"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ItineraryPricingPNRB implements Serializable
{
    private TicketingInstructionsInfoPNRB ticketingInstructionsInfo;
    private List<FuturePriceInfoPNRB> futurePriceInfoList = new ArrayList<FuturePriceInfoPNRB>();
    private PACInfoPNRB PACInfo;
    private List<PricedItineraryPNRB> pricedItineraryList = new ArrayList<PricedItineraryPNRB>();
    private BigInteger numberInParty;

    /** 
     * Get the 'TicketingInstructionsInfo' element value. Ticketing instruction information.
     * 
     * @return value
     */
    public TicketingInstructionsInfoPNRB getTicketingInstructionsInfo() {
        return ticketingInstructionsInfo;
    }

    /** 
     * Set the 'TicketingInstructionsInfo' element value. Ticketing instruction information.
     * 
     * @param ticketingInstructionsInfo
     */
    public void setTicketingInstructionsInfo(
            TicketingInstructionsInfoPNRB ticketingInstructionsInfo) {
        this.ticketingInstructionsInfo = ticketingInstructionsInfo;
    }

    /** 
     * Get the list of 'FuturePriceInfo' element items. Future price information.
     * 
     * @return list
     */
    public List<FuturePriceInfoPNRB> getFuturePriceInfoList() {
        return futurePriceInfoList;
    }

    /** 
     * Set the list of 'FuturePriceInfo' element items. Future price information.
     * 
     * @param list
     */
    public void setFuturePriceInfoList(List<FuturePriceInfoPNRB> list) {
        futurePriceInfoList = list;
    }

    /** 
     * Get the 'PACInfo' element value. Passenger Account Code information.
     * 
     * @return value
     */
    public PACInfoPNRB getPACInfo() {
        return PACInfo;
    }

    /** 
     * Set the 'PACInfo' element value. Passenger Account Code information.
     * 
     * @param PACInfo
     */
    public void setPACInfo(PACInfoPNRB PACInfo) {
        this.PACInfo = PACInfo;
    }

    /** 
     * Get the list of 'PricedItinerary' element items. Priced Itinerary information.
     * 
     * @return list
     */
    public List<PricedItineraryPNRB> getPricedItineraryList() {
        return pricedItineraryList;
    }

    /** 
     * Set the list of 'PricedItinerary' element items. Priced Itinerary information.
     * 
     * @param list
     */
    public void setPricedItineraryList(List<PricedItineraryPNRB> list) {
        pricedItineraryList = list;
    }

    /** 
     * Get the 'numberInParty' attribute value. Ex. "1"
     * 
     * @return value
     */
    public BigInteger getNumberInParty() {
        return numberInParty;
    }

    /** 
     * Set the 'numberInParty' attribute value. Ex. "1"
     * 
     * @param numberInParty
     */
    public void setNumberInParty(BigInteger numberInParty) {
        this.numberInParty = numberInParty;
    }
}
