
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * The type of value in the membership level value. Possibilities include: 2L, 3L, Banner
 (BN), Tier Level Indicator (TI)

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MembershipLevelTypeCodes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="2L"/>
 *     &lt;xs:enumeration value="3L"/>
 *     &lt;xs:enumeration value="BN"/>
 *     &lt;xs:enumeration value="TI"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum MembershipLevelTypeCodes implements Serializable {
    _2_L("2L"), _3_L("3L"), BN("BN"), TI("TI");
    private final String value;

    private MembershipLevelTypeCodes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static MembershipLevelTypeCodes convert(String value) {
        for (MembershipLevelTypeCodes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
