
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OptionalIndicatorType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Y"/>
 *     &lt;xs:enumeration value="N"/>
 *     &lt;xs:enumeration value=" "/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum OptionalIndicatorType implements Serializable {
    Y("Y"), N("N"), _(" ");
    private final String value;

    private OptionalIndicatorType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static OptionalIndicatorType convert(String value) {
        for (OptionalIndicatorType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
