
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Point of Sale (POS) is the details identifying the party or connection channel making the
 request.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="POS_Type.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:SourceType.PNRB" name="Source" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="AirExtras"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InhibitCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class POSTypePNRB implements Serializable
{
    private SourceTypePNRB source;
    private Boolean airExtras;
    private String inhibitCode;

    /** 
     * Get the 'Source' element value. This holds details regarding the requestor. It may be repeated to also
                          accommodate the delivery systems.
                      
     * 
     * @return value
     */
    public SourceTypePNRB getSource() {
        return source;
    }

    /** 
     * Set the 'Source' element value. This holds details regarding the requestor. It may be repeated to also
                          accommodate the delivery systems.
                      
     * 
     * @param source
     */
    public void setSource(SourceTypePNRB source) {
        this.source = source;
    }

    /** 
     * Get the 'AirExtras' attribute value. "AirExtras" is used to indicate whether or not air extra-related information pertains
                      to the particular record.
                  
     * 
     * @return value
     */
    public Boolean getAirExtras() {
        return airExtras;
    }

    /** 
     * Set the 'AirExtras' attribute value. "AirExtras" is used to indicate whether or not air extra-related information pertains
                      to the particular record.
                  
     * 
     * @param airExtras
     */
    public void setAirExtras(Boolean airExtras) {
        this.airExtras = airExtras;
    }

    /** 
     * Get the 'InhibitCode' attribute value. "InhibitCode" is utilized to return the viewership code associated with the
                      particular record.
                  
     * 
     * @return value
     */
    public String getInhibitCode() {
        return inhibitCode;
    }

    /** 
     * Set the 'InhibitCode' attribute value. "InhibitCode" is utilized to return the viewership code associated with the
                      particular record.
                  
     * 
     * @param inhibitCode
     */
    public void setInhibitCode(String inhibitCode) {
        this.inhibitCode = inhibitCode;
    }
}
