
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerQuantity">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="PassengerTypeQuantity" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class PassengerTypeQuantity -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PassengerQuantity implements Serializable
{
    private List<PassengerTypeQuantity> passengerTypeQuantityList = new ArrayList<PassengerTypeQuantity>();

    /** 
     * Get the list of 'PassengerTypeQuantity' element items.
     * 
     * @return list
     */
    public List<PassengerTypeQuantity> getPassengerTypeQuantityList() {
        return passengerTypeQuantityList;
    }

    /** 
     * Set the list of 'PassengerTypeQuantity' element items.
     * 
     * @param list
     */
    public void setPassengerTypeQuantityList(List<PassengerTypeQuantity> list) {
        passengerTypeQuantityList = list;
    }
    /** 
     * Quantity of particulat pax type indicator.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerTypeQuantity" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="Code"/>
     *     &lt;xs:attribute type="xs:integer" name="Quantity"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PassengerTypeQuantity implements Serializable
    {
        private String code;
        private BigInteger quantity;

        /** 
         * Get the 'Code' attribute value.
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' attribute value.
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'Quantity' attribute value. Passenger type quantity. Ex."1"
         * 
         * @return value
         */
        public BigInteger getQuantity() {
            return quantity;
        }

        /** 
         * Set the 'Quantity' attribute value. Passenger type quantity. Ex."1"
         * 
         * @param quantity
         */
        public void setQuantity(BigInteger quantity) {
            this.quantity = quantity;
        }
    }
}
