
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TravelerGroup.PNRB" name="Corporate" minOccurs="0"/>
 *     &lt;xs:element type="ns:BSGGroup.PNRB" name="BlockedSpaceGroup" minOccurs="0"/>
 *     &lt;xs:element type="ns:TravelerGroup.PNRB" name="ZGroup" minOccurs="0"/>
 *     &lt;xs:element type="ns:Passenger.PNRB" name="Passenger" minOccurs="0" maxOccurs="99"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:integer" name="numberInParty"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PassengersPNRB implements Serializable
{
    private TravelerGroupPNRB corporate;
    private BSGGroupPNRB blockedSpaceGroup;
    private TravelerGroupPNRB ZGroup;
    private List<PassengerPNRB> passengerList = new ArrayList<PassengerPNRB>();
    private BigInteger numberInParty;

    /** 
     * Get the 'Corporate' element value. Corporate PNR
     * 
     * @return value
     */
    public TravelerGroupPNRB getCorporate() {
        return corporate;
    }

    /** 
     * Set the 'Corporate' element value. Corporate PNR
     * 
     * @param corporate
     */
    public void setCorporate(TravelerGroupPNRB corporate) {
        this.corporate = corporate;
    }

    /** 
     * Get the 'BlockedSpaceGroup' element value. BSG Master PNR
     * 
     * @return value
     */
    public BSGGroupPNRB getBlockedSpaceGroup() {
        return blockedSpaceGroup;
    }

    /** 
     * Set the 'BlockedSpaceGroup' element value. BSG Master PNR
     * 
     * @param blockedSpaceGroup
     */
    public void setBlockedSpaceGroup(BSGGroupPNRB blockedSpaceGroup) {
        this.blockedSpaceGroup = blockedSpaceGroup;
    }

    /** 
     * Get the 'ZGroup' element value. Z-Name Group PNR
     * 
     * @return value
     */
    public TravelerGroupPNRB getZGroup() {
        return ZGroup;
    }

    /** 
     * Set the 'ZGroup' element value. Z-Name Group PNR
     * 
     * @param ZGroup
     */
    public void setZGroup(TravelerGroupPNRB ZGroup) {
        this.ZGroup = ZGroup;
    }

    /** 
     * Get the list of 'Passenger' element items.
     * 
     * @return list
     */
    public List<PassengerPNRB> getPassengerList() {
        return passengerList;
    }

    /** 
     * Set the list of 'Passenger' element items.
     * 
     * @param list
     */
    public void setPassengerList(List<PassengerPNRB> list) {
        passengerList = list;
    }

    /** 
     * Get the 'numberInParty' attribute value.
     * 
     * @return value
     */
    public BigInteger getNumberInParty() {
        return numberInParty;
    }

    /** 
     * Set the 'numberInParty' attribute value.
     * 
     * @param numberInParty
     */
    public void setNumberInParty(BigInteger numberInParty) {
        this.numberInParty = numberInParty;
    }
}
