
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;

/** 
 * limited to 57 chars

 optional fields are: passport number, country of issue,
 date of birth, name field, gender field, primary
 passport holder inidicator and name number

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassportInfoMessage.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="PassportNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CountryOfIssue" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="ExpireDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="DateOfBirth" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="LastName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FirstName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Gender" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="IncludedChild" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="PrimaryHolder" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ActionCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="NumberInParty" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Comment" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:string" name="RPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PassportInfoMessagePNRB implements Serializable
{
    private String passportNumber;
    private String countryOfIssue;
    private Date expireDate;
    private Date dateOfBirth;
    private String lastName;
    private String firstName;
    private String gender;
    private Boolean includedChild;
    private Boolean primaryHolder;
    private String actionCode;
    private BigInteger numberInParty;
    private String comment;
    private String id;
    private OperationTypePNRB op;
    private String RPH;

    /** 
     * Get the 'PassportNumber' element value. Number issued for the indicated document.
     * 
     * @return value
     */
    public String getPassportNumber() {
        return passportNumber;
    }

    /** 
     * Set the 'PassportNumber' element value. Number issued for the indicated document.
     * 
     * @param passportNumber
     */
    public void setPassportNumber(String passportNumber) {
        this.passportNumber = passportNumber;
    }

    /** 
     * Get the 'CountryOfIssue' element value. Country code of the government that issued the indicated document.
                      
     * 
     * @return value
     */
    public String getCountryOfIssue() {
        return countryOfIssue;
    }

    /** 
     * Set the 'CountryOfIssue' element value. Country code of the government that issued the indicated document.
                      
     * 
     * @param countryOfIssue
     */
    public void setCountryOfIssue(String countryOfIssue) {
        this.countryOfIssue = countryOfIssue;
    }

    /** 
     * Get the 'ExpireDate' element value.
     * 
     * @return value
     */
    public Date getExpireDate() {
        return expireDate;
    }

    /** 
     * Set the 'ExpireDate' element value.
     * 
     * @param expireDate
     */
    public void setExpireDate(Date expireDate) {
        this.expireDate = expireDate;
    }

    /** 
     * Get the 'DateOfBirth' element value. format ddmmmyy
     * 
     * @return value
     */
    public Date getDateOfBirth() {
        return dateOfBirth;
    }

    /** 
     * Set the 'DateOfBirth' element value. format ddmmmyy
     * 
     * @param dateOfBirth
     */
    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    /** 
     * Get the 'LastName' element value. Surname of the passenger for whom the SSR is being sent.
                          May be different than the passenger who is the document holder in the case of an infant.
                      
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'LastName' element value. Surname of the passenger for whom the SSR is being sent.
                          May be different than the passenger who is the document holder in the case of an infant.
                      
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /** 
     * Get the 'FirstName' element value. First name of the passenger for whom the SSR is being sent.
                          May be different than the passenger who is the document holder in the case of an infant.
                      
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'FirstName' element value. First name of the passenger for whom the SSR is being sent.
                          May be different than the passenger who is the document holder in the case of an infant.
                      
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /** 
     * Get the 'Gender' element value. F = Female M = Male  X = unspecified gender U = Unknown
     * 
     * @return value
     */
    public String getGender() {
        return gender;
    }

    /** 
     * Set the 'Gender' element value. F = Female M = Male  X = unspecified gender U = Unknown
     * 
     * @param gender
     */
    public void setGender(String gender) {
        this.gender = gender;
    }

    /** 
     * Get the 'IncludedChild' element value.
     * 
     * @return value
     */
    public Boolean getIncludedChild() {
        return includedChild;
    }

    /** 
     * Set the 'IncludedChild' element value.
     * 
     * @param includedChild
     */
    public void setIncludedChild(Boolean includedChild) {
        this.includedChild = includedChild;
    }

    /** 
     * Get the 'PrimaryHolder' element value.
     * 
     * @return value
     */
    public Boolean getPrimaryHolder() {
        return primaryHolder;
    }

    /** 
     * Set the 'PrimaryHolder' element value.
     * 
     * @param primaryHolder
     */
    public void setPrimaryHolder(Boolean primaryHolder) {
        this.primaryHolder = primaryHolder;
    }

    /** 
     * Get the 'ActionCode' element value. Indication of the status of the SSR notification.
                          A value of 'HK' indicates the intended carrier has received the message and has confirmed its
                          contents.
                      
     * 
     * @return value
     */
    public String getActionCode() {
        return actionCode;
    }

    /** 
     * Set the 'ActionCode' element value. Indication of the status of the SSR notification.
                          A value of 'HK' indicates the intended carrier has received the message and has confirmed its
                          contents.
                      
     * 
     * @param actionCode
     */
    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    /** 
     * Get the 'NumberInParty' element value. Number of passengers for whom the Special Service Request is being requested.
                      
     * 
     * @return value
     */
    public BigInteger getNumberInParty() {
        return numberInParty;
    }

    /** 
     * Set the 'NumberInParty' element value. Number of passengers for whom the Special Service Request is being requested.
                      
     * 
     * @param numberInParty
     */
    public void setNumberInParty(BigInteger numberInParty) {
        this.numberInParty = numberInParty;
    }

    /** 
     * Get the 'Comment' element value.
     * 
     * @return value
     */
    public String getComment() {
        return comment;
    }

    /** 
     * Set the 'Comment' element value.
     * 
     * @param comment
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
}
