
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PreReservedSeat.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="SeatNumber"/>
 *     &lt;xs:element type="xs:boolean" name="SmokingPrefOfferedIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SeatTypeCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="BoardingPassIssueFlag" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SeatStatusCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PreviousSeatStatusCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Status" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="IsAEAssociated" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="IsPREdit" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CogFlight.PNRB" name="Cog" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CompartmentNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="BoardPoint" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OffPoint" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:dateTime" name="ArrivalTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Changed" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="NameNumber" minOccurs="0"/>
 *     &lt;xs:element type="ns:FormerFlight.PNRB" name="FormerFlight" minOccurs="0"/>
 *     &lt;xs:element type="ns:PADISCodes.PNRB" name="PADISCodes" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PreReservedSeatPNRB implements Serializable
{
    private String seatNumber;
    private Boolean smokingPrefOfferedIndicator;
    private String seatTypeCode;
    private Boolean boardingPassIssueFlag;
    private String seatStatusCode;
    private String previousSeatStatusCode;
    private String status;
    private Boolean isAEAssociated;
    private Boolean isPREdit;
    private CogFlightPNRB cog;
    private String compartmentNumber;
    private String boardPoint;
    private String offPoint;
    private Date departureTime;
    private Date arrivalTime;
    private String changed;
    private String nameNumber;
    private FormerFlightPNRB formerFlight;
    private PADISCodesPNRB PADISCodes;
    private String id;
    private OperationTypePNRB op;

    /** 
     * Get the 'SeatNumber' element value. Seat number. Ex."7D"
     * 
     * @return value
     */
    public String getSeatNumber() {
        return seatNumber;
    }

    /** 
     * Set the 'SeatNumber' element value. Seat number. Ex."7D"
     * 
     * @param seatNumber
     */
    public void setSeatNumber(String seatNumber) {
        this.seatNumber = seatNumber;
    }

    /** 
     * Get the 'SmokingPrefOfferedIndicator' element value.
     * 
     * @return value
     */
    public Boolean getSmokingPrefOfferedIndicator() {
        return smokingPrefOfferedIndicator;
    }

    /** 
     * Set the 'SmokingPrefOfferedIndicator' element value.
     * 
     * @param smokingPrefOfferedIndicator
     */
    public void setSmokingPrefOfferedIndicator(
            Boolean smokingPrefOfferedIndicator) {
        this.smokingPrefOfferedIndicator = smokingPrefOfferedIndicator;
    }

    /** 
     * Get the 'SeatTypeCode' element value. Information about the seat. Ex."ARMI"
     * 
     * @return value
     */
    public String getSeatTypeCode() {
        return seatTypeCode;
    }

    /** 
     * Set the 'SeatTypeCode' element value. Information about the seat. Ex."ARMI"
     * 
     * @param seatTypeCode
     */
    public void setSeatTypeCode(String seatTypeCode) {
        this.seatTypeCode = seatTypeCode;
    }

    /** 
     * Get the 'BoardingPassIssueFlag' element value. True/False indicator for the boarding pass issuance. Ex."TRUE"
                      
     * 
     * @return value
     */
    public Boolean getBoardingPassIssueFlag() {
        return boardingPassIssueFlag;
    }

    /** 
     * Set the 'BoardingPassIssueFlag' element value. True/False indicator for the boarding pass issuance. Ex."TRUE"
                      
     * 
     * @param boardingPassIssueFlag
     */
    public void setBoardingPassIssueFlag(Boolean boardingPassIssueFlag) {
        this.boardingPassIssueFlag = boardingPassIssueFlag;
    }

    /** 
     * Get the 'SeatStatusCode' element value. Current status of the seat request. Ex."HK"
     * 
     * @return value
     */
    public String getSeatStatusCode() {
        return seatStatusCode;
    }

    /** 
     * Set the 'SeatStatusCode' element value. Current status of the seat request. Ex."HK"
     * 
     * @param seatStatusCode
     */
    public void setSeatStatusCode(String seatStatusCode) {
        this.seatStatusCode = seatStatusCode;
    }

    /** 
     * Get the 'PreviousSeatStatusCode' element value. Previous status of the seat request. Ex."NN"
     * 
     * @return value
     */
    public String getPreviousSeatStatusCode() {
        return previousSeatStatusCode;
    }

    /** 
     * Set the 'PreviousSeatStatusCode' element value. Previous status of the seat request. Ex."NN"
     * 
     * @param previousSeatStatusCode
     */
    public void setPreviousSeatStatusCode(String previousSeatStatusCode) {
        this.previousSeatStatusCode = previousSeatStatusCode;
    }

    /** 
     * Get the 'Status' element value. "Status" is used to return the seat status code.
     * 
     * @return value
     */
    public String getStatus() {
        return status;
    }

    /** 
     * Set the 'Status' element value. "Status" is used to return the seat status code.
     * 
     * @param status
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /** 
     * Get the 'IsAEAssociated' element value.
     * 
     * @return value
     */
    public Boolean getIsAEAssociated() {
        return isAEAssociated;
    }

    /** 
     * Set the 'IsAEAssociated' element value.
     * 
     * @param isAEAssociated
     */
    public void setIsAEAssociated(Boolean isAEAssociated) {
        this.isAEAssociated = isAEAssociated;
    }

    /** 
     * Get the 'IsPREdit' element value.
     * 
     * @return value
     */
    public Boolean getIsPREdit() {
        return isPREdit;
    }

    /** 
     * Set the 'IsPREdit' element value.
     * 
     * @param isPREdit
     */
    public void setIsPREdit(Boolean isPREdit) {
        this.isPREdit = isPREdit;
    }

    /** 
     * Get the 'Cog' element value.
     * 
     * @return value
     */
    public CogFlightPNRB getCog() {
        return cog;
    }

    /** 
     * Set the 'Cog' element value.
     * 
     * @param cog
     */
    public void setCog(CogFlightPNRB cog) {
        this.cog = cog;
    }

    /** 
     * Get the 'CompartmentNumber' element value.
     * 
     * @return value
     */
    public String getCompartmentNumber() {
        return compartmentNumber;
    }

    /** 
     * Set the 'CompartmentNumber' element value.
     * 
     * @param compartmentNumber
     */
    public void setCompartmentNumber(String compartmentNumber) {
        this.compartmentNumber = compartmentNumber;
    }

    /** 
     * Get the 'BoardPoint' element value.
     * 
     * @return value
     */
    public String getBoardPoint() {
        return boardPoint;
    }

    /** 
     * Set the 'BoardPoint' element value.
     * 
     * @param boardPoint
     */
    public void setBoardPoint(String boardPoint) {
        this.boardPoint = boardPoint;
    }

    /** 
     * Get the 'OffPoint' element value.
     * 
     * @return value
     */
    public String getOffPoint() {
        return offPoint;
    }

    /** 
     * Set the 'OffPoint' element value.
     * 
     * @param offPoint
     */
    public void setOffPoint(String offPoint) {
        this.offPoint = offPoint;
    }

    /** 
     * Get the 'DepartureTime' element value.
     * 
     * @return value
     */
    public Date getDepartureTime() {
        return departureTime;
    }

    /** 
     * Set the 'DepartureTime' element value.
     * 
     * @param departureTime
     */
    public void setDepartureTime(Date departureTime) {
        this.departureTime = departureTime;
    }

    /** 
     * Get the 'ArrivalTime' element value.
     * 
     * @return value
     */
    public Date getArrivalTime() {
        return arrivalTime;
    }

    /** 
     * Set the 'ArrivalTime' element value.
     * 
     * @param arrivalTime
     */
    public void setArrivalTime(Date arrivalTime) {
        this.arrivalTime = arrivalTime;
    }

    /** 
     * Get the 'Changed' element value. "Changed" is used to indicate if the passenger's seat as been changed.
     * 
     * @return value
     */
    public String getChanged() {
        return changed;
    }

    /** 
     * Set the 'Changed' element value. "Changed" is used to indicate if the passenger's seat as been changed.
     * 
     * @param changed
     */
    public void setChanged(String changed) {
        this.changed = changed;
    }

    /** 
     * Get the 'NameNumber' element value. "NameNumber" is used return the passenger name number associated with the particular seat reservation.
     * 
     * @return value
     */
    public String getNameNumber() {
        return nameNumber;
    }

    /** 
     * Set the 'NameNumber' element value. "NameNumber" is used return the passenger name number associated with the particular seat reservation.
     * 
     * @param nameNumber
     */
    public void setNameNumber(String nameNumber) {
        this.nameNumber = nameNumber;
    }

    /** 
     * Get the 'FormerFlight' element value.
     * 
     * @return value
     */
    public FormerFlightPNRB getFormerFlight() {
        return formerFlight;
    }

    /** 
     * Set the 'FormerFlight' element value.
     * 
     * @param formerFlight
     */
    public void setFormerFlight(FormerFlightPNRB formerFlight) {
        this.formerFlight = formerFlight;
    }

    /** 
     * Get the 'PADISCodes' element value.
     * 
     * @return value
     */
    public PADISCodesPNRB getPADISCodes() {
        return PADISCodes;
    }

    /** 
     * Set the 'PADISCodes' element value.
     * 
     * @param PADISCodes
     */
    public void setPADISCodes(PADISCodesPNRB PADISCodes) {
        this.PADISCodes = PADISCodes;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }
}
