
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuoteOptions.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PriceQuoteStatus.PNRB" name="Status" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuoteType.PNRB" name="Type" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CustomDetails" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PriceQuoteResultType.PNRB" name="ResultType" minOccurs="0"/>
 *     &lt;xs:choice>
 *       &lt;xs:element type="xs:integer" name="PqNumber" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;xs:element type="ns:PriceQuoteTravelItinerary.PNRB" name="TravelItinerary" minOccurs="0"/>
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteOptionsPNRB implements Serializable
{
    private PriceQuoteStatusPNRB status;
    private PriceQuoteTypePNRB type;
    private List<String> customDetailList = new ArrayList<String>();
    private PriceQuoteResultTypePNRB resultType;
    private int choiceSelect = -1;
    private static final int PQ_NUMBER_LIST_CHOICE = 0;
    private static final int TRAVEL_ITINERARY_CHOICE = 1;
    private List<BigInteger> pqNumberList = new ArrayList<BigInteger>();
    private PriceQuoteTravelItineraryPNRB travelItinerary;

    /** 
     * Get the 'Status' element value. PQ status -
                          Valid Status:
                          A = Active (airline and agencies)
                          I = Inactive (airline only)
                          X = Expired (airlines only)
                          M = Manual (airlines only)
                          D = Deleted (agencies only)
                          H = History (airlines only)
                      
     * 
     * @return value
     */
    public PriceQuoteStatusPNRB getStatus() {
        return status;
    }

    /** 
     * Set the 'Status' element value. PQ status -
                          Valid Status:
                          A = Active (airline and agencies)
                          I = Inactive (airline only)
                          X = Expired (airlines only)
                          M = Manual (airlines only)
                          D = Deleted (agencies only)
                          H = History (airlines only)
                      
     * 
     * @param status
     */
    public void setStatus(PriceQuoteStatusPNRB status) {
        this.status = status;
    }

    /** 
     * Get the 'Type' element value. Price Quote Type

                          Possible values can be:
                          PQ - Price Quote
                          PQR - Price Quote Reissue

                          If not specified, it defaults to PQ
                      
     * 
     * @return value
     */
    public PriceQuoteTypePNRB getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. Price Quote Type

                          Possible values can be:
                          PQ - Price Quote
                          PQR - Price Quote Reissue

                          If not specified, it defaults to PQ
                      
     * 
     * @param type
     */
    public void setType(PriceQuoteTypePNRB type) {
        this.type = type;
    }

    /** 
     * Get the list of 'CustomDetails' element items. If @resultType=C attribute is specified (Custom), then requested data sections needs to be defined in this
                          element, each section as separate element.
                          Available sections are:
                          - NameAssociationInfo
                          - SegmentInfo
                          - FareInfo
                          - AdditionalFareInfo
                          - FeeInfo
                          - MiscellaneousInfo
                          - PaymentInfo
                          - HistoryInfo
                      
     * 
     * @return list
     */
    public List<String> getCustomDetailList() {
        return customDetailList;
    }

    /** 
     * Set the list of 'CustomDetails' element items. If @resultType=C attribute is specified (Custom), then requested data sections needs to be defined in this
                          element, each section as separate element.
                          Available sections are:
                          - NameAssociationInfo
                          - SegmentInfo
                          - FareInfo
                          - AdditionalFareInfo
                          - FeeInfo
                          - MiscellaneousInfo
                          - PaymentInfo
                          - HistoryInfo
                      
     * 
     * @param list
     */
    public void setCustomDetailList(List<String> list) {
        customDetailList = list;
    }

    /** 
     * Get the 'ResultType' element value. A code that represents the format of response to be returned.

                          If resultType=D is specified (Detail), both Details and Name Association info will be returned in the response.

                          If @resultType=C attribute is specified (Custom), then requested data sections needs to be defined in this
                          element, each section as separate element.
                          Available sections are:
                          - NameAssociationInfo
                          - SegmentInfo
                          - FareInfo
                          - FeeInfo
                          - MiscellaneousInfo

                          If resultType=S is specified, only summary of PriceQuote and Name association/Unassociated will be returned in response

                          If resultType= B is specified, Active NameAssociated priceQuotes and summary breakdown of Pricequotes by passenger type will be returned in reponse(PQSB)

                      
     * 
     * @return value
     */
    public PriceQuoteResultTypePNRB getResultType() {
        return resultType;
    }

    /** 
     * Set the 'ResultType' element value. A code that represents the format of response to be returned.

                          If resultType=D is specified (Detail), both Details and Name Association info will be returned in the response.

                          If @resultType=C attribute is specified (Custom), then requested data sections needs to be defined in this
                          element, each section as separate element.
                          Available sections are:
                          - NameAssociationInfo
                          - SegmentInfo
                          - FareInfo
                          - FeeInfo
                          - MiscellaneousInfo

                          If resultType=S is specified, only summary of PriceQuote and Name association/Unassociated will be returned in response

                          If resultType= B is specified, Active NameAssociated priceQuotes and summary breakdown of Pricequotes by passenger type will be returned in reponse(PQSB)

                      
     * 
     * @param resultType
     */
    public void setResultType(PriceQuoteResultTypePNRB resultType) {
        this.resultType = resultType;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if PqNumberList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPqNumberList() {
        return choiceSelect == PQ_NUMBER_LIST_CHOICE;
    }

    /** 
     * Get the list of 'PqNumber' element items. PQ sequence number as stored and displayed from the database

                              If not specified, it defaults to ALL PQs attached to the PNR
                          
     * 
     * @return list
     */
    public List<BigInteger> getPqNumberList() {
        return pqNumberList;
    }

    /** 
     * Set the list of 'PqNumber' element items. PQ sequence number as stored and displayed from the database

                              If not specified, it defaults to ALL PQs attached to the PNR
                          
     * 
     * @param list
     */
    public void setPqNumberList(List<BigInteger> list) {
        setChoiceSelect(PQ_NUMBER_LIST_CHOICE);
        pqNumberList = list;
    }

    /** 
     * Check if TravelItinerary is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTravelItinerary() {
        return choiceSelect == TRAVEL_ITINERARY_CHOICE;
    }

    /** 
     * Get the 'TravelItinerary' element value. Searched Price Quote information by TravelItinerary
     * 
     * @return value
     */
    public PriceQuoteTravelItineraryPNRB getTravelItinerary() {
        return travelItinerary;
    }

    /** 
     * Set the 'TravelItinerary' element value. Searched Price Quote information by TravelItinerary
     * 
     * @param travelItinerary
     */
    public void setTravelItinerary(PriceQuoteTravelItineraryPNRB travelItinerary) {
        setChoiceSelect(TRAVEL_ITINERARY_CHOICE);
        this.travelItinerary = travelItinerary;
    }
}
