
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuoteTravelItinerary.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="NameNumber" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="ns:PriceQuoteSegmentSearch.PNRB" name="Segment" maxOccurs="30"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteTravelItineraryPNRB implements Serializable
{
    private List<String> nameNumberList = new ArrayList<String>();
    private List<PriceQuoteSegmentSearchPNRB> segmentList = new ArrayList<PriceQuoteSegmentSearchPNRB>();

    /** 
     * Get the list of 'NameNumber' element items. A sequence number of the customer name as it is stored in the reservation record.
     * 
     * @return list
     */
    public List<String> getNameNumberList() {
        return nameNumberList;
    }

    /** 
     * Set the list of 'NameNumber' element items. A sequence number of the customer name as it is stored in the reservation record.
     * 
     * @param list
     */
    public void setNameNumberList(List<String> list) {
        nameNumberList = list;
    }

    /** 
     * Get the list of 'Segment' element items. repeats on the number of itinerary segments
     * 
     * @return list
     */
    public List<PriceQuoteSegmentSearchPNRB> getSegmentList() {
        return segmentList;
    }

    /** 
     * Set the list of 'Segment' element items. repeats on the number of itinerary segments
     * 
     * @param list
     */
    public void setSegmentList(List<PriceQuoteSegmentSearchPNRB> list) {
        segmentList = list;
    }
}
