
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedItinerary.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="AirItineraryPricingInfo" minOccurs="0">
 *       &lt;!-- Reference to inner class AirItineraryPricingInfo -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:NetTicketingInfoType" name="NetTicketingInfo" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TaxExempt"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="StatusCode"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="SequenceNumber"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InputMessage"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ValidatingCarrier"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PricedItineraryPNRB implements Serializable
{
    private AirItineraryPricingInfo airItineraryPricingInfo;
    private NetTicketingInfoType netTicketingInfo;
    private String taxExempt;
    private String statusCode;
    private BigInteger sequenceNumber;
    private String inputMessage;
    private String validatingCarrier;

    /** 
     * Get the 'AirItineraryPricingInfo' element value.
     * 
     * @return value
     */
    public AirItineraryPricingInfo getAirItineraryPricingInfo() {
        return airItineraryPricingInfo;
    }

    /** 
     * Set the 'AirItineraryPricingInfo' element value.
     * 
     * @param airItineraryPricingInfo
     */
    public void setAirItineraryPricingInfo(
            AirItineraryPricingInfo airItineraryPricingInfo) {
        this.airItineraryPricingInfo = airItineraryPricingInfo;
    }

    /** 
     * Get the 'NetTicketingInfo' element value.
     * 
     * @return value
     */
    public NetTicketingInfoType getNetTicketingInfo() {
        return netTicketingInfo;
    }

    /** 
     * Set the 'NetTicketingInfo' element value.
     * 
     * @param netTicketingInfo
     */
    public void setNetTicketingInfo(NetTicketingInfoType netTicketingInfo) {
        this.netTicketingInfo = netTicketingInfo;
    }

    /** 
     * Get the 'TaxExempt' attribute value. Tax exemption.
     * 
     * @return value
     */
    public String getTaxExempt() {
        return taxExempt;
    }

    /** 
     * Set the 'TaxExempt' attribute value. Tax exemption.
     * 
     * @param taxExempt
     */
    public void setTaxExempt(String taxExempt) {
        this.taxExempt = taxExempt;
    }

    /** 
     * Get the 'StatusCode' attribute value. Status code.
     * 
     * @return value
     */
    public String getStatusCode() {
        return statusCode;
    }

    /** 
     * Set the 'StatusCode' attribute value. Status code.
     * 
     * @param statusCode
     */
    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    /** 
     * Get the 'SequenceNumber' attribute value. SequenceNumber.
     * 
     * @return value
     */
    public BigInteger getSequenceNumber() {
        return sequenceNumber;
    }

    /** 
     * Set the 'SequenceNumber' attribute value. SequenceNumber.
     * 
     * @param sequenceNumber
     */
    public void setSequenceNumber(BigInteger sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    /** 
     * Get the 'InputMessage' attribute value. InputMessage.
     * 
     * @return value
     */
    public String getInputMessage() {
        return inputMessage;
    }

    /** 
     * Set the 'InputMessage' attribute value. InputMessage.
     * 
     * @param inputMessage
     */
    public void setInputMessage(String inputMessage) {
        this.inputMessage = inputMessage;
    }

    /** 
     * Get the 'ValidatingCarrier' attribute value. Validating Carrier
     * 
     * @return value
     */
    public String getValidatingCarrier() {
        return validatingCarrier;
    }

    /** 
     * Set the 'ValidatingCarrier' attribute value. Validating Carrier
     * 
     * @param validatingCarrier
     */
    public void setValidatingCarrier(String validatingCarrier) {
        this.validatingCarrier = validatingCarrier;
    }
    /** 
     * Airitinerary pricing information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirItineraryPricingInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence minOccurs="0">
     *       &lt;!-- Reference to inner class AirItineraryPricingInfoInner -->
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AirItineraryPricingInfo implements Serializable
    {
        private AirItineraryPricingInfoInner airItineraryPricingInfo;

        /** 
         * Get the 'AirItineraryPricingInfo' element value.
         * 
         * @return value
         */
        public AirItineraryPricingInfoInner getAirItineraryPricingInfo() {
            return airItineraryPricingInfo;
        }

        /** 
         * Set the 'AirItineraryPricingInfo' element value.
         * 
         * @param airItineraryPricingInfo
         */
        public void setAirItineraryPricingInfo(
                AirItineraryPricingInfoInner airItineraryPricingInfo) {
            this.airItineraryPricingInfo = airItineraryPricingInfo;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:sequence xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
         *   &lt;xs:element type="ns:FeeDetailsTotal" name="ItinTotalFare" minOccurs="0" maxOccurs="unbounded"/>
         *   &lt;xs:element type="ns:FareBreakdown" name="PTC_FareBreakdown" minOccurs="0" maxOccurs="unbounded"/>
         *   &lt;xs:element type="ns:TicketingFees" name="TicketingFees" minOccurs="0"/>
         *   &lt;xs:element type="ns:SignatureLine" name="SignatureLine" minOccurs="0"/>
         * &lt;/xs:sequence>
         * </pre>
         */
        public static class AirItineraryPricingInfoInner implements
            Serializable
        {
            private List<FeeDetailsTotal> itinTotalFareList = new ArrayList<FeeDetailsTotal>();
            private List<FareBreakdown> PTCFareBreakdownList = new ArrayList<FareBreakdown>();
            private TicketingFees ticketingFees;
            private SignatureLine signatureLine;

            /** 
             * Get the list of 'ItinTotalFare' element items. Air itinerary total fare information.
             * 
             * @return list
             */
            public List<FeeDetailsTotal> getItinTotalFareList() {
                return itinTotalFareList;
            }

            /** 
             * Set the list of 'ItinTotalFare' element items. Air itinerary total fare information.
             * 
             * @param list
             */
            public void setItinTotalFareList(List<FeeDetailsTotal> list) {
                itinTotalFareList = list;
            }

            /** 
             * Get the list of 'PTC_FareBreakdown' element items. PTC fare breakdown information.
             * 
             * @return list
             */
            public List<FareBreakdown> getPTCFareBreakdownList() {
                return PTCFareBreakdownList;
            }

            /** 
             * Set the list of 'PTC_FareBreakdown' element items. PTC fare breakdown information.
             * 
             * @param list
             */
            public void setPTCFareBreakdownList(List<FareBreakdown> list) {
                PTCFareBreakdownList = list;
            }

            /** 
             * Get the 'TicketingFees' element value. Ticketing fees.
             * 
             * @return value
             */
            public TicketingFees getTicketingFees() {
                return ticketingFees;
            }

            /** 
             * Set the 'TicketingFees' element value. Ticketing fees.
             * 
             * @param ticketingFees
             */
            public void setTicketingFees(TicketingFees ticketingFees) {
                this.ticketingFees = ticketingFees;
            }

            /** 
             * Get the 'SignatureLine' element value. Agent signature line.
             * 
             * @return value
             */
            public SignatureLine getSignatureLine() {
                return signatureLine;
            }

            /** 
             * Set the 'SignatureLine' element value. Agent signature line.
             * 
             * @param signatureLine
             */
            public void setSignatureLine(SignatureLine signatureLine) {
                this.signatureLine = signatureLine;
            }
        }
    }
}
