
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfilesDataGroup.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ProfileID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ProfileType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PolicyId" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PreferenceId" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PolicyRemovalReason" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OwningAgency" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:group>
 * </pre>
 */
public class ProfilesDataGroupPNRB implements Serializable
{
    private String profileID;
    private String profileType;
    private String policyId;
    private String preferenceId;
    private String policyRemovalReason;
    private String owningAgency;

    /** 
     * Get the 'ProfileID' element value. Profile ID
     * 
     * @return value
     */
    public String getProfileID() {
        return profileID;
    }

    /** 
     * Set the 'ProfileID' element value. Profile ID
     * 
     * @param profileID
     */
    public void setProfileID(String profileID) {
        this.profileID = profileID;
    }

    /** 
     * Get the 'ProfileType' element value. Profile Type like TVL, CRP eyc
     * 
     * @return value
     */
    public String getProfileType() {
        return profileType;
    }

    /** 
     * Set the 'ProfileType' element value. Profile Type like TVL, CRP eyc
     * 
     * @param profileType
     */
    public void setProfileType(String profileType) {
        this.profileType = profileType;
    }

    /** 
     * Get the 'PolicyId' element value.
     * 
     * @return value
     */
    public String getPolicyId() {
        return policyId;
    }

    /** 
     * Set the 'PolicyId' element value.
     * 
     * @param policyId
     */
    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    /** 
     * Get the 'PreferenceId' element value.
     * 
     * @return value
     */
    public String getPreferenceId() {
        return preferenceId;
    }

    /** 
     * Set the 'PreferenceId' element value.
     * 
     * @param preferenceId
     */
    public void setPreferenceId(String preferenceId) {
        this.preferenceId = preferenceId;
    }

    /** 
     * Get the 'PolicyRemovalReason' element value.
     * 
     * @return value
     */
    public String getPolicyRemovalReason() {
        return policyRemovalReason;
    }

    /** 
     * Set the 'PolicyRemovalReason' element value.
     * 
     * @param policyRemovalReason
     */
    public void setPolicyRemovalReason(String policyRemovalReason) {
        this.policyRemovalReason = policyRemovalReason;
    }

    /** 
     * Get the 'OwningAgency' element value. 
                          This attribute specifies the PCC, where the profile exist.
                          It can be of alphanumeric value of 4 length.
                      
     * 
     * @return value
     */
    public String getOwningAgency() {
        return owningAgency;
    }

    /** 
     * Set the 'OwningAgency' element value. 
                          This attribute specifies the PCC, where the profile exist.
                          It can be of alphanumeric value of 4 length.
                      
     * 
     * @param owningAgency
     */
    public void setOwningAgency(String owningAgency) {
        this.owningAgency = owningAgency;
    }
}
