
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Profiles.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Profile" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Profile -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProfilesPNRB implements Serializable
{
    private List<Profile> profileList = new ArrayList<Profile>();

    /** 
     * Get the list of 'Profile' element items.
     * 
     * @return list
     */
    public List<Profile> getProfileList() {
        return profileList;
    }

    /** 
     * Set the list of 'Profile' element items.
     * 
     * @param list
     */
    public void setProfileList(List<Profile> list) {
        profileList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Profile" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:group ref="ns:ProfilesDataGroup.PNRB"/>
     *       &lt;xs:element type="xs:string" name="AirlineCode" minOccurs="0"/>
     *       &lt;xs:element type="ns:CustomerLoyalty" name="FrequentFlyer" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="ns:CV_Score" name="ValueScore" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" name="id"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Profile implements Serializable
    {
        private ProfilesDataGroupPNRB profilesDataGroupPNRB;
        private String airlineCode;
        private List<CustomerLoyalty> frequentFlyerList = new ArrayList<CustomerLoyalty>();
        private List<CVScore> valueScoreList = new ArrayList<CVScore>();
        private String id;

        /** 
         * Get the 'ProfilesDataGroup.PNRB' group value.
         * 
         * @return value
         */
        public ProfilesDataGroupPNRB getProfilesDataGroupPNRB() {
            return profilesDataGroupPNRB;
        }

        /** 
         * Set the 'ProfilesDataGroup.PNRB' group value.
         * 
         * @param profilesDataGroupPNRB
         */
        public void setProfilesDataGroupPNRB(
                ProfilesDataGroupPNRB profilesDataGroupPNRB) {
            this.profilesDataGroupPNRB = profilesDataGroupPNRB;
        }

        /** 
         * Get the 'AirlineCode' element value. Profile Type like TVL, CRP eyc
         * 
         * @return value
         */
        public String getAirlineCode() {
            return airlineCode;
        }

        /** 
         * Set the 'AirlineCode' element value. Profile Type like TVL, CRP eyc
         * 
         * @param airlineCode
         */
        public void setAirlineCode(String airlineCode) {
            this.airlineCode = airlineCode;
        }

        /** 
         * Get the list of 'FrequentFlyer' element items.
         * 
         * @return list
         */
        public List<CustomerLoyalty> getFrequentFlyerList() {
            return frequentFlyerList;
        }

        /** 
         * Set the list of 'FrequentFlyer' element items.
         * 
         * @param list
         */
        public void setFrequentFlyerList(List<CustomerLoyalty> list) {
            frequentFlyerList = list;
        }

        /** 
         * Get the list of 'ValueScore' element items.
         * 
         * @return list
         */
        public List<CVScore> getValueScoreList() {
            return valueScoreList;
        }

        /** 
         * Set the list of 'ValueScore' element items.
         * 
         * @param list
         */
        public void setValueScoreList(List<CVScore> list) {
            valueScoreList = list;
        }

        /** 
         * Get the 'id' attribute value.
         * 
         * @return value
         */
        public String getId() {
            return id;
        }

        /** 
         * Set the 'id' attribute value.
         * 
         * @param id
         */
        public void setId(String id) {
            this.id = id;
        }
    }
}
