
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReservationEmail.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:EmailLines.PNRB" name="EmailText" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Subject" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PseudoEmailAddress" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="xs:boolean" name="highPriority"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ReservationEmailPNRB implements Serializable
{
    private EmailLinesPNRB emailText;
    private String subject;
    private String pseudoEmailAddress;
    private String id;
    private Boolean highPriority;
    private OperationTypePNRB op;
    private String RPH;

    /** 
     * Get the 'EmailText' element value.
     * 
     * @return value
     */
    public EmailLinesPNRB getEmailText() {
        return emailText;
    }

    /** 
     * Set the 'EmailText' element value.
     * 
     * @param emailText
     */
    public void setEmailText(EmailLinesPNRB emailText) {
        this.emailText = emailText;
    }

    /** 
     * Get the 'Subject' element value. can be up to 65 chars
     * 
     * @return value
     */
    public String getSubject() {
        return subject;
    }

    /** 
     * Set the 'Subject' element value. can be up to 65 chars
     * 
     * @param subject
     */
    public void setSubject(String subject) {
        this.subject = subject;
    }

    /** 
     * Get the 'PseudoEmailAddress' element value. this field contains only the info to the left of
                          the @. This generates a pseudo email address for
                          use on the Sabre Virtually There website by
                          those travelers that do not want to provide
                          their real address.

                          max of 63 chars

                          You cannot use the _ char. If there is an _ char
                          to the left of the @ then you need to replace
                          that with two = (i.e., ==) The extra = counts as
                          a char towards the max # of chars

                          Use a / in place of a '
                      
     * 
     * @return value
     */
    public String getPseudoEmailAddress() {
        return pseudoEmailAddress;
    }

    /** 
     * Set the 'PseudoEmailAddress' element value. this field contains only the info to the left of
                          the @. This generates a pseudo email address for
                          use on the Sabre Virtually There website by
                          those travelers that do not want to provide
                          their real address.

                          max of 63 chars

                          You cannot use the _ char. If there is an _ char
                          to the left of the @ then you need to replace
                          that with two = (i.e., ==) The extra = counts as
                          a char towards the max # of chars

                          Use a / in place of a '
                      
     * 
     * @param pseudoEmailAddress
     */
    public void setPseudoEmailAddress(String pseudoEmailAddress) {
        this.pseudoEmailAddress = pseudoEmailAddress;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'highPriority' attribute value.
     * 
     * @return value
     */
    public Boolean getHighPriority() {
        return highPriority;
    }

    /** 
     * Set the 'highPriority' attribute value.
     * 
     * @param highPriority
     */
    public void setHighPriority(Boolean highPriority) {
        this.highPriority = highPriority;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
}
