
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResultAction">
 *   &lt;xs:choice minOccurs="0">
 *     &lt;!-- Reference to inner class Choice -->
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ResultAction implements Serializable
{
    private Choice choice;

    /** 
     * Get the 'ResultAction' complexType value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the 'ResultAction' complexType value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element name="QueuePlaceAction" minOccurs="0" maxOccurs="1">
     *     &lt;!-- Reference to inner class QueuePlaceAction -->
     *   &lt;/xs:element>
     *   &lt;xs:element type="xs:boolean" name="EvaluateOnly" maxOccurs="1"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int QUEUE_PLACE_ACTION_CHOICE = 0;
        private static final int EVALUATE_ONLY_CHOICE = 1;
        private QueuePlaceAction queuePlaceAction;
        private boolean evaluateOnly;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if QueuePlaceAction is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifQueuePlaceAction() {
            return choiceSelect == QUEUE_PLACE_ACTION_CHOICE;
        }

        /** 
         * Get the 'QueuePlaceAction' element value.
         * 
         * @return value
         */
        public QueuePlaceAction getQueuePlaceAction() {
            return queuePlaceAction;
        }

        /** 
         * Set the 'QueuePlaceAction' element value.
         * 
         * @param queuePlaceAction
         */
        public void setQueuePlaceAction(QueuePlaceAction queuePlaceAction) {
            setChoiceSelect(QUEUE_PLACE_ACTION_CHOICE);
            this.queuePlaceAction = queuePlaceAction;
        }

        /** 
         * Check if EvaluateOnly is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifEvaluateOnly() {
            return choiceSelect == EVALUATE_ONLY_CHOICE;
        }

        /** 
         * Get the 'EvaluateOnly' element value.
         * 
         * @return value
         */
        public boolean isEvaluateOnly() {
            return evaluateOnly;
        }

        /** 
         * Set the 'EvaluateOnly' element value.
         * 
         * @param evaluateOnly
         */
        public void setEvaluateOnly(boolean evaluateOnly) {
            setChoiceSelect(EVALUATE_ONLY_CHOICE);
            this.evaluateOnly = evaluateOnly;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueuePlaceAction" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:QueuePlacement" name="QueuePlacement" minOccurs="1" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class QueuePlaceAction implements Serializable
        {
            private List<QueuePlacement> queuePlacementList = new ArrayList<QueuePlacement>();

            /** 
             * Get the list of 'QueuePlacement' element items. Number and pit code of the queue, where pnr should be placed
                                      
             * 
             * @return list
             */
            public List<QueuePlacement> getQueuePlacementList() {
                return queuePlacementList;
            }

            /** 
             * Set the list of 'QueuePlacement' element items. Number and pit code of the queue, where pnr should be placed
                                      
             * 
             * @param list
             */
            public void setQueuePlacementList(List<QueuePlacement> list) {
                queuePlacementList = list;
            }
        }
    }
}
