
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReturnOptions.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="SubjectAreas" minOccurs="0">
 *       &lt;!-- Reference to inner class SubjectAreas -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="ViewName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" default="STL" name="ResponseFormat" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuoteOptions.PNRB" name="PriceQuote" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" default="false" name="UnmaskCreditCard"/>
 *   &lt;xs:attribute type="xs:boolean" default="false" name="ShowTicketStatus"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Language"/>
 *   &lt;xs:attribute type="xs:string" name="PriceQuoteServiceVersion"/>
 *   &lt;xs:attribute type="xs:boolean" default="false" name="IncludePaymentCardToken"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ReturnOptionsPNRB implements Serializable
{
    private SubjectAreas subjectAreas;
    private String viewName;
    private String responseFormat;
    private PriceQuoteOptionsPNRB priceQuote;
    private Boolean unmaskCreditCard;
    private Boolean showTicketStatus;
    private String language;
    private String priceQuoteServiceVersion;
    private Boolean includePaymentCardToken;

    /** 
     * Get the 'SubjectAreas' element value.
     * 
     * @return value
     */
    public SubjectAreas getSubjectAreas() {
        return subjectAreas;
    }

    /** 
     * Set the 'SubjectAreas' element value.
     * 
     * @param subjectAreas
     */
    public void setSubjectAreas(SubjectAreas subjectAreas) {
        this.subjectAreas = subjectAreas;
    }

    /** 
     * Get the 'ViewName' element value.
     * 
     * @return value
     */
    public String getViewName() {
        return viewName;
    }

    /** 
     * Set the 'ViewName' element value.
     * 
     * @param viewName
     */
    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    /** 
     * Get the 'ResponseFormat' element value.
     * 
     * @return value
     */
    public String getResponseFormat() {
        return responseFormat;
    }

    /** 
     * Set the 'ResponseFormat' element value.
     * 
     * @param responseFormat
     */
    public void setResponseFormat(String responseFormat) {
        this.responseFormat = responseFormat;
    }

    /** 
     * Get the 'PriceQuote' element value.
     * 
     * @return value
     */
    public PriceQuoteOptionsPNRB getPriceQuote() {
        return priceQuote;
    }

    /** 
     * Set the 'PriceQuote' element value.
     * 
     * @param priceQuote
     */
    public void setPriceQuote(PriceQuoteOptionsPNRB priceQuote) {
        this.priceQuote = priceQuote;
    }

    /** 
     * Get the 'UnmaskCreditCard' attribute value.
     * 
     * @return value
     */
    public Boolean getUnmaskCreditCard() {
        return unmaskCreditCard;
    }

    /** 
     * Set the 'UnmaskCreditCard' attribute value.
     * 
     * @param unmaskCreditCard
     */
    public void setUnmaskCreditCard(Boolean unmaskCreditCard) {
        this.unmaskCreditCard = unmaskCreditCard;
    }

    /** 
     * Get the 'ShowTicketStatus' attribute value. "ShowTicketStatus" is for specifying whether user wants status for each ticket or
                      not.
                  
     * 
     * @return value
     */
    public Boolean getShowTicketStatus() {
        return showTicketStatus;
    }

    /** 
     * Set the 'ShowTicketStatus' attribute value. "ShowTicketStatus" is for specifying whether user wants status for each ticket or
                      not.
                  
     * 
     * @param showTicketStatus
     */
    public void setShowTicketStatus(Boolean showTicketStatus) {
        this.showTicketStatus = showTicketStatus;
    }

    /** 
     * Get the 'Language' attribute value. "Language" is used to translate attributes (like Cabin name).
                  
     * 
     * @return value
     */
    public String getLanguage() {
        return language;
    }

    /** 
     * Set the 'Language' attribute value. "Language" is used to translate attributes (like Cabin name).
                  
     * 
     * @param language
     */
    public void setLanguage(String language) {
        this.language = language;
    }

    /** 
     * Get the 'PriceQuoteServiceVersion' attribute value. Defines version of service used to obtain Price Quote content.
                  
     * 
     * @return value
     */
    public String getPriceQuoteServiceVersion() {
        return priceQuoteServiceVersion;
    }

    /** 
     * Set the 'PriceQuoteServiceVersion' attribute value. Defines version of service used to obtain Price Quote content.
                  
     * 
     * @param priceQuoteServiceVersion
     */
    public void setPriceQuoteServiceVersion(String priceQuoteServiceVersion) {
        this.priceQuoteServiceVersion = priceQuoteServiceVersion;
    }

    /** 
     * Get the 'IncludePaymentCardToken' attribute value. "IncludePaymentCardToken" forces credit card form of payments to return a token and
                      mask the credit card number. This overrides the UnmaskCreditCard attribute and CCView.
                  
     * 
     * @return value
     */
    public Boolean getIncludePaymentCardToken() {
        return includePaymentCardToken;
    }

    /** 
     * Set the 'IncludePaymentCardToken' attribute value. "IncludePaymentCardToken" forces credit card form of payments to return a token and
                      mask the credit card number. This overrides the UnmaskCreditCard attribute and CCView.
                  
     * 
     * @param includePaymentCardToken
     */
    public void setIncludePaymentCardToken(Boolean includePaymentCardToken) {
        this.includePaymentCardToken = includePaymentCardToken;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SubjectAreas" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="SubjectArea" minOccurs="1" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SubjectAreas implements Serializable
    {
        private List<String> subjectAreaList = new ArrayList<String>();

        /** 
         * Get the list of 'SubjectArea' element items.
         * 
         * @return list
         */
        public List<String> getSubjectAreaList() {
            return subjectAreaList;
        }

        /** 
         * Set the list of 'SubjectArea' element items.
         * 
         * @param list
         */
        public void setSubjectAreaList(List<String> list) {
            subjectAreaList = list;
        }
    }
}
