
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * name associated.

 formats (AFAX and GFAX for all)

 * request seat assignment

 4(seat code)(seg #)-(name #)
 4NSST1-2.1

 * request seats for all segments for multiple name
 fields 4(seat code)(seg #)-(name #),(name #)
 4NSST1-1.1,2.0

 * request seats for specified segment for specified name
 number and add free text

 4(seat code)(seg #)/(free text)-(name number)
 4SMST4/WDW-2.1

 * request seats for specified segment for multiple
 specified name numbers and add free text

 4(seat code)(seg #)/(free text)-(name #),(name#)
 4NSST2/AISLE-1.1,2.0

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatRequest.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="SeatCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FlightNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="VendorCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FlightDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BoardCity" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OffCity" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Comment" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ActionCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ClassOfService" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="NumberInParty" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="ns:RequestType.PNRB" name="type"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:string" name="RPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatRequestPNRB implements Serializable
{
    private String seatCode;
    private String flightNumber;
    private String vendorCode;
    private String flightDate;
    private String boardCity;
    private String offCity;
    private String comment;
    private String actionCode;
    private String classOfService;
    private BigInteger numberInParty;
    private String id;
    private RequestTypePNRB type;
    private OperationTypePNRB op;
    private String RPH;

    /** 
     * Get the 'SeatCode' element value. Code indicating the type of SSR/OSI e.g. RQST, NSST.
     * 
     * @return value
     */
    public String getSeatCode() {
        return seatCode;
    }

    /** 
     * Set the 'SeatCode' element value. Code indicating the type of SSR/OSI e.g. RQST, NSST.
     * 
     * @param seatCode
     */
    public void setSeatCode(String seatCode) {
        this.seatCode = seatCode;
    }

    /** 
     * Get the 'FlightNumber' element value. The flight number of the associated flight. Ex."0002"
     * 
     * @return value
     */
    public String getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' element value. The flight number of the associated flight. Ex."0002"
     * 
     * @param flightNumber
     */
    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }

    /** 
     * Get the 'VendorCode' element value. Carrier OSI/SSR is being sent to. Ex."EY"
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' element value. Carrier OSI/SSR is being sent to. Ex."EY"
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'FlightDate' element value. Date that service starts for the flight. Ex."2013-07-29"
     * 
     * @return value
     */
    public String getFlightDate() {
        return flightDate;
    }

    /** 
     * Set the 'FlightDate' element value. Date that service starts for the flight. Ex."2013-07-29"
     * 
     * @param flightDate
     */
    public void setFlightDate(String flightDate) {
        this.flightDate = flightDate;
    }

    /** 
     * Get the 'BoardCity' element value. Start city for the flight. Ex."FRA"
     * 
     * @return value
     */
    public String getBoardCity() {
        return boardCity;
    }

    /** 
     * Set the 'BoardCity' element value. Start city for the flight. Ex."FRA"
     * 
     * @param boardCity
     */
    public void setBoardCity(String boardCity) {
        this.boardCity = boardCity;
    }

    /** 
     * Get the 'OffCity' element value. End/Arrival city of the flight. Ex."AUH"
     * 
     * @return value
     */
    public String getOffCity() {
        return offCity;
    }

    /** 
     * Set the 'OffCity' element value. End/Arrival city of the flight. Ex."AUH"
     * 
     * @param offCity
     */
    public void setOffCity(String offCity) {
        this.offCity = offCity;
    }

    /** 
     * Get the 'Comment' element value. Seat Comment. Ex."27HN27KN"
     * 
     * @return value
     */
    public String getComment() {
        return comment;
    }

    /** 
     * Set the 'Comment' element value. Seat Comment. Ex."27HN27KN"
     * 
     * @param comment
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    /** 
     * Get the 'ActionCode' element value. Indicates the current status of the SSR message. Ex."NN"
     * 
     * @return value
     */
    public String getActionCode() {
        return actionCode;
    }

    /** 
     * Set the 'ActionCode' element value. Indicates the current status of the SSR message. Ex."NN"
     * 
     * @param actionCode
     */
    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    /** 
     * Get the 'ClassOfService' element value. Class of service
     * 
     * @return value
     */
    public String getClassOfService() {
        return classOfService;
    }

    /** 
     * Set the 'ClassOfService' element value. Class of service
     * 
     * @param classOfService
     */
    public void setClassOfService(String classOfService) {
        this.classOfService = classOfService;
    }

    /** 
     * Get the 'NumberInParty' element value. Number of passengers for whom the Special Service Request
                          is being requested. Ex."1".
                      
     * 
     * @return value
     */
    public BigInteger getNumberInParty() {
        return numberInParty;
    }

    /** 
     * Set the 'NumberInParty' element value. Number of passengers for whom the Special Service Request
                          is being requested. Ex."1".
                      
     * 
     * @param numberInParty
     */
    public void setNumberInParty(BigInteger numberInParty) {
        this.numberInParty = numberInParty;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'type' attribute value. A = AFAX G = GFAX
     * 
     * @return value
     */
    public RequestTypePNRB getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. A = AFAX G = GFAX
     * 
     * @param type
     */
    public void setType(RequestTypePNRB type) {
        this.type = type;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
}
