
package com.sabre.webservices.pnrbuilder.v119;

import com.sabre.services.res.or.v114.ProductType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:ns1="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentType.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Poc" name="Poc" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element name="Air" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Air -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:Vehicle" name="Vehicle" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns1:ProductType" name="Product" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:Hotel" name="Hotel" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:Open" name="Open" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:Arunk" name="Arunk" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:GeneralSegmentType.PNRB" name="General" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element name="Segment" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Segment -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SegmentTypePNRB implements Serializable
{
    private Poc poc;
    private List<Air> airList = new ArrayList<Air>();
    private List<Vehicle> vehicleList = new ArrayList<Vehicle>();
    private List<ProductType> productList = new ArrayList<ProductType>();
    private List<Hotel> hotelList = new ArrayList<Hotel>();
    private List<Open> openList = new ArrayList<Open>();
    private List<Arunk> arunkList = new ArrayList<Arunk>();
    private List<GeneralSegmentTypePNRB> generalList = new ArrayList<GeneralSegmentTypePNRB>();
    private List<Segment> segmentList = new ArrayList<Segment>();

    /** 
     * Get the 'Poc' element value.
     * 
     * @return value
     */
    public Poc getPoc() {
        return poc;
    }

    /** 
     * Set the 'Poc' element value.
     * 
     * @param poc
     */
    public void setPoc(Poc poc) {
        this.poc = poc;
    }

    /** 
     * Get the list of 'Air' element items.
     * 
     * @return list
     */
    public List<Air> getAirList() {
        return airList;
    }

    /** 
     * Set the list of 'Air' element items.
     * 
     * @param list
     */
    public void setAirList(List<Air> list) {
        airList = list;
    }

    /** 
     * Get the list of 'Vehicle' element items. Vehicle rental
                          information.
                      
     * 
     * @return list
     */
    public List<Vehicle> getVehicleList() {
        return vehicleList;
    }

    /** 
     * Set the list of 'Vehicle' element items. Vehicle rental
                          information.
                      
     * 
     * @param list
     */
    public void setVehicleList(List<Vehicle> list) {
        vehicleList = list;
    }

    /** 
     * Get the list of 'Product' element items. Open Reservation Product
     * 
     * @return list
     */
    public List<ProductType> getProductList() {
        return productList;
    }

    /** 
     * Set the list of 'Product' element items. Open Reservation Product
     * 
     * @param list
     */
    public void setProductList(List<ProductType> list) {
        productList = list;
    }

    /** 
     * Get the list of 'Hotel' element items.
     * 
     * @return list
     */
    public List<Hotel> getHotelList() {
        return hotelList;
    }

    /** 
     * Set the list of 'Hotel' element items.
     * 
     * @param list
     */
    public void setHotelList(List<Hotel> list) {
        hotelList = list;
    }

    /** 
     * Get the list of 'Open' element items. Open Segment
                          Flight
                          reservation.
                      
     * 
     * @return list
     */
    public List<Open> getOpenList() {
        return openList;
    }

    /** 
     * Set the list of 'Open' element items. Open Segment
                          Flight
                          reservation.
                      
     * 
     * @param list
     */
    public void setOpenList(List<Open> list) {
        openList = list;
    }

    /** 
     * Get the list of 'Arunk' element items.
     * 
     * @return list
     */
    public List<Arunk> getArunkList() {
        return arunkList;
    }

    /** 
     * Set the list of 'Arunk' element items.
     * 
     * @param list
     */
    public void setArunkList(List<Arunk> list) {
        arunkList = list;
    }

    /** 
     * Get the list of 'General' element items.
     * 
     * @return list
     */
    public List<GeneralSegmentTypePNRB> getGeneralList() {
        return generalList;
    }

    /** 
     * Set the list of 'General' element items.
     * 
     * @param list
     */
    public void setGeneralList(List<GeneralSegmentTypePNRB> list) {
        generalList = list;
    }

    /** 
     * Get the list of 'Segment' element items.
     * 
     * @return list
     */
    public List<Segment> getSegmentList() {
        return segmentList;
    }

    /** 
     * Set the list of 'Segment' element items.
     * 
     * @param list
     */
    public void setSegmentList(List<Segment> list) {
        segmentList = list;
    }
    /** 
     * Flight reservation
                          information.
                      
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Air" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:AirType">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="CheckInAirline" minOccurs="0">
     *             &lt;!-- Reference to inner class CheckInAirline -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *         &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Air extends AirType implements Serializable
    {
        private CheckInAirline checkInAirline;
        private String RPH;

        /** 
         * Get the 'CheckInAirline' element value.
         * 
         * @return value
         */
        public CheckInAirline getCheckInAirline() {
            return checkInAirline;
        }

        /** 
         * Set the 'CheckInAirline' element value.
         * 
         * @param checkInAirline
         */
        public void setCheckInAirline(CheckInAirline checkInAirline) {
            this.checkInAirline = checkInAirline;
        }

        /** 
         * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                                            in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                                        
         * 
         * @return value
         */
        public String getRPH() {
            return RPH;
        }

        /** 
         * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                                            in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                                        
         * 
         * @param RPH
         */
        public void setRPH(String RPH) {
            this.RPH = RPH;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CheckInAirline" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="CompanyShortName"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CheckInAirline implements Serializable
        {
            private String code;
            private String companyShortName;

            /** 
             * Get the 'Code' attribute value. "Code" is used to return the check in airline code associated with the particular flight segment.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value. "Code" is used to return the check in airline code associated with the particular flight segment.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }

            /** 
             * Get the 'CompanyShortName' attribute value. "CompanyShortName" is used to return the check in airline name.
             * 
             * @return value
             */
            public String getCompanyShortName() {
                return companyShortName;
            }

            /** 
             * Set the 'CompanyShortName' attribute value. "CompanyShortName" is used to return the check in airline name.
             * 
             * @param companyShortName
             */
            public void setCompanyShortName(String companyShortName) {
                this.companyShortName = companyShortName;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:ns1="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:choice>
     *         &lt;xs:element name="Air" minOccurs="0">
     *           &lt;!-- Reference to inner class Air -->
     *         &lt;/xs:element>
     *         &lt;xs:element type="ns:Vehicle" name="Vehicle" minOccurs="0"/>
     *         &lt;xs:element type="ns:Hotel" name="Hotel" minOccurs="0"/>
     *         &lt;xs:element type="ns:Open" name="Open" minOccurs="0"/>
     *         &lt;xs:element type="ns:Arunk" name="Arunk" minOccurs="0"/>
     *         &lt;xs:element type="ns:GeneralSegmentType.PNRB" name="General" minOccurs="0"/>
     *       &lt;/xs:choice>
     *       &lt;xs:element type="ns1:ProductType" name="Product" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:short" name="sequence"/>
     *     &lt;xs:attribute type="xs:string" name="id"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Segment implements Serializable
    {
        private int choiceSelect = -1;
        private static final int AIR_CHOICE = 0;
        private static final int VEHICLE_CHOICE = 1;
        private static final int HOTEL_CHOICE = 2;
        private static final int OPEN_CHOICE = 3;
        private static final int ARUNK_CHOICE = 4;
        private static final int GENERAL_CHOICE = 5;
        private Air air;
        private Vehicle vehicle;
        private Hotel hotel;
        private Open open;
        private Arunk arunk;
        private GeneralSegmentTypePNRB general;
        private ProductType product;
        private Short sequence;
        private String id;
        private String RPH;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if Air is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAir() {
            return choiceSelect == AIR_CHOICE;
        }

        /** 
         * Get the 'Air' element value.
         * 
         * @return value
         */
        public Air getAir() {
            return air;
        }

        /** 
         * Set the 'Air' element value.
         * 
         * @param air
         */
        public void setAir(Air air) {
            setChoiceSelect(AIR_CHOICE);
            this.air = air;
        }

        /** 
         * Check if Vehicle is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifVehicle() {
            return choiceSelect == VEHICLE_CHOICE;
        }

        /** 
         * Get the 'Vehicle' element value. Vehicle rental
                                            information.
                                        
         * 
         * @return value
         */
        public Vehicle getVehicle() {
            return vehicle;
        }

        /** 
         * Set the 'Vehicle' element value. Vehicle rental
                                            information.
                                        
         * 
         * @param vehicle
         */
        public void setVehicle(Vehicle vehicle) {
            setChoiceSelect(VEHICLE_CHOICE);
            this.vehicle = vehicle;
        }

        /** 
         * Check if Hotel is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifHotel() {
            return choiceSelect == HOTEL_CHOICE;
        }

        /** 
         * Get the 'Hotel' element value.
         * 
         * @return value
         */
        public Hotel getHotel() {
            return hotel;
        }

        /** 
         * Set the 'Hotel' element value.
         * 
         * @param hotel
         */
        public void setHotel(Hotel hotel) {
            setChoiceSelect(HOTEL_CHOICE);
            this.hotel = hotel;
        }

        /** 
         * Check if Open is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOpen() {
            return choiceSelect == OPEN_CHOICE;
        }

        /** 
         * Get the 'Open' element value. Open Segment
                                            Flight
                                            reservation.
                                        
         * 
         * @return value
         */
        public Open getOpen() {
            return open;
        }

        /** 
         * Set the 'Open' element value. Open Segment
                                            Flight
                                            reservation.
                                        
         * 
         * @param open
         */
        public void setOpen(Open open) {
            setChoiceSelect(OPEN_CHOICE);
            this.open = open;
        }

        /** 
         * Check if Arunk is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifArunk() {
            return choiceSelect == ARUNK_CHOICE;
        }

        /** 
         * Get the 'Arunk' element value.
         * 
         * @return value
         */
        public Arunk getArunk() {
            return arunk;
        }

        /** 
         * Set the 'Arunk' element value.
         * 
         * @param arunk
         */
        public void setArunk(Arunk arunk) {
            setChoiceSelect(ARUNK_CHOICE);
            this.arunk = arunk;
        }

        /** 
         * Check if General is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifGeneral() {
            return choiceSelect == GENERAL_CHOICE;
        }

        /** 
         * Get the 'General' element value.
         * 
         * @return value
         */
        public GeneralSegmentTypePNRB getGeneral() {
            return general;
        }

        /** 
         * Set the 'General' element value.
         * 
         * @param general
         */
        public void setGeneral(GeneralSegmentTypePNRB general) {
            setChoiceSelect(GENERAL_CHOICE);
            this.general = general;
        }

        /** 
         * Get the 'Product' element value.
         * 
         * @return value
         */
        public ProductType getProduct() {
            return product;
        }

        /** 
         * Set the 'Product' element value.
         * 
         * @param product
         */
        public void setProduct(ProductType product) {
            this.product = product;
        }

        /** 
         * Get the 'sequence' attribute value. Identifies sequence number of Itinerary
                                
         * 
         * @return value
         */
        public Short getSequence() {
            return sequence;
        }

        /** 
         * Set the 'sequence' attribute value. Identifies sequence number of Itinerary
                                
         * 
         * @param sequence
         */
        public void setSequence(Short sequence) {
            this.sequence = sequence;
        }

        /** 
         * Get the 'id' attribute value.
         * 
         * @return value
         */
        public String getId() {
            return id;
        }

        /** 
         * Set the 'id' attribute value.
         * 
         * @param id
         */
        public void setId(String id) {
            this.id = id;
        }

        /** 
         * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                                    in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                                
         * 
         * @return value
         */
        public String getRPH() {
            return RPH;
        }

        /** 
         * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                                    in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                                
         * 
         * @param RPH
         */
        public void setRPH(String RPH) {
            this.RPH = RPH;
        }
        /** 
         * Flight reservation
                                            information.
                                        
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Air" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:AirType">
         *         &lt;xs:sequence>
         *           &lt;xs:element name="CheckInAirline" minOccurs="0">
         *             &lt;!-- Reference to inner class CheckInAirline -->
         *           &lt;/xs:element>
         *         &lt;/xs:sequence>
         *         &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Air extends AirType implements Serializable
        {
            private CheckInAirline checkInAirline;
            private String RPH;

            /** 
             * Get the 'CheckInAirline' element value.
             * 
             * @return value
             */
            public CheckInAirline getCheckInAirline() {
                return checkInAirline;
            }

            /** 
             * Set the 'CheckInAirline' element value.
             * 
             * @param checkInAirline
             */
            public void setCheckInAirline(CheckInAirline checkInAirline) {
                this.checkInAirline = checkInAirline;
            }

            /** 
             * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                                                              in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                                                          
             * 
             * @return value
             */
            public String getRPH() {
                return RPH;
            }

            /** 
             * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                                                              in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                                                          
             * 
             * @param RPH
             */
            public void setRPH(String RPH) {
                this.RPH = RPH;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CheckInAirline" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="CompanyShortName"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CheckInAirline implements Serializable
            {
                private String code;
                private String companyShortName;

                /** 
                 * Get the 'Code' attribute value. "Code" is used to return the check in airline code associated with the particular flight segment.
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value. "Code" is used to return the check in airline code associated with the particular flight segment.
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'CompanyShortName' attribute value. "CompanyShortName" is used to return the check in airline name.
                 * 
                 * @return value
                 */
                public String getCompanyShortName() {
                    return companyShortName;
                }

                /** 
                 * Set the 'CompanyShortName' attribute value. "CompanyShortName" is used to return the check in airline name.
                 * 
                 * @param companyShortName
                 */
                public void setCompanyShortName(String companyShortName) {
                    this.companyShortName = companyShortName;
                }
            }
        }
    }
}
