
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SubscriptionCardHistoryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="HistoryAction" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CardNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FreeText" minOccurs="0"/>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SubscriptionCardHistoryType implements Serializable
{
    private String historyAction;
    private String cardNumber;
    private String freeText;
    private Choice choice;

    /** 
     * Get the 'HistoryAction' element value.
     * 
     * @return value
     */
    public String getHistoryAction() {
        return historyAction;
    }

    /** 
     * Set the 'HistoryAction' element value.
     * 
     * @param historyAction
     */
    public void setHistoryAction(String historyAction) {
        this.historyAction = historyAction;
    }

    /** 
     * Get the 'CardNumber' element value.
     * 
     * @return value
     */
    public String getCardNumber() {
        return cardNumber;
    }

    /** 
     * Set the 'CardNumber' element value.
     * 
     * @param cardNumber
     */
    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    /** 
     * Get the 'FreeText' element value.
     * 
     * @return value
     */
    public String getFreeText() {
        return freeText;
    }

    /** 
     * Set the 'FreeText' element value.
     * 
     * @param freeText
     */
    public void setFreeText(String freeText) {
        this.freeText = freeText;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:SubscriptionCardBasicHistoryType" name="SubscriptionCardBasic" minOccurs="0"/>
     *   &lt;xs:element type="ns:SegmentAssociationTag.PNRB" name="SubscriptionCardSegment" minOccurs="0"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int SUBSCRIPTION_CARD_BASIC_CHOICE = 0;
        private static final int SUBSCRIPTION_CARD_SEGMENT_CHOICE = 1;
        private SubscriptionCardBasicHistoryType subscriptionCardBasic;
        private SegmentAssociationTagPNRB subscriptionCardSegment;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if SubscriptionCardBasic is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSubscriptionCardBasic() {
            return choiceSelect == SUBSCRIPTION_CARD_BASIC_CHOICE;
        }

        /** 
         * Get the 'SubscriptionCardBasic' element value.
         * 
         * @return value
         */
        public SubscriptionCardBasicHistoryType getSubscriptionCardBasic() {
            return subscriptionCardBasic;
        }

        /** 
         * Set the 'SubscriptionCardBasic' element value.
         * 
         * @param subscriptionCardBasic
         */
        public void setSubscriptionCardBasic(
                SubscriptionCardBasicHistoryType subscriptionCardBasic) {
            setChoiceSelect(SUBSCRIPTION_CARD_BASIC_CHOICE);
            this.subscriptionCardBasic = subscriptionCardBasic;
        }

        /** 
         * Check if SubscriptionCardSegment is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSubscriptionCardSegment() {
            return choiceSelect == SUBSCRIPTION_CARD_SEGMENT_CHOICE;
        }

        /** 
         * Get the 'SubscriptionCardSegment' element value.
         * 
         * @return value
         */
        public SegmentAssociationTagPNRB getSubscriptionCardSegment() {
            return subscriptionCardSegment;
        }

        /** 
         * Set the 'SubscriptionCardSegment' element value.
         * 
         * @param subscriptionCardSegment
         */
        public void setSubscriptionCardSegment(
                SegmentAssociationTagPNRB subscriptionCardSegment) {
            setChoiceSelect(SUBSCRIPTION_CARD_SEGMENT_CHOICE);
            this.subscriptionCardSegment = subscriptionCardSegment;
        }
    }
}
