
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDetailsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="OriginalTicketDetails" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TransactionIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TicketNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PassengerName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AgencyLocation" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DutyCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AgentSine" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="Timestamp" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PaymentType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TktEntry" minOccurs="0"/>
 *     &lt;xs:element type="ns:NameAssociationType" name="NameAssociation" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:SegmentAssociationType" name="SegmentAssociation" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="CouponStatus" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="PaperTicketInd" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Status" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="xs:integer" name="index"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="elementId"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TicketDetailsType implements Serializable
{
    private String originalTicketDetails;
    private String transactionIndicator;
    private String ticketNumber;
    private String passengerName;
    private String agencyLocation;
    private String dutyCode;
    private String agentSine;
    private Date timestamp;
    private String paymentType;
    private String tktEntry;
    private List<NameAssociationType> nameAssociationList = new ArrayList<NameAssociationType>();
    private List<SegmentAssociationType> segmentAssociationList = new ArrayList<SegmentAssociationType>();
    private String couponStatus;
    private Boolean paperTicketInd;
    private String status;
    private String id;
    private BigInteger index;
    private OperationTypePNRB op;
    private String elementId;
    private String RPH;

    /** 
     * Get the 'OriginalTicketDetails' element value.
     * 
     * @return value
     */
    public String getOriginalTicketDetails() {
        return originalTicketDetails;
    }

    /** 
     * Set the 'OriginalTicketDetails' element value.
     * 
     * @param originalTicketDetails
     */
    public void setOriginalTicketDetails(String originalTicketDetails) {
        this.originalTicketDetails = originalTicketDetails;
    }

    /** 
     * Get the 'TransactionIndicator' element value. Ticket entry code indicating the type of ticketing transaction. Ex."TE"
                      
     * 
     * @return value
     */
    public String getTransactionIndicator() {
        return transactionIndicator;
    }

    /** 
     * Set the 'TransactionIndicator' element value. Ticket entry code indicating the type of ticketing transaction. Ex."TE"
                      
     * 
     * @param transactionIndicator
     */
    public void setTransactionIndicator(String transactionIndicator) {
        this.transactionIndicator = transactionIndicator;
    }

    /** 
     * Get the 'TicketNumber' element value. Ticket number (or numbers in the case of conjunctive tickets) associated with the
                          indicated ticket issuance/refund/exchange/void activity.
                          SSR ticket number may contain the coupon number at the end of the ticket number. Tickets issued
                          by the hosted airline
                          will not include the three character airline ticket indicator at the beginning of the ticket
                          number. Ex."8.38218E+12"
                      
     * 
     * @return value
     */
    public String getTicketNumber() {
        return ticketNumber;
    }

    /** 
     * Set the 'TicketNumber' element value. Ticket number (or numbers in the case of conjunctive tickets) associated with the
                          indicated ticket issuance/refund/exchange/void activity.
                          SSR ticket number may contain the coupon number at the end of the ticket number. Tickets issued
                          by the hosted airline
                          will not include the three character airline ticket indicator at the beginning of the ticket
                          number. Ex."8.38218E+12"
                      
     * 
     * @param ticketNumber
     */
    public void setTicketNumber(String ticketNumber) {
        this.ticketNumber = ticketNumber;
    }

    /** 
     * Get the 'PassengerName' element value. First five characters of passenger last name and first initial of passenger first
                          name for
                          whom the ticket was issued. Only populated on TK/TE/TR/TM ResArrActionCodes. Ex. "CAMPB/A"
                      
     * 
     * @return value
     */
    public String getPassengerName() {
        return passengerName;
    }

    /** 
     * Set the 'PassengerName' element value. First five characters of passenger last name and first initial of passenger first
                          name for
                          whom the ticket was issued. Only populated on TK/TE/TR/TM ResArrActionCodes. Ex. "CAMPB/A"
                      
     * 
     * @param passengerName
     */
    public void setPassengerName(String passengerName) {
        this.passengerName = passengerName;
    }

    /** 
     * Get the 'AgencyLocation' element value. The Pseudo City Code of the agent that generated the TK/TE/TR/TV/TM
                          ticketing entry or the Pseudo City Code to whom the PNR has been queued to perform ticketing.
                          Ex. "3Z71"
                      
     * 
     * @return value
     */
    public String getAgencyLocation() {
        return agencyLocation;
    }

    /** 
     * Set the 'AgencyLocation' element value. The Pseudo City Code of the agent that generated the TK/TE/TR/TV/TM
                          ticketing entry or the Pseudo City Code to whom the PNR has been queued to perform ticketing.
                          Ex. "3Z71"
                      
     * 
     * @param agencyLocation
     */
    public void setAgencyLocation(String agencyLocation) {
        this.agencyLocation = agencyLocation;
    }

    /** 
     * Get the 'DutyCode' element value. Duty code of the agent that issued a ticket/refund/exchange/void.
                          Only populated on TK/TE/TR/TV/TM ResArrActionCodes. Ex. "5"
                      
     * 
     * @return value
     */
    public String getDutyCode() {
        return dutyCode;
    }

    /** 
     * Set the 'DutyCode' element value. Duty code of the agent that issued a ticket/refund/exchange/void.
                          Only populated on TK/TE/TR/TV/TM ResArrActionCodes. Ex. "5"
                      
     * 
     * @param dutyCode
     */
    public void setDutyCode(String dutyCode) {
        this.dutyCode = dutyCode;
    }

    /** 
     * Get the 'AgentSine' element value. Agent sine of the agent that issued a ticket/refund/exchange/void.
                          Only populated on TK/TE/TR/TV/TM ResArrActionCodes. Ex."SSW"
                      
     * 
     * @return value
     */
    public String getAgentSine() {
        return agentSine;
    }

    /** 
     * Set the 'AgentSine' element value. Agent sine of the agent that issued a ticket/refund/exchange/void.
                          Only populated on TK/TE/TR/TV/TM ResArrActionCodes. Ex."SSW"
                      
     * 
     * @param agentSine
     */
    public void setAgentSine(String agentSine) {
        this.agentSine = agentSine;
    }

    /** 
     * Get the 'Timestamp' element value. Date that the ticket was issued or a refund/exchange/void was performed.
                          Only populated on TK/TE/TR/TV/TM ResArrActionCodes. Date is stated according to agent's AAA city
                          time zone.
                          Ex. "2012-10-06T07:04:00"
                      
     * 
     * @return value
     */
    public Date getTimestamp() {
        return timestamp;
    }

    /** 
     * Set the 'Timestamp' element value. Date that the ticket was issued or a refund/exchange/void was performed.
                          Only populated on TK/TE/TR/TV/TM ResArrActionCodes. Date is stated according to agent's AAA city
                          time zone.
                          Ex. "2012-10-06T07:04:00"
                      
     * 
     * @param timestamp
     */
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    /** 
     * Get the 'PaymentType' element value.
     * 
     * @return value
     */
    public String getPaymentType() {
        return paymentType;
    }

    /** 
     * Set the 'PaymentType' element value.
     * 
     * @param paymentType
     */
    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    /** 
     * Get the 'TktEntry' element value.
     * 
     * @return value
     */
    public String getTktEntry() {
        return tktEntry;
    }

    /** 
     * Set the 'TktEntry' element value.
     * 
     * @param tktEntry
     */
    public void setTktEntry(String tktEntry) {
        this.tktEntry = tktEntry;
    }

    /** 
     * Get the list of 'NameAssociation' element items.
     * 
     * @return list
     */
    public List<NameAssociationType> getNameAssociationList() {
        return nameAssociationList;
    }

    /** 
     * Set the list of 'NameAssociation' element items.
     * 
     * @param list
     */
    public void setNameAssociationList(List<NameAssociationType> list) {
        nameAssociationList = list;
    }

    /** 
     * Get the list of 'SegmentAssociation' element items.
     * 
     * @return list
     */
    public List<SegmentAssociationType> getSegmentAssociationList() {
        return segmentAssociationList;
    }

    /** 
     * Set the list of 'SegmentAssociation' element items.
     * 
     * @param list
     */
    public void setSegmentAssociationList(List<SegmentAssociationType> list) {
        segmentAssociationList = list;
    }

    /** 
     * Get the 'CouponStatus' element value.
     * 
     * @return value
     */
    public String getCouponStatus() {
        return couponStatus;
    }

    /** 
     * Set the 'CouponStatus' element value.
     * 
     * @param couponStatus
     */
    public void setCouponStatus(String couponStatus) {
        this.couponStatus = couponStatus;
    }

    /** 
     * Get the 'PaperTicketInd' element value. Paper ticket indicator from VCR
     * 
     * @return value
     */
    public Boolean getPaperTicketInd() {
        return paperTicketInd;
    }

    /** 
     * Set the 'PaperTicketInd' element value. Paper ticket indicator from VCR
     * 
     * @param paperTicketInd
     */
    public void setPaperTicketInd(Boolean paperTicketInd) {
        this.paperTicketInd = paperTicketInd;
    }

    /** 
     * Get the 'Status' element value. status of Ticket number e.g Active/Inactive/Unknown
     * 
     * @return value
     */
    public String getStatus() {
        return status;
    }

    /** 
     * Set the 'Status' element value. status of Ticket number e.g Active/Inactive/Unknown
     * 
     * @param status
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'index' attribute value.
     * 
     * @return value
     */
    public BigInteger getIndex() {
        return index;
    }

    /** 
     * Set the 'index' attribute value.
     * 
     * @param index
     */
    public void setIndex(BigInteger index) {
        this.index = index;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'elementId' attribute value.
     * 
     * @return value
     */
    public String getElementId() {
        return elementId;
    }

    /** 
     * Set the 'elementId' attribute value.
     * 
     * @param elementId
     */
    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    /** 
     * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
}
