
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Ticketing information must be entered before the PNR can be finalized.

 The ticketing field (7) has a maximum of 71 characters starting with the
 7, regardless of the entry or character combination used.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingInfo">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:FutureTicketing.PNRB" name="FutureTicketing" minOccurs="0"/>
 *     &lt;xs:element type="ns:TicketingTimeLimit.PNRB" name="TicketingTimeLimit" minOccurs="0"/>
 *     &lt;xs:element type="ns:AlreadyTicketed.PNRB" name="AlreadyTicketed" minOccurs="0"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TicketingInfo implements Serializable
{
    private int choiceSelect = -1;
    private static final int FUTURE_TICKETING_CHOICE = 0;
    private static final int TICKETING_TIME_LIMIT_CHOICE = 1;
    private static final int ALREADY_TICKETED_CHOICE = 2;
    private FutureTicketingPNRB futureTicketing;
    private TicketingTimeLimitPNRB ticketingTimeLimit;
    private AlreadyTicketedPNRB alreadyTicketed;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if FutureTicketing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFutureTicketing() {
        return choiceSelect == FUTURE_TICKETING_CHOICE;
    }

    /** 
     * Get the 'FutureTicketing' element value.
     * 
     * @return value
     */
    public FutureTicketingPNRB getFutureTicketing() {
        return futureTicketing;
    }

    /** 
     * Set the 'FutureTicketing' element value.
     * 
     * @param futureTicketing
     */
    public void setFutureTicketing(FutureTicketingPNRB futureTicketing) {
        setChoiceSelect(FUTURE_TICKETING_CHOICE);
        this.futureTicketing = futureTicketing;
    }

    /** 
     * Check if TicketingTimeLimit is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTicketingTimeLimit() {
        return choiceSelect == TICKETING_TIME_LIMIT_CHOICE;
    }

    /** 
     * Get the 'TicketingTimeLimit' element value.
     * 
     * @return value
     */
    public TicketingTimeLimitPNRB getTicketingTimeLimit() {
        return ticketingTimeLimit;
    }

    /** 
     * Set the 'TicketingTimeLimit' element value.
     * 
     * @param ticketingTimeLimit
     */
    public void setTicketingTimeLimit(TicketingTimeLimitPNRB ticketingTimeLimit) {
        setChoiceSelect(TICKETING_TIME_LIMIT_CHOICE);
        this.ticketingTimeLimit = ticketingTimeLimit;
    }

    /** 
     * Check if AlreadyTicketed is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAlreadyTicketed() {
        return choiceSelect == ALREADY_TICKETED_CHOICE;
    }

    /** 
     * Get the 'AlreadyTicketed' element value.
     * 
     * @return value
     */
    public AlreadyTicketedPNRB getAlreadyTicketed() {
        return alreadyTicketed;
    }

    /** 
     * Set the 'AlreadyTicketed' element value.
     * 
     * @param alreadyTicketed
     */
    public void setAlreadyTicketed(AlreadyTicketedPNRB alreadyTicketed) {
        setChoiceSelect(ALREADY_TICKETED_CHOICE);
        this.alreadyTicketed = alreadyTicketed;
    }
}
