
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Transaction.PNRB">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:StatelessTransaction.PNRB" name="StatelessTransaction" minOccurs="0"/>
 *     &lt;xs:element type="ns:StatefulTransaction.PNRB" name="StatefulTransaction" minOccurs="0"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TransactionPNRB implements Serializable
{
    private int choiceSelect = -1;
    private static final int STATELESS_TRANSACTION_CHOICE = 0;
    private static final int STATEFUL_TRANSACTION_CHOICE = 1;
    private StatelessTransactionPNRB statelessTransaction;
    private StatefulTransactionPNRB statefulTransaction;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if StatelessTransaction is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifStatelessTransaction() {
        return choiceSelect == STATELESS_TRANSACTION_CHOICE;
    }

    /** 
     * Get the 'StatelessTransaction' element value.
     * 
     * @return value
     */
    public StatelessTransactionPNRB getStatelessTransaction() {
        return statelessTransaction;
    }

    /** 
     * Set the 'StatelessTransaction' element value.
     * 
     * @param statelessTransaction
     */
    public void setStatelessTransaction(
            StatelessTransactionPNRB statelessTransaction) {
        setChoiceSelect(STATELESS_TRANSACTION_CHOICE);
        this.statelessTransaction = statelessTransaction;
    }

    /** 
     * Check if StatefulTransaction is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifStatefulTransaction() {
        return choiceSelect == STATEFUL_TRANSACTION_CHOICE;
    }

    /** 
     * Get the 'StatefulTransaction' element value.
     * 
     * @return value
     */
    public StatefulTransactionPNRB getStatefulTransaction() {
        return statefulTransaction;
    }

    /** 
     * Set the 'StatefulTransaction' element value.
     * 
     * @param statefulTransaction
     */
    public void setStatefulTransaction(
            StatefulTransactionPNRB statefulTransaction) {
        setChoiceSelect(STATEFUL_TRANSACTION_CHOICE);
        this.statefulTransaction = statefulTransaction;
    }
}
