
package com.sabre.webservices.pnrbuilder.v119;

import com.sabre.services.res.or.v114.ArrangerDetailsType;
import java.io.Serializable;

/** 
 * An identifier used to
 uniquely reference an object in a system (e.g. an airline
 reservation reference, customer profile reference, booking
 confirmation number, or a reference to a previous availability
 quote).

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:ns1="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UniqueID_Type.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CompanyNameType" name="CompanyName" minOccurs="0"/>
 *     &lt;xs:element type="ns1:ArrangerDetailsType" name="ArrangerDetails" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:UniqueID_Group"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class UniqueIDTypePNRB implements Serializable
{
    private CompanyNameType companyName;
    private ArrangerDetailsType arrangerDetails;
    private UniqueIDGroup uniqueIDGroup;

    /** 
     * Get the 'CompanyName' element value. Identifies
                          the company that is associated with the UniqueID.
                      
     * 
     * @return value
     */
    public CompanyNameType getCompanyName() {
        return companyName;
    }

    /** 
     * Set the 'CompanyName' element value. Identifies
                          the company that is associated with the UniqueID.
                      
     * 
     * @param companyName
     */
    public void setCompanyName(CompanyNameType companyName) {
        this.companyName = companyName;
    }

    /** 
     * Get the 'ArrangerDetails' element value.
     * 
     * @return value
     */
    public ArrangerDetailsType getArrangerDetails() {
        return arrangerDetails;
    }

    /** 
     * Set the 'ArrangerDetails' element value.
     * 
     * @param arrangerDetails
     */
    public void setArrangerDetails(ArrangerDetailsType arrangerDetails) {
        this.arrangerDetails = arrangerDetails;
    }

    /** 
     * Get the 'UniqueID_Group' attributeGroup value.
     * 
     * @return value
     */
    public UniqueIDGroup getUniqueIDGroup() {
        return uniqueIDGroup;
    }

    /** 
     * Set the 'UniqueID_Group' attributeGroup value.
     * 
     * @param uniqueIDGroup
     */
    public void setUniqueIDGroup(UniqueIDGroup uniqueIDGroup) {
        this.uniqueIDGroup = uniqueIDGroup;
    }
}
