
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VCRAssociationDetailsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:NameAssociationType" name="NameAssocId" minOccurs="0"/>
 *     &lt;xs:element type="ns:SegmentAssociationType" name="SegmentAssociationId" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AirlineAccountingCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TicketNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="NumberOfConjunctiveTicket" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="CouponNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="VCRCreationDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="PaperTicketIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="ManualIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="AutomaticIndicator" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="elementId"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class VCRAssociationDetailsType implements Serializable
{
    private NameAssociationType nameAssocId;
    private SegmentAssociationType segmentAssociationId;
    private String airlineAccountingCode;
    private String ticketNumber;
    private BigInteger numberOfConjunctiveTicket;
    private BigInteger couponNumber;
    private Date VCRCreationDate;
    private Boolean paperTicketIndicator;
    private Boolean manualIndicator;
    private Boolean automaticIndicator;
    private String id;
    private String elementId;

    /** 
     * Get the 'NameAssocId' element value. The passenger name to which this VCR is associated to.
     * 
     * @return value
     */
    public NameAssociationType getNameAssocId() {
        return nameAssocId;
    }

    /** 
     * Set the 'NameAssocId' element value. The passenger name to which this VCR is associated to.
     * 
     * @param nameAssocId
     */
    public void setNameAssocId(NameAssociationType nameAssocId) {
        this.nameAssocId = nameAssocId;
    }

    /** 
     * Get the 'SegmentAssociationId' element value. The segment to which this VCR is associated to.
     * 
     * @return value
     */
    public SegmentAssociationType getSegmentAssociationId() {
        return segmentAssociationId;
    }

    /** 
     * Set the 'SegmentAssociationId' element value. The segment to which this VCR is associated to.
     * 
     * @param segmentAssociationId
     */
    public void setSegmentAssociationId(
            SegmentAssociationType segmentAssociationId) {
        this.segmentAssociationId = segmentAssociationId;
    }

    /** 
     * Get the 'AirlineAccountingCode' element value. The airline accounting code from VCR. eg: 001 for AA
     * 
     * @return value
     */
    public String getAirlineAccountingCode() {
        return airlineAccountingCode;
    }

    /** 
     * Set the 'AirlineAccountingCode' element value. The airline accounting code from VCR. eg: 001 for AA
     * 
     * @param airlineAccountingCode
     */
    public void setAirlineAccountingCode(String airlineAccountingCode) {
        this.airlineAccountingCode = airlineAccountingCode;
    }

    /** 
     * Get the 'TicketNumber' element value. The ten digit ticket number from the VCR
     * 
     * @return value
     */
    public String getTicketNumber() {
        return ticketNumber;
    }

    /** 
     * Set the 'TicketNumber' element value. The ten digit ticket number from the VCR
     * 
     * @param ticketNumber
     */
    public void setTicketNumber(String ticketNumber) {
        this.ticketNumber = ticketNumber;
    }

    /** 
     * Get the 'NumberOfConjunctiveTicket' element value. The number of conjunctive tickets it is associated with for this
                          ticket number.
     * 
     * @return value
     */
    public BigInteger getNumberOfConjunctiveTicket() {
        return numberOfConjunctiveTicket;
    }

    /** 
     * Set the 'NumberOfConjunctiveTicket' element value. The number of conjunctive tickets it is associated with for this
                          ticket number.
     * 
     * @param numberOfConjunctiveTicket
     */
    public void setNumberOfConjunctiveTicket(
            BigInteger numberOfConjunctiveTicket) {
        this.numberOfConjunctiveTicket = numberOfConjunctiveTicket;
    }

    /** 
     * Get the 'CouponNumber' element value. Coupon number from VCR
     * 
     * @return value
     */
    public BigInteger getCouponNumber() {
        return couponNumber;
    }

    /** 
     * Set the 'CouponNumber' element value. Coupon number from VCR
     * 
     * @param couponNumber
     */
    public void setCouponNumber(BigInteger couponNumber) {
        this.couponNumber = couponNumber;
    }

    /** 
     * Get the 'VCRCreationDate' element value. VCR creation data from VCR
     * 
     * @return value
     */
    public Date getVCRCreationDate() {
        return VCRCreationDate;
    }

    /** 
     * Set the 'VCRCreationDate' element value. VCR creation data from VCR
     * 
     * @param VCRCreationDate
     */
    public void setVCRCreationDate(Date VCRCreationDate) {
        this.VCRCreationDate = VCRCreationDate;
    }

    /** 
     * Get the 'PaperTicketIndicator' element value. Paper ticket indicator from VCR
     * 
     * @return value
     */
    public Boolean getPaperTicketIndicator() {
        return paperTicketIndicator;
    }

    /** 
     * Set the 'PaperTicketIndicator' element value. Paper ticket indicator from VCR
     * 
     * @param paperTicketIndicator
     */
    public void setPaperTicketIndicator(Boolean paperTicketIndicator) {
        this.paperTicketIndicator = paperTicketIndicator;
    }

    /** 
     * Get the 'ManualIndicator' element value. Manual ticket indicator from VCR
     * 
     * @return value
     */
    public Boolean getManualIndicator() {
        return manualIndicator;
    }

    /** 
     * Set the 'ManualIndicator' element value. Manual ticket indicator from VCR
     * 
     * @param manualIndicator
     */
    public void setManualIndicator(Boolean manualIndicator) {
        this.manualIndicator = manualIndicator;
    }

    /** 
     * Get the 'AutomaticIndicator' element value. Automatic ticket indicator from VCR
     * 
     * @return value
     */
    public Boolean getAutomaticIndicator() {
        return automaticIndicator;
    }

    /** 
     * Set the 'AutomaticIndicator' element value. Automatic ticket indicator from VCR
     * 
     * @param automaticIndicator
     */
    public void setAutomaticIndicator(Boolean automaticIndicator) {
        this.automaticIndicator = automaticIndicator;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'elementId' attribute value.
     * 
     * @return value
     */
    public String getElementId() {
        return elementId;
    }

    /** 
     * Set the 'elementId' attribute value.
     * 
     * @param elementId
     */
    public void setElementId(String elementId) {
        this.elementId = elementId;
    }
}
