
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehSegmentInfo.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="PricedOffLocServiceTelephone" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PricedOffLocServiceFax" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CorporateID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ClientID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CustLoyaltyMembershipID" minOccurs="0"/>
 *     &lt;xs:element name="InvoiceRemarks" minOccurs="0">
 *       &lt;!-- Reference to inner class InvoiceRemarks -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Remarks" minOccurs="0">
 *       &lt;!-- Reference to inner class Remarks -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="PassengerName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="VoucherType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="VoucherBillingNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="VoucherID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="VoucherFormat" minOccurs="0"/>
 *     &lt;xs:element type="ns:SpecialEquipmentType" name="SpecialEquipment" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class VehSegmentInfoPNRB implements Serializable
{
    private String pricedOffLocServiceTelephone;
    private String pricedOffLocServiceFax;
    private String corporateID;
    private String clientID;
    private String custLoyaltyMembershipID;
    private InvoiceRemarks invoiceRemarks;
    private Remarks remarks;
    private String passengerName;
    private String voucherType;
    private String voucherBillingNumber;
    private String voucherID;
    private String voucherFormat;
    private List<SpecialEquipmentType> specialEquipmentList = new ArrayList<SpecialEquipmentType>();

    /** 
     * Get the 'PricedOffLocServiceTelephone' element value. Phone number of off airport location.
     * 
     * @return value
     */
    public String getPricedOffLocServiceTelephone() {
        return pricedOffLocServiceTelephone;
    }

    /** 
     * Set the 'PricedOffLocServiceTelephone' element value. Phone number of off airport location.
     * 
     * @param pricedOffLocServiceTelephone
     */
    public void setPricedOffLocServiceTelephone(
            String pricedOffLocServiceTelephone) {
        this.pricedOffLocServiceTelephone = pricedOffLocServiceTelephone;
    }

    /** 
     * Get the 'PricedOffLocServiceFax' element value. fax number of off airport location
     * 
     * @return value
     */
    public String getPricedOffLocServiceFax() {
        return pricedOffLocServiceFax;
    }

    /** 
     * Set the 'PricedOffLocServiceFax' element value. fax number of off airport location
     * 
     * @param pricedOffLocServiceFax
     */
    public void setPricedOffLocServiceFax(String pricedOffLocServiceFax) {
        this.pricedOffLocServiceFax = pricedOffLocServiceFax;
    }

    /** 
     * Get the 'CorporateID' element value. Corporate Discount number affilated to renter. Example "8"
     * 
     * @return value
     */
    public String getCorporateID() {
        return corporateID;
    }

    /** 
     * Set the 'CorporateID' element value. Corporate Discount number affilated to renter. Example "8"
     * 
     * @param corporateID
     */
    public void setCorporateID(String corporateID) {
        this.corporateID = corporateID;
    }

    /** 
     * Get the 'ClientID' element value.
     * 
     * @return value
     */
    public String getClientID() {
        return clientID;
    }

    /** 
     * Set the 'ClientID' element value.
     * 
     * @param clientID
     */
    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    /** 
     * Get the 'CustLoyaltyMembershipID' element value. unique loyalty membership ID
     * 
     * @return value
     */
    public String getCustLoyaltyMembershipID() {
        return custLoyaltyMembershipID;
    }

    /** 
     * Set the 'CustLoyaltyMembershipID' element value. unique loyalty membership ID
     * 
     * @param custLoyaltyMembershipID
     */
    public void setCustLoyaltyMembershipID(String custLoyaltyMembershipID) {
        this.custLoyaltyMembershipID = custLoyaltyMembershipID;
    }

    /** 
     * Get the 'InvoiceRemarks' element value.
     * 
     * @return value
     */
    public InvoiceRemarks getInvoiceRemarks() {
        return invoiceRemarks;
    }

    /** 
     * Set the 'InvoiceRemarks' element value.
     * 
     * @param invoiceRemarks
     */
    public void setInvoiceRemarks(InvoiceRemarks invoiceRemarks) {
        this.invoiceRemarks = invoiceRemarks;
    }

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public Remarks getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(Remarks remarks) {
        this.remarks = remarks;
    }

    /** 
     * Get the 'PassengerName' element value.
     * 
     * @return value
     */
    public String getPassengerName() {
        return passengerName;
    }

    /** 
     * Set the 'PassengerName' element value.
     * 
     * @param passengerName
     */
    public void setPassengerName(String passengerName) {
        this.passengerName = passengerName;
    }

    /** 
     * Get the 'VoucherType' element value.
     * 
     * @return value
     */
    public String getVoucherType() {
        return voucherType;
    }

    /** 
     * Set the 'VoucherType' element value.
     * 
     * @param voucherType
     */
    public void setVoucherType(String voucherType) {
        this.voucherType = voucherType;
    }

    /** 
     * Get the 'VoucherBillingNumber' element value. Company eVoucher Billing Number
     * 
     * @return value
     */
    public String getVoucherBillingNumber() {
        return voucherBillingNumber;
    }

    /** 
     * Set the 'VoucherBillingNumber' element value. Company eVoucher Billing Number
     * 
     * @param voucherBillingNumber
     */
    public void setVoucherBillingNumber(String voucherBillingNumber) {
        this.voucherBillingNumber = voucherBillingNumber;
    }

    /** 
     * Get the 'VoucherID' element value. voucher ID
     * 
     * @return value
     */
    public String getVoucherID() {
        return voucherID;
    }

    /** 
     * Set the 'VoucherID' element value. voucher ID
     * 
     * @param voucherID
     */
    public void setVoucherID(String voucherID) {
        this.voucherID = voucherID;
    }

    /** 
     * Get the 'VoucherFormat' element value. format of voucher
     * 
     * @return value
     */
    public String getVoucherFormat() {
        return voucherFormat;
    }

    /** 
     * Set the 'VoucherFormat' element value. format of voucher
     * 
     * @param voucherFormat
     */
    public void setVoucherFormat(String voucherFormat) {
        this.voucherFormat = voucherFormat;
    }

    /** 
     * Get the list of 'SpecialEquipment' element items. any special equipment, e.g., ski rack, included in rental
     * 
     * @return list
     */
    public List<SpecialEquipmentType> getSpecialEquipmentList() {
        return specialEquipmentList;
    }

    /** 
     * Set the list of 'SpecialEquipment' element items. any special equipment, e.g., ski rack, included in rental
     * 
     * @param list
     */
    public void setSpecialEquipmentList(List<SpecialEquipmentType> list) {
        specialEquipmentList = list;
    }
    /** 
     * invoice related remarks
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InvoiceRemarks" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class InvoiceRemarks implements Serializable
    {
        private List<String> textList = new ArrayList<String>();

        /** 
         * Get the list of 'Text' element items.
         * 
         * @return list
         */
        public List<String> getTextList() {
            return textList;
        }

        /** 
         * Set the list of 'Text' element items.
         * 
         * @param list
         */
        public void setTextList(List<String> list) {
            textList = list;
        }
    }
    /** 
     * additional remarks
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remarks" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Remarks implements Serializable
    {
        private List<String> textList = new ArrayList<String>();

        /** 
         * Get the list of 'Text' element items.
         * 
         * @return list
         */
        public List<String> getTextList() {
            return textList;
        }

        /** 
         * Set the list of 'Text' element items.
         * 
         * @param list
         */
        public void setTextList(List<String> list) {
            textList = list;
        }
    }
}
