
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VehicalType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="LineNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="LineStatus" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="POSRequestorID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ConfId" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="VendorCode" minOccurs="0"/>
 *     &lt;xs:element name="PickUpLocation" minOccurs="0">
 *       &lt;!-- Reference to inner class PickUpLocation -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ReturnLocation" minOccurs="0">
 *       &lt;!-- Reference to inner class ReturnLocation -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="PickUpDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PickUpDay" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ReturnDateTime" minOccurs="0"/>
 *     &lt;xs:element type="ns:RentalRate.PNRB" name="RentalRate" minOccurs="0"/>
 *     &lt;xs:element name="PricedEquipment" minOccurs="0">
 *       &lt;!-- Reference to inner class PricedEquipment -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:VehSegmentInfo.PNRB" name="VehSegmentInfo" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AirVendorCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FlightNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TourCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="WrittenConfirmation" minOccurs="0"/>
 *     &lt;xs:element name="Customer" minOccurs="0">
 *       &lt;!-- Reference to inner class Customer -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Delivery" minOccurs="0">
 *       &lt;!-- Reference to inner class Delivery -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Collection" minOccurs="0">
 *       &lt;!-- Reference to inner class Collection -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="SegmentText" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DayOfWeekInd"/>
 *   &lt;xs:attribute type="xs:integer" name="index"/>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="xs:short" name="sequence"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="isPast"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class VehicalType implements Serializable
{
    private String lineNumber;
    private String lineStatus;
    private String POSRequestorID;
    private String confId;
    private String vendorCode;
    private PickUpLocation pickUpLocation;
    private ReturnLocation returnLocation;
    private String pickUpDateTime;
    private String pickUpDay;
    private String returnDateTime;
    private RentalRatePNRB rentalRate;
    private PricedEquipment pricedEquipment;
    private VehSegmentInfoPNRB vehSegmentInfo;
    private String airVendorCode;
    private String flightNumber;
    private String tourCode;
    private Boolean writtenConfirmation;
    private Customer customer;
    private Delivery delivery;
    private Collection collection;
    private String segmentText;
    private String dayOfWeekInd;
    private BigInteger index;
    private String id;
    private Short sequence;
    private OperationTypePNRB op;
    private Boolean isPast;

    /** 
     * Get the 'LineNumber' element value.
     * 
     * @return value
     */
    public String getLineNumber() {
        return lineNumber;
    }

    /** 
     * Set the 'LineNumber' element value.
     * 
     * @param lineNumber
     */
    public void setLineNumber(String lineNumber) {
        this.lineNumber = lineNumber;
    }

    /** 
     * Get the 'LineStatus' element value. Current status of booked segment. Example "HK".
     * 
     * @return value
     */
    public String getLineStatus() {
        return lineStatus;
    }

    /** 
     * Set the 'LineStatus' element value. Current status of booked segment. Example "HK".
     * 
     * @param lineStatus
     */
    public void setLineStatus(String lineStatus) {
        this.lineStatus = lineStatus;
    }

    /** 
     * Get the 'POSRequestorID' element value. Point of Sale ID.
     * 
     * @return value
     */
    public String getPOSRequestorID() {
        return POSRequestorID;
    }

    /** 
     * Set the 'POSRequestorID' element value. Point of Sale ID.
     * 
     * @param POSRequestorID
     */
    public void setPOSRequestorID(String POSRequestorID) {
        this.POSRequestorID = POSRequestorID;
    }

    /** 
     * Get the 'ConfId' element value. A confirmation number by which this reservation
                          can be uniquely identified. Value assigned by the creating system.
                      
     * 
     * @return value
     */
    public String getConfId() {
        return confId;
    }

    /** 
     * Set the 'ConfId' element value. A confirmation number by which this reservation
                          can be uniquely identified. Value assigned by the creating system.
                      
     * 
     * @param confId
     */
    public void setConfId(String confId) {
        this.confId = confId;
    }

    /** 
     * Get the 'VendorCode' element value. Identifies the vendor associated with this
                          information
                      
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' element value. Identifies the vendor associated with this
                          information
                      
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'PickUpLocation' element value.
     * 
     * @return value
     */
    public PickUpLocation getPickUpLocation() {
        return pickUpLocation;
    }

    /** 
     * Set the 'PickUpLocation' element value.
     * 
     * @param pickUpLocation
     */
    public void setPickUpLocation(PickUpLocation pickUpLocation) {
        this.pickUpLocation = pickUpLocation;
    }

    /** 
     * Get the 'ReturnLocation' element value.
     * 
     * @return value
     */
    public ReturnLocation getReturnLocation() {
        return returnLocation;
    }

    /** 
     * Set the 'ReturnLocation' element value.
     * 
     * @param returnLocation
     */
    public void setReturnLocation(ReturnLocation returnLocation) {
        this.returnLocation = returnLocation;
    }

    /** 
     * Get the 'PickUpDateTime' element value. Pick up datetime. Example "2013-08-08T13:00:00"
     * 
     * @return value
     */
    public String getPickUpDateTime() {
        return pickUpDateTime;
    }

    /** 
     * Set the 'PickUpDateTime' element value. Pick up datetime. Example "2013-08-08T13:00:00"
     * 
     * @param pickUpDateTime
     */
    public void setPickUpDateTime(String pickUpDateTime) {
        this.pickUpDateTime = pickUpDateTime;
    }

    /** 
     * Get the 'PickUpDay' element value. The car pick up day.
     * 
     * @return value
     */
    public String getPickUpDay() {
        return pickUpDay;
    }

    /** 
     * Set the 'PickUpDay' element value. The car pick up day.
     * 
     * @param pickUpDay
     */
    public void setPickUpDay(String pickUpDay) {
        this.pickUpDay = pickUpDay;
    }

    /** 
     * Get the 'ReturnDateTime' element value. Number of days the car is rented for; A one day rental with pick-up and return in
                          the same or next day would reflect a value of '1';
                          Segments without a valid return date will have a value of '0'. Example "2013-08-08T13:00:00"
                      
     * 
     * @return value
     */
    public String getReturnDateTime() {
        return returnDateTime;
    }

    /** 
     * Set the 'ReturnDateTime' element value. Number of days the car is rented for; A one day rental with pick-up and return in
                          the same or next day would reflect a value of '1';
                          Segments without a valid return date will have a value of '0'. Example "2013-08-08T13:00:00"
                      
     * 
     * @param returnDateTime
     */
    public void setReturnDateTime(String returnDateTime) {
        this.returnDateTime = returnDateTime;
    }

    /** 
     * Get the 'RentalRate' element value.
     * 
     * @return value
     */
    public RentalRatePNRB getRentalRate() {
        return rentalRate;
    }

    /** 
     * Set the 'RentalRate' element value.
     * 
     * @param rentalRate
     */
    public void setRentalRate(RentalRatePNRB rentalRate) {
        this.rentalRate = rentalRate;
    }

    /** 
     * Get the 'PricedEquipment' element value.
     * 
     * @return value
     */
    public PricedEquipment getPricedEquipment() {
        return pricedEquipment;
    }

    /** 
     * Set the 'PricedEquipment' element value.
     * 
     * @param pricedEquipment
     */
    public void setPricedEquipment(PricedEquipment pricedEquipment) {
        this.pricedEquipment = pricedEquipment;
    }

    /** 
     * Get the 'VehSegmentInfo' element value.
     * 
     * @return value
     */
    public VehSegmentInfoPNRB getVehSegmentInfo() {
        return vehSegmentInfo;
    }

    /** 
     * Set the 'VehSegmentInfo' element value.
     * 
     * @param vehSegmentInfo
     */
    public void setVehSegmentInfo(VehSegmentInfoPNRB vehSegmentInfo) {
        this.vehSegmentInfo = vehSegmentInfo;
    }

    /** 
     * Get the 'AirVendorCode' element value. Airline code of arrival flight.
     * 
     * @return value
     */
    public String getAirVendorCode() {
        return airVendorCode;
    }

    /** 
     * Set the 'AirVendorCode' element value. Airline code of arrival flight.
     * 
     * @param airVendorCode
     */
    public void setAirVendorCode(String airVendorCode) {
        this.airVendorCode = airVendorCode;
    }

    /** 
     * Get the 'FlightNumber' element value.
     * 
     * @return value
     */
    public String getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' element value.
     * 
     * @param flightNumber
     */
    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }

    /** 
     * Get the 'TourCode' element value. Tour Code used.
     * 
     * @return value
     */
    public String getTourCode() {
        return tourCode;
    }

    /** 
     * Set the 'TourCode' element value. Tour Code used.
     * 
     * @param tourCode
     */
    public void setTourCode(String tourCode) {
        this.tourCode = tourCode;
    }

    /** 
     * Get the 'WrittenConfirmation' element value. Written confirmation is requested.
     * 
     * @return value
     */
    public Boolean getWrittenConfirmation() {
        return writtenConfirmation;
    }

    /** 
     * Set the 'WrittenConfirmation' element value. Written confirmation is requested.
     * 
     * @param writtenConfirmation
     */
    public void setWrittenConfirmation(Boolean writtenConfirmation) {
        this.writtenConfirmation = writtenConfirmation;
    }

    /** 
     * Get the 'Customer' element value.
     * 
     * @return value
     */
    public Customer getCustomer() {
        return customer;
    }

    /** 
     * Set the 'Customer' element value.
     * 
     * @param customer
     */
    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    /** 
     * Get the 'Delivery' element value.
     * 
     * @return value
     */
    public Delivery getDelivery() {
        return delivery;
    }

    /** 
     * Set the 'Delivery' element value.
     * 
     * @param delivery
     */
    public void setDelivery(Delivery delivery) {
        this.delivery = delivery;
    }

    /** 
     * Get the 'Collection' element value.
     * 
     * @return value
     */
    public Collection getCollection() {
        return collection;
    }

    /** 
     * Set the 'Collection' element value.
     * 
     * @param collection
     */
    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    /** 
     * Get the 'SegmentText' element value. Can be the airport code or a text description of a non-airport pick-up location
                          for
                          the rental car when specified in the optional PUP field in the segment.
                          Example "CUN/09AUG/EDMR/ARR-1P/RET-1P/DT-16JUL130636/SBS-HS/TAC-@2.8515.000PCT/RG-USD19.00 UNL
                          DY/AP-@USD24.75 UNL 1DY 0HR 5.75MC/BS-45605302/RC-SXA/CF-9800046742"
                      
     * 
     * @return value
     */
    public String getSegmentText() {
        return segmentText;
    }

    /** 
     * Set the 'SegmentText' element value. Can be the airport code or a text description of a non-airport pick-up location
                          for
                          the rental car when specified in the optional PUP field in the segment.
                          Example "CUN/09AUG/EDMR/ARR-1P/RET-1P/DT-16JUL130636/SBS-HS/TAC-@2.8515.000PCT/RG-USD19.00 UNL
                          DY/AP-@USD24.75 UNL 1DY 0HR 5.75MC/BS-45605302/RC-SXA/CF-9800046742"
                      
     * 
     * @param segmentText
     */
    public void setSegmentText(String segmentText) {
        this.segmentText = segmentText;
    }

    /** 
     * Get the 'DayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator.
     * 
     * @return value
     */
    public String getDayOfWeekInd() {
        return dayOfWeekInd;
    }

    /** 
     * Set the 'DayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator.
     * 
     * @param dayOfWeekInd
     */
    public void setDayOfWeekInd(String dayOfWeekInd) {
        this.dayOfWeekInd = dayOfWeekInd;
    }

    /** 
     * Get the 'index' attribute value. Sabre index ID.
     * 
     * @return value
     */
    public BigInteger getIndex() {
        return index;
    }

    /** 
     * Set the 'index' attribute value. Sabre index ID.
     * 
     * @param index
     */
    public void setIndex(BigInteger index) {
        this.index = index;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'sequence' attribute value. Identifies sequence number of Itinerary
                  
     * 
     * @return value
     */
    public Short getSequence() {
        return sequence;
    }

    /** 
     * Set the 'sequence' attribute value. Identifies sequence number of Itinerary
                  
     * 
     * @param sequence
     */
    public void setSequence(Short sequence) {
        this.sequence = sequence;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
                  
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
                  
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'isPast' attribute value. It returns information if current segment is past or not.
     * 
     * @return value
     */
    public Boolean getIsPast() {
        return isPast;
    }

    /** 
     * Set the 'isPast' attribute value. It returns information if current segment is past or not.
     * 
     * @param isPast
     */
    public void setIsPast(Boolean isPast) {
        this.isPast = isPast;
    }
    /** 
     * A code to identify the pick up location, along
                          with an optional code context.
                      
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PickUpLocation" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="LocationCode" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="LocationName" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="ServiceLocationName" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="CodeContext" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PickUpLocation implements Serializable
    {
        private String locationCode;
        private String locationName;
        private String serviceLocationName;
        private String codeContext;

        /** 
         * Get the 'LocationCode' element value. Identifies a
                                        company by the company code.
                                    
         * 
         * @return value
         */
        public String getLocationCode() {
            return locationCode;
        }

        /** 
         * Set the 'LocationCode' element value. Identifies a
                                        company by the company code.
                                    
         * 
         * @param locationCode
         */
        public void setLocationCode(String locationCode) {
            this.locationCode = locationCode;
        }

        /** 
         * Get the 'LocationName' element value. Identifies a
                                        company by the company code.
                                    
         * 
         * @return value
         */
        public String getLocationName() {
            return locationName;
        }

        /** 
         * Set the 'LocationName' element value. Identifies a
                                        company by the company code.
                                    
         * 
         * @param locationName
         */
        public void setLocationName(String locationName) {
            this.locationName = locationName;
        }

        /** 
         * Get the 'ServiceLocationName' element value. Identifies the
                                        context of the identifying code, such as DUNS, IATA or internal
                                        code, etc.
                                    
         * 
         * @return value
         */
        public String getServiceLocationName() {
            return serviceLocationName;
        }

        /** 
         * Set the 'ServiceLocationName' element value. Identifies the
                                        context of the identifying code, such as DUNS, IATA or internal
                                        code, etc.
                                    
         * 
         * @param serviceLocationName
         */
        public void setServiceLocationName(String serviceLocationName) {
            this.serviceLocationName = serviceLocationName;
        }

        /** 
         * Get the 'CodeContext' element value. Identifies the
                                        context of the identifying code, such as DUNS, IATA or internal
                                        code, etc.
                                    
         * 
         * @return value
         */
        public String getCodeContext() {
            return codeContext;
        }

        /** 
         * Set the 'CodeContext' element value. Identifies the
                                        context of the identifying code, such as DUNS, IATA or internal
                                        code, etc.
                                    
         * 
         * @param codeContext
         */
        public void setCodeContext(String codeContext) {
            this.codeContext = codeContext;
        }
    }
    /** 
     * A code to identify the return location, along
                          with an optional code context.
                      
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReturnLocation" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="LocationCode" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="CodeContext" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ReturnLocation implements Serializable
    {
        private String locationCode;
        private String codeContext;

        /** 
         * Get the 'LocationCode' element value. Identifies a
                                        company by the company code.
                                    
         * 
         * @return value
         */
        public String getLocationCode() {
            return locationCode;
        }

        /** 
         * Set the 'LocationCode' element value. Identifies a
                                        company by the company code.
                                    
         * 
         * @param locationCode
         */
        public void setLocationCode(String locationCode) {
            this.locationCode = locationCode;
        }

        /** 
         * Get the 'CodeContext' element value. Identifies the
                                        context of the identifying code, such as DUNS, IATA or internal
                                        code, etc.
                                    
         * 
         * @return value
         */
        public String getCodeContext() {
            return codeContext;
        }

        /** 
         * Set the 'CodeContext' element value. Identifies the
                                        context of the identifying code, such as DUNS, IATA or internal
                                        code, etc.
                                    
         * 
         * @param codeContext
         */
        public void setCodeContext(String codeContext) {
            this.codeContext = codeContext;
        }
    }
    /** 
     * A collection of special equipment that is part
                          of this reservation, along with the charges associated with this
                          equipment.
                      The VehicleEquipmentPricedType complex type
                          identifies the data that describes a priced piece of special
                          equipment in association with the rental of a vehicle. The data
                          consists of the equipment and the correspondinng charge.
                      
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedEquipment" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="EquipType" minOccurs="0"/>
     *       &lt;xs:element type="xs:integer" name="Quantity" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PricedEquipment implements Serializable
    {
        private String equipType;
        private BigInteger quantity;

        /** 
         * Get the 'EquipType' element value. The VehicleEquipmentPricedType complex type
                                        identifies the data that describes a priced piece of special
                                        equipment in association with the rental of a vehicle. The data
                                        consists of the equipment and the correspondinng charge.


                                        The VehicleEquipmentPricedType complex type
                                        identifies the data that describes a priced piece of special
                                        equipment in association with the rental of a vehicle. The data
                                        consists of the equipment and the correspondinng charge.
                                        Category of rental vehicle. Example "EDMR"
                                    
         * 
         * @return value
         */
        public String getEquipType() {
            return equipType;
        }

        /** 
         * Set the 'EquipType' element value. The VehicleEquipmentPricedType complex type
                                        identifies the data that describes a priced piece of special
                                        equipment in association with the rental of a vehicle. The data
                                        consists of the equipment and the correspondinng charge.


                                        The VehicleEquipmentPricedType complex type
                                        identifies the data that describes a priced piece of special
                                        equipment in association with the rental of a vehicle. The data
                                        consists of the equipment and the correspondinng charge.
                                        Category of rental vehicle. Example "EDMR"
                                    
         * 
         * @param equipType
         */
        public void setEquipType(String equipType) {
            this.equipType = equipType;
        }

        /** 
         * Get the 'Quantity' element value. Number of booked vehicles. Example "1"
         * 
         * @return value
         */
        public BigInteger getQuantity() {
            return quantity;
        }

        /** 
         * Set the 'Quantity' element value. Number of booked vehicles. Example "1"
         * 
         * @param quantity
         */
        public void setQuantity(BigInteger quantity) {
            this.quantity = quantity;
        }
    }
    /** 
     * Customer name.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Customer" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Address" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Phone" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="DriverLicense" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Customer implements Serializable
    {
        private String address;
        private String phone;
        private String driverLicense;

        /** 
         * Get the 'Address' element value. Customer - Address.
         * 
         * @return value
         */
        public String getAddress() {
            return address;
        }

        /** 
         * Set the 'Address' element value. Customer - Address.
         * 
         * @param address
         */
        public void setAddress(String address) {
            this.address = address;
        }

        /** 
         * Get the 'Phone' element value. Customer - Phone.
         * 
         * @return value
         */
        public String getPhone() {
            return phone;
        }

        /** 
         * Set the 'Phone' element value. Customer - Phone.
         * 
         * @param phone
         */
        public void setPhone(String phone) {
            this.phone = phone;
        }

        /** 
         * Get the 'DriverLicense' element value. Driver license number.
         * 
         * @return value
         */
        public String getDriverLicense() {
            return driverLicense;
        }

        /** 
         * Set the 'DriverLicense' element value. Driver license number.
         * 
         * @param driverLicense
         */
        public void setDriverLicense(String driverLicense) {
            this.driverLicense = driverLicense;
        }
    }
    /** 
     * Is car to be delivered.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Delivery" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="City" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Country" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="State" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="ZipCode" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Phone" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Address" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Delivery implements Serializable
    {
        private String name;
        private String city;
        private String country;
        private String state;
        private String zipCode;
        private String phone;
        private String address;

        /** 
         * Get the 'Name' element value. name of person to be delivered to
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value. name of person to be delivered to
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }

        /** 
         * Get the 'City' element value. delivery city
         * 
         * @return value
         */
        public String getCity() {
            return city;
        }

        /** 
         * Set the 'City' element value. delivery city
         * 
         * @param city
         */
        public void setCity(String city) {
            this.city = city;
        }

        /** 
         * Get the 'Country' element value. delivery country
         * 
         * @return value
         */
        public String getCountry() {
            return country;
        }

        /** 
         * Set the 'Country' element value. delivery country
         * 
         * @param country
         */
        public void setCountry(String country) {
            this.country = country;
        }

        /** 
         * Get the 'State' element value. delivery state
         * 
         * @return value
         */
        public String getState() {
            return state;
        }

        /** 
         * Set the 'State' element value. delivery state
         * 
         * @param state
         */
        public void setState(String state) {
            this.state = state;
        }

        /** 
         * Get the 'ZipCode' element value. delivery zip code
         * 
         * @return value
         */
        public String getZipCode() {
            return zipCode;
        }

        /** 
         * Set the 'ZipCode' element value. delivery zip code
         * 
         * @param zipCode
         */
        public void setZipCode(String zipCode) {
            this.zipCode = zipCode;
        }

        /** 
         * Get the 'Phone' element value. delivery phone number
         * 
         * @return value
         */
        public String getPhone() {
            return phone;
        }

        /** 
         * Set the 'Phone' element value. delivery phone number
         * 
         * @param phone
         */
        public void setPhone(String phone) {
            this.phone = phone;
        }

        /** 
         * Get the 'Address' element value. delivery address
         * 
         * @return value
         */
        public String getAddress() {
            return address;
        }

        /** 
         * Set the 'Address' element value. delivery address
         * 
         * @param address
         */
        public void setAddress(String address) {
            this.address = address;
        }
    }
    /** 
     * Is car to be collected at end of rental.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Collection" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="City" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Country" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="State" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="ZipCode" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Phone" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Address" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Collection implements Serializable
    {
        private String name;
        private String city;
        private String country;
        private String state;
        private String zipCode;
        private String phone;
        private String address;

        /** 
         * Get the 'Name' element value. name of person to collect the car from
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value. name of person to collect the car from
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }

        /** 
         * Get the 'City' element value. collection city
         * 
         * @return value
         */
        public String getCity() {
            return city;
        }

        /** 
         * Set the 'City' element value. collection city
         * 
         * @param city
         */
        public void setCity(String city) {
            this.city = city;
        }

        /** 
         * Get the 'Country' element value. collection country
         * 
         * @return value
         */
        public String getCountry() {
            return country;
        }

        /** 
         * Set the 'Country' element value. collection country
         * 
         * @param country
         */
        public void setCountry(String country) {
            this.country = country;
        }

        /** 
         * Get the 'State' element value. collection state
         * 
         * @return value
         */
        public String getState() {
            return state;
        }

        /** 
         * Set the 'State' element value. collection state
         * 
         * @param state
         */
        public void setState(String state) {
            this.state = state;
        }

        /** 
         * Get the 'ZipCode' element value. collection zip code
         * 
         * @return value
         */
        public String getZipCode() {
            return zipCode;
        }

        /** 
         * Set the 'ZipCode' element value. collection zip code
         * 
         * @param zipCode
         */
        public void setZipCode(String zipCode) {
            this.zipCode = zipCode;
        }

        /** 
         * Get the 'Phone' element value. collection phone number
         * 
         * @return value
         */
        public String getPhone() {
            return phone;
        }

        /** 
         * Set the 'Phone' element value. collection phone number
         * 
         * @param phone
         */
        public void setPhone(String phone) {
            this.phone = phone;
        }

        /** 
         * Get the 'Address' element value. collection address
         * 
         * @return value
         */
        public String getAddress() {
            return address;
        }

        /** 
         * Set the 'Address' element value. collection address
         * 
         * @param address
         */
        public void setAddress(String address) {
            this.address = address;
        }
    }
}
