
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * can be name associated.

 formats (both AFAX and GFAX)

 * request wheelchair, all segments 4(Wheelchair code)
 4WCHR

 * request wheelchair, specific name, all segments
 4(Wheelchair code)-(name number) 4WCHR-1.2

 * request wheelchair, specific segment and name
 4(Wheelchair code)(segment #)-(name num) 4WCHR3-1.2

 * request wheelchair, specific city 4(Wheelchair
 code)(seg #)/(city code) 4WCHR3/MIA

 * request wheelchair, specific city and name
 4(Wheelchair code)(segment #)/(city code)-(name #)
 4WCHR3/MIA-1.2

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="WheelchairRequest.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:WheelchairCode.PNRB" name="WheelchairCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FreeText" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CityCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FlightNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="VendorCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FlightDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BoardCity" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OffCity" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ActionCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="NumberInParty" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ClassOfService" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="ns:RequestType.PNRB" name="type"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:string" name="RPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class WheelchairRequestPNRB implements Serializable
{
    private WheelchairCodePNRB wheelchairCode;
    private String freeText;
    private String cityCode;
    private String flightNumber;
    private String vendorCode;
    private String flightDate;
    private String boardCity;
    private String offCity;
    private String actionCode;
    private BigInteger numberInParty;
    private String classOfService;
    private String id;
    private RequestTypePNRB type;
    private OperationTypePNRB op;
    private String RPH;

    /** 
     * Get the 'WheelchairCode' element value.
     * 
     * @return value
     */
    public WheelchairCodePNRB getWheelchairCode() {
        return wheelchairCode;
    }

    /** 
     * Set the 'WheelchairCode' element value.
     * 
     * @param wheelchairCode
     */
    public void setWheelchairCode(WheelchairCodePNRB wheelchairCode) {
        this.wheelchairCode = wheelchairCode;
    }

    /** 
     * Get the 'FreeText' element value. Free text
     * 
     * @return value
     */
    public String getFreeText() {
        return freeText;
    }

    /** 
     * Set the 'FreeText' element value. Free text
     * 
     * @param freeText
     */
    public void setFreeText(String freeText) {
        this.freeText = freeText;
    }

    /** 
     * Get the 'CityCode' element value.
     * 
     * @return value
     */
    public String getCityCode() {
        return cityCode;
    }

    /** 
     * Set the 'CityCode' element value.
     * 
     * @param cityCode
     */
    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    /** 
     * Get the 'FlightNumber' element value. The flight number of the associated flight. Ex."25643"
     * 
     * @return value
     */
    public String getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' element value. The flight number of the associated flight. Ex."25643"
     * 
     * @param flightNumber
     */
    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }

    /** 
     * Get the 'VendorCode' element value. Carrier OSI/SSR is being sent to. Ex."OS"
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' element value. Carrier OSI/SSR is being sent to. Ex."OS"
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'FlightDate' element value. Date that service starts for the flight. Ex."2013-07-29"
     * 
     * @return value
     */
    public String getFlightDate() {
        return flightDate;
    }

    /** 
     * Set the 'FlightDate' element value. Date that service starts for the flight. Ex."2013-07-29"
     * 
     * @param flightDate
     */
    public void setFlightDate(String flightDate) {
        this.flightDate = flightDate;
    }

    /** 
     * Get the 'BoardCity' element value. Start city for the flight. Ex." WAW"
     * 
     * @return value
     */
    public String getBoardCity() {
        return boardCity;
    }

    /** 
     * Set the 'BoardCity' element value. Start city for the flight. Ex." WAW"
     * 
     * @param boardCity
     */
    public void setBoardCity(String boardCity) {
        this.boardCity = boardCity;
    }

    /** 
     * Get the 'OffCity' element value. End/Arrival city of the flight. Ex."KUL"
     * 
     * @return value
     */
    public String getOffCity() {
        return offCity;
    }

    /** 
     * Set the 'OffCity' element value. End/Arrival city of the flight. Ex."KUL"
     * 
     * @param offCity
     */
    public void setOffCity(String offCity) {
        this.offCity = offCity;
    }

    /** 
     * Get the 'ActionCode' element value. Indicates the current status of the SSR message. Ex."NN"
     * 
     * @return value
     */
    public String getActionCode() {
        return actionCode;
    }

    /** 
     * Set the 'ActionCode' element value. Indicates the current status of the SSR message. Ex."NN"
     * 
     * @param actionCode
     */
    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    /** 
     * Get the 'NumberInParty' element value. Number of passengers for whom the Special Service Request is being requested. Ex.
                          "2"
                      
     * 
     * @return value
     */
    public BigInteger getNumberInParty() {
        return numberInParty;
    }

    /** 
     * Set the 'NumberInParty' element value. Number of passengers for whom the Special Service Request is being requested. Ex.
                          "2"
                      
     * 
     * @param numberInParty
     */
    public void setNumberInParty(BigInteger numberInParty) {
        this.numberInParty = numberInParty;
    }

    /** 
     * Get the 'ClassOfService' element value. Class of service
     * 
     * @return value
     */
    public String getClassOfService() {
        return classOfService;
    }

    /** 
     * Set the 'ClassOfService' element value. Class of service
     * 
     * @param classOfService
     */
    public void setClassOfService(String classOfService) {
        this.classOfService = classOfService;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'type' attribute value. A = AFAX G = GFAX
     * 
     * @return value
     */
    public RequestTypePNRB getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. A = AFAX G = GFAX
     * 
     * @param type
     */
    public void setType(RequestTypePNRB type) {
        this.type = type;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
}
