
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirTicketRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="OptionalQualifiers" minOccurs="0">
 *         &lt;!-- Reference to inner class OptionalQualifiers -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:integer" use="required" name="NumResponses"/>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" fixed="2.14.0" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AirTicketRQ implements Serializable
{
    private OptionalQualifiers optionalQualifiers;
    private BigInteger numResponses;
    private Boolean returnHostCommand;
    private Date timeStamp;
    private String version;

    /** 
     * Get the 'OptionalQualifiers' element value.
     * 
     * @return value
     */
    public OptionalQualifiers getOptionalQualifiers() {
        return optionalQualifiers;
    }

    /** 
     * Set the 'OptionalQualifiers' element value.
     * 
     * @param optionalQualifiers
     */
    public void setOptionalQualifiers(OptionalQualifiers optionalQualifiers) {
        this.optionalQualifiers = optionalQualifiers;
    }

    /** 
     * Get the 'NumResponses' attribute value.
     * 
     * @return value
     */
    public BigInteger getNumResponses() {
        return numResponses;
    }

    /** 
     * Set the 'NumResponses' attribute value.
     * 
     * @param numResponses
     */
    public void setNumResponses(BigInteger numResponses) {
        this.numResponses = numResponses;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(Boolean returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OptionalQualifiers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FlightQualifiers" minOccurs="0">
     *         &lt;!-- Reference to inner class FlightQualifiers -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FOP_Qualifiers" minOccurs="0">
     *         &lt;!-- Reference to inner class FOPQualifiers -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MiscQualifiers" minOccurs="0">
     *         &lt;!-- Reference to inner class MiscQualifiers -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PricingQualifiers" minOccurs="0">
     *         &lt;!-- Reference to inner class PricingQualifiers -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OptionalQualifiers implements Serializable
    {
        private FlightQualifiers flightQualifiers;
        private FOPQualifiers FOPQualifiers1;
        private MiscQualifiers miscQualifiers;
        private PricingQualifiers pricingQualifiers;

        /** 
         * Get the 'FlightQualifiers' element value.
         * 
         * @return value
         */
        public FlightQualifiers getFlightQualifiers() {
            return flightQualifiers;
        }

        /** 
         * Set the 'FlightQualifiers' element value.
         * 
         * @param flightQualifiers
         */
        public void setFlightQualifiers(FlightQualifiers flightQualifiers) {
            this.flightQualifiers = flightQualifiers;
        }

        /** 
         * Get the 'FOP_Qualifiers' element value.
         * 
         * @return value
         */
        public FOPQualifiers getFOPQualifiers1() {
            return FOPQualifiers1;
        }

        /** 
         * Set the 'FOP_Qualifiers' element value.
         * 
         * @param FOPQualifiers1
         */
        public void setFOPQualifiers1(FOPQualifiers FOPQualifiers1) {
            this.FOPQualifiers1 = FOPQualifiers1;
        }

        /** 
         * Get the 'MiscQualifiers' element value.
         * 
         * @return value
         */
        public MiscQualifiers getMiscQualifiers() {
            return miscQualifiers;
        }

        /** 
         * Set the 'MiscQualifiers' element value.
         * 
         * @param miscQualifiers
         */
        public void setMiscQualifiers(MiscQualifiers miscQualifiers) {
            this.miscQualifiers = miscQualifiers;
        }

        /** 
         * Get the 'PricingQualifiers' element value.
         * 
         * @return value
         */
        public PricingQualifiers getPricingQualifiers() {
            return pricingQualifiers;
        }

        /** 
         * Set the 'PricingQualifiers' element value.
         * 
         * @param pricingQualifiers
         */
        public void setPricingQualifiers(PricingQualifiers pricingQualifiers) {
            this.pricingQualifiers = pricingQualifiers;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightQualifiers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="VendorPrefs" minOccurs="0">
         *         &lt;!-- Reference to inner class VendorPrefs -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightQualifiers implements Serializable
        {
            private VendorPrefs vendorPrefs;

            /** 
             * Get the 'VendorPrefs' element value.
             * 
             * @return value
             */
            public VendorPrefs getVendorPrefs() {
                return vendorPrefs;
            }

            /** 
             * Set the 'VendorPrefs' element value.
             * 
             * @param vendorPrefs
             */
            public void setVendorPrefs(VendorPrefs vendorPrefs) {
                this.vendorPrefs = vendorPrefs;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Airline">
             *         &lt;xs:complexType>
             *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class VendorPrefs implements Serializable
            {
                private String airline;

                /** 
                 * Get the 'Code' attribute value.
                 * 
                 * @return value
                 */
                public String getAirline() {
                    return airline;
                }

                /** 
                 * Set the 'Code' attribute value.
                 * 
                 * @param airline
                 */
                public void setAirline(String airline) {
                    this.airline = airline;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FOP_Qualifiers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="BasicFOP" minOccurs="0">
         *         &lt;!-- Reference to inner class BasicFOP -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="BSP_Ticketing" minOccurs="0">
         *         &lt;!-- Reference to inner class BSPTicketing -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="MultipleCC_FOP" minOccurs="0">
         *         &lt;!-- Reference to inner class MultipleCCFOP -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="SabreSonicTicketing" minOccurs="0">
         *         &lt;!-- Reference to inner class SabreSonicTicketing -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FOPQualifiers implements Serializable
        {
            private BasicFOP basicFOP;
            private BSPTicketing BSPTicketing1;
            private MultipleCCFOP multipleCCFOP;
            private SabreSonicTicketing sabreSonicTicketing;

            /** 
             * Get the 'BasicFOP' element value.
             * 
             * @return value
             */
            public BasicFOP getBasicFOP() {
                return basicFOP;
            }

            /** 
             * Set the 'BasicFOP' element value.
             * 
             * @param basicFOP
             */
            public void setBasicFOP(BasicFOP basicFOP) {
                this.basicFOP = basicFOP;
            }

            /** 
             * Get the 'BSP_Ticketing' element value.
             * 
             * @return value
             */
            public BSPTicketing getBSPTicketing1() {
                return BSPTicketing1;
            }

            /** 
             * Set the 'BSP_Ticketing' element value.
             * 
             * @param BSPTicketing1
             */
            public void setBSPTicketing1(BSPTicketing BSPTicketing1) {
                this.BSPTicketing1 = BSPTicketing1;
            }

            /** 
             * Get the 'MultipleCC_FOP' element value.
             * 
             * @return value
             */
            public MultipleCCFOP getMultipleCCFOP() {
                return multipleCCFOP;
            }

            /** 
             * Set the 'MultipleCC_FOP' element value.
             * 
             * @param multipleCCFOP
             */
            public void setMultipleCCFOP(MultipleCCFOP multipleCCFOP) {
                this.multipleCCFOP = multipleCCFOP;
            }

            /** 
             * Get the 'SabreSonicTicketing' element value.
             * 
             * @return value
             */
            public SabreSonicTicketing getSabreSonicTicketing() {
                return sabreSonicTicketing;
            }

            /** 
             * Set the 'SabreSonicTicketing' element value.
             * 
             * @param sabreSonicTicketing
             */
            public void setSabreSonicTicketing(
                    SabreSonicTicketing sabreSonicTicketing) {
                this.sabreSonicTicketing = sabreSonicTicketing;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BasicFOP" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="CC_Info" minOccurs="0">
             *         &lt;!-- Reference to inner class CCInfo -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="CostCenter"/>
             *     &lt;xs:attribute type="xs:integer" use="optional" name="Reference"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Virtual"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BasicFOP implements Serializable
            {
                private CCInfo CCInfo1;
                private String costCenter;
                private BigInteger reference;
                private String type;
                private String virtual;

                /** 
                 * Get the 'CC_Info' element value.
                 * 
                 * @return value
                 */
                public CCInfo getCCInfo1() {
                    return CCInfo1;
                }

                /** 
                 * Set the 'CC_Info' element value.
                 * 
                 * @param CCInfo1
                 */
                public void setCCInfo1(CCInfo CCInfo1) {
                    this.CCInfo1 = CCInfo1;
                }

                /** 
                 * Get the 'CostCenter' attribute value.
                 * 
                 * @return value
                 */
                public String getCostCenter() {
                    return costCenter;
                }

                /** 
                 * Set the 'CostCenter' attribute value.
                 * 
                 * @param costCenter
                 */
                public void setCostCenter(String costCenter) {
                    this.costCenter = costCenter;
                }

                /** 
                 * Get the 'Reference' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getReference() {
                    return reference;
                }

                /** 
                 * Set the 'Reference' attribute value.
                 * 
                 * @param reference
                 */
                public void setReference(BigInteger reference) {
                    this.reference = reference;
                }

                /** 
                 * Get the 'Type' attribute value.
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value.
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }

                /** 
                 * Get the 'Virtual' attribute value.
                 * 
                 * @return value
                 */
                public String getVirtual() {
                    return virtual;
                }

                /** 
                 * Set the 'Virtual' attribute value.
                 * 
                 * @param virtual
                 */
                public void setVirtual(String virtual) {
                    this.virtual = virtual;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="PaymentCard">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="CardSecurityCode"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="ExpireDate"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="ManualOBFee"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CCInfo implements Serializable
                {
                    private String paymentCardCode;
                    private String paymentCardCardSecurityCode;
                    private String paymentCardExpireDate;
                    private BigInteger paymentCardExtendedPayment;
                    private String paymentCardManualApprovalCode;
                    private String paymentCardManualOBFee;
                    private BigInteger paymentCardNumber;
                    private Boolean suppress;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardCode() {
                        return paymentCardCode;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param paymentCardCode
                     */
                    public void setPaymentCardCode(String paymentCardCode) {
                        this.paymentCardCode = paymentCardCode;
                    }

                    /** 
                     * Get the 'CardSecurityCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardCardSecurityCode() {
                        return paymentCardCardSecurityCode;
                    }

                    /** 
                     * Set the 'CardSecurityCode' attribute value.
                     * 
                     * @param paymentCardCardSecurityCode
                     */
                    public void setPaymentCardCardSecurityCode(
                            String paymentCardCardSecurityCode) {
                        this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                    }

                    /** 
                     * Get the 'ExpireDate' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardExpireDate() {
                        return paymentCardExpireDate;
                    }

                    /** 
                     * Set the 'ExpireDate' attribute value.
                     * 
                     * @param paymentCardExpireDate
                     */
                    public void setPaymentCardExpireDate(
                            String paymentCardExpireDate) {
                        this.paymentCardExpireDate = paymentCardExpireDate;
                    }

                    /** 
                     * Get the 'ExtendedPayment' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getPaymentCardExtendedPayment() {
                        return paymentCardExtendedPayment;
                    }

                    /** 
                     * Set the 'ExtendedPayment' attribute value.
                     * 
                     * @param paymentCardExtendedPayment
                     */
                    public void setPaymentCardExtendedPayment(
                            BigInteger paymentCardExtendedPayment) {
                        this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                    }

                    /** 
                     * Get the 'ManualApprovalCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardManualApprovalCode() {
                        return paymentCardManualApprovalCode;
                    }

                    /** 
                     * Set the 'ManualApprovalCode' attribute value.
                     * 
                     * @param paymentCardManualApprovalCode
                     */
                    public void setPaymentCardManualApprovalCode(
                            String paymentCardManualApprovalCode) {
                        this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                    }

                    /** 
                     * Get the 'ManualOBFee' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardManualOBFee() {
                        return paymentCardManualOBFee;
                    }

                    /** 
                     * Set the 'ManualOBFee' attribute value.
                     * 
                     * @param paymentCardManualOBFee
                     */
                    public void setPaymentCardManualOBFee(
                            String paymentCardManualOBFee) {
                        this.paymentCardManualOBFee = paymentCardManualOBFee;
                    }

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getPaymentCardNumber() {
                        return paymentCardNumber;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param paymentCardNumber
                     */
                    public void setPaymentCardNumber(
                            BigInteger paymentCardNumber) {
                        this.paymentCardNumber = paymentCardNumber;
                    }

                    /** 
                     * Get the 'Suppress' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getSuppress() {
                        return suppress;
                    }

                    /** 
                     * Set the 'Suppress' attribute value.
                     * 
                     * @param suppress
                     */
                    public void setSuppress(Boolean suppress) {
                        this.suppress = suppress;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BSP_Ticketing" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="MultipleFOP" minOccurs="0">
             *         &lt;!-- Reference to inner class MultipleFOP -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="MultipleMiscFOP" minOccurs="0">
             *         &lt;!-- Reference to inner class MultipleMiscFOP -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="PayLaterPlan" minOccurs="0">
             *         &lt;!-- Reference to inner class PayLaterPlan -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BSPTicketing implements Serializable
            {
                private MultipleFOP multipleFOP;
                private MultipleMiscFOP multipleMiscFOP;
                private PayLaterPlan payLaterPlan;

                /** 
                 * Get the 'MultipleFOP' element value.
                 * 
                 * @return value
                 */
                public MultipleFOP getMultipleFOP() {
                    return multipleFOP;
                }

                /** 
                 * Set the 'MultipleFOP' element value.
                 * 
                 * @param multipleFOP
                 */
                public void setMultipleFOP(MultipleFOP multipleFOP) {
                    this.multipleFOP = multipleFOP;
                }

                /** 
                 * Get the 'MultipleMiscFOP' element value.
                 * 
                 * @return value
                 */
                public MultipleMiscFOP getMultipleMiscFOP() {
                    return multipleMiscFOP;
                }

                /** 
                 * Set the 'MultipleMiscFOP' element value.
                 * 
                 * @param multipleMiscFOP
                 */
                public void setMultipleMiscFOP(MultipleMiscFOP multipleMiscFOP) {
                    this.multipleMiscFOP = multipleMiscFOP;
                }

                /** 
                 * Get the 'PayLaterPlan' element value.
                 * 
                 * @return value
                 */
                public PayLaterPlan getPayLaterPlan() {
                    return payLaterPlan;
                }

                /** 
                 * Set the 'PayLaterPlan' element value.
                 * 
                 * @param payLaterPlan
                 */
                public void setPayLaterPlan(PayLaterPlan payLaterPlan) {
                    this.payLaterPlan = payLaterPlan;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleFOP" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Fare">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_One">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="Reference"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_Two">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo1 -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="Reference"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Taxes" minOccurs="0">
                 *         &lt;!-- Reference to inner class Taxes -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MultipleFOP implements Serializable
                {
                    private String fare;
                    private CCInfo CCInfo2;
                    private String FOPOneType;
                    private BigInteger FOPOneReference;
                    private CCInfo1 CCInfo3;
                    private String FOPTwoType;
                    private BigInteger FOPTwoReference;
                    private Taxes taxes;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getFare() {
                        return fare;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param fare
                     */
                    public void setFare(String fare) {
                        this.fare = fare;
                    }

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo2() {
                        return CCInfo2;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo2
                     */
                    public void setCCInfo2(CCInfo CCInfo2) {
                        this.CCInfo2 = CCInfo2;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getFOPOneType() {
                        return FOPOneType;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param FOPOneType
                     */
                    public void setFOPOneType(String FOPOneType) {
                        this.FOPOneType = FOPOneType;
                    }

                    /** 
                     * Get the 'Reference' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getFOPOneReference() {
                        return FOPOneReference;
                    }

                    /** 
                     * Set the 'Reference' attribute value.
                     * 
                     * @param FOPOneReference
                     */
                    public void setFOPOneReference(BigInteger FOPOneReference) {
                        this.FOPOneReference = FOPOneReference;
                    }

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo1 getCCInfo3() {
                        return CCInfo3;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo3
                     */
                    public void setCCInfo3(CCInfo1 CCInfo3) {
                        this.CCInfo3 = CCInfo3;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getFOPTwoType() {
                        return FOPTwoType;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param FOPTwoType
                     */
                    public void setFOPTwoType(String FOPTwoType) {
                        this.FOPTwoType = FOPTwoType;
                    }

                    /** 
                     * Get the 'Reference' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getFOPTwoReference() {
                        return FOPTwoReference;
                    }

                    /** 
                     * Set the 'Reference' attribute value.
                     * 
                     * @param FOPTwoReference
                     */
                    public void setFOPTwoReference(BigInteger FOPTwoReference) {
                        this.FOPTwoReference = FOPTwoReference;
                    }

                    /** 
                     * Get the 'Taxes' element value.
                     * 
                     * @return value
                     */
                    public Taxes getTaxes() {
                        return taxes;
                    }

                    /** 
                     * Set the 'Taxes' element value.
                     * 
                     * @param taxes
                     */
                    public void setTaxes(Taxes taxes) {
                        this.taxes = taxes;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="CardSecurityCode"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualOBFee"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardCardSecurityCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private String paymentCardManualOBFee;
                        private BigInteger paymentCardNumber;
                        private Boolean suppress;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'CardSecurityCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCardSecurityCode() {
                            return paymentCardCardSecurityCode;
                        }

                        /** 
                         * Set the 'CardSecurityCode' attribute value.
                         * 
                         * @param paymentCardCardSecurityCode
                         */
                        public void setPaymentCardCardSecurityCode(
                                String paymentCardCardSecurityCode) {
                            this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value.
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'ManualOBFee' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualOBFee() {
                            return paymentCardManualOBFee;
                        }

                        /** 
                         * Set the 'ManualOBFee' attribute value.
                         * 
                         * @param paymentCardManualOBFee
                         */
                        public void setPaymentCardManualOBFee(
                                String paymentCardManualOBFee) {
                            this.paymentCardManualOBFee = paymentCardManualOBFee;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }

                        /** 
                         * Get the 'Suppress' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getSuppress() {
                            return suppress;
                        }

                        /** 
                         * Set the 'Suppress' attribute value.
                         * 
                         * @param suppress
                         */
                        public void setSuppress(Boolean suppress) {
                            this.suppress = suppress;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="CardSecurityCode"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualOBFee"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo1 implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardCardSecurityCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private String paymentCardManualOBFee;
                        private BigInteger paymentCardNumber;
                        private Boolean suppress;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'CardSecurityCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCardSecurityCode() {
                            return paymentCardCardSecurityCode;
                        }

                        /** 
                         * Set the 'CardSecurityCode' attribute value.
                         * 
                         * @param paymentCardCardSecurityCode
                         */
                        public void setPaymentCardCardSecurityCode(
                                String paymentCardCardSecurityCode) {
                            this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value.
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'ManualOBFee' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualOBFee() {
                            return paymentCardManualOBFee;
                        }

                        /** 
                         * Set the 'ManualOBFee' attribute value.
                         * 
                         * @param paymentCardManualOBFee
                         */
                        public void setPaymentCardManualOBFee(
                                String paymentCardManualOBFee) {
                            this.paymentCardManualOBFee = paymentCardManualOBFee;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }

                        /** 
                         * Get the 'Suppress' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getSuppress() {
                            return suppress;
                        }

                        /** 
                         * Set the 'Suppress' attribute value.
                         * 
                         * @param suppress
                         */
                        public void setSuppress(Boolean suppress) {
                            this.suppress = suppress;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Tax" maxOccurs="3">
                     *         &lt;!-- Reference to inner class Tax -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Taxes implements Serializable
                    {
                        private List<Tax> taxList = new ArrayList<Tax>();

                        /** 
                         * Get the list of 'Tax' element items.
                         * 
                         * @return list
                         */
                        public List<Tax> getTaxList() {
                            return taxList;
                        }

                        /** 
                         * Set the list of 'Tax' element items.
                         * 
                         * @param list
                         */
                        public void setTaxList(List<Tax> list) {
                            taxList = list;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" maxOccurs="3">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                         *     &lt;xs:attribute type="xs:string" use="required" name="TaxCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Tax implements Serializable
                        {
                            private String amount;
                            private String taxCode;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }

                            /** 
                             * Get the 'TaxCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getTaxCode() {
                                return taxCode;
                            }

                            /** 
                             * Set the 'TaxCode' attribute value.
                             * 
                             * @param taxCode
                             */
                            public void setTaxCode(String taxCode) {
                                this.taxCode = taxCode;
                            }
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleMiscFOP" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Fare">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_One">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="Reference"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_Two">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="ExtendedPayment" minOccurs="0">
                 *               &lt;!-- Reference to inner class ExtendedPayment -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="Reference"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Taxes" minOccurs="0">
                 *         &lt;!-- Reference to inner class Taxes -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MultipleMiscFOP implements Serializable
                {
                    private String fare;
                    private CCInfo CCInfo1;
                    private String FOPOneType;
                    private BigInteger FOPOneReference;
                    private ExtendedPayment extendedPayment;
                    private String FOPTwoType;
                    private BigInteger FOPTwoReference;
                    private Taxes taxes;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getFare() {
                        return fare;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param fare
                     */
                    public void setFare(String fare) {
                        this.fare = fare;
                    }

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo1() {
                        return CCInfo1;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo1
                     */
                    public void setCCInfo1(CCInfo CCInfo1) {
                        this.CCInfo1 = CCInfo1;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getFOPOneType() {
                        return FOPOneType;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param FOPOneType
                     */
                    public void setFOPOneType(String FOPOneType) {
                        this.FOPOneType = FOPOneType;
                    }

                    /** 
                     * Get the 'Reference' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getFOPOneReference() {
                        return FOPOneReference;
                    }

                    /** 
                     * Set the 'Reference' attribute value.
                     * 
                     * @param FOPOneReference
                     */
                    public void setFOPOneReference(BigInteger FOPOneReference) {
                        this.FOPOneReference = FOPOneReference;
                    }

                    /** 
                     * Get the 'ExtendedPayment' element value.
                     * 
                     * @return value
                     */
                    public ExtendedPayment getExtendedPayment() {
                        return extendedPayment;
                    }

                    /** 
                     * Set the 'ExtendedPayment' element value.
                     * 
                     * @param extendedPayment
                     */
                    public void setExtendedPayment(
                            ExtendedPayment extendedPayment) {
                        this.extendedPayment = extendedPayment;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getFOPTwoType() {
                        return FOPTwoType;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param FOPTwoType
                     */
                    public void setFOPTwoType(String FOPTwoType) {
                        this.FOPTwoType = FOPTwoType;
                    }

                    /** 
                     * Get the 'Reference' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getFOPTwoReference() {
                        return FOPTwoReference;
                    }

                    /** 
                     * Set the 'Reference' attribute value.
                     * 
                     * @param FOPTwoReference
                     */
                    public void setFOPTwoReference(BigInteger FOPTwoReference) {
                        this.FOPTwoReference = FOPTwoReference;
                    }

                    /** 
                     * Get the 'Taxes' element value.
                     * 
                     * @return value
                     */
                    public Taxes getTaxes() {
                        return taxes;
                    }

                    /** 
                     * Set the 'Taxes' element value.
                     * 
                     * @param taxes
                     */
                    public void setTaxes(Taxes taxes) {
                        this.taxes = taxes;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;
                        private Boolean suppress;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value.
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }

                        /** 
                         * Get the 'Suppress' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getSuppress() {
                            return suppress;
                        }

                        /** 
                         * Set the 'Suppress' attribute value.
                         * 
                         * @param suppress
                         */
                        public void setSuppress(Boolean suppress) {
                            this.suppress = suppress;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExtendedPayment" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:integer" use="required" name="NumMonths"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class ExtendedPayment implements Serializable
                    {
                        private BigInteger numMonths;

                        /** 
                         * Get the 'NumMonths' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getNumMonths() {
                            return numMonths;
                        }

                        /** 
                         * Set the 'NumMonths' attribute value.
                         * 
                         * @param numMonths
                         */
                        public void setNumMonths(BigInteger numMonths) {
                            this.numMonths = numMonths;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Tax" maxOccurs="2">
                     *         &lt;!-- Reference to inner class Tax -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Taxes implements Serializable
                    {
                        private List<Tax> taxList = new ArrayList<Tax>();

                        /** 
                         * Get the list of 'Tax' element items.
                         * 
                         * @return list
                         */
                        public List<Tax> getTaxList() {
                            return taxList;
                        }

                        /** 
                         * Set the list of 'Tax' element items.
                         * 
                         * @param list
                         */
                        public void setTaxList(List<Tax> list) {
                            taxList = list;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" maxOccurs="2">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                         *     &lt;xs:attribute type="xs:string" use="required" name="TaxCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Tax implements Serializable
                        {
                            private String amount;
                            private String taxCode;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }

                            /** 
                             * Get the 'TaxCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getTaxCode() {
                                return taxCode;
                            }

                            /** 
                             * Set the 'TaxCode' attribute value.
                             * 
                             * @param taxCode
                             */
                            public void setTaxCode(String taxCode) {
                                this.taxCode = taxCode;
                            }
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PayLaterPlan" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Fare">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="Reference"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Installment">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Count"/>
                 *           &lt;xs:attribute type="xs:string" use="required" name="PayLaterReferenceNumber"/>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Value"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PayLaterPlan implements Serializable
                {
                    private String fare;
                    private CCInfo CCInfo1;
                    private String FOPType;
                    private BigInteger FOPReference;
                    private String installmentCount;
                    private String installmentPayLaterReferenceNumber;
                    private String installmentValue;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getFare() {
                        return fare;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param fare
                     */
                    public void setFare(String fare) {
                        this.fare = fare;
                    }

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo1() {
                        return CCInfo1;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo1
                     */
                    public void setCCInfo1(CCInfo CCInfo1) {
                        this.CCInfo1 = CCInfo1;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getFOPType() {
                        return FOPType;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param FOPType
                     */
                    public void setFOPType(String FOPType) {
                        this.FOPType = FOPType;
                    }

                    /** 
                     * Get the 'Reference' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getFOPReference() {
                        return FOPReference;
                    }

                    /** 
                     * Set the 'Reference' attribute value.
                     * 
                     * @param FOPReference
                     */
                    public void setFOPReference(BigInteger FOPReference) {
                        this.FOPReference = FOPReference;
                    }

                    /** 
                     * Get the 'Count' attribute value.
                     * 
                     * @return value
                     */
                    public String getInstallmentCount() {
                        return installmentCount;
                    }

                    /** 
                     * Set the 'Count' attribute value.
                     * 
                     * @param installmentCount
                     */
                    public void setInstallmentCount(String installmentCount) {
                        this.installmentCount = installmentCount;
                    }

                    /** 
                     * Get the 'PayLaterReferenceNumber' attribute value.
                     * 
                     * @return value
                     */
                    public String getInstallmentPayLaterReferenceNumber() {
                        return installmentPayLaterReferenceNumber;
                    }

                    /** 
                     * Set the 'PayLaterReferenceNumber' attribute value.
                     * 
                     * @param installmentPayLaterReferenceNumber
                     */
                    public void setInstallmentPayLaterReferenceNumber(
                            String installmentPayLaterReferenceNumber) {
                        this.installmentPayLaterReferenceNumber = installmentPayLaterReferenceNumber;
                    }

                    /** 
                     * Get the 'Value' attribute value.
                     * 
                     * @return value
                     */
                    public String getInstallmentValue() {
                        return installmentValue;
                    }

                    /** 
                     * Set the 'Value' attribute value.
                     * 
                     * @param installmentValue
                     */
                    public void setInstallmentValue(String installmentValue) {
                        this.installmentValue = installmentValue;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleCC_FOP" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Fare">
             *         &lt;xs:complexType>
             *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element name="CC_One">
             *         &lt;xs:complexType>
             *           &lt;xs:sequence>
             *             &lt;xs:element name="CC_Info" minOccurs="0">
             *               &lt;!-- Reference to inner class CCInfo -->
             *             &lt;/xs:element>
             *           &lt;/xs:sequence>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element name="CC_Two">
             *         &lt;xs:complexType>
             *           &lt;xs:sequence>
             *             &lt;xs:element name="CC_Info" minOccurs="0">
             *               &lt;!-- Reference to inner class CCInfo1 -->
             *             &lt;/xs:element>
             *           &lt;/xs:sequence>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MultipleCCFOP implements Serializable
            {
                private String fare;
                private CCInfo CCOne;
                private CCInfo1 CCTwo;

                /** 
                 * Get the 'Amount' attribute value.
                 * 
                 * @return value
                 */
                public String getFare() {
                    return fare;
                }

                /** 
                 * Set the 'Amount' attribute value.
                 * 
                 * @param fare
                 */
                public void setFare(String fare) {
                    this.fare = fare;
                }

                /** 
                 * Get the 'CC_Info' element value.
                 * 
                 * @return value
                 */
                public CCInfo getCCOne() {
                    return CCOne;
                }

                /** 
                 * Set the 'CC_Info' element value.
                 * 
                 * @param CCOne
                 */
                public void setCCOne(CCInfo CCOne) {
                    this.CCOne = CCOne;
                }

                /** 
                 * Get the 'CC_Info' element value.
                 * 
                 * @return value
                 */
                public CCInfo1 getCCTwo() {
                    return CCTwo;
                }

                /** 
                 * Set the 'CC_Info' element value.
                 * 
                 * @param CCTwo
                 */
                public void setCCTwo(CCInfo1 CCTwo) {
                    this.CCTwo = CCTwo;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="PaymentCard">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="CardSecurityCode"/>
                 *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="ManualOBFee"/>
                 *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CCInfo implements Serializable
                {
                    private String paymentCardCode;
                    private String paymentCardCardSecurityCode;
                    private String paymentCardExpireDate;
                    private BigInteger paymentCardExtendedPayment;
                    private String paymentCardManualApprovalCode;
                    private String paymentCardManualOBFee;
                    private BigInteger paymentCardNumber;
                    private Boolean suppress;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardCode() {
                        return paymentCardCode;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param paymentCardCode
                     */
                    public void setPaymentCardCode(String paymentCardCode) {
                        this.paymentCardCode = paymentCardCode;
                    }

                    /** 
                     * Get the 'CardSecurityCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardCardSecurityCode() {
                        return paymentCardCardSecurityCode;
                    }

                    /** 
                     * Set the 'CardSecurityCode' attribute value.
                     * 
                     * @param paymentCardCardSecurityCode
                     */
                    public void setPaymentCardCardSecurityCode(
                            String paymentCardCardSecurityCode) {
                        this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                    }

                    /** 
                     * Get the 'ExpireDate' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardExpireDate() {
                        return paymentCardExpireDate;
                    }

                    /** 
                     * Set the 'ExpireDate' attribute value.
                     * 
                     * @param paymentCardExpireDate
                     */
                    public void setPaymentCardExpireDate(
                            String paymentCardExpireDate) {
                        this.paymentCardExpireDate = paymentCardExpireDate;
                    }

                    /** 
                     * Get the 'ExtendedPayment' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getPaymentCardExtendedPayment() {
                        return paymentCardExtendedPayment;
                    }

                    /** 
                     * Set the 'ExtendedPayment' attribute value.
                     * 
                     * @param paymentCardExtendedPayment
                     */
                    public void setPaymentCardExtendedPayment(
                            BigInteger paymentCardExtendedPayment) {
                        this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                    }

                    /** 
                     * Get the 'ManualApprovalCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardManualApprovalCode() {
                        return paymentCardManualApprovalCode;
                    }

                    /** 
                     * Set the 'ManualApprovalCode' attribute value.
                     * 
                     * @param paymentCardManualApprovalCode
                     */
                    public void setPaymentCardManualApprovalCode(
                            String paymentCardManualApprovalCode) {
                        this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                    }

                    /** 
                     * Get the 'ManualOBFee' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardManualOBFee() {
                        return paymentCardManualOBFee;
                    }

                    /** 
                     * Set the 'ManualOBFee' attribute value.
                     * 
                     * @param paymentCardManualOBFee
                     */
                    public void setPaymentCardManualOBFee(
                            String paymentCardManualOBFee) {
                        this.paymentCardManualOBFee = paymentCardManualOBFee;
                    }

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getPaymentCardNumber() {
                        return paymentCardNumber;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param paymentCardNumber
                     */
                    public void setPaymentCardNumber(
                            BigInteger paymentCardNumber) {
                        this.paymentCardNumber = paymentCardNumber;
                    }

                    /** 
                     * Get the 'Suppress' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getSuppress() {
                        return suppress;
                    }

                    /** 
                     * Set the 'Suppress' attribute value.
                     * 
                     * @param suppress
                     */
                    public void setSuppress(Boolean suppress) {
                        this.suppress = suppress;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="PaymentCard">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="CardSecurityCode"/>
                 *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                 *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="ManualOBFee"/>
                 *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CCInfo1 implements Serializable
                {
                    private String paymentCardCode;
                    private String paymentCardCardSecurityCode;
                    private String paymentCardExpireDate;
                    private BigInteger paymentCardExtendedPayment;
                    private String paymentCardManualApprovalCode;
                    private String paymentCardManualOBFee;
                    private BigInteger paymentCardNumber;
                    private Boolean suppress;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardCode() {
                        return paymentCardCode;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param paymentCardCode
                     */
                    public void setPaymentCardCode(String paymentCardCode) {
                        this.paymentCardCode = paymentCardCode;
                    }

                    /** 
                     * Get the 'CardSecurityCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardCardSecurityCode() {
                        return paymentCardCardSecurityCode;
                    }

                    /** 
                     * Set the 'CardSecurityCode' attribute value.
                     * 
                     * @param paymentCardCardSecurityCode
                     */
                    public void setPaymentCardCardSecurityCode(
                            String paymentCardCardSecurityCode) {
                        this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                    }

                    /** 
                     * Get the 'ExpireDate' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardExpireDate() {
                        return paymentCardExpireDate;
                    }

                    /** 
                     * Set the 'ExpireDate' attribute value.
                     * 
                     * @param paymentCardExpireDate
                     */
                    public void setPaymentCardExpireDate(
                            String paymentCardExpireDate) {
                        this.paymentCardExpireDate = paymentCardExpireDate;
                    }

                    /** 
                     * Get the 'ExtendedPayment' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getPaymentCardExtendedPayment() {
                        return paymentCardExtendedPayment;
                    }

                    /** 
                     * Set the 'ExtendedPayment' attribute value.
                     * 
                     * @param paymentCardExtendedPayment
                     */
                    public void setPaymentCardExtendedPayment(
                            BigInteger paymentCardExtendedPayment) {
                        this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                    }

                    /** 
                     * Get the 'ManualApprovalCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardManualApprovalCode() {
                        return paymentCardManualApprovalCode;
                    }

                    /** 
                     * Set the 'ManualApprovalCode' attribute value.
                     * 
                     * @param paymentCardManualApprovalCode
                     */
                    public void setPaymentCardManualApprovalCode(
                            String paymentCardManualApprovalCode) {
                        this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                    }

                    /** 
                     * Get the 'ManualOBFee' attribute value.
                     * 
                     * @return value
                     */
                    public String getPaymentCardManualOBFee() {
                        return paymentCardManualOBFee;
                    }

                    /** 
                     * Set the 'ManualOBFee' attribute value.
                     * 
                     * @param paymentCardManualOBFee
                     */
                    public void setPaymentCardManualOBFee(
                            String paymentCardManualOBFee) {
                        this.paymentCardManualOBFee = paymentCardManualOBFee;
                    }

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getPaymentCardNumber() {
                        return paymentCardNumber;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param paymentCardNumber
                     */
                    public void setPaymentCardNumber(
                            BigInteger paymentCardNumber) {
                        this.paymentCardNumber = paymentCardNumber;
                    }

                    /** 
                     * Get the 'Suppress' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getSuppress() {
                        return suppress;
                    }

                    /** 
                     * Set the 'Suppress' attribute value.
                     * 
                     * @param suppress
                     */
                    public void setSuppress(Boolean suppress) {
                        this.suppress = suppress;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SabreSonicTicketing" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BasicFOP" minOccurs="0">
             *         &lt;!-- Reference to inner class BasicFOP -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="EnhancedMultipleFOP" minOccurs="0">
             *         &lt;!-- Reference to inner class EnhancedMultipleFOP -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="MultipleFOP" minOccurs="0">
             *         &lt;!-- Reference to inner class MultipleFOP -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SabreSonicTicketing implements Serializable
            {
                private BasicFOP basicFOP;
                private EnhancedMultipleFOP enhancedMultipleFOP;
                private MultipleFOP multipleFOP;

                /** 
                 * Get the 'BasicFOP' element value.
                 * 
                 * @return value
                 */
                public BasicFOP getBasicFOP() {
                    return basicFOP;
                }

                /** 
                 * Set the 'BasicFOP' element value.
                 * 
                 * @param basicFOP
                 */
                public void setBasicFOP(BasicFOP basicFOP) {
                    this.basicFOP = basicFOP;
                }

                /** 
                 * Get the 'EnhancedMultipleFOP' element value.
                 * 
                 * @return value
                 */
                public EnhancedMultipleFOP getEnhancedMultipleFOP() {
                    return enhancedMultipleFOP;
                }

                /** 
                 * Set the 'EnhancedMultipleFOP' element value.
                 * 
                 * @param enhancedMultipleFOP
                 */
                public void setEnhancedMultipleFOP(
                        EnhancedMultipleFOP enhancedMultipleFOP) {
                    this.enhancedMultipleFOP = enhancedMultipleFOP;
                }

                /** 
                 * Get the 'MultipleFOP' element value.
                 * 
                 * @return value
                 */
                public MultipleFOP getMultipleFOP() {
                    return multipleFOP;
                }

                /** 
                 * Set the 'MultipleFOP' element value.
                 * 
                 * @param multipleFOP
                 */
                public void setMultipleFOP(MultipleFOP multipleFOP) {
                    this.multipleFOP = multipleFOP;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BasicFOP" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="CC_Info" minOccurs="0">
                 *         &lt;!-- Reference to inner class CCInfo -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BasicFOP implements Serializable
                {
                    private CCInfo CCInfo1;
                    private String manualApprovalCode;
                    private String type;

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo1() {
                        return CCInfo1;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo1
                     */
                    public void setCCInfo1(CCInfo CCInfo1) {
                        this.CCInfo1 = CCInfo1;
                    }

                    /** 
                     * Get the 'ManualApprovalCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getManualApprovalCode() {
                        return manualApprovalCode;
                    }

                    /** 
                     * Set the 'ManualApprovalCode' attribute value.
                     * 
                     * @param manualApprovalCode
                     */
                    public void setManualApprovalCode(String manualApprovalCode) {
                        this.manualApprovalCode = manualApprovalCode;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="CardSecurityCode"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Suppress"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private BigInteger paymentCardCardSecurityCode;
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;
                        private Boolean suppress;

                        /** 
                         * Get the 'CardSecurityCode' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardCardSecurityCode() {
                            return paymentCardCardSecurityCode;
                        }

                        /** 
                         * Set the 'CardSecurityCode' attribute value.
                         * 
                         * @param paymentCardCardSecurityCode
                         */
                        public void setPaymentCardCardSecurityCode(
                                BigInteger paymentCardCardSecurityCode) {
                            this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                        }

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value.
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }

                        /** 
                         * Get the 'Suppress' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getSuppress() {
                            return suppress;
                        }

                        /** 
                         * Set the 'Suppress' attribute value.
                         * 
                         * @param suppress
                         */
                        public void setSuppress(Boolean suppress) {
                            this.suppress = suppress;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EnhancedMultipleFOP" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Fare">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_One">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_Two">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo1 -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Taxes">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="Tax">
                 *               &lt;xs:complexType>
                 *                 &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *                 &lt;xs:attribute type="xs:string" use="required" name="TaxCode"/>
                 *               &lt;/xs:complexType>
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class EnhancedMultipleFOP implements Serializable
                {
                    private String fare;
                    private CCInfo CCInfo2;
                    private String FOPOneType;
                    private CCInfo1 CCInfo3;
                    private String FOPTwoType;
                    private String taxesTaxAmount;
                    private String taxesTaxTaxCode;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getFare() {
                        return fare;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param fare
                     */
                    public void setFare(String fare) {
                        this.fare = fare;
                    }

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo2() {
                        return CCInfo2;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo2
                     */
                    public void setCCInfo2(CCInfo CCInfo2) {
                        this.CCInfo2 = CCInfo2;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getFOPOneType() {
                        return FOPOneType;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param FOPOneType
                     */
                    public void setFOPOneType(String FOPOneType) {
                        this.FOPOneType = FOPOneType;
                    }

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo1 getCCInfo3() {
                        return CCInfo3;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo3
                     */
                    public void setCCInfo3(CCInfo1 CCInfo3) {
                        this.CCInfo3 = CCInfo3;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getFOPTwoType() {
                        return FOPTwoType;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param FOPTwoType
                     */
                    public void setFOPTwoType(String FOPTwoType) {
                        this.FOPTwoType = FOPTwoType;
                    }

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getTaxesTaxAmount() {
                        return taxesTaxAmount;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param taxesTaxAmount
                     */
                    public void setTaxesTaxAmount(String taxesTaxAmount) {
                        this.taxesTaxAmount = taxesTaxAmount;
                    }

                    /** 
                     * Get the 'TaxCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getTaxesTaxTaxCode() {
                        return taxesTaxTaxCode;
                    }

                    /** 
                     * Set the 'TaxCode' attribute value.
                     * 
                     * @param taxesTaxTaxCode
                     */
                    public void setTaxesTaxTaxCode(String taxesTaxTaxCode) {
                        this.taxesTaxTaxCode = taxesTaxTaxCode;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="CardSecurityCode"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private String paymentCardCardSecurityCode;
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;

                        /** 
                         * Get the 'CardSecurityCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCardSecurityCode() {
                            return paymentCardCardSecurityCode;
                        }

                        /** 
                         * Set the 'CardSecurityCode' attribute value.
                         * 
                         * @param paymentCardCardSecurityCode
                         */
                        public void setPaymentCardCardSecurityCode(
                                String paymentCardCardSecurityCode) {
                            this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                        }

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value.
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="CardSecurityCode"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="ExpireDate"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="ExtendedPayment"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo1 implements Serializable
                    {
                        private String paymentCardCardSecurityCode;
                        private String paymentCardCode;
                        private String paymentCardExpireDate;
                        private BigInteger paymentCardExtendedPayment;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;

                        /** 
                         * Get the 'CardSecurityCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCardSecurityCode() {
                            return paymentCardCardSecurityCode;
                        }

                        /** 
                         * Set the 'CardSecurityCode' attribute value.
                         * 
                         * @param paymentCardCardSecurityCode
                         */
                        public void setPaymentCardCardSecurityCode(
                                String paymentCardCardSecurityCode) {
                            this.paymentCardCardSecurityCode = paymentCardCardSecurityCode;
                        }

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ExpireDate' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardExpireDate() {
                            return paymentCardExpireDate;
                        }

                        /** 
                         * Set the 'ExpireDate' attribute value.
                         * 
                         * @param paymentCardExpireDate
                         */
                        public void setPaymentCardExpireDate(
                                String paymentCardExpireDate) {
                            this.paymentCardExpireDate = paymentCardExpireDate;
                        }

                        /** 
                         * Get the 'ExtendedPayment' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardExtendedPayment() {
                            return paymentCardExtendedPayment;
                        }

                        /** 
                         * Set the 'ExtendedPayment' attribute value.
                         * 
                         * @param paymentCardExtendedPayment
                         */
                        public void setPaymentCardExtendedPayment(
                                BigInteger paymentCardExtendedPayment) {
                            this.paymentCardExtendedPayment = paymentCardExtendedPayment;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleFOP" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Fare">
                 *         &lt;xs:complexType>
                 *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_One">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FOP_Two">
                 *         &lt;xs:complexType>
                 *           &lt;xs:sequence>
                 *             &lt;xs:element name="CC_Info" minOccurs="0">
                 *               &lt;!-- Reference to inner class CCInfo1 -->
                 *             &lt;/xs:element>
                 *           &lt;/xs:sequence>
                 *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Taxes" minOccurs="0">
                 *         &lt;!-- Reference to inner class Taxes -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MultipleFOP implements Serializable
                {
                    private String fare;
                    private CCInfo CCInfo2;
                    private String FOPOneType;
                    private CCInfo1 CCInfo3;
                    private String FOPTwoType;
                    private Taxes taxes;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getFare() {
                        return fare;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param fare
                     */
                    public void setFare(String fare) {
                        this.fare = fare;
                    }

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo getCCInfo2() {
                        return CCInfo2;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo2
                     */
                    public void setCCInfo2(CCInfo CCInfo2) {
                        this.CCInfo2 = CCInfo2;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getFOPOneType() {
                        return FOPOneType;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param FOPOneType
                     */
                    public void setFOPOneType(String FOPOneType) {
                        this.FOPOneType = FOPOneType;
                    }

                    /** 
                     * Get the 'CC_Info' element value.
                     * 
                     * @return value
                     */
                    public CCInfo1 getCCInfo3() {
                        return CCInfo3;
                    }

                    /** 
                     * Set the 'CC_Info' element value.
                     * 
                     * @param CCInfo3
                     */
                    public void setCCInfo3(CCInfo1 CCInfo3) {
                        this.CCInfo3 = CCInfo3;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getFOPTwoType() {
                        return FOPTwoType;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param FOPTwoType
                     */
                    public void setFOPTwoType(String FOPTwoType) {
                        this.FOPTwoType = FOPTwoType;
                    }

                    /** 
                     * Get the 'Taxes' element value.
                     * 
                     * @return value
                     */
                    public Taxes getTaxes() {
                        return taxes;
                    }

                    /** 
                     * Set the 'Taxes' element value.
                     * 
                     * @param taxes
                     */
                    public void setTaxes(Taxes taxes) {
                        this.taxes = taxes;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="PaymentCard">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="ManualApprovalCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CCInfo1 implements Serializable
                    {
                        private String paymentCardCode;
                        private String paymentCardManualApprovalCode;
                        private BigInteger paymentCardNumber;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardCode() {
                            return paymentCardCode;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param paymentCardCode
                         */
                        public void setPaymentCardCode(String paymentCardCode) {
                            this.paymentCardCode = paymentCardCode;
                        }

                        /** 
                         * Get the 'ManualApprovalCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getPaymentCardManualApprovalCode() {
                            return paymentCardManualApprovalCode;
                        }

                        /** 
                         * Set the 'ManualApprovalCode' attribute value.
                         * 
                         * @param paymentCardManualApprovalCode
                         */
                        public void setPaymentCardManualApprovalCode(
                                String paymentCardManualApprovalCode) {
                            this.paymentCardManualApprovalCode = paymentCardManualApprovalCode;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getPaymentCardNumber() {
                            return paymentCardNumber;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param paymentCardNumber
                         */
                        public void setPaymentCardNumber(
                                BigInteger paymentCardNumber) {
                            this.paymentCardNumber = paymentCardNumber;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Tax">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                     *           &lt;xs:attribute type="xs:string" use="required" name="TaxCode"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Taxes implements Serializable
                    {
                        private String taxAmount;
                        private String taxTaxCode;

                        /** 
                         * Get the 'Amount' attribute value.
                         * 
                         * @return value
                         */
                        public String getTaxAmount() {
                            return taxAmount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.
                         * 
                         * @param taxAmount
                         */
                        public void setTaxAmount(String taxAmount) {
                            this.taxAmount = taxAmount;
                        }

                        /** 
                         * Get the 'TaxCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getTaxTaxCode() {
                            return taxTaxCode;
                        }

                        /** 
                         * Set the 'TaxCode' attribute value.
                         * 
                         * @param taxTaxCode
                         */
                        public void setTaxTaxCode(String taxTaxCode) {
                            this.taxTaxCode = taxTaxCode;
                        }
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiscQualifiers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AirExtras" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class AirExtras -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="BaggageAllowance" minOccurs="0" maxOccurs="99">
         *         &lt;!-- Reference to inner class BaggageAllowance -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Certificate" minOccurs="0" maxOccurs="2">
         *         &lt;!-- Reference to inner class Certificate -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Commission" minOccurs="0">
         *         &lt;!-- Reference to inner class Commission -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Discount" minOccurs="0">
         *         &lt;!-- Reference to inner class Discount -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="DateOfBirth" minOccurs="0"/>
         *       &lt;xs:element name="Endorsement" minOccurs="0">
         *         &lt;!-- Reference to inner class Endorsement -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="EndTransaction" minOccurs="0">
         *         &lt;!-- Reference to inner class EndTransaction -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="FutureTicket" minOccurs="0">
         *         &lt;!-- Reference to inner class FutureTicket -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Invoice" minOccurs="0">
         *         &lt;!-- Reference to inner class Invoice -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="MISF" minOccurs="0">
         *         &lt;!-- Reference to inner class MISF -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="NeedPrint" minOccurs="0">
         *         &lt;!-- Reference to inner class NeedPrint -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="NetRemit" minOccurs="0">
         *         &lt;!-- Reference to inner class NetRemit -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Ticket" minOccurs="0">
         *         &lt;!-- Reference to inner class Ticket -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TourCode" minOccurs="0">
         *         &lt;!-- Reference to inner class TourCode -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MiscQualifiers implements Serializable
        {
            private List<AirExtras> airExtraList = new ArrayList<AirExtras>();
            private List<BaggageAllowance> baggageAllowanceList = new ArrayList<BaggageAllowance>();
            private List<Certificate> certificateList = new ArrayList<Certificate>();
            private Commission commission;
            private Discount discount;
            private boolean dateOfBirth;
            private Endorsement endorsement;
            private EndTransaction endTransaction;
            private FutureTicket futureTicket;
            private Invoice invoice;
            private MISF MISF1;
            private NeedPrint needPrint;
            private NetRemit netRemit;
            private Ticket ticket;
            private TourCode tourCode;

            /** 
             * Get the list of 'AirExtras' element items.
             * 
             * @return list
             */
            public List<AirExtras> getAirExtraList() {
                return airExtraList;
            }

            /** 
             * Set the list of 'AirExtras' element items.
             * 
             * @param list
             */
            public void setAirExtraList(List<AirExtras> list) {
                airExtraList = list;
            }

            /** 
             * Get the list of 'BaggageAllowance' element items.
             * 
             * @return list
             */
            public List<BaggageAllowance> getBaggageAllowanceList() {
                return baggageAllowanceList;
            }

            /** 
             * Set the list of 'BaggageAllowance' element items.
             * 
             * @param list
             */
            public void setBaggageAllowanceList(List<BaggageAllowance> list) {
                baggageAllowanceList = list;
            }

            /** 
             * Get the list of 'Certificate' element items.
             * 
             * @return list
             */
            public List<Certificate> getCertificateList() {
                return certificateList;
            }

            /** 
             * Set the list of 'Certificate' element items.
             * 
             * @param list
             */
            public void setCertificateList(List<Certificate> list) {
                certificateList = list;
            }

            /** 
             * Get the 'Commission' element value.
             * 
             * @return value
             */
            public Commission getCommission() {
                return commission;
            }

            /** 
             * Set the 'Commission' element value.
             * 
             * @param commission
             */
            public void setCommission(Commission commission) {
                this.commission = commission;
            }

            /** 
             * Get the 'Discount' element value.
             * 
             * @return value
             */
            public Discount getDiscount() {
                return discount;
            }

            /** 
             * Set the 'Discount' element value.
             * 
             * @param discount
             */
            public void setDiscount(Discount discount) {
                this.discount = discount;
            }

            /** 
             * Check if the 'DateOfBirth' element is present.
             * 
             * @return <code>true</code> if present, <code>false</code> if not
             */
            public boolean ifDateOfBirthPresent() {
                return dateOfBirth;
            }

            /** 
             * Set flag for 'DateOfBirth' element present.
             * 
             * @param dateOfBirth
             */
            public void flagDateOfBirthPresent(boolean dateOfBirth) {
                this.dateOfBirth = dateOfBirth;
            }

            /** 
             * Get the 'Endorsement' element value.
             * 
             * @return value
             */
            public Endorsement getEndorsement() {
                return endorsement;
            }

            /** 
             * Set the 'Endorsement' element value.
             * 
             * @param endorsement
             */
            public void setEndorsement(Endorsement endorsement) {
                this.endorsement = endorsement;
            }

            /** 
             * Get the 'EndTransaction' element value.
             * 
             * @return value
             */
            public EndTransaction getEndTransaction() {
                return endTransaction;
            }

            /** 
             * Set the 'EndTransaction' element value.
             * 
             * @param endTransaction
             */
            public void setEndTransaction(EndTransaction endTransaction) {
                this.endTransaction = endTransaction;
            }

            /** 
             * Get the 'FutureTicket' element value.
             * 
             * @return value
             */
            public FutureTicket getFutureTicket() {
                return futureTicket;
            }

            /** 
             * Set the 'FutureTicket' element value.
             * 
             * @param futureTicket
             */
            public void setFutureTicket(FutureTicket futureTicket) {
                this.futureTicket = futureTicket;
            }

            /** 
             * Get the 'Invoice' element value.
             * 
             * @return value
             */
            public Invoice getInvoice() {
                return invoice;
            }

            /** 
             * Set the 'Invoice' element value.
             * 
             * @param invoice
             */
            public void setInvoice(Invoice invoice) {
                this.invoice = invoice;
            }

            /** 
             * Get the 'MISF' element value.
             * 
             * @return value
             */
            public MISF getMISF1() {
                return MISF1;
            }

            /** 
             * Set the 'MISF' element value.
             * 
             * @param MISF1
             */
            public void setMISF1(MISF MISF1) {
                this.MISF1 = MISF1;
            }

            /** 
             * Get the 'NeedPrint' element value.
             * 
             * @return value
             */
            public NeedPrint getNeedPrint() {
                return needPrint;
            }

            /** 
             * Set the 'NeedPrint' element value.
             * 
             * @param needPrint
             */
            public void setNeedPrint(NeedPrint needPrint) {
                this.needPrint = needPrint;
            }

            /** 
             * Get the 'NetRemit' element value.
             * 
             * @return value
             */
            public NetRemit getNetRemit() {
                return netRemit;
            }

            /** 
             * Set the 'NetRemit' element value.
             * 
             * @param netRemit
             */
            public void setNetRemit(NetRemit netRemit) {
                this.netRemit = netRemit;
            }

            /** 
             * Get the 'Ticket' element value.
             * 
             * @return value
             */
            public Ticket getTicket() {
                return ticket;
            }

            /** 
             * Set the 'Ticket' element value.
             * 
             * @param ticket
             */
            public void setTicket(Ticket ticket) {
                this.ticket = ticket;
            }

            /** 
             * Get the 'TourCode' element value.
             * 
             * @return value
             */
            public TourCode getTourCode() {
                return tourCode;
            }

            /** 
             * Set the 'TourCode' element value.
             * 
             * @param tourCode
             */
            public void setTourCode(TourCode tourCode) {
                this.tourCode = tourCode;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirExtras" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
             *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AirExtras implements Serializable
            {
                private BigInteger endNumber;
                private BigInteger number;

                /** 
                 * Get the 'EndNumber' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getEndNumber() {
                    return endNumber;
                }

                /** 
                 * Set the 'EndNumber' attribute value.
                 * 
                 * @param endNumber
                 */
                public void setEndNumber(BigInteger endNumber) {
                    this.endNumber = endNumber;
                }

                /** 
                 * Get the 'Number' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' attribute value.
                 * 
                 * @param number
                 */
                public void setNumber(BigInteger number) {
                    this.number = number;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageAllowance" minOccurs="0" maxOccurs="99">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="SegmentSelect">
             *         &lt;xs:complexType>
             *           &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
             *           &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Weight"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaggageAllowance implements Serializable
            {
                private BigInteger segmentSelectEndNumber;
                private BigInteger segmentSelectNumber;
                private String number;
                private String weight;

                /** 
                 * Get the 'EndNumber' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getSegmentSelectEndNumber() {
                    return segmentSelectEndNumber;
                }

                /** 
                 * Set the 'EndNumber' attribute value.
                 * 
                 * @param segmentSelectEndNumber
                 */
                public void setSegmentSelectEndNumber(
                        BigInteger segmentSelectEndNumber) {
                    this.segmentSelectEndNumber = segmentSelectEndNumber;
                }

                /** 
                 * Get the 'Number' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getSegmentSelectNumber() {
                    return segmentSelectNumber;
                }

                /** 
                 * Set the 'Number' attribute value.
                 * 
                 * @param segmentSelectNumber
                 */
                public void setSegmentSelectNumber(
                        BigInteger segmentSelectNumber) {
                    this.segmentSelectNumber = segmentSelectNumber;
                }

                /** 
                 * Get the 'Number' attribute value.
                 * 
                 * @return value
                 */
                public String getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' attribute value.
                 * 
                 * @param number
                 */
                public void setNumber(String number) {
                    this.number = number;
                }

                /** 
                 * Get the 'Weight' attribute value.
                 * 
                 * @return value
                 */
                public String getWeight() {
                    return weight;
                }

                /** 
                 * Set the 'Weight' attribute value.
                 * 
                 * @param weight
                 */
                public void setWeight(String weight) {
                    this.weight = weight;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Certificate" minOccurs="0" maxOccurs="2">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Certificate implements Serializable
            {
                private String number;

                /** 
                 * Get the 'Number' attribute value.
                 * 
                 * @return value
                 */
                public String getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' attribute value.
                 * 
                 * @param number
                 */
                public void setNumber(String number) {
                    this.number = number;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:decimal" use="optional" name="Amount"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Net"/>
             *     &lt;xs:attribute type="xs:decimal" use="optional" name="Percent"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Commission implements Serializable
            {
                private BigDecimal amount;
                private Boolean net;
                private BigDecimal percent;

                /** 
                 * Get the 'Amount' attribute value.
                 * 
                 * @return value
                 */
                public BigDecimal getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value.
                 * 
                 * @param amount
                 */
                public void setAmount(BigDecimal amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'Net' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getNet() {
                    return net;
                }

                /** 
                 * Set the 'Net' attribute value.
                 * 
                 * @param net
                 */
                public void setNet(Boolean net) {
                    this.net = net;
                }

                /** 
                 * Get the 'Percent' attribute value.
                 * 
                 * @return value
                 */
                public BigDecimal getPercent() {
                    return percent;
                }

                /** 
                 * Set the 'Percent' attribute value.
                 * 
                 * @param percent
                 */
                public void setPercent(BigDecimal percent) {
                    this.percent = percent;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Discount" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:integer" use="optional" name="Code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Discount implements Serializable
            {
                private BigInteger code;

                /** 
                 * Get the 'Code' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value.
                 * 
                 * @param code
                 */
                public void setCode(BigInteger code) {
                    this.code = code;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Endorsement" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Text"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Override"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Endorsement implements Serializable
            {
                private String text;
                private Boolean override;

                /** 
                 * Get the 'Text' element value.
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value.
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }

                /** 
                 * Get the 'Override' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getOverride() {
                    return override;
                }

                /** 
                 * Set the 'Override' attribute value.
                 * 
                 * @param override
                 */
                public void setOverride(Boolean override) {
                    this.override = override;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EndTransaction" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class EndTransaction implements Serializable
            {
                private boolean ind;

                /** 
                 * Get the 'Ind' attribute value.
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value.
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FutureTicket" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Line" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Line -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FutureTicket implements Serializable
            {
                private List<Line> lineList = new ArrayList<Line>();

                /** 
                 * Get the list of 'Line' element items.
                 * 
                 * @return list
                 */
                public List<Line> getLineList() {
                    return lineList;
                }

                /** 
                 * Set the list of 'Line' element items.
                 * 
                 * @param list
                 */
                public void setLineList(List<Line> list) {
                    lineList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Line" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="NameNumber"/>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Line implements Serializable
                {
                    private BigInteger endNumber;
                    private String nameNumber;
                    private BigInteger number;

                    /** 
                     * Get the 'EndNumber' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getEndNumber() {
                        return endNumber;
                    }

                    /** 
                     * Set the 'EndNumber' attribute value.
                     * 
                     * @param endNumber
                     */
                    public void setEndNumber(BigInteger endNumber) {
                        this.endNumber = endNumber;
                    }

                    /** 
                     * Get the 'NameNumber' attribute value.
                     * 
                     * @return value
                     */
                    public String getNameNumber() {
                        return nameNumber;
                    }

                    /** 
                     * Set the 'NameNumber' attribute value.
                     * 
                     * @param nameNumber
                     */
                    public void setNameNumber(String nameNumber) {
                        this.nameNumber = nameNumber;
                    }

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(BigInteger number) {
                        this.number = number;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Invoice" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="ETReceipt"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Invoice implements Serializable
            {
                private Boolean ind;
                private Boolean ETReceipt;

                /** 
                 * Get the 'Ind' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value.
                 * 
                 * @param ind
                 */
                public void setInd(Boolean ind) {
                    this.ind = ind;
                }

                /** 
                 * Get the 'ETReceipt' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getETReceipt() {
                    return ETReceipt;
                }

                /** 
                 * Set the 'ETReceipt' attribute value.
                 * 
                 * @param ETReceipt
                 */
                public void setETReceipt(Boolean ETReceipt) {
                    this.ETReceipt = ETReceipt;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MISF" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Override" minOccurs="0">
             *         &lt;!-- Reference to inner class Override -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MISF implements Serializable
            {
                private Override override;
                private Boolean ind;

                /** 
                 * Get the 'Override' element value.
                 * 
                 * @return value
                 */
                public Override getOverride() {
                    return override;
                }

                /** 
                 * Set the 'Override' element value.
                 * 
                 * @param override
                 */
                public void setOverride(Override override) {
                    this.override = override;
                }

                /** 
                 * Get the 'Ind' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value.
                 * 
                 * @param ind
                 */
                public void setInd(Boolean ind) {
                    this.ind = ind;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Override" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ServiceFeeDescription"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CustomerReference"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Override implements Serializable
                {
                    private String amount;
                    private String currencyCode;
                    private String serviceFeeDescription;
                    private String customerReference;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'ServiceFeeDescription' attribute value.
                     * 
                     * @return value
                     */
                    public String getServiceFeeDescription() {
                        return serviceFeeDescription;
                    }

                    /** 
                     * Set the 'ServiceFeeDescription' attribute value.
                     * 
                     * @param serviceFeeDescription
                     */
                    public void setServiceFeeDescription(
                            String serviceFeeDescription) {
                        this.serviceFeeDescription = serviceFeeDescription;
                    }

                    /** 
                     * Get the 'CustomerReference' attribute value.
                     * 
                     * @return value
                     */
                    public String getCustomerReference() {
                        return customerReference;
                    }

                    /** 
                     * Set the 'CustomerReference' attribute value.
                     * 
                     * @param customerReference
                     */
                    public void setCustomerReference(String customerReference) {
                        this.customerReference = customerReference;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NeedPrint" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="AuditorCoupon"/>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Itinerary"/>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="PassengerReceipt"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class NeedPrint implements Serializable
            {
                private boolean auditorCoupon;
                private boolean itinerary;
                private boolean passengerReceipt;

                /** 
                 * Get the 'AuditorCoupon' attribute value.
                 * 
                 * @return value
                 */
                public boolean isAuditorCoupon() {
                    return auditorCoupon;
                }

                /** 
                 * Set the 'AuditorCoupon' attribute value.
                 * 
                 * @param auditorCoupon
                 */
                public void setAuditorCoupon(boolean auditorCoupon) {
                    this.auditorCoupon = auditorCoupon;
                }

                /** 
                 * Get the 'Itinerary' attribute value.
                 * 
                 * @return value
                 */
                public boolean isItinerary() {
                    return itinerary;
                }

                /** 
                 * Set the 'Itinerary' attribute value.
                 * 
                 * @param itinerary
                 */
                public void setItinerary(boolean itinerary) {
                    this.itinerary = itinerary;
                }

                /** 
                 * Get the 'PassengerReceipt' attribute value.
                 * 
                 * @return value
                 */
                public boolean isPassengerReceipt() {
                    return passengerReceipt;
                }

                /** 
                 * Set the 'PassengerReceipt' attribute value.
                 * 
                 * @param passengerReceipt
                 */
                public void setPassengerReceipt(boolean passengerReceipt) {
                    this.passengerReceipt = passengerReceipt;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetRemit" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="DiscountAmount"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="SellingFareAmount"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="ContractAgreementCode"/>
             *     &lt;xs:attribute type="xs:decimal" use="optional" name="NetCreditAmount"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="TourCode"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="ValueCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class NetRemit implements Serializable
            {
                private String amount;
                private String discountAmount;
                private String sellingFareAmount;
                private String contractAgreementCode;
                private BigDecimal netCreditAmount;
                private String tourCode;
                private String valueCode;

                /** 
                 * Get the 'Amount' attribute value.
                 * 
                 * @return value
                 */
                public String getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value.
                 * 
                 * @param amount
                 */
                public void setAmount(String amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'DiscountAmount' attribute value.
                 * 
                 * @return value
                 */
                public String getDiscountAmount() {
                    return discountAmount;
                }

                /** 
                 * Set the 'DiscountAmount' attribute value.
                 * 
                 * @param discountAmount
                 */
                public void setDiscountAmount(String discountAmount) {
                    this.discountAmount = discountAmount;
                }

                /** 
                 * Get the 'SellingFareAmount' attribute value.
                 * 
                 * @return value
                 */
                public String getSellingFareAmount() {
                    return sellingFareAmount;
                }

                /** 
                 * Set the 'SellingFareAmount' attribute value.
                 * 
                 * @param sellingFareAmount
                 */
                public void setSellingFareAmount(String sellingFareAmount) {
                    this.sellingFareAmount = sellingFareAmount;
                }

                /** 
                 * Get the 'ContractAgreementCode' attribute value.
                 * 
                 * @return value
                 */
                public String getContractAgreementCode() {
                    return contractAgreementCode;
                }

                /** 
                 * Set the 'ContractAgreementCode' attribute value.
                 * 
                 * @param contractAgreementCode
                 */
                public void setContractAgreementCode(
                        String contractAgreementCode) {
                    this.contractAgreementCode = contractAgreementCode;
                }

                /** 
                 * Get the 'NetCreditAmount' attribute value.
                 * 
                 * @return value
                 */
                public BigDecimal getNetCreditAmount() {
                    return netCreditAmount;
                }

                /** 
                 * Set the 'NetCreditAmount' attribute value.
                 * 
                 * @param netCreditAmount
                 */
                public void setNetCreditAmount(BigDecimal netCreditAmount) {
                    this.netCreditAmount = netCreditAmount;
                }

                /** 
                 * Get the 'TourCode' attribute value.
                 * 
                 * @return value
                 */
                public String getTourCode() {
                    return tourCode;
                }

                /** 
                 * Set the 'TourCode' attribute value.
                 * 
                 * @param tourCode
                 */
                public void setTourCode(String tourCode) {
                    this.tourCode = tourCode;
                }

                /** 
                 * Get the 'ValueCode' attribute value.
                 * 
                 * @return value
                 */
                public String getValueCode() {
                    return valueCode;
                }

                /** 
                 * Set the 'ValueCode' attribute value.
                 * 
                 * @param valueCode
                 */
                public void setValueCode(String valueCode) {
                    this.valueCode = valueCode;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ticket" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Action"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Ticket implements Serializable
            {
                private String action;
                private String type;

                /** 
                 * Get the 'Action' attribute value.
                 * 
                 * @return value
                 */
                public String getAction() {
                    return action;
                }

                /** 
                 * Set the 'Action' attribute value.
                 * 
                 * @param action
                 */
                public void setAction(String action) {
                    this.action = action;
                }

                /** 
                 * Get the 'Type' attribute value.
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value.
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TourCode" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="SuppressFareReplaceWithBT" minOccurs="0">
             *         &lt;!-- Reference to inner class SuppressFareReplaceWithBT -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SuppressFareReplaceWithIT" minOccurs="0">
             *         &lt;!-- Reference to inner class SuppressFareReplaceWithIT -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SuppressIT" minOccurs="0">
             *         &lt;!-- Reference to inner class SuppressIT -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SuppressITSupressFare" minOccurs="0">
             *         &lt;!-- Reference to inner class SuppressITSupressFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TourCode implements Serializable
            {
                private SuppressFareReplaceWithBT suppressFareReplaceWithBT;
                private SuppressFareReplaceWithIT suppressFareReplaceWithIT;
                private SuppressIT suppressIT;
                private SuppressITSupressFare suppressITSupressFare;
                private String text;

                /** 
                 * Get the 'SuppressFareReplaceWithBT' element value.
                 * 
                 * @return value
                 */
                public SuppressFareReplaceWithBT getSuppressFareReplaceWithBT() {
                    return suppressFareReplaceWithBT;
                }

                /** 
                 * Set the 'SuppressFareReplaceWithBT' element value.
                 * 
                 * @param suppressFareReplaceWithBT
                 */
                public void setSuppressFareReplaceWithBT(
                        SuppressFareReplaceWithBT suppressFareReplaceWithBT) {
                    this.suppressFareReplaceWithBT = suppressFareReplaceWithBT;
                }

                /** 
                 * Get the 'SuppressFareReplaceWithIT' element value.
                 * 
                 * @return value
                 */
                public SuppressFareReplaceWithIT getSuppressFareReplaceWithIT() {
                    return suppressFareReplaceWithIT;
                }

                /** 
                 * Set the 'SuppressFareReplaceWithIT' element value.
                 * 
                 * @param suppressFareReplaceWithIT
                 */
                public void setSuppressFareReplaceWithIT(
                        SuppressFareReplaceWithIT suppressFareReplaceWithIT) {
                    this.suppressFareReplaceWithIT = suppressFareReplaceWithIT;
                }

                /** 
                 * Get the 'SuppressIT' element value.
                 * 
                 * @return value
                 */
                public SuppressIT getSuppressIT() {
                    return suppressIT;
                }

                /** 
                 * Set the 'SuppressIT' element value.
                 * 
                 * @param suppressIT
                 */
                public void setSuppressIT(SuppressIT suppressIT) {
                    this.suppressIT = suppressIT;
                }

                /** 
                 * Get the 'SuppressITSupressFare' element value.
                 * 
                 * @return value
                 */
                public SuppressITSupressFare getSuppressITSupressFare() {
                    return suppressITSupressFare;
                }

                /** 
                 * Set the 'SuppressITSupressFare' element value.
                 * 
                 * @param suppressITSupressFare
                 */
                public void setSuppressITSupressFare(
                        SuppressITSupressFare suppressITSupressFare) {
                    this.suppressITSupressFare = suppressITSupressFare;
                }

                /** 
                 * Get the 'Text' element value.
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value.
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SuppressFareReplaceWithBT" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SuppressFareReplaceWithBT implements
                    Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SuppressFareReplaceWithIT" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SuppressFareReplaceWithIT implements
                    Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SuppressIT" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SuppressIT implements Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SuppressITSupressFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SuppressITSupressFare implements
                    Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingQualifiers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Brand" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Brand -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="FareFocusExclude" minOccurs="0">
         *         &lt;!-- Reference to inner class FareFocusExclude -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Fare" minOccurs="0">
         *         &lt;!-- Reference to inner class Fare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ItineraryOptions" minOccurs="0">
         *         &lt;!-- Reference to inner class ItineraryOptions -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="NameSelect" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class NameSelect -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PhaseIV" minOccurs="0" maxOccurs="7">
         *         &lt;!-- Reference to inner class PhaseIV -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PriceQuote" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class PriceQuote -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="RefundableBalance" minOccurs="0">
         *         &lt;!-- Reference to inner class RefundableBalance -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="SpanishLargeFamilyDiscountLevel" minOccurs="0">
         *         &lt;xs:simpleType>
         *           &lt;!-- Reference to inner class SpanishLargeFamilyDiscountLevel -->
         *         &lt;/xs:simpleType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="SpecificFare" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class SpecificFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="SpecificPenalty" minOccurs="0">
         *         &lt;!-- Reference to inner class SpecificPenalty -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Taxes" minOccurs="0">
         *         &lt;!-- Reference to inner class Taxes -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ValidityDates" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class ValidityDates -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PricingQualifiers implements Serializable
        {
            private List<Brand> brandList = new ArrayList<Brand>();
            private FareFocusExclude fareFocusExclude;
            private Fare fare;
            private ItineraryOptions itineraryOptions;
            private List<NameSelect> nameSelectList = new ArrayList<NameSelect>();
            private List<PhaseIV> phaseIVList = new ArrayList<PhaseIV>();
            private List<PriceQuote> priceQuoteList = new ArrayList<PriceQuote>();
            private RefundableBalance refundableBalance;
            private SpanishLargeFamilyDiscountLevel spanishLargeFamilyDiscountLevel;
            private List<SpecificFare> specificFareList = new ArrayList<SpecificFare>();
            private SpecificPenalty specificPenalty;
            private Taxes taxes;
            private List<ValidityDates> validityDateList = new ArrayList<ValidityDates>();

            /** 
             * Get the list of 'Brand' element items.
             * 
             * @return list
             */
            public List<Brand> getBrandList() {
                return brandList;
            }

            /** 
             * Set the list of 'Brand' element items.
             * 
             * @param list
             */
            public void setBrandList(List<Brand> list) {
                brandList = list;
            }

            /** 
             * Get the 'FareFocusExclude' element value.
             * 
             * @return value
             */
            public FareFocusExclude getFareFocusExclude() {
                return fareFocusExclude;
            }

            /** 
             * Set the 'FareFocusExclude' element value.
             * 
             * @param fareFocusExclude
             */
            public void setFareFocusExclude(FareFocusExclude fareFocusExclude) {
                this.fareFocusExclude = fareFocusExclude;
            }

            /** 
             * Get the 'Fare' element value.
             * 
             * @return value
             */
            public Fare getFare() {
                return fare;
            }

            /** 
             * Set the 'Fare' element value.
             * 
             * @param fare
             */
            public void setFare(Fare fare) {
                this.fare = fare;
            }

            /** 
             * Get the 'ItineraryOptions' element value.
             * 
             * @return value
             */
            public ItineraryOptions getItineraryOptions() {
                return itineraryOptions;
            }

            /** 
             * Set the 'ItineraryOptions' element value.
             * 
             * @param itineraryOptions
             */
            public void setItineraryOptions(ItineraryOptions itineraryOptions) {
                this.itineraryOptions = itineraryOptions;
            }

            /** 
             * Get the list of 'NameSelect' element items.
             * 
             * @return list
             */
            public List<NameSelect> getNameSelectList() {
                return nameSelectList;
            }

            /** 
             * Set the list of 'NameSelect' element items.
             * 
             * @param list
             */
            public void setNameSelectList(List<NameSelect> list) {
                nameSelectList = list;
            }

            /** 
             * Get the list of 'PhaseIV' element items.
             * 
             * @return list
             */
            public List<PhaseIV> getPhaseIVList() {
                return phaseIVList;
            }

            /** 
             * Set the list of 'PhaseIV' element items.
             * 
             * @param list
             */
            public void setPhaseIVList(List<PhaseIV> list) {
                phaseIVList = list;
            }

            /** 
             * Get the list of 'PriceQuote' element items.
             * 
             * @return list
             */
            public List<PriceQuote> getPriceQuoteList() {
                return priceQuoteList;
            }

            /** 
             * Set the list of 'PriceQuote' element items.
             * 
             * @param list
             */
            public void setPriceQuoteList(List<PriceQuote> list) {
                priceQuoteList = list;
            }

            /** 
             * Get the 'RefundableBalance' element value.
             * 
             * @return value
             */
            public RefundableBalance getRefundableBalance() {
                return refundableBalance;
            }

            /** 
             * Set the 'RefundableBalance' element value.
             * 
             * @param refundableBalance
             */
            public void setRefundableBalance(RefundableBalance refundableBalance) {
                this.refundableBalance = refundableBalance;
            }

            /** 
             * Get the 'SpanishLargeFamilyDiscountLevel' element value.
             * 
             * @return value
             */
            public SpanishLargeFamilyDiscountLevel getSpanishLargeFamilyDiscountLevel() {
                return spanishLargeFamilyDiscountLevel;
            }

            /** 
             * Set the 'SpanishLargeFamilyDiscountLevel' element value.
             * 
             * @param spanishLargeFamilyDiscountLevel
             */
            public void setSpanishLargeFamilyDiscountLevel(
                    SpanishLargeFamilyDiscountLevel spanishLargeFamilyDiscountLevel) {
                this.spanishLargeFamilyDiscountLevel = spanishLargeFamilyDiscountLevel;
            }

            /** 
             * Get the list of 'SpecificFare' element items.
             * 
             * @return list
             */
            public List<SpecificFare> getSpecificFareList() {
                return specificFareList;
            }

            /** 
             * Set the list of 'SpecificFare' element items.
             * 
             * @param list
             */
            public void setSpecificFareList(List<SpecificFare> list) {
                specificFareList = list;
            }

            /** 
             * Get the 'SpecificPenalty' element value.
             * 
             * @return value
             */
            public SpecificPenalty getSpecificPenalty() {
                return specificPenalty;
            }

            /** 
             * Set the 'SpecificPenalty' element value.
             * 
             * @param specificPenalty
             */
            public void setSpecificPenalty(SpecificPenalty specificPenalty) {
                this.specificPenalty = specificPenalty;
            }

            /** 
             * Get the 'Taxes' element value.
             * 
             * @return value
             */
            public Taxes getTaxes() {
                return taxes;
            }

            /** 
             * Set the 'Taxes' element value.
             * 
             * @param taxes
             */
            public void setTaxes(Taxes taxes) {
                this.taxes = taxes;
            }

            /** 
             * Get the list of 'ValidityDates' element items.
             * 
             * @return list
             */
            public List<ValidityDates> getValidityDateList() {
                return validityDateList;
            }

            /** 
             * Set the list of 'ValidityDates' element items.
             * 
             * @param list
             */
            public void setValidityDateList(List<ValidityDates> list) {
                validityDateList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Brand" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Brand implements Serializable
            {
                private String string;
                private BigInteger RPH;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'RPH' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value.
                 * 
                 * @param RPH
                 */
                public void setRPH(BigInteger RPH) {
                    this.RPH = RPH;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareFocusExclude" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FareFocusExclude implements Serializable
            {
                private boolean ind;

                /** 
                 * Get the 'Ind' attribute value.
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value.
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Fare implements Serializable
            {
                private String type;

                /** 
                 * Get the 'Type' attribute value.
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value.
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryOptions" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="SegmentSelect" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class SegmentSelect -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SideTrip" minOccurs="0">
             *         &lt;!-- Reference to inner class SideTrip -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ItineraryOptions implements Serializable
            {
                private List<SegmentSelect> segmentSelectList = new ArrayList<SegmentSelect>();
                private SideTrip sideTrip;

                /** 
                 * Get the list of 'SegmentSelect' element items.
                 * 
                 * @return list
                 */
                public List<SegmentSelect> getSegmentSelectList() {
                    return segmentSelectList;
                }

                /** 
                 * Set the list of 'SegmentSelect' element items.
                 * 
                 * @param list
                 */
                public void setSegmentSelectList(List<SegmentSelect> list) {
                    segmentSelectList = list;
                }

                /** 
                 * Get the 'SideTrip' element value.
                 * 
                 * @return value
                 */
                public SideTrip getSideTrip() {
                    return sideTrip;
                }

                /** 
                 * Set the 'SideTrip' element value.
                 * 
                 * @param sideTrip
                 */
                public void setSideTrip(SideTrip sideTrip) {
                    this.sideTrip = sideTrip;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentSelect" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SegmentSelect implements Serializable
                {
                    private BigInteger endNumber;
                    private BigInteger number;
                    private String RPH;

                    /** 
                     * Get the 'EndNumber' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getEndNumber() {
                        return endNumber;
                    }

                    /** 
                     * Set the 'EndNumber' attribute value.
                     * 
                     * @param endNumber
                     */
                    public void setEndNumber(BigInteger endNumber) {
                        this.endNumber = endNumber;
                    }

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(BigInteger number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'RPH' attribute value.
                     * 
                     * @return value
                     */
                    public String getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value.
                     * 
                     * @param RPH
                     */
                    public void setRPH(String RPH) {
                        this.RPH = RPH;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SideTrip" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SideTrip implements Serializable
                {
                    private BigInteger endNumber;
                    private BigInteger number;

                    /** 
                     * Get the 'EndNumber' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getEndNumber() {
                        return endNumber;
                    }

                    /** 
                     * Set the 'EndNumber' attribute value.
                     * 
                     * @param endNumber
                     */
                    public void setEndNumber(BigInteger endNumber) {
                        this.endNumber = endNumber;
                    }

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(BigInteger number) {
                        this.number = number;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NameSelect" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="EndNameNumber"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="NameNumber"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class NameSelect implements Serializable
            {
                private String endNameNumber;
                private String nameNumber;

                /** 
                 * Get the 'EndNameNumber' attribute value.
                 * 
                 * @return value
                 */
                public String getEndNameNumber() {
                    return endNameNumber;
                }

                /** 
                 * Set the 'EndNameNumber' attribute value.
                 * 
                 * @param endNameNumber
                 */
                public void setEndNameNumber(String endNameNumber) {
                    this.endNameNumber = endNameNumber;
                }

                /** 
                 * Get the 'NameNumber' attribute value.
                 * 
                 * @return value
                 */
                public String getNameNumber() {
                    return nameNumber;
                }

                /** 
                 * Set the 'NameNumber' attribute value.
                 * 
                 * @param nameNumber
                 */
                public void setNameNumber(String nameNumber) {
                    this.nameNumber = nameNumber;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PhaseIV" minOccurs="0" maxOccurs="7">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="NameSelect" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class NameSelect -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PhaseIV implements Serializable
            {
                private List<NameSelect> nameSelectList = new ArrayList<NameSelect>();
                private BigInteger number;

                /** 
                 * Get the list of 'NameSelect' element items.
                 * 
                 * @return list
                 */
                public List<NameSelect> getNameSelectList() {
                    return nameSelectList;
                }

                /** 
                 * Set the list of 'NameSelect' element items.
                 * 
                 * @param list
                 */
                public void setNameSelectList(List<NameSelect> list) {
                    nameSelectList = list;
                }

                /** 
                 * Get the 'Number' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' attribute value.
                 * 
                 * @param number
                 */
                public void setNumber(BigInteger number) {
                    this.number = number;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NameSelect" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="EndNameNumber"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="NameNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class NameSelect implements Serializable
                {
                    private String endNameNumber;
                    private String nameNumber;

                    /** 
                     * Get the 'EndNameNumber' attribute value.
                     * 
                     * @return value
                     */
                    public String getEndNameNumber() {
                        return endNameNumber;
                    }

                    /** 
                     * Set the 'EndNameNumber' attribute value.
                     * 
                     * @param endNameNumber
                     */
                    public void setEndNameNumber(String endNameNumber) {
                        this.endNameNumber = endNameNumber;
                    }

                    /** 
                     * Get the 'NameNumber' attribute value.
                     * 
                     * @return value
                     */
                    public String getNameNumber() {
                        return nameNumber;
                    }

                    /** 
                     * Set the 'NameNumber' attribute value.
                     * 
                     * @param nameNumber
                     */
                    public void setNameNumber(String nameNumber) {
                        this.nameNumber = nameNumber;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="NameSelect" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class NameSelect -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Record" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Record -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PriceQuote implements Serializable
            {
                private List<NameSelect> nameSelectList = new ArrayList<NameSelect>();
                private List<Record> recordList = new ArrayList<Record>();

                /** 
                 * Get the list of 'NameSelect' element items.
                 * 
                 * @return list
                 */
                public List<NameSelect> getNameSelectList() {
                    return nameSelectList;
                }

                /** 
                 * Set the list of 'NameSelect' element items.
                 * 
                 * @param list
                 */
                public void setNameSelectList(List<NameSelect> list) {
                    nameSelectList = list;
                }

                /** 
                 * Get the list of 'Record' element items.
                 * 
                 * @return list
                 */
                public List<Record> getRecordList() {
                    return recordList;
                }

                /** 
                 * Set the list of 'Record' element items.
                 * 
                 * @param list
                 */
                public void setRecordList(List<Record> list) {
                    recordList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NameSelect" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:decimal" use="optional" name="EndNameNumber"/>
                 *     &lt;xs:attribute type="xs:decimal" use="required" name="NameNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class NameSelect implements Serializable
                {
                    private BigDecimal endNameNumber;
                    private BigDecimal nameNumber;

                    /** 
                     * Get the 'EndNameNumber' attribute value.
                     * 
                     * @return value
                     */
                    public BigDecimal getEndNameNumber() {
                        return endNameNumber;
                    }

                    /** 
                     * Set the 'EndNameNumber' attribute value.
                     * 
                     * @param endNameNumber
                     */
                    public void setEndNameNumber(BigDecimal endNameNumber) {
                        this.endNameNumber = endNameNumber;
                    }

                    /** 
                     * Get the 'NameNumber' attribute value.
                     * 
                     * @return value
                     */
                    public BigDecimal getNameNumber() {
                        return nameNumber;
                    }

                    /** 
                     * Set the 'NameNumber' attribute value.
                     * 
                     * @param nameNumber
                     */
                    public void setNameNumber(BigDecimal nameNumber) {
                        this.nameNumber = nameNumber;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Record" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Reissue"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Record implements Serializable
                {
                    private BigInteger endNumber;
                    private BigInteger number;
                    private Boolean reissue;

                    /** 
                     * Get the 'EndNumber' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getEndNumber() {
                        return endNumber;
                    }

                    /** 
                     * Set the 'EndNumber' attribute value.
                     * 
                     * @param endNumber
                     */
                    public void setEndNumber(BigInteger endNumber) {
                        this.endNumber = endNumber;
                    }

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(BigInteger number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'Reissue' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getReissue() {
                        return reissue;
                    }

                    /** 
                     * Set the 'Reissue' attribute value.
                     * 
                     * @param reissue
                     */
                    public void setReissue(Boolean reissue) {
                        this.reissue = reissue;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RefundableBalance" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Taxes" minOccurs="0">
             *         &lt;!-- Reference to inner class Taxes -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RefundableBalance implements Serializable
            {
                private Taxes taxes;
                private String amount;

                /** 
                 * Get the 'Taxes' element value.
                 * 
                 * @return value
                 */
                public Taxes getTaxes() {
                    return taxes;
                }

                /** 
                 * Set the 'Taxes' element value.
                 * 
                 * @param taxes
                 */
                public void setTaxes(Taxes taxes) {
                    this.taxes = taxes;
                }

                /** 
                 * Get the 'Amount' attribute value.
                 * 
                 * @return value
                 */
                public String getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' attribute value.
                 * 
                 * @param amount
                 */
                public void setAmount(String amount) {
                    this.amount = amount;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Tax" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Tax -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Taxes implements Serializable
                {
                    private List<Tax> taxList = new ArrayList<Tax>();

                    /** 
                     * Get the list of 'Tax' element items.
                     * 
                     * @return list
                     */
                    public List<Tax> getTaxList() {
                        return taxList;
                    }

                    /** 
                     * Set the list of 'Tax' element items.
                     * 
                     * @param list
                     */
                    public void setTaxList(List<Tax> list) {
                        taxList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Tax implements Serializable
                    {
                        private String amount;
                        private String code;

                        /** 
                         * Get the 'Amount' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="1"/>
             *     &lt;xs:enumeration value="2"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum SpanishLargeFamilyDiscountLevel
                    implements
                        Serializable {
                _1("1"), _2("2");
                private final String value;

                private SpanishLargeFamilyDiscountLevel(String value) {
                    this.value = value;
                }

                public String xmlValue() {
                    return value;
                }

                public static SpanishLargeFamilyDiscountLevel convert(
                        String value) {
                    for (SpanishLargeFamilyDiscountLevel inst : values()) {
                        if (inst.xmlValue().equals(value)) {
                            return inst;
                        }
                    }
                    return null;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecificFare" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="FareBasis" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SpecificFare implements Serializable
            {
                private String fareBasis;
                private String RPH;

                /** 
                 * Get the 'FareBasis' element value.
                 * 
                 * @return value
                 */
                public String getFareBasis() {
                    return fareBasis;
                }

                /** 
                 * Set the 'FareBasis' element value.
                 * 
                 * @param fareBasis
                 */
                public void setFareBasis(String fareBasis) {
                    this.fareBasis = fareBasis;
                }

                /** 
                 * Get the 'RPH' attribute value.
                 * 
                 * @return value
                 */
                public String getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value.
                 * 
                 * @param RPH
                 */
                public void setRPH(String RPH) {
                    this.RPH = RPH;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecificPenalty" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Changeable" minOccurs="0">
             *         &lt;!-- Reference to inner class Changeable -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="EitherOr" minOccurs="0">
             *         &lt;!-- Reference to inner class EitherOr -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Refundable" minOccurs="0">
             *         &lt;!-- Reference to inner class Refundable -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="AdditionalInfo"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SpecificPenalty implements Serializable
            {
                private Changeable changeable;
                private EitherOr eitherOr;
                private Refundable refundable;
                private Boolean additionalInfo;

                /** 
                 * Get the 'Changeable' element value.
                 * 
                 * @return value
                 */
                public Changeable getChangeable() {
                    return changeable;
                }

                /** 
                 * Set the 'Changeable' element value.
                 * 
                 * @param changeable
                 */
                public void setChangeable(Changeable changeable) {
                    this.changeable = changeable;
                }

                /** 
                 * Get the 'EitherOr' element value.
                 * 
                 * @return value
                 */
                public EitherOr getEitherOr() {
                    return eitherOr;
                }

                /** 
                 * Set the 'EitherOr' element value.
                 * 
                 * @param eitherOr
                 */
                public void setEitherOr(EitherOr eitherOr) {
                    this.eitherOr = eitherOr;
                }

                /** 
                 * Get the 'Refundable' element value.
                 * 
                 * @return value
                 */
                public Refundable getRefundable() {
                    return refundable;
                }

                /** 
                 * Set the 'Refundable' element value.
                 * 
                 * @param refundable
                 */
                public void setRefundable(Refundable refundable) {
                    this.refundable = refundable;
                }

                /** 
                 * Get the 'AdditionalInfo' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getAdditionalInfo() {
                    return additionalInfo;
                }

                /** 
                 * Set the 'AdditionalInfo' attribute value.
                 * 
                 * @param additionalInfo
                 */
                public void setAdditionalInfo(Boolean additionalInfo) {
                    this.additionalInfo = additionalInfo;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Changeable" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Any"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="MaxPenalty"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="BeforeDeparture"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="AfterDeparture"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Changeable implements Serializable
                {
                    private Boolean any;
                    private String currencyCode;
                    private String maxPenalty;
                    private Boolean beforeDeparture;
                    private Boolean afterDeparture;

                    /** 
                     * Get the 'Any' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getAny() {
                        return any;
                    }

                    /** 
                     * Set the 'Any' attribute value.
                     * 
                     * @param any
                     */
                    public void setAny(Boolean any) {
                        this.any = any;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'MaxPenalty' attribute value.
                     * 
                     * @return value
                     */
                    public String getMaxPenalty() {
                        return maxPenalty;
                    }

                    /** 
                     * Set the 'MaxPenalty' attribute value.
                     * 
                     * @param maxPenalty
                     */
                    public void setMaxPenalty(String maxPenalty) {
                        this.maxPenalty = maxPenalty;
                    }

                    /** 
                     * Get the 'BeforeDeparture' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getBeforeDeparture() {
                        return beforeDeparture;
                    }

                    /** 
                     * Set the 'BeforeDeparture' attribute value.
                     * 
                     * @param beforeDeparture
                     */
                    public void setBeforeDeparture(Boolean beforeDeparture) {
                        this.beforeDeparture = beforeDeparture;
                    }

                    /** 
                     * Get the 'AfterDeparture' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getAfterDeparture() {
                        return afterDeparture;
                    }

                    /** 
                     * Set the 'AfterDeparture' attribute value.
                     * 
                     * @param afterDeparture
                     */
                    public void setAfterDeparture(Boolean afterDeparture) {
                        this.afterDeparture = afterDeparture;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EitherOr" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Any"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="MaxPenalty"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="BeforeDeparture"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="AfterDeparture"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class EitherOr implements Serializable
                {
                    private Boolean any;
                    private String currencyCode;
                    private String maxPenalty;
                    private Boolean beforeDeparture;
                    private Boolean afterDeparture;

                    /** 
                     * Get the 'Any' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getAny() {
                        return any;
                    }

                    /** 
                     * Set the 'Any' attribute value.
                     * 
                     * @param any
                     */
                    public void setAny(Boolean any) {
                        this.any = any;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'MaxPenalty' attribute value.
                     * 
                     * @return value
                     */
                    public String getMaxPenalty() {
                        return maxPenalty;
                    }

                    /** 
                     * Set the 'MaxPenalty' attribute value.
                     * 
                     * @param maxPenalty
                     */
                    public void setMaxPenalty(String maxPenalty) {
                        this.maxPenalty = maxPenalty;
                    }

                    /** 
                     * Get the 'BeforeDeparture' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getBeforeDeparture() {
                        return beforeDeparture;
                    }

                    /** 
                     * Set the 'BeforeDeparture' attribute value.
                     * 
                     * @param beforeDeparture
                     */
                    public void setBeforeDeparture(Boolean beforeDeparture) {
                        this.beforeDeparture = beforeDeparture;
                    }

                    /** 
                     * Get the 'AfterDeparture' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getAfterDeparture() {
                        return afterDeparture;
                    }

                    /** 
                     * Set the 'AfterDeparture' attribute value.
                     * 
                     * @param afterDeparture
                     */
                    public void setAfterDeparture(Boolean afterDeparture) {
                        this.afterDeparture = afterDeparture;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Refundable" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Any"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="MaxPenalty"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="BeforeDeparture"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="AfterDeparture"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Refundable implements Serializable
                {
                    private Boolean any;
                    private String currencyCode;
                    private String maxPenalty;
                    private Boolean beforeDeparture;
                    private Boolean afterDeparture;

                    /** 
                     * Get the 'Any' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getAny() {
                        return any;
                    }

                    /** 
                     * Set the 'Any' attribute value.
                     * 
                     * @param any
                     */
                    public void setAny(Boolean any) {
                        this.any = any;
                    }

                    /** 
                     * Get the 'CurrencyCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' attribute value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'MaxPenalty' attribute value.
                     * 
                     * @return value
                     */
                    public String getMaxPenalty() {
                        return maxPenalty;
                    }

                    /** 
                     * Set the 'MaxPenalty' attribute value.
                     * 
                     * @param maxPenalty
                     */
                    public void setMaxPenalty(String maxPenalty) {
                        this.maxPenalty = maxPenalty;
                    }

                    /** 
                     * Get the 'BeforeDeparture' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getBeforeDeparture() {
                        return beforeDeparture;
                    }

                    /** 
                     * Set the 'BeforeDeparture' attribute value.
                     * 
                     * @param beforeDeparture
                     */
                    public void setBeforeDeparture(Boolean beforeDeparture) {
                        this.beforeDeparture = beforeDeparture;
                    }

                    /** 
                     * Get the 'AfterDeparture' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getAfterDeparture() {
                        return afterDeparture;
                    }

                    /** 
                     * Set the 'AfterDeparture' attribute value.
                     * 
                     * @param afterDeparture
                     */
                    public void setAfterDeparture(Boolean afterDeparture) {
                        this.afterDeparture = afterDeparture;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="NoTax" minOccurs="0">
             *         &lt;!-- Reference to inner class NoTax -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TaxExempt" minOccurs="0" maxOccurs="5">
             *         &lt;!-- Reference to inner class TaxExempt -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Taxes implements Serializable
            {
                private NoTax noTax;
                private List<TaxExempt> taxExemptList = new ArrayList<TaxExempt>();

                /** 
                 * Get the 'NoTax' element value.
                 * 
                 * @return value
                 */
                public NoTax getNoTax() {
                    return noTax;
                }

                /** 
                 * Set the 'NoTax' element value.
                 * 
                 * @param noTax
                 */
                public void setNoTax(NoTax noTax) {
                    this.noTax = noTax;
                }

                /** 
                 * Get the list of 'TaxExempt' element items.
                 * 
                 * @return list
                 */
                public List<TaxExempt> getTaxExemptList() {
                    return taxExemptList;
                }

                /** 
                 * Set the list of 'TaxExempt' element items.
                 * 
                 * @param list
                 */
                public void setTaxExemptList(List<TaxExempt> list) {
                    taxExemptList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoTax" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class NoTax implements Serializable
                {
                    private Boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(Boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxExempt" minOccurs="0" maxOccurs="5">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TaxExempt implements Serializable
                {
                    private String code;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidityDates" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="NotValidAfter" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="NotValidBefore" minOccurs="0"/>
             *       &lt;xs:element name="Segment" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Segment -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ValidityDates implements Serializable
            {
                private String notValidAfter;
                private String notValidBefore;
                private List<Segment> segmentList = new ArrayList<Segment>();

                /** 
                 * Get the 'NotValidAfter' element value.
                 * 
                 * @return value
                 */
                public String getNotValidAfter() {
                    return notValidAfter;
                }

                /** 
                 * Set the 'NotValidAfter' element value.
                 * 
                 * @param notValidAfter
                 */
                public void setNotValidAfter(String notValidAfter) {
                    this.notValidAfter = notValidAfter;
                }

                /** 
                 * Get the 'NotValidBefore' element value.
                 * 
                 * @return value
                 */
                public String getNotValidBefore() {
                    return notValidBefore;
                }

                /** 
                 * Set the 'NotValidBefore' element value.
                 * 
                 * @param notValidBefore
                 */
                public void setNotValidBefore(String notValidBefore) {
                    this.notValidBefore = notValidBefore;
                }

                /** 
                 * Get the list of 'Segment' element items.
                 * 
                 * @return list
                 */
                public List<Segment> getSegmentList() {
                    return segmentList;
                }

                /** 
                 * Set the list of 'Segment' element items.
                 * 
                 * @param list
                 */
                public void setSegmentList(List<Segment> list) {
                    segmentList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Segment implements Serializable
                {
                    private BigInteger endNumber;
                    private BigInteger number;

                    /** 
                     * Get the 'EndNumber' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getEndNumber() {
                        return endNumber;
                    }

                    /** 
                     * Set the 'EndNumber' attribute value.
                     * 
                     * @param endNumber
                     */
                    public void setEndNumber(BigInteger endNumber) {
                        this.endNumber = endNumber;
                    }

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(BigInteger number) {
                        this.number = number;
                    }
                }
            }
        }
    }
}
