
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BargainFinderPlusRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="OriginDestinationInformation" minOccurs="0" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class OriginDestinationInformation -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="PriceRequestInformation" minOccurs="0">
 *         &lt;!-- Reference to inner class PriceRequestInformation -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" fixed="2.13.0" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class BargainFinderPlusRQ implements Serializable
{
    private List<OriginDestinationInformation> originDestinationInformationList = new ArrayList<OriginDestinationInformation>();
    private PriceRequestInformation priceRequestInformation;
    private Boolean returnHostCommand;
    private Date timeStamp;
    private String version;

    /** 
     * Get the list of 'OriginDestinationInformation' element items.
     * 
     * @return list
     */
    public List<OriginDestinationInformation> getOriginDestinationInformationList() {
        return originDestinationInformationList;
    }

    /** 
     * Set the list of 'OriginDestinationInformation' element items.
     * 
     * @param list
     */
    public void setOriginDestinationInformationList(
            List<OriginDestinationInformation> list) {
        originDestinationInformationList = list;
    }

    /** 
     * Get the 'PriceRequestInformation' element value.
     * 
     * @return value
     */
    public PriceRequestInformation getPriceRequestInformation() {
        return priceRequestInformation;
    }

    /** 
     * Set the 'PriceRequestInformation' element value.
     * 
     * @param priceRequestInformation
     */
    public void setPriceRequestInformation(
            PriceRequestInformation priceRequestInformation) {
        this.priceRequestInformation = priceRequestInformation;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(Boolean returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationInformation" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FlightSegment" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class FlightSegment -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginDestinationInformation implements Serializable
    {
        private List<FlightSegment> flightSegmentList = new ArrayList<FlightSegment>();
        private BigInteger RPH;

        /** 
         * Get the list of 'FlightSegment' element items.
         * 
         * @return list
         */
        public List<FlightSegment> getFlightSegmentList() {
            return flightSegmentList;
        }

        /** 
         * Set the list of 'FlightSegment' element items.
         * 
         * @param list
         */
        public void setFlightSegmentList(List<FlightSegment> list) {
            flightSegmentList = list;
        }

        /** 
         * Get the 'RPH' attribute value.
         * 
         * @return value
         */
        public BigInteger getRPH() {
            return RPH;
        }

        /** 
         * Set the 'RPH' attribute value.
         * 
         * @param RPH
         */
        public void setRPH(BigInteger RPH) {
            this.RPH = RPH;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="DestinationLocation">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="MarketingCarrier">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *           &lt;xs:attribute type="xs:string" use="required" name="FlightNumber"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="OriginLocation">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ArrivalDateTime"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ConnectionInd"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightSegment implements Serializable
        {
            private String destinationLocation;
            private String marketingCarrierCode;
            private String marketingCarrierFlightNumber;
            private String originLocation;
            private String arrivalDateTime;
            private String connectionInd;
            private String departureDateTime;
            private String flightNumber;
            private String resBookDesigCode;

            /** 
             * Get the 'LocationCode' attribute value.
             * 
             * @return value
             */
            public String getDestinationLocation() {
                return destinationLocation;
            }

            /** 
             * Set the 'LocationCode' attribute value.
             * 
             * @param destinationLocation
             */
            public void setDestinationLocation(String destinationLocation) {
                this.destinationLocation = destinationLocation;
            }

            /** 
             * Get the 'Code' attribute value.
             * 
             * @return value
             */
            public String getMarketingCarrierCode() {
                return marketingCarrierCode;
            }

            /** 
             * Set the 'Code' attribute value.
             * 
             * @param marketingCarrierCode
             */
            public void setMarketingCarrierCode(String marketingCarrierCode) {
                this.marketingCarrierCode = marketingCarrierCode;
            }

            /** 
             * Get the 'FlightNumber' attribute value.
             * 
             * @return value
             */
            public String getMarketingCarrierFlightNumber() {
                return marketingCarrierFlightNumber;
            }

            /** 
             * Set the 'FlightNumber' attribute value.
             * 
             * @param marketingCarrierFlightNumber
             */
            public void setMarketingCarrierFlightNumber(
                    String marketingCarrierFlightNumber) {
                this.marketingCarrierFlightNumber = marketingCarrierFlightNumber;
            }

            /** 
             * Get the 'LocationCode' attribute value.
             * 
             * @return value
             */
            public String getOriginLocation() {
                return originLocation;
            }

            /** 
             * Set the 'LocationCode' attribute value.
             * 
             * @param originLocation
             */
            public void setOriginLocation(String originLocation) {
                this.originLocation = originLocation;
            }

            /** 
             * Get the 'ArrivalDateTime' attribute value.
             * 
             * @return value
             */
            public String getArrivalDateTime() {
                return arrivalDateTime;
            }

            /** 
             * Set the 'ArrivalDateTime' attribute value.
             * 
             * @param arrivalDateTime
             */
            public void setArrivalDateTime(String arrivalDateTime) {
                this.arrivalDateTime = arrivalDateTime;
            }

            /** 
             * Get the 'ConnectionInd' attribute value.
             * 
             * @return value
             */
            public String getConnectionInd() {
                return connectionInd;
            }

            /** 
             * Set the 'ConnectionInd' attribute value.
             * 
             * @param connectionInd
             */
            public void setConnectionInd(String connectionInd) {
                this.connectionInd = connectionInd;
            }

            /** 
             * Get the 'DepartureDateTime' attribute value.
             * 
             * @return value
             */
            public String getDepartureDateTime() {
                return departureDateTime;
            }

            /** 
             * Set the 'DepartureDateTime' attribute value.
             * 
             * @param departureDateTime
             */
            public void setDepartureDateTime(String departureDateTime) {
                this.departureDateTime = departureDateTime;
            }

            /** 
             * Get the 'FlightNumber' attribute value.
             * 
             * @return value
             */
            public String getFlightNumber() {
                return flightNumber;
            }

            /** 
             * Set the 'FlightNumber' attribute value.
             * 
             * @param flightNumber
             */
            public void setFlightNumber(String flightNumber) {
                this.flightNumber = flightNumber;
            }

            /** 
             * Get the 'ResBookDesigCode' attribute value.
             * 
             * @return value
             */
            public String getResBookDesigCode() {
                return resBookDesigCode;
            }

            /** 
             * Set the 'ResBookDesigCode' attribute value.
             * 
             * @param resBookDesigCode
             */
            public void setResBookDesigCode(String resBookDesigCode) {
                this.resBookDesigCode = resBookDesigCode;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceRequestInformation" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="OptionalQualifiers" minOccurs="0">
     *         &lt;!-- Reference to inner class OptionalQualifiers -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PriceRequestInformation implements Serializable
    {
        private OptionalQualifiers optionalQualifiers;

        /** 
         * Get the 'OptionalQualifiers' element value.
         * 
         * @return value
         */
        public OptionalQualifiers getOptionalQualifiers() {
            return optionalQualifiers;
        }

        /** 
         * Set the 'OptionalQualifiers' element value.
         * 
         * @param optionalQualifiers
         */
        public void setOptionalQualifiers(OptionalQualifiers optionalQualifiers) {
            this.optionalQualifiers = optionalQualifiers;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OptionalQualifiers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="FlightQualifiers" minOccurs="0">
         *         &lt;!-- Reference to inner class FlightQualifiers -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="MiscQualifiers" minOccurs="0">
         *         &lt;!-- Reference to inner class MiscQualifiers -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="PricingQualifiers" minOccurs="0">
         *         &lt;!-- Reference to inner class PricingQualifiers -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TimeQualifiers" minOccurs="0">
         *         &lt;!-- Reference to inner class TimeQualifiers -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OptionalQualifiers implements Serializable
        {
            private FlightQualifiers flightQualifiers;
            private MiscQualifiers miscQualifiers;
            private PricingQualifiers pricingQualifiers;
            private TimeQualifiers timeQualifiers;

            /** 
             * Get the 'FlightQualifiers' element value.
             * 
             * @return value
             */
            public FlightQualifiers getFlightQualifiers() {
                return flightQualifiers;
            }

            /** 
             * Set the 'FlightQualifiers' element value.
             * 
             * @param flightQualifiers
             */
            public void setFlightQualifiers(FlightQualifiers flightQualifiers) {
                this.flightQualifiers = flightQualifiers;
            }

            /** 
             * Get the 'MiscQualifiers' element value.
             * 
             * @return value
             */
            public MiscQualifiers getMiscQualifiers() {
                return miscQualifiers;
            }

            /** 
             * Set the 'MiscQualifiers' element value.
             * 
             * @param miscQualifiers
             */
            public void setMiscQualifiers(MiscQualifiers miscQualifiers) {
                this.miscQualifiers = miscQualifiers;
            }

            /** 
             * Get the 'PricingQualifiers' element value.
             * 
             * @return value
             */
            public PricingQualifiers getPricingQualifiers() {
                return pricingQualifiers;
            }

            /** 
             * Set the 'PricingQualifiers' element value.
             * 
             * @param pricingQualifiers
             */
            public void setPricingQualifiers(PricingQualifiers pricingQualifiers) {
                this.pricingQualifiers = pricingQualifiers;
            }

            /** 
             * Get the 'TimeQualifiers' element value.
             * 
             * @return value
             */
            public TimeQualifiers getTimeQualifiers() {
                return timeQualifiers;
            }

            /** 
             * Set the 'TimeQualifiers' element value.
             * 
             * @param timeQualifiers
             */
            public void setTimeQualifiers(TimeQualifiers timeQualifiers) {
                this.timeQualifiers = timeQualifiers;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightQualifiers" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="AlliancePartner" minOccurs="0">
             *         &lt;!-- Reference to inner class AlliancePartner -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="AlternateAirports" minOccurs="0">
             *         &lt;!-- Reference to inner class AlternateAirports -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ConnectionInformation" minOccurs="0">
             *         &lt;!-- Reference to inner class ConnectionInformation -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="DiversityCustomization" minOccurs="0">
             *         &lt;!-- Reference to inner class DiversityCustomization -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="LongConnections" minOccurs="0">
             *         &lt;!-- Reference to inner class LongConnections -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Routing" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Routing -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="VendorPrefs" minOccurs="0" maxOccurs="2">
             *         &lt;!-- Reference to inner class VendorPrefs -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="ConsiderAlternateLocations"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="DisableJumpCabinLogic"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="ExpandJumpCabinLogic"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="MixedCarrier"/>
             *     &lt;xs:attribute type="xs:integer" use="optional" name="NumStops"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="OnlineOnly"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="ThruFares"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FlightQualifiers implements Serializable
            {
                private AlliancePartner alliancePartner;
                private AlternateAirports alternateAirports;
                private ConnectionInformation connectionInformation;
                private DiversityCustomization diversityCustomization;
                private LongConnections longConnections;
                private List<Routing> routingList = new ArrayList<Routing>();
                private List<VendorPrefs> vendorPrefList = new ArrayList<VendorPrefs>();
                private Boolean considerAlternateLocations;
                private Boolean disableJumpCabinLogic;
                private Boolean expandJumpCabinLogic;
                private Boolean mixedCarrier;
                private BigInteger numStops;
                private Boolean onlineOnly;
                private Boolean thruFares;

                /** 
                 * Get the 'AlliancePartner' element value.
                 * 
                 * @return value
                 */
                public AlliancePartner getAlliancePartner() {
                    return alliancePartner;
                }

                /** 
                 * Set the 'AlliancePartner' element value.
                 * 
                 * @param alliancePartner
                 */
                public void setAlliancePartner(AlliancePartner alliancePartner) {
                    this.alliancePartner = alliancePartner;
                }

                /** 
                 * Get the 'AlternateAirports' element value.
                 * 
                 * @return value
                 */
                public AlternateAirports getAlternateAirports() {
                    return alternateAirports;
                }

                /** 
                 * Set the 'AlternateAirports' element value.
                 * 
                 * @param alternateAirports
                 */
                public void setAlternateAirports(
                        AlternateAirports alternateAirports) {
                    this.alternateAirports = alternateAirports;
                }

                /** 
                 * Get the 'ConnectionInformation' element value.
                 * 
                 * @return value
                 */
                public ConnectionInformation getConnectionInformation() {
                    return connectionInformation;
                }

                /** 
                 * Set the 'ConnectionInformation' element value.
                 * 
                 * @param connectionInformation
                 */
                public void setConnectionInformation(
                        ConnectionInformation connectionInformation) {
                    this.connectionInformation = connectionInformation;
                }

                /** 
                 * Get the 'DiversityCustomization' element value.
                 * 
                 * @return value
                 */
                public DiversityCustomization getDiversityCustomization() {
                    return diversityCustomization;
                }

                /** 
                 * Set the 'DiversityCustomization' element value.
                 * 
                 * @param diversityCustomization
                 */
                public void setDiversityCustomization(
                        DiversityCustomization diversityCustomization) {
                    this.diversityCustomization = diversityCustomization;
                }

                /** 
                 * Get the 'LongConnections' element value.
                 * 
                 * @return value
                 */
                public LongConnections getLongConnections() {
                    return longConnections;
                }

                /** 
                 * Set the 'LongConnections' element value.
                 * 
                 * @param longConnections
                 */
                public void setLongConnections(LongConnections longConnections) {
                    this.longConnections = longConnections;
                }

                /** 
                 * Get the list of 'Routing' element items.
                 * 
                 * @return list
                 */
                public List<Routing> getRoutingList() {
                    return routingList;
                }

                /** 
                 * Set the list of 'Routing' element items.
                 * 
                 * @param list
                 */
                public void setRoutingList(List<Routing> list) {
                    routingList = list;
                }

                /** 
                 * Get the list of 'VendorPrefs' element items.
                 * 
                 * @return list
                 */
                public List<VendorPrefs> getVendorPrefList() {
                    return vendorPrefList;
                }

                /** 
                 * Set the list of 'VendorPrefs' element items.
                 * 
                 * @param list
                 */
                public void setVendorPrefList(List<VendorPrefs> list) {
                    vendorPrefList = list;
                }

                /** 
                 * Get the 'ConsiderAlternateLocations' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getConsiderAlternateLocations() {
                    return considerAlternateLocations;
                }

                /** 
                 * Set the 'ConsiderAlternateLocations' attribute value.
                 * 
                 * @param considerAlternateLocations
                 */
                public void setConsiderAlternateLocations(
                        Boolean considerAlternateLocations) {
                    this.considerAlternateLocations = considerAlternateLocations;
                }

                /** 
                 * Get the 'DisableJumpCabinLogic' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getDisableJumpCabinLogic() {
                    return disableJumpCabinLogic;
                }

                /** 
                 * Set the 'DisableJumpCabinLogic' attribute value.
                 * 
                 * @param disableJumpCabinLogic
                 */
                public void setDisableJumpCabinLogic(
                        Boolean disableJumpCabinLogic) {
                    this.disableJumpCabinLogic = disableJumpCabinLogic;
                }

                /** 
                 * Get the 'ExpandJumpCabinLogic' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getExpandJumpCabinLogic() {
                    return expandJumpCabinLogic;
                }

                /** 
                 * Set the 'ExpandJumpCabinLogic' attribute value.
                 * 
                 * @param expandJumpCabinLogic
                 */
                public void setExpandJumpCabinLogic(Boolean expandJumpCabinLogic) {
                    this.expandJumpCabinLogic = expandJumpCabinLogic;
                }

                /** 
                 * Get the 'MixedCarrier' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getMixedCarrier() {
                    return mixedCarrier;
                }

                /** 
                 * Set the 'MixedCarrier' attribute value.
                 * 
                 * @param mixedCarrier
                 */
                public void setMixedCarrier(Boolean mixedCarrier) {
                    this.mixedCarrier = mixedCarrier;
                }

                /** 
                 * Get the 'NumStops' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getNumStops() {
                    return numStops;
                }

                /** 
                 * Set the 'NumStops' attribute value.
                 * 
                 * @param numStops
                 */
                public void setNumStops(BigInteger numStops) {
                    this.numStops = numStops;
                }

                /** 
                 * Get the 'OnlineOnly' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getOnlineOnly() {
                    return onlineOnly;
                }

                /** 
                 * Set the 'OnlineOnly' attribute value.
                 * 
                 * @param onlineOnly
                 */
                public void setOnlineOnly(Boolean onlineOnly) {
                    this.onlineOnly = onlineOnly;
                }

                /** 
                 * Get the 'ThruFares' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getThruFares() {
                    return thruFares;
                }

                /** 
                 * Set the 'ThruFares' attribute value.
                 * 
                 * @param thruFares
                 */
                public void setThruFares(Boolean thruFares) {
                    this.thruFares = thruFares;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlliancePartner" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Group" maxOccurs="3"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Exclude"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AlliancePartner implements Serializable
                {
                    private List<String> groupList = new ArrayList<String>();
                    private Boolean exclude;

                    /** 
                     * Get the list of 'Group' element items.
                     * 
                     * @return list
                     */
                    public List<String> getGroupList() {
                        return groupList;
                    }

                    /** 
                     * Set the list of 'Group' element items.
                     * 
                     * @param list
                     */
                    public void setGroupList(List<String> list) {
                        groupList = list;
                    }

                    /** 
                     * Get the 'Exclude' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getExclude() {
                        return exclude;
                    }

                    /** 
                     * Set the 'Exclude' attribute value.
                     * 
                     * @param exclude
                     */
                    public void setExclude(Boolean exclude) {
                        this.exclude = exclude;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternateAirports" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Option" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Option -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AlternateAirports implements Serializable
                {
                    private List<Option> optionList = new ArrayList<Option>();

                    /** 
                     * Get the list of 'Option' element items.
                     * 
                     * @return list
                     */
                    public List<Option> getOptionList() {
                        return optionList;
                    }

                    /** 
                     * Set the list of 'Option' element items.
                     * 
                     * @param list
                     */
                    public void setOptionList(List<Option> list) {
                        optionList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Option" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="AlternateLocation" minOccurs="0" maxOccurs="5">
                     *         &lt;!-- Reference to inner class AlternateLocation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="Mileage" minOccurs="0"/>
                     *       &lt;xs:element name="OriginLocation">
                     *         &lt;xs:complexType>
                     *           &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                     *           &lt;xs:attribute type="xs:integer" use="optional" name="SegmentNumber"/>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Option implements Serializable
                    {
                        private List<AlternateLocation> alternateLocationList = new ArrayList<AlternateLocation>();
                        private String mileage;
                        private String originLocationLocationCode;
                        private BigInteger originLocationSegmentNumber;

                        /** 
                         * Get the list of 'AlternateLocation' element items.
                         * 
                         * @return list
                         */
                        public List<AlternateLocation> getAlternateLocationList() {
                            return alternateLocationList;
                        }

                        /** 
                         * Set the list of 'AlternateLocation' element items.
                         * 
                         * @param list
                         */
                        public void setAlternateLocationList(
                                List<AlternateLocation> list) {
                            alternateLocationList = list;
                        }

                        /** 
                         * Get the 'Mileage' element value.
                         * 
                         * @return value
                         */
                        public String getMileage() {
                            return mileage;
                        }

                        /** 
                         * Set the 'Mileage' element value.
                         * 
                         * @param mileage
                         */
                        public void setMileage(String mileage) {
                            this.mileage = mileage;
                        }

                        /** 
                         * Get the 'LocationCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getOriginLocationLocationCode() {
                            return originLocationLocationCode;
                        }

                        /** 
                         * Set the 'LocationCode' attribute value.
                         * 
                         * @param originLocationLocationCode
                         */
                        public void setOriginLocationLocationCode(
                                String originLocationLocationCode) {
                            this.originLocationLocationCode = originLocationLocationCode;
                        }

                        /** 
                         * Get the 'SegmentNumber' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getOriginLocationSegmentNumber() {
                            return originLocationSegmentNumber;
                        }

                        /** 
                         * Set the 'SegmentNumber' attribute value.
                         * 
                         * @param originLocationSegmentNumber
                         */
                        public void setOriginLocationSegmentNumber(
                                BigInteger originLocationSegmentNumber) {
                            this.originLocationSegmentNumber = originLocationSegmentNumber;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternateLocation" minOccurs="0" maxOccurs="5">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class AlternateLocation implements
                            Serializable
                        {
                            private String locationCode;

                            /** 
                             * Get the 'LocationCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getLocationCode() {
                                return locationCode;
                            }

                            /** 
                             * Set the 'LocationCode' attribute value.
                             * 
                             * @param locationCode
                             */
                            public void setLocationCode(String locationCode) {
                                this.locationCode = locationCode;
                            }
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConnectionInformation" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="ExcludeLocation" minOccurs="0">
                 *         &lt;!-- Reference to inner class ExcludeLocation -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="NoConnectionChange"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ConnectionInformation implements
                    Serializable
                {
                    private ExcludeLocation excludeLocation;
                    private Boolean noConnectionChange;

                    /** 
                     * Get the 'ExcludeLocation' element value.
                     * 
                     * @return value
                     */
                    public ExcludeLocation getExcludeLocation() {
                        return excludeLocation;
                    }

                    /** 
                     * Set the 'ExcludeLocation' element value.
                     * 
                     * @param excludeLocation
                     */
                    public void setExcludeLocation(
                            ExcludeLocation excludeLocation) {
                        this.excludeLocation = excludeLocation;
                    }

                    /** 
                     * Get the 'NoConnectionChange' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getNoConnectionChange() {
                        return noConnectionChange;
                    }

                    /** 
                     * Set the 'NoConnectionChange' attribute value.
                     * 
                     * @param noConnectionChange
                     */
                    public void setNoConnectionChange(Boolean noConnectionChange) {
                        this.noConnectionChange = noConnectionChange;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExcludeLocation" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class ExcludeLocation implements Serializable
                    {
                        private String locationCode;

                        /** 
                         * Get the 'LocationCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getLocationCode() {
                            return locationCode;
                        }

                        /** 
                         * Set the 'LocationCode' attribute value.
                         * 
                         * @param locationCode
                         */
                        public void setLocationCode(String locationCode) {
                            this.locationCode = locationCode;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DiversityCustomization" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="NumNonStopOptions"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class DiversityCustomization implements
                    Serializable
                {
                    private BigInteger numNonStopOptions;

                    /** 
                     * Get the 'NumNonStopOptions' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getNumNonStopOptions() {
                        return numNonStopOptions;
                    }

                    /** 
                     * Set the 'NumNonStopOptions' attribute value.
                     * 
                     * @param numNonStopOptions
                     */
                    public void setNumNonStopOptions(
                            BigInteger numNonStopOptions) {
                        this.numNonStopOptions = numNonStopOptions;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LongConnections" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="ConnectionNumber" minOccurs="0">
                 *         &lt;!-- Reference to inner class ConnectionNumber -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="ConnectionTimeOverride" minOccurs="0">
                 *         &lt;!-- Reference to inner class ConnectionTimeOverride -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="ExcludeOvernightConnection" minOccurs="0">
                 *         &lt;!-- Reference to inner class ExcludeOvernightConnection -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="LongConnectTime" minOccurs="0">
                 *         &lt;!-- Reference to inner class LongConnectTime -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="TotalTravelTime" minOccurs="0">
                 *         &lt;!-- Reference to inner class TotalTravelTime -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class LongConnections implements Serializable
                {
                    private ConnectionNumber connectionNumber;
                    private ConnectionTimeOverride connectionTimeOverride;
                    private ExcludeOvernightConnection excludeOvernightConnection;
                    private LongConnectTime longConnectTime;
                    private TotalTravelTime totalTravelTime;

                    /** 
                     * Get the 'ConnectionNumber' element value.
                     * 
                     * @return value
                     */
                    public ConnectionNumber getConnectionNumber() {
                        return connectionNumber;
                    }

                    /** 
                     * Set the 'ConnectionNumber' element value.
                     * 
                     * @param connectionNumber
                     */
                    public void setConnectionNumber(
                            ConnectionNumber connectionNumber) {
                        this.connectionNumber = connectionNumber;
                    }

                    /** 
                     * Get the 'ConnectionTimeOverride' element value.
                     * 
                     * @return value
                     */
                    public ConnectionTimeOverride getConnectionTimeOverride() {
                        return connectionTimeOverride;
                    }

                    /** 
                     * Set the 'ConnectionTimeOverride' element value.
                     * 
                     * @param connectionTimeOverride
                     */
                    public void setConnectionTimeOverride(
                            ConnectionTimeOverride connectionTimeOverride) {
                        this.connectionTimeOverride = connectionTimeOverride;
                    }

                    /** 
                     * Get the 'ExcludeOvernightConnection' element value.
                     * 
                     * @return value
                     */
                    public ExcludeOvernightConnection getExcludeOvernightConnection() {
                        return excludeOvernightConnection;
                    }

                    /** 
                     * Set the 'ExcludeOvernightConnection' element value.
                     * 
                     * @param excludeOvernightConnection
                     */
                    public void setExcludeOvernightConnection(
                            ExcludeOvernightConnection excludeOvernightConnection) {
                        this.excludeOvernightConnection = excludeOvernightConnection;
                    }

                    /** 
                     * Get the 'LongConnectTime' element value.
                     * 
                     * @return value
                     */
                    public LongConnectTime getLongConnectTime() {
                        return longConnectTime;
                    }

                    /** 
                     * Set the 'LongConnectTime' element value.
                     * 
                     * @param longConnectTime
                     */
                    public void setLongConnectTime(
                            LongConnectTime longConnectTime) {
                        this.longConnectTime = longConnectTime;
                    }

                    /** 
                     * Get the 'TotalTravelTime' element value.
                     * 
                     * @return value
                     */
                    public TotalTravelTime getTotalTravelTime() {
                        return totalTravelTime;
                    }

                    /** 
                     * Set the 'TotalTravelTime' element value.
                     * 
                     * @param totalTravelTime
                     */
                    public void setTotalTravelTime(
                            TotalTravelTime totalTravelTime) {
                        this.totalTravelTime = totalTravelTime;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConnectionNumber" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:integer" use="optional" name="Minimum"/>
                     *     &lt;xs:attribute type="xs:integer" use="optional" name="Maximum"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class ConnectionNumber implements
                        Serializable
                    {
                        private BigInteger minimum;
                        private BigInteger maximum;

                        /** 
                         * Get the 'Minimum' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getMinimum() {
                            return minimum;
                        }

                        /** 
                         * Set the 'Minimum' attribute value.
                         * 
                         * @param minimum
                         */
                        public void setMinimum(BigInteger minimum) {
                            this.minimum = minimum;
                        }

                        /** 
                         * Get the 'Maximum' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getMaximum() {
                            return maximum;
                        }

                        /** 
                         * Set the 'Maximum' attribute value.
                         * 
                         * @param maximum
                         */
                        public void setMaximum(BigInteger maximum) {
                            this.maximum = maximum;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConnectionTimeOverride" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:integer" use="optional" name="Minimum"/>
                     *     &lt;xs:attribute type="xs:integer" use="optional" name="Maximum"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class ConnectionTimeOverride implements
                        Serializable
                    {
                        private BigInteger minimum;
                        private BigInteger maximum;

                        /** 
                         * Get the 'Minimum' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getMinimum() {
                            return minimum;
                        }

                        /** 
                         * Set the 'Minimum' attribute value.
                         * 
                         * @param minimum
                         */
                        public void setMinimum(BigInteger minimum) {
                            this.minimum = minimum;
                        }

                        /** 
                         * Get the 'Maximum' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getMaximum() {
                            return maximum;
                        }

                        /** 
                         * Set the 'Maximum' attribute value.
                         * 
                         * @param maximum
                         */
                        public void setMaximum(BigInteger maximum) {
                            this.maximum = maximum;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExcludeOvernightConnection" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Begin"/>
                     *     &lt;xs:attribute type="xs:string" use="required" name="End"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class ExcludeOvernightConnection implements
                        Serializable
                    {
                        private String begin;
                        private String end;

                        /** 
                         * Get the 'Begin' attribute value.
                         * 
                         * @return value
                         */
                        public String getBegin() {
                            return begin;
                        }

                        /** 
                         * Set the 'Begin' attribute value.
                         * 
                         * @param begin
                         */
                        public void setBegin(String begin) {
                            this.begin = begin;
                        }

                        /** 
                         * Get the 'End' attribute value.
                         * 
                         * @return value
                         */
                        public String getEnd() {
                            return end;
                        }

                        /** 
                         * Set the 'End' attribute value.
                         * 
                         * @param end
                         */
                        public void setEnd(String end) {
                            this.end = end;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LongConnectTime" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:integer" use="optional" name="Minimum"/>
                     *     &lt;xs:attribute type="xs:integer" use="optional" name="Maximum"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class LongConnectTime implements Serializable
                    {
                        private BigInteger minimum;
                        private BigInteger maximum;

                        /** 
                         * Get the 'Minimum' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getMinimum() {
                            return minimum;
                        }

                        /** 
                         * Set the 'Minimum' attribute value.
                         * 
                         * @param minimum
                         */
                        public void setMinimum(BigInteger minimum) {
                            this.minimum = minimum;
                        }

                        /** 
                         * Get the 'Maximum' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getMaximum() {
                            return maximum;
                        }

                        /** 
                         * Set the 'Maximum' attribute value.
                         * 
                         * @param maximum
                         */
                        public void setMaximum(BigInteger maximum) {
                            this.maximum = maximum;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTravelTime" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:integer" use="optional" name="Minimum"/>
                     *     &lt;xs:attribute type="xs:integer" use="optional" name="Maximum"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class TotalTravelTime implements Serializable
                    {
                        private BigInteger minimum;
                        private BigInteger maximum;

                        /** 
                         * Get the 'Minimum' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getMinimum() {
                            return minimum;
                        }

                        /** 
                         * Set the 'Minimum' attribute value.
                         * 
                         * @param minimum
                         */
                        public void setMinimum(BigInteger minimum) {
                            this.minimum = minimum;
                        }

                        /** 
                         * Get the 'Maximum' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getMaximum() {
                            return maximum;
                        }

                        /** 
                         * Set the 'Maximum' attribute value.
                         * 
                         * @param maximum
                         */
                        public void setMaximum(BigInteger maximum) {
                            this.maximum = maximum;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Routing" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="RoutingLeg" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class RoutingLeg -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="SegmentNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Routing implements Serializable
                {
                    private List<RoutingLeg> routingLegList = new ArrayList<RoutingLeg>();
                    private BigInteger segmentNumber;

                    /** 
                     * Get the list of 'RoutingLeg' element items.
                     * 
                     * @return list
                     */
                    public List<RoutingLeg> getRoutingLegList() {
                        return routingLegList;
                    }

                    /** 
                     * Set the list of 'RoutingLeg' element items.
                     * 
                     * @param list
                     */
                    public void setRoutingLegList(List<RoutingLeg> list) {
                        routingLegList = list;
                    }

                    /** 
                     * Get the 'SegmentNumber' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getSegmentNumber() {
                        return segmentNumber;
                    }

                    /** 
                     * Set the 'SegmentNumber' attribute value.
                     * 
                     * @param segmentNumber
                     */
                    public void setSegmentNumber(BigInteger segmentNumber) {
                        this.segmentNumber = segmentNumber;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoutingLeg" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="ConnectPoint" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element type="xs:string" name="InboundCarrier" maxOccurs="unbounded"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class RoutingLeg implements Serializable
                    {
                        private List<String> connectPointList = new ArrayList<String>();
                        private List<String> inboundCarrierList = new ArrayList<String>();

                        /** 
                         * Get the list of 'ConnectPoint' element items.
                         * 
                         * @return list
                         */
                        public List<String> getConnectPointList() {
                            return connectPointList;
                        }

                        /** 
                         * Set the list of 'ConnectPoint' element items.
                         * 
                         * @param list
                         */
                        public void setConnectPointList(List<String> list) {
                            connectPointList = list;
                        }

                        /** 
                         * Get the list of 'InboundCarrier' element items.
                         * 
                         * @return list
                         */
                        public List<String> getInboundCarrierList() {
                            return inboundCarrierList;
                        }

                        /** 
                         * Set the list of 'InboundCarrier' element items.
                         * 
                         * @param list
                         */
                        public void setInboundCarrierList(List<String> list) {
                            inboundCarrierList = list;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0" maxOccurs="2">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Airline" maxOccurs="20">
                 *         &lt;!-- Reference to inner class Airline -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Exclude"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class VendorPrefs implements Serializable
                {
                    private List<Airline> airlineList = new ArrayList<Airline>();
                    private Boolean exclude;

                    /** 
                     * Get the list of 'Airline' element items.
                     * 
                     * @return list
                     */
                    public List<Airline> getAirlineList() {
                        return airlineList;
                    }

                    /** 
                     * Set the list of 'Airline' element items.
                     * 
                     * @param list
                     */
                    public void setAirlineList(List<Airline> list) {
                        airlineList = list;
                    }

                    /** 
                     * Get the 'Exclude' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getExclude() {
                        return exclude;
                    }

                    /** 
                     * Set the 'Exclude' attribute value.
                     * 
                     * @param exclude
                     */
                    public void setExclude(Boolean exclude) {
                        this.exclude = exclude;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Airline" maxOccurs="20">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Airline implements Serializable
                    {
                        private String code;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiscQualifiers" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="AirExtras" minOccurs="0">
             *         &lt;!-- Reference to inner class AirExtras -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Customer" minOccurs="0">
             *         &lt;!-- Reference to inner class Customer -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="FareCalculation" minOccurs="0">
             *         &lt;!-- Reference to inner class FareCalculation -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="MultiPCC" minOccurs="0">
             *         &lt;!-- Reference to inner class MultiPCC -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="MultiTicket" minOccurs="0">
             *         &lt;!-- Reference to inner class MultiTicket -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="ValidationMethod" minOccurs="0"/>
             *       &lt;xs:element name="ValidInterlineTicket" minOccurs="0">
             *         &lt;!-- Reference to inner class ValidInterlineTicket -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MiscQualifiers implements Serializable
            {
                private AirExtras airExtras;
                private Customer customer;
                private FareCalculation fareCalculation;
                private MultiPCC multiPCC;
                private MultiTicket multiTicket;
                private String validationMethod;
                private ValidInterlineTicket validInterlineTicket;

                /** 
                 * Get the 'AirExtras' element value.
                 * 
                 * @return value
                 */
                public AirExtras getAirExtras() {
                    return airExtras;
                }

                /** 
                 * Set the 'AirExtras' element value.
                 * 
                 * @param airExtras
                 */
                public void setAirExtras(AirExtras airExtras) {
                    this.airExtras = airExtras;
                }

                /** 
                 * Get the 'Customer' element value.
                 * 
                 * @return value
                 */
                public Customer getCustomer() {
                    return customer;
                }

                /** 
                 * Set the 'Customer' element value.
                 * 
                 * @param customer
                 */
                public void setCustomer(Customer customer) {
                    this.customer = customer;
                }

                /** 
                 * Get the 'FareCalculation' element value.
                 * 
                 * @return value
                 */
                public FareCalculation getFareCalculation() {
                    return fareCalculation;
                }

                /** 
                 * Set the 'FareCalculation' element value.
                 * 
                 * @param fareCalculation
                 */
                public void setFareCalculation(FareCalculation fareCalculation) {
                    this.fareCalculation = fareCalculation;
                }

                /** 
                 * Get the 'MultiPCC' element value.
                 * 
                 * @return value
                 */
                public MultiPCC getMultiPCC() {
                    return multiPCC;
                }

                /** 
                 * Set the 'MultiPCC' element value.
                 * 
                 * @param multiPCC
                 */
                public void setMultiPCC(MultiPCC multiPCC) {
                    this.multiPCC = multiPCC;
                }

                /** 
                 * Get the 'MultiTicket' element value.
                 * 
                 * @return value
                 */
                public MultiTicket getMultiTicket() {
                    return multiTicket;
                }

                /** 
                 * Set the 'MultiTicket' element value.
                 * 
                 * @param multiTicket
                 */
                public void setMultiTicket(MultiTicket multiTicket) {
                    this.multiTicket = multiTicket;
                }

                /** 
                 * Get the 'ValidationMethod' element value.
                 * 
                 * @return value
                 */
                public String getValidationMethod() {
                    return validationMethod;
                }

                /** 
                 * Set the 'ValidationMethod' element value.
                 * 
                 * @param validationMethod
                 */
                public void setValidationMethod(String validationMethod) {
                    this.validationMethod = validationMethod;
                }

                /** 
                 * Get the 'ValidInterlineTicket' element value.
                 * 
                 * @return value
                 */
                public ValidInterlineTicket getValidInterlineTicket() {
                    return validInterlineTicket;
                }

                /** 
                 * Set the 'ValidInterlineTicket' element value.
                 * 
                 * @param validInterlineTicket
                 */
                public void setValidInterlineTicket(
                        ValidInterlineTicket validInterlineTicket) {
                    this.validInterlineTicket = validInterlineTicket;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirExtras" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="CustLoyalty" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class CustLoyalty -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="Qualifier" minOccurs="0" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Summary"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AirExtras implements Serializable
                {
                    private List<CustLoyalty> custLoyaltyList = new ArrayList<CustLoyalty>();
                    private List<String> qualifierList = new ArrayList<String>();
                    private Boolean ind;
                    private Boolean summary;

                    /** 
                     * Get the list of 'CustLoyalty' element items.
                     * 
                     * @return list
                     */
                    public List<CustLoyalty> getCustLoyaltyList() {
                        return custLoyaltyList;
                    }

                    /** 
                     * Set the list of 'CustLoyalty' element items.
                     * 
                     * @param list
                     */
                    public void setCustLoyaltyList(List<CustLoyalty> list) {
                        custLoyaltyList = list;
                    }

                    /** 
                     * Get the list of 'Qualifier' element items.
                     * 
                     * @return list
                     */
                    public List<String> getQualifierList() {
                        return qualifierList;
                    }

                    /** 
                     * Set the list of 'Qualifier' element items.
                     * 
                     * @param list
                     */
                    public void setQualifierList(List<String> list) {
                        qualifierList = list;
                    }

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(Boolean ind) {
                        this.ind = ind;
                    }

                    /** 
                     * Get the 'Summary' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getSummary() {
                        return summary;
                    }

                    /** 
                     * Set the 'Summary' attribute value.
                     * 
                     * @param summary
                     */
                    public void setSummary(Boolean summary) {
                        this.summary = summary;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustLoyalty" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="ProgramID"/>
                     *     &lt;xs:attribute type="xs:string" use="required" name="TierLevel"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CustLoyalty implements Serializable
                    {
                        private String programID;
                        private String tierLevel;

                        /** 
                         * Get the 'ProgramID' attribute value.
                         * 
                         * @return value
                         */
                        public String getProgramID() {
                            return programID;
                        }

                        /** 
                         * Set the 'ProgramID' attribute value.
                         * 
                         * @param programID
                         */
                        public void setProgramID(String programID) {
                            this.programID = programID;
                        }

                        /** 
                         * Get the 'TierLevel' attribute value.
                         * 
                         * @return value
                         */
                        public String getTierLevel() {
                            return tierLevel;
                        }

                        /** 
                         * Set the 'TierLevel' attribute value.
                         * 
                         * @param tierLevel
                         */
                        public void setTierLevel(String tierLevel) {
                            this.tierLevel = tierLevel;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Customer" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Customer implements Serializable
                {
                    private String number;

                    /** 
                     * Get the 'Number' attribute value.
                     * 
                     * @return value
                     */
                    public String getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value.
                     * 
                     * @param number
                     */
                    public void setNumber(String number) {
                        this.number = number;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareCalculation" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Qualifier"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareCalculation implements Serializable
                {
                    private String qualifier;

                    /** 
                     * Get the 'Qualifier' attribute value.
                     * 
                     * @return value
                     */
                    public String getQualifier() {
                        return qualifier;
                    }

                    /** 
                     * Set the 'Qualifier' attribute value.
                     * 
                     * @param qualifier
                     */
                    public void setQualifier(String qualifier) {
                        this.qualifier = qualifier;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultiPCC" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="PseudoCity" minOccurs="0" maxOccurs="4">
                 *         &lt;!-- Reference to inner class PseudoCity -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MultiPCC implements Serializable
                {
                    private List<PseudoCity> pseudoCityList = new ArrayList<PseudoCity>();

                    /** 
                     * Get the list of 'PseudoCity' element items.
                     * 
                     * @return list
                     */
                    public List<PseudoCity> getPseudoCityList() {
                        return pseudoCityList;
                    }

                    /** 
                     * Set the list of 'PseudoCity' element items.
                     * 
                     * @param list
                     */
                    public void setPseudoCityList(List<PseudoCity> list) {
                        pseudoCityList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PseudoCity" minOccurs="0" maxOccurs="4">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="VendorPrefs" minOccurs="0" maxOccurs="2">
                     *         &lt;!-- Reference to inner class VendorPrefs -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class PseudoCity implements Serializable
                    {
                        private List<VendorPrefs> vendorPrefList = new ArrayList<VendorPrefs>();
                        private String code;

                        /** 
                         * Get the list of 'VendorPrefs' element items.
                         * 
                         * @return list
                         */
                        public List<VendorPrefs> getVendorPrefList() {
                            return vendorPrefList;
                        }

                        /** 
                         * Set the list of 'VendorPrefs' element items.
                         * 
                         * @param list
                         */
                        public void setVendorPrefList(List<VendorPrefs> list) {
                            vendorPrefList = list;
                        }

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0" maxOccurs="2">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Airline" maxOccurs="20">
                         *         &lt;!-- Reference to inner class Airline -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Exclude"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class VendorPrefs implements Serializable
                        {
                            private List<Airline> airlineList = new ArrayList<Airline>();
                            private Boolean exclude;

                            /** 
                             * Get the list of 'Airline' element items.
                             * 
                             * @return list
                             */
                            public List<Airline> getAirlineList() {
                                return airlineList;
                            }

                            /** 
                             * Set the list of 'Airline' element items.
                             * 
                             * @param list
                             */
                            public void setAirlineList(List<Airline> list) {
                                airlineList = list;
                            }

                            /** 
                             * Get the 'Exclude' attribute value.
                             * 
                             * @return value
                             */
                            public Boolean getExclude() {
                                return exclude;
                            }

                            /** 
                             * Set the 'Exclude' attribute value.
                             * 
                             * @param exclude
                             */
                            public void setExclude(Boolean exclude) {
                                this.exclude = exclude;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Airline" maxOccurs="20">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Airline implements Serializable
                            {
                                private String code;

                                /** 
                                 * Get the 'Code' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCode() {
                                    return code;
                                }

                                /** 
                                 * Set the 'Code' attribute value.
                                 * 
                                 * @param code
                                 */
                                public void setCode(String code) {
                                    this.code = code;
                                }
                            }
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultiTicket" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MultiTicket implements Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidInterlineTicket" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ValidInterlineTicket implements
                    Serializable
                {
                    private boolean ind;

                    /** 
                     * Get the 'Ind' attribute value.
                     * 
                     * @return value
                     */
                    public boolean isInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value.
                     * 
                     * @param ind
                     */
                    public void setInd(boolean ind) {
                        this.ind = ind;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingQualifiers" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Account" minOccurs="0">
             *         &lt;!-- Reference to inner class Account -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Brand" minOccurs="0">
             *         &lt;!-- Reference to inner class Brand -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="Cabin" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="CommissionContract" minOccurs="0" maxOccurs="4"/>
             *       &lt;xs:element name="Corporate" minOccurs="0">
             *         &lt;!-- Reference to inner class Corporate -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="CountryExclude" minOccurs="0" maxOccurs="5">
             *         &lt;!-- Reference to inner class CountryExclude -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="FareOptions" minOccurs="0">
             *         &lt;!-- Reference to inner class FareOptions -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="FlexibleFares" minOccurs="0">
             *         &lt;!-- Reference to inner class FlexibleFares -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ItineraryOptions" minOccurs="0">
             *         &lt;!-- Reference to inner class ItineraryOptions -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Overrides" minOccurs="0">
             *         &lt;!-- Reference to inner class Overrides -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="PassengerStatus" minOccurs="0">
             *         &lt;!-- Reference to inner class PassengerStatus -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="PassengerType" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class PassengerType -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="PurchaseDate" minOccurs="0"/>
             *       &lt;xs:element name="RetailerRuleQualifier" minOccurs="0">
             *         &lt;!-- Reference to inner class RetailerRuleQualifier -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SpanishLargeFamilyDiscountLevel" minOccurs="0">
             *         &lt;xs:simpleType>
             *           &lt;!-- Reference to inner class SpanishLargeFamilyDiscountLevel -->
             *         &lt;/xs:simpleType>
             *       &lt;/xs:element>
             *       &lt;xs:element name="SpecificPenalty" minOccurs="0">
             *         &lt;!-- Reference to inner class SpecificPenalty -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Taxes" minOccurs="0">
             *         &lt;!-- Reference to inner class Taxes -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="AggregatedContentExclude"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="FareFocusExclude"/>
             *     &lt;xs:attribute type="xs:integer" use="optional" name="NumOptions"/>
             *     &lt;xs:attribute type="xs:integer" use="optional" name="NumOptionsWithRouting"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PricingQualifiers implements Serializable
            {
                private Account account;
                private Brand brand;
                private String cabin;
                private List<String> commissionContractList = new ArrayList<String>();
                private Corporate corporate;
                private List<CountryExclude> countryExcludeList = new ArrayList<CountryExclude>();
                private FareOptions fareOptions;
                private FlexibleFares flexibleFares;
                private ItineraryOptions itineraryOptions;
                private Overrides overrides;
                private PassengerStatus passengerStatus;
                private List<PassengerType> passengerTypeList = new ArrayList<PassengerType>();
                private String purchaseDate;
                private RetailerRuleQualifier retailerRuleQualifier;
                private SpanishLargeFamilyDiscountLevel spanishLargeFamilyDiscountLevel;
                private SpecificPenalty specificPenalty;
                private Taxes taxes;
                private String currencyCode;
                private Boolean aggregatedContentExclude;
                private Boolean fareFocusExclude;
                private BigInteger numOptions;
                private BigInteger numOptionsWithRouting;

                /** 
                 * Get the 'Account' element value.
                 * 
                 * @return value
                 */
                public Account getAccount() {
                    return account;
                }

                /** 
                 * Set the 'Account' element value.
                 * 
                 * @param account
                 */
                public void setAccount(Account account) {
                    this.account = account;
                }

                /** 
                 * Get the 'Brand' element value.
                 * 
                 * @return value
                 */
                public Brand getBrand() {
                    return brand;
                }

                /** 
                 * Set the 'Brand' element value.
                 * 
                 * @param brand
                 */
                public void setBrand(Brand brand) {
                    this.brand = brand;
                }

                /** 
                 * Get the 'Cabin' element value.
                 * 
                 * @return value
                 */
                public String getCabin() {
                    return cabin;
                }

                /** 
                 * Set the 'Cabin' element value.
                 * 
                 * @param cabin
                 */
                public void setCabin(String cabin) {
                    this.cabin = cabin;
                }

                /** 
                 * Get the list of 'CommissionContract' element items.
                 * 
                 * @return list
                 */
                public List<String> getCommissionContractList() {
                    return commissionContractList;
                }

                /** 
                 * Set the list of 'CommissionContract' element items.
                 * 
                 * @param list
                 */
                public void setCommissionContractList(List<String> list) {
                    commissionContractList = list;
                }

                /** 
                 * Get the 'Corporate' element value.
                 * 
                 * @return value
                 */
                public Corporate getCorporate() {
                    return corporate;
                }

                /** 
                 * Set the 'Corporate' element value.
                 * 
                 * @param corporate
                 */
                public void setCorporate(Corporate corporate) {
                    this.corporate = corporate;
                }

                /** 
                 * Get the list of 'CountryExclude' element items.
                 * 
                 * @return list
                 */
                public List<CountryExclude> getCountryExcludeList() {
                    return countryExcludeList;
                }

                /** 
                 * Set the list of 'CountryExclude' element items.
                 * 
                 * @param list
                 */
                public void setCountryExcludeList(List<CountryExclude> list) {
                    countryExcludeList = list;
                }

                /** 
                 * Get the 'FareOptions' element value.
                 * 
                 * @return value
                 */
                public FareOptions getFareOptions() {
                    return fareOptions;
                }

                /** 
                 * Set the 'FareOptions' element value.
                 * 
                 * @param fareOptions
                 */
                public void setFareOptions(FareOptions fareOptions) {
                    this.fareOptions = fareOptions;
                }

                /** 
                 * Get the 'FlexibleFares' element value.
                 * 
                 * @return value
                 */
                public FlexibleFares getFlexibleFares() {
                    return flexibleFares;
                }

                /** 
                 * Set the 'FlexibleFares' element value.
                 * 
                 * @param flexibleFares
                 */
                public void setFlexibleFares(FlexibleFares flexibleFares) {
                    this.flexibleFares = flexibleFares;
                }

                /** 
                 * Get the 'ItineraryOptions' element value.
                 * 
                 * @return value
                 */
                public ItineraryOptions getItineraryOptions() {
                    return itineraryOptions;
                }

                /** 
                 * Set the 'ItineraryOptions' element value.
                 * 
                 * @param itineraryOptions
                 */
                public void setItineraryOptions(
                        ItineraryOptions itineraryOptions) {
                    this.itineraryOptions = itineraryOptions;
                }

                /** 
                 * Get the 'Overrides' element value.
                 * 
                 * @return value
                 */
                public Overrides getOverrides() {
                    return overrides;
                }

                /** 
                 * Set the 'Overrides' element value.
                 * 
                 * @param overrides
                 */
                public void setOverrides(Overrides overrides) {
                    this.overrides = overrides;
                }

                /** 
                 * Get the 'PassengerStatus' element value.
                 * 
                 * @return value
                 */
                public PassengerStatus getPassengerStatus() {
                    return passengerStatus;
                }

                /** 
                 * Set the 'PassengerStatus' element value.
                 * 
                 * @param passengerStatus
                 */
                public void setPassengerStatus(PassengerStatus passengerStatus) {
                    this.passengerStatus = passengerStatus;
                }

                /** 
                 * Get the list of 'PassengerType' element items.
                 * 
                 * @return list
                 */
                public List<PassengerType> getPassengerTypeList() {
                    return passengerTypeList;
                }

                /** 
                 * Set the list of 'PassengerType' element items.
                 * 
                 * @param list
                 */
                public void setPassengerTypeList(List<PassengerType> list) {
                    passengerTypeList = list;
                }

                /** 
                 * Get the 'PurchaseDate' element value.
                 * 
                 * @return value
                 */
                public String getPurchaseDate() {
                    return purchaseDate;
                }

                /** 
                 * Set the 'PurchaseDate' element value.
                 * 
                 * @param purchaseDate
                 */
                public void setPurchaseDate(String purchaseDate) {
                    this.purchaseDate = purchaseDate;
                }

                /** 
                 * Get the 'RetailerRuleQualifier' element value.
                 * 
                 * @return value
                 */
                public RetailerRuleQualifier getRetailerRuleQualifier() {
                    return retailerRuleQualifier;
                }

                /** 
                 * Set the 'RetailerRuleQualifier' element value.
                 * 
                 * @param retailerRuleQualifier
                 */
                public void setRetailerRuleQualifier(
                        RetailerRuleQualifier retailerRuleQualifier) {
                    this.retailerRuleQualifier = retailerRuleQualifier;
                }

                /** 
                 * Get the 'SpanishLargeFamilyDiscountLevel' element value.
                 * 
                 * @return value
                 */
                public SpanishLargeFamilyDiscountLevel getSpanishLargeFamilyDiscountLevel() {
                    return spanishLargeFamilyDiscountLevel;
                }

                /** 
                 * Set the 'SpanishLargeFamilyDiscountLevel' element value.
                 * 
                 * @param spanishLargeFamilyDiscountLevel
                 */
                public void setSpanishLargeFamilyDiscountLevel(
                        SpanishLargeFamilyDiscountLevel spanishLargeFamilyDiscountLevel) {
                    this.spanishLargeFamilyDiscountLevel = spanishLargeFamilyDiscountLevel;
                }

                /** 
                 * Get the 'SpecificPenalty' element value.
                 * 
                 * @return value
                 */
                public SpecificPenalty getSpecificPenalty() {
                    return specificPenalty;
                }

                /** 
                 * Set the 'SpecificPenalty' element value.
                 * 
                 * @param specificPenalty
                 */
                public void setSpecificPenalty(SpecificPenalty specificPenalty) {
                    this.specificPenalty = specificPenalty;
                }

                /** 
                 * Get the 'Taxes' element value.
                 * 
                 * @return value
                 */
                public Taxes getTaxes() {
                    return taxes;
                }

                /** 
                 * Set the 'Taxes' element value.
                 * 
                 * @param taxes
                 */
                public void setTaxes(Taxes taxes) {
                    this.taxes = taxes;
                }

                /** 
                 * Get the 'CurrencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'AggregatedContentExclude' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getAggregatedContentExclude() {
                    return aggregatedContentExclude;
                }

                /** 
                 * Set the 'AggregatedContentExclude' attribute value.
                 * 
                 * @param aggregatedContentExclude
                 */
                public void setAggregatedContentExclude(
                        Boolean aggregatedContentExclude) {
                    this.aggregatedContentExclude = aggregatedContentExclude;
                }

                /** 
                 * Get the 'FareFocusExclude' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getFareFocusExclude() {
                    return fareFocusExclude;
                }

                /** 
                 * Set the 'FareFocusExclude' attribute value.
                 * 
                 * @param fareFocusExclude
                 */
                public void setFareFocusExclude(Boolean fareFocusExclude) {
                    this.fareFocusExclude = fareFocusExclude;
                }

                /** 
                 * Get the 'NumOptions' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getNumOptions() {
                    return numOptions;
                }

                /** 
                 * Set the 'NumOptions' attribute value.
                 * 
                 * @param numOptions
                 */
                public void setNumOptions(BigInteger numOptions) {
                    this.numOptions = numOptions;
                }

                /** 
                 * Get the 'NumOptionsWithRouting' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getNumOptionsWithRouting() {
                    return numOptionsWithRouting;
                }

                /** 
                 * Set the 'NumOptionsWithRouting' attribute value.
                 * 
                 * @param numOptionsWithRouting
                 */
                public void setNumOptionsWithRouting(
                        BigInteger numOptionsWithRouting) {
                    this.numOptionsWithRouting = numOptionsWithRouting;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Account" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Code" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Force"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Account implements Serializable
                {
                    private List<String> codeList = new ArrayList<String>();
                    private Boolean force;

                    /** 
                     * Get the list of 'Code' element items.
                     * 
                     * @return list
                     */
                    public List<String> getCodeList() {
                        return codeList;
                    }

                    /** 
                     * Set the list of 'Code' element items.
                     * 
                     * @param list
                     */
                    public void setCodeList(List<String> list) {
                        codeList = list;
                    }

                    /** 
                     * Get the 'Force' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getForce() {
                        return force;
                    }

                    /** 
                     * Set the 'Force' attribute value.
                     * 
                     * @param force
                     */
                    public void setForce(Boolean force) {
                        this.force = force;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Brand" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Force"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Brand implements Serializable
                {
                    private Boolean force;

                    /** 
                     * Get the 'Force' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getForce() {
                        return force;
                    }

                    /** 
                     * Set the 'Force' attribute value.
                     * 
                     * @param force
                     */
                    public void setForce(Boolean force) {
                        this.force = force;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Corporate" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="ID" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Force"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Corporate implements Serializable
                {
                    private List<String> IDList = new ArrayList<String>();
                    private Boolean force;

                    /** 
                     * Get the list of 'ID' element items.
                     * 
                     * @return list
                     */
                    public List<String> getIDList() {
                        return IDList;
                    }

                    /** 
                     * Set the list of 'ID' element items.
                     * 
                     * @param list
                     */
                    public void setIDList(List<String> list) {
                        IDList = list;
                    }

                    /** 
                     * Get the 'Force' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getForce() {
                        return force;
                    }

                    /** 
                     * Set the 'Force' attribute value.
                     * 
                     * @param force
                     */
                    public void setForce(Boolean force) {
                        this.force = force;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CountryExclude" minOccurs="0" maxOccurs="5">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CountryExclude implements Serializable
                {
                    private String code;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareOptions" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ASLBreakdown"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ASLIgnore"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="HandlingFees"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Public"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Private"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareOptions implements Serializable
                {
                    private Boolean ASLBreakdown;
                    private Boolean ASLIgnore;
                    private String handlingFees;
                    private Boolean _public;
                    private Boolean _private;

                    /** 
                     * Get the 'ASLBreakdown' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getASLBreakdown() {
                        return ASLBreakdown;
                    }

                    /** 
                     * Set the 'ASLBreakdown' attribute value.
                     * 
                     * @param ASLBreakdown
                     */
                    public void setASLBreakdown(Boolean ASLBreakdown) {
                        this.ASLBreakdown = ASLBreakdown;
                    }

                    /** 
                     * Get the 'ASLIgnore' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getASLIgnore() {
                        return ASLIgnore;
                    }

                    /** 
                     * Set the 'ASLIgnore' attribute value.
                     * 
                     * @param ASLIgnore
                     */
                    public void setASLIgnore(Boolean ASLIgnore) {
                        this.ASLIgnore = ASLIgnore;
                    }

                    /** 
                     * Get the 'HandlingFees' attribute value.
                     * 
                     * @return value
                     */
                    public String getHandlingFees() {
                        return handlingFees;
                    }

                    /** 
                     * Set the 'HandlingFees' attribute value.
                     * 
                     * @param handlingFees
                     */
                    public void setHandlingFees(String handlingFees) {
                        this.handlingFees = handlingFees;
                    }

                    /** 
                     * Get the 'Public' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getPublic() {
                        return _public;
                    }

                    /** 
                     * Set the 'Public' attribute value.
                     * 
                     * @param _public
                     */
                    public void setPublic(Boolean _public) {
                        this._public = _public;
                    }

                    /** 
                     * Get the 'Private' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getPrivate() {
                        return _private;
                    }

                    /** 
                     * Set the 'Private' attribute value.
                     * 
                     * @param _private
                     */
                    public void setPrivate(Boolean _private) {
                        this._private = _private;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlexibleFares" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="FareParameters" maxOccurs="10">
                 *         &lt;!-- Reference to inner class FareParameters -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FlexibleFares implements Serializable
                {
                    private List<FareParameters> fareParameterList = new ArrayList<FareParameters>();

                    /** 
                     * Get the list of 'FareParameters' element items.
                     * 
                     * @return list
                     */
                    public List<FareParameters> getFareParameterList() {
                        return fareParameterList;
                    }

                    /** 
                     * Set the list of 'FareParameters' element items.
                     * 
                     * @param list
                     */
                    public void setFareParameterList(List<FareParameters> list) {
                        fareParameterList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareParameters" maxOccurs="10">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Account" minOccurs="0">
                     *         &lt;!-- Reference to inner class Account -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Cabin" minOccurs="0">
                     *         &lt;!-- Reference to inner class Cabin -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="CorporateID" minOccurs="0">
                     *         &lt;!-- Reference to inner class CorporateID -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="ExcludeRestricted" minOccurs="0">
                     *         &lt;!-- Reference to inner class ExcludeRestricted -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="MinMaxStay" minOccurs="0">
                     *         &lt;!-- Reference to inner class MinMaxStay -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="PassengerType" minOccurs="0" maxOccurs="4">
                     *         &lt;!-- Reference to inner class PassengerType -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="PrivateFare" minOccurs="0">
                     *         &lt;!-- Reference to inner class PrivateFare -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="PublicFare" minOccurs="0">
                     *         &lt;!-- Reference to inner class PublicFare -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="RefundPenalty" minOccurs="0">
                     *         &lt;!-- Reference to inner class RefundPenalty -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="ResTicketing" minOccurs="0">
                     *         &lt;!-- Reference to inner class ResTicketing -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="SpecificPenalty" minOccurs="0">
                     *         &lt;!-- Reference to inner class SpecificPenalty -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:integer" use="required" name="GroupNumber"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FareParameters implements Serializable
                    {
                        private Account account;
                        private Cabin cabin;
                        private CorporateID corporateID;
                        private ExcludeRestricted excludeRestricted;
                        private MinMaxStay minMaxStay;
                        private List<PassengerType> passengerTypeList = new ArrayList<PassengerType>();
                        private PrivateFare privateFare;
                        private PublicFare publicFare;
                        private RefundPenalty refundPenalty;
                        private ResTicketing resTicketing;
                        private SpecificPenalty specificPenalty;
                        private BigInteger groupNumber;

                        /** 
                         * Get the 'Account' element value.
                         * 
                         * @return value
                         */
                        public Account getAccount() {
                            return account;
                        }

                        /** 
                         * Set the 'Account' element value.
                         * 
                         * @param account
                         */
                        public void setAccount(Account account) {
                            this.account = account;
                        }

                        /** 
                         * Get the 'Cabin' element value.
                         * 
                         * @return value
                         */
                        public Cabin getCabin() {
                            return cabin;
                        }

                        /** 
                         * Set the 'Cabin' element value.
                         * 
                         * @param cabin
                         */
                        public void setCabin(Cabin cabin) {
                            this.cabin = cabin;
                        }

                        /** 
                         * Get the 'CorporateID' element value.
                         * 
                         * @return value
                         */
                        public CorporateID getCorporateID() {
                            return corporateID;
                        }

                        /** 
                         * Set the 'CorporateID' element value.
                         * 
                         * @param corporateID
                         */
                        public void setCorporateID(CorporateID corporateID) {
                            this.corporateID = corporateID;
                        }

                        /** 
                         * Get the 'ExcludeRestricted' element value.
                         * 
                         * @return value
                         */
                        public ExcludeRestricted getExcludeRestricted() {
                            return excludeRestricted;
                        }

                        /** 
                         * Set the 'ExcludeRestricted' element value.
                         * 
                         * @param excludeRestricted
                         */
                        public void setExcludeRestricted(
                                ExcludeRestricted excludeRestricted) {
                            this.excludeRestricted = excludeRestricted;
                        }

                        /** 
                         * Get the 'MinMaxStay' element value.
                         * 
                         * @return value
                         */
                        public MinMaxStay getMinMaxStay() {
                            return minMaxStay;
                        }

                        /** 
                         * Set the 'MinMaxStay' element value.
                         * 
                         * @param minMaxStay
                         */
                        public void setMinMaxStay(MinMaxStay minMaxStay) {
                            this.minMaxStay = minMaxStay;
                        }

                        /** 
                         * Get the list of 'PassengerType' element items.
                         * 
                         * @return list
                         */
                        public List<PassengerType> getPassengerTypeList() {
                            return passengerTypeList;
                        }

                        /** 
                         * Set the list of 'PassengerType' element items.
                         * 
                         * @param list
                         */
                        public void setPassengerTypeList(
                                List<PassengerType> list) {
                            passengerTypeList = list;
                        }

                        /** 
                         * Get the 'PrivateFare' element value.
                         * 
                         * @return value
                         */
                        public PrivateFare getPrivateFare() {
                            return privateFare;
                        }

                        /** 
                         * Set the 'PrivateFare' element value.
                         * 
                         * @param privateFare
                         */
                        public void setPrivateFare(PrivateFare privateFare) {
                            this.privateFare = privateFare;
                        }

                        /** 
                         * Get the 'PublicFare' element value.
                         * 
                         * @return value
                         */
                        public PublicFare getPublicFare() {
                            return publicFare;
                        }

                        /** 
                         * Set the 'PublicFare' element value.
                         * 
                         * @param publicFare
                         */
                        public void setPublicFare(PublicFare publicFare) {
                            this.publicFare = publicFare;
                        }

                        /** 
                         * Get the 'RefundPenalty' element value.
                         * 
                         * @return value
                         */
                        public RefundPenalty getRefundPenalty() {
                            return refundPenalty;
                        }

                        /** 
                         * Set the 'RefundPenalty' element value.
                         * 
                         * @param refundPenalty
                         */
                        public void setRefundPenalty(RefundPenalty refundPenalty) {
                            this.refundPenalty = refundPenalty;
                        }

                        /** 
                         * Get the 'ResTicketing' element value.
                         * 
                         * @return value
                         */
                        public ResTicketing getResTicketing() {
                            return resTicketing;
                        }

                        /** 
                         * Set the 'ResTicketing' element value.
                         * 
                         * @param resTicketing
                         */
                        public void setResTicketing(ResTicketing resTicketing) {
                            this.resTicketing = resTicketing;
                        }

                        /** 
                         * Get the 'SpecificPenalty' element value.
                         * 
                         * @return value
                         */
                        public SpecificPenalty getSpecificPenalty() {
                            return specificPenalty;
                        }

                        /** 
                         * Set the 'SpecificPenalty' element value.
                         * 
                         * @param specificPenalty
                         */
                        public void setSpecificPenalty(
                                SpecificPenalty specificPenalty) {
                            this.specificPenalty = specificPenalty;
                        }

                        /** 
                         * Get the 'GroupNumber' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getGroupNumber() {
                            return groupNumber;
                        }

                        /** 
                         * Set the 'GroupNumber' attribute value.
                         * 
                         * @param groupNumber
                         */
                        public void setGroupNumber(BigInteger groupNumber) {
                            this.groupNumber = groupNumber;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Account" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Force"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Account implements Serializable
                        {
                            private String code;
                            private Boolean force;

                            /** 
                             * Get the 'Code' attribute value.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }

                            /** 
                             * Get the 'Force' attribute value.
                             * 
                             * @return value
                             */
                            public Boolean getForce() {
                                return force;
                            }

                            /** 
                             * Set the 'Force' attribute value.
                             * 
                             * @param force
                             */
                            public void setForce(Boolean force) {
                                this.force = force;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cabin" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                         *     &lt;xs:attribute type="xs:boolean" use="optional" name="DisableJumpCabinLogic"/>
                         *     &lt;xs:attribute type="xs:boolean" use="optional" name="ExpandJumpCabinLogic"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Cabin implements Serializable
                        {
                            private String type;
                            private Boolean disableJumpCabinLogic;
                            private Boolean expandJumpCabinLogic;

                            /** 
                             * Get the 'Type' attribute value.
                             * 
                             * @return value
                             */
                            public String getType() {
                                return type;
                            }

                            /** 
                             * Set the 'Type' attribute value.
                             * 
                             * @param type
                             */
                            public void setType(String type) {
                                this.type = type;
                            }

                            /** 
                             * Get the 'DisableJumpCabinLogic' attribute value.
                             * 
                             * @return value
                             */
                            public Boolean getDisableJumpCabinLogic() {
                                return disableJumpCabinLogic;
                            }

                            /** 
                             * Set the 'DisableJumpCabinLogic' attribute value.
                             * 
                             * @param disableJumpCabinLogic
                             */
                            public void setDisableJumpCabinLogic(
                                    Boolean disableJumpCabinLogic) {
                                this.disableJumpCabinLogic = disableJumpCabinLogic;
                            }

                            /** 
                             * Get the 'ExpandJumpCabinLogic' attribute value.
                             * 
                             * @return value
                             */
                            public Boolean getExpandJumpCabinLogic() {
                                return expandJumpCabinLogic;
                            }

                            /** 
                             * Set the 'ExpandJumpCabinLogic' attribute value.
                             * 
                             * @param expandJumpCabinLogic
                             */
                            public void setExpandJumpCabinLogic(
                                    Boolean expandJumpCabinLogic) {
                                this.expandJumpCabinLogic = expandJumpCabinLogic;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CorporateID" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Force"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CorporateID implements Serializable
                        {
                            private String code;
                            private Boolean force;

                            /** 
                             * Get the 'Code' attribute value.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }

                            /** 
                             * Get the 'Force' attribute value.
                             * 
                             * @return value
                             */
                            public Boolean getForce() {
                                return force;
                            }

                            /** 
                             * Set the 'Force' attribute value.
                             * 
                             * @param force
                             */
                            public void setForce(Boolean force) {
                                this.force = force;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExcludeRestricted" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class ExcludeRestricted implements
                            Serializable
                        {
                            private Boolean ind;

                            /** 
                             * Get the 'Ind' attribute value.
                             * 
                             * @return value
                             */
                            public Boolean getInd() {
                                return ind;
                            }

                            /** 
                             * Set the 'Ind' attribute value.
                             * 
                             * @param ind
                             */
                            public void setInd(Boolean ind) {
                                this.ind = ind;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MinMaxStay" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class MinMaxStay implements Serializable
                        {
                            private Boolean ind;

                            /** 
                             * Get the 'Ind' attribute value.
                             * 
                             * @return value
                             */
                            public Boolean getInd() {
                                return ind;
                            }

                            /** 
                             * Set the 'Ind' attribute value.
                             * 
                             * @param ind
                             */
                            public void setInd(Boolean ind) {
                                this.ind = ind;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerType" minOccurs="0" maxOccurs="4">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Force"/>
                         *     &lt;xs:attribute type="xs:string" use="required" name="Quantity"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class PassengerType implements
                            Serializable
                        {
                            private String code;
                            private Boolean force;
                            private String quantity;

                            /** 
                             * Get the 'Code' attribute value.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }

                            /** 
                             * Get the 'Force' attribute value.
                             * 
                             * @return value
                             */
                            public Boolean getForce() {
                                return force;
                            }

                            /** 
                             * Set the 'Force' attribute value.
                             * 
                             * @param force
                             */
                            public void setForce(Boolean force) {
                                this.force = force;
                            }

                            /** 
                             * Get the 'Quantity' attribute value.
                             * 
                             * @return value
                             */
                            public String getQuantity() {
                                return quantity;
                            }

                            /** 
                             * Set the 'Quantity' attribute value.
                             * 
                             * @param quantity
                             */
                            public void setQuantity(String quantity) {
                                this.quantity = quantity;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PrivateFare" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class PrivateFare implements Serializable
                        {
                            private Boolean ind;

                            /** 
                             * Get the 'Ind' attribute value.
                             * 
                             * @return value
                             */
                            public Boolean getInd() {
                                return ind;
                            }

                            /** 
                             * Set the 'Ind' attribute value.
                             * 
                             * @param ind
                             */
                            public void setInd(Boolean ind) {
                                this.ind = ind;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PublicFare" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class PublicFare implements Serializable
                        {
                            private Boolean ind;

                            /** 
                             * Get the 'Ind' attribute value.
                             * 
                             * @return value
                             */
                            public Boolean getInd() {
                                return ind;
                            }

                            /** 
                             * Set the 'Ind' attribute value.
                             * 
                             * @param ind
                             */
                            public void setInd(Boolean ind) {
                                this.ind = ind;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RefundPenalty" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class RefundPenalty implements
                            Serializable
                        {
                            private Boolean ind;

                            /** 
                             * Get the 'Ind' attribute value.
                             * 
                             * @return value
                             */
                            public Boolean getInd() {
                                return ind;
                            }

                            /** 
                             * Set the 'Ind' attribute value.
                             * 
                             * @param ind
                             */
                            public void setInd(Boolean ind) {
                                this.ind = ind;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResTicketing" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class ResTicketing implements
                            Serializable
                        {
                            private Boolean ind;

                            /** 
                             * Get the 'Ind' attribute value.
                             * 
                             * @return value
                             */
                            public Boolean getInd() {
                                return ind;
                            }

                            /** 
                             * Set the 'Ind' attribute value.
                             * 
                             * @param ind
                             */
                            public void setInd(Boolean ind) {
                                this.ind = ind;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecificPenalty" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Changeable" minOccurs="0">
                         *         &lt;!-- Reference to inner class Changeable -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="EitherOr" minOccurs="0">
                         *         &lt;!-- Reference to inner class EitherOr -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="Refundable" minOccurs="0">
                         *         &lt;!-- Reference to inner class Refundable -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:boolean" use="optional" name="AdditionalInfo"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class SpecificPenalty implements
                            Serializable
                        {
                            private Changeable changeable;
                            private EitherOr eitherOr;
                            private Refundable refundable;
                            private Boolean additionalInfo;

                            /** 
                             * Get the 'Changeable' element value.
                             * 
                             * @return value
                             */
                            public Changeable getChangeable() {
                                return changeable;
                            }

                            /** 
                             * Set the 'Changeable' element value.
                             * 
                             * @param changeable
                             */
                            public void setChangeable(Changeable changeable) {
                                this.changeable = changeable;
                            }

                            /** 
                             * Get the 'EitherOr' element value.
                             * 
                             * @return value
                             */
                            public EitherOr getEitherOr() {
                                return eitherOr;
                            }

                            /** 
                             * Set the 'EitherOr' element value.
                             * 
                             * @param eitherOr
                             */
                            public void setEitherOr(EitherOr eitherOr) {
                                this.eitherOr = eitherOr;
                            }

                            /** 
                             * Get the 'Refundable' element value.
                             * 
                             * @return value
                             */
                            public Refundable getRefundable() {
                                return refundable;
                            }

                            /** 
                             * Set the 'Refundable' element value.
                             * 
                             * @param refundable
                             */
                            public void setRefundable(Refundable refundable) {
                                this.refundable = refundable;
                            }

                            /** 
                             * Get the 'AdditionalInfo' attribute value.
                             * 
                             * @return value
                             */
                            public Boolean getAdditionalInfo() {
                                return additionalInfo;
                            }

                            /** 
                             * Set the 'AdditionalInfo' attribute value.
                             * 
                             * @param additionalInfo
                             */
                            public void setAdditionalInfo(Boolean additionalInfo) {
                                this.additionalInfo = additionalInfo;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Changeable" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Any"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="MaxPenalty"/>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="BeforeDeparture"/>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="AfterDeparture"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Changeable implements
                                Serializable
                            {
                                private Boolean any;
                                private String currencyCode;
                                private String maxPenalty;
                                private Boolean beforeDeparture;
                                private Boolean afterDeparture;

                                /** 
                                 * Get the 'Any' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getAny() {
                                    return any;
                                }

                                /** 
                                 * Set the 'Any' attribute value.
                                 * 
                                 * @param any
                                 */
                                public void setAny(Boolean any) {
                                    this.any = any;
                                }

                                /** 
                                 * Get the 'CurrencyCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCurrencyCode() {
                                    return currencyCode;
                                }

                                /** 
                                 * Set the 'CurrencyCode' attribute value.
                                 * 
                                 * @param currencyCode
                                 */
                                public void setCurrencyCode(String currencyCode) {
                                    this.currencyCode = currencyCode;
                                }

                                /** 
                                 * Get the 'MaxPenalty' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getMaxPenalty() {
                                    return maxPenalty;
                                }

                                /** 
                                 * Set the 'MaxPenalty' attribute value.
                                 * 
                                 * @param maxPenalty
                                 */
                                public void setMaxPenalty(String maxPenalty) {
                                    this.maxPenalty = maxPenalty;
                                }

                                /** 
                                 * Get the 'BeforeDeparture' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getBeforeDeparture() {
                                    return beforeDeparture;
                                }

                                /** 
                                 * Set the 'BeforeDeparture' attribute value.
                                 * 
                                 * @param beforeDeparture
                                 */
                                public void setBeforeDeparture(
                                        Boolean beforeDeparture) {
                                    this.beforeDeparture = beforeDeparture;
                                }

                                /** 
                                 * Get the 'AfterDeparture' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getAfterDeparture() {
                                    return afterDeparture;
                                }

                                /** 
                                 * Set the 'AfterDeparture' attribute value.
                                 * 
                                 * @param afterDeparture
                                 */
                                public void setAfterDeparture(
                                        Boolean afterDeparture) {
                                    this.afterDeparture = afterDeparture;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EitherOr" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Any"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="MaxPenalty"/>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="BeforeDeparture"/>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="AfterDeparture"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class EitherOr implements
                                Serializable
                            {
                                private Boolean any;
                                private String currencyCode;
                                private String maxPenalty;
                                private Boolean beforeDeparture;
                                private Boolean afterDeparture;

                                /** 
                                 * Get the 'Any' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getAny() {
                                    return any;
                                }

                                /** 
                                 * Set the 'Any' attribute value.
                                 * 
                                 * @param any
                                 */
                                public void setAny(Boolean any) {
                                    this.any = any;
                                }

                                /** 
                                 * Get the 'CurrencyCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCurrencyCode() {
                                    return currencyCode;
                                }

                                /** 
                                 * Set the 'CurrencyCode' attribute value.
                                 * 
                                 * @param currencyCode
                                 */
                                public void setCurrencyCode(String currencyCode) {
                                    this.currencyCode = currencyCode;
                                }

                                /** 
                                 * Get the 'MaxPenalty' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getMaxPenalty() {
                                    return maxPenalty;
                                }

                                /** 
                                 * Set the 'MaxPenalty' attribute value.
                                 * 
                                 * @param maxPenalty
                                 */
                                public void setMaxPenalty(String maxPenalty) {
                                    this.maxPenalty = maxPenalty;
                                }

                                /** 
                                 * Get the 'BeforeDeparture' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getBeforeDeparture() {
                                    return beforeDeparture;
                                }

                                /** 
                                 * Set the 'BeforeDeparture' attribute value.
                                 * 
                                 * @param beforeDeparture
                                 */
                                public void setBeforeDeparture(
                                        Boolean beforeDeparture) {
                                    this.beforeDeparture = beforeDeparture;
                                }

                                /** 
                                 * Get the 'AfterDeparture' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getAfterDeparture() {
                                    return afterDeparture;
                                }

                                /** 
                                 * Set the 'AfterDeparture' attribute value.
                                 * 
                                 * @param afterDeparture
                                 */
                                public void setAfterDeparture(
                                        Boolean afterDeparture) {
                                    this.afterDeparture = afterDeparture;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Refundable" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Any"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="MaxPenalty"/>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="BeforeDeparture"/>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="AfterDeparture"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Refundable implements
                                Serializable
                            {
                                private Boolean any;
                                private String currencyCode;
                                private String maxPenalty;
                                private Boolean beforeDeparture;
                                private Boolean afterDeparture;

                                /** 
                                 * Get the 'Any' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getAny() {
                                    return any;
                                }

                                /** 
                                 * Set the 'Any' attribute value.
                                 * 
                                 * @param any
                                 */
                                public void setAny(Boolean any) {
                                    this.any = any;
                                }

                                /** 
                                 * Get the 'CurrencyCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCurrencyCode() {
                                    return currencyCode;
                                }

                                /** 
                                 * Set the 'CurrencyCode' attribute value.
                                 * 
                                 * @param currencyCode
                                 */
                                public void setCurrencyCode(String currencyCode) {
                                    this.currencyCode = currencyCode;
                                }

                                /** 
                                 * Get the 'MaxPenalty' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getMaxPenalty() {
                                    return maxPenalty;
                                }

                                /** 
                                 * Set the 'MaxPenalty' attribute value.
                                 * 
                                 * @param maxPenalty
                                 */
                                public void setMaxPenalty(String maxPenalty) {
                                    this.maxPenalty = maxPenalty;
                                }

                                /** 
                                 * Get the 'BeforeDeparture' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getBeforeDeparture() {
                                    return beforeDeparture;
                                }

                                /** 
                                 * Set the 'BeforeDeparture' attribute value.
                                 * 
                                 * @param beforeDeparture
                                 */
                                public void setBeforeDeparture(
                                        Boolean beforeDeparture) {
                                    this.beforeDeparture = beforeDeparture;
                                }

                                /** 
                                 * Get the 'AfterDeparture' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getAfterDeparture() {
                                    return afterDeparture;
                                }

                                /** 
                                 * Set the 'AfterDeparture' attribute value.
                                 * 
                                 * @param afterDeparture
                                 */
                                public void setAfterDeparture(
                                        Boolean afterDeparture) {
                                    this.afterDeparture = afterDeparture;
                                }
                            }
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryOptions" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="SegmentSelect" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class SegmentSelect -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ItineraryOptions implements Serializable
                {
                    private List<SegmentSelect> segmentSelectList = new ArrayList<SegmentSelect>();

                    /** 
                     * Get the list of 'SegmentSelect' element items.
                     * 
                     * @return list
                     */
                    public List<SegmentSelect> getSegmentSelectList() {
                        return segmentSelectList;
                    }

                    /** 
                     * Set the list of 'SegmentSelect' element items.
                     * 
                     * @param list
                     */
                    public void setSegmentSelectList(List<SegmentSelect> list) {
                        segmentSelectList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentSelect" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
                     *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
                     *     &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class SegmentSelect implements Serializable
                    {
                        private BigInteger endNumber;
                        private BigInteger number;
                        private BigInteger RPH;

                        /** 
                         * Get the 'EndNumber' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getEndNumber() {
                            return endNumber;
                        }

                        /** 
                         * Set the 'EndNumber' attribute value.
                         * 
                         * @param endNumber
                         */
                        public void setEndNumber(BigInteger endNumber) {
                            this.endNumber = endNumber;
                        }

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getNumber() {
                            return number;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param number
                         */
                        public void setNumber(BigInteger number) {
                            this.number = number;
                        }

                        /** 
                         * Get the 'RPH' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getRPH() {
                            return RPH;
                        }

                        /** 
                         * Set the 'RPH' attribute value.
                         * 
                         * @param RPH
                         */
                        public void setRPH(BigInteger RPH) {
                            this.RPH = RPH;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Overrides" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="NoAdvancePurchase" minOccurs="0">
                 *         &lt;!-- Reference to inner class NoAdvancePurchase -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="NoFareRestrictions" minOccurs="0">
                 *         &lt;!-- Reference to inner class NoFareRestrictions -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="NoMinMaxStay" minOccurs="0">
                 *         &lt;!-- Reference to inner class NoMinMaxStay -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="NoPenalty" minOccurs="0">
                 *         &lt;!-- Reference to inner class NoPenalty -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Purchase" minOccurs="0">
                 *         &lt;!-- Reference to inner class Purchase -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Ticketing" minOccurs="0">
                 *         &lt;!-- Reference to inner class Ticketing -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Overrides implements Serializable
                {
                    private NoAdvancePurchase noAdvancePurchase;
                    private NoFareRestrictions noFareRestrictions;
                    private NoMinMaxStay noMinMaxStay;
                    private NoPenalty noPenalty;
                    private Purchase purchase;
                    private Ticketing ticketing;

                    /** 
                     * Get the 'NoAdvancePurchase' element value.
                     * 
                     * @return value
                     */
                    public NoAdvancePurchase getNoAdvancePurchase() {
                        return noAdvancePurchase;
                    }

                    /** 
                     * Set the 'NoAdvancePurchase' element value.
                     * 
                     * @param noAdvancePurchase
                     */
                    public void setNoAdvancePurchase(
                            NoAdvancePurchase noAdvancePurchase) {
                        this.noAdvancePurchase = noAdvancePurchase;
                    }

                    /** 
                     * Get the 'NoFareRestrictions' element value.
                     * 
                     * @return value
                     */
                    public NoFareRestrictions getNoFareRestrictions() {
                        return noFareRestrictions;
                    }

                    /** 
                     * Set the 'NoFareRestrictions' element value.
                     * 
                     * @param noFareRestrictions
                     */
                    public void setNoFareRestrictions(
                            NoFareRestrictions noFareRestrictions) {
                        this.noFareRestrictions = noFareRestrictions;
                    }

                    /** 
                     * Get the 'NoMinMaxStay' element value.
                     * 
                     * @return value
                     */
                    public NoMinMaxStay getNoMinMaxStay() {
                        return noMinMaxStay;
                    }

                    /** 
                     * Set the 'NoMinMaxStay' element value.
                     * 
                     * @param noMinMaxStay
                     */
                    public void setNoMinMaxStay(NoMinMaxStay noMinMaxStay) {
                        this.noMinMaxStay = noMinMaxStay;
                    }

                    /** 
                     * Get the 'NoPenalty' element value.
                     * 
                     * @return value
                     */
                    public NoPenalty getNoPenalty() {
                        return noPenalty;
                    }

                    /** 
                     * Set the 'NoPenalty' element value.
                     * 
                     * @param noPenalty
                     */
                    public void setNoPenalty(NoPenalty noPenalty) {
                        this.noPenalty = noPenalty;
                    }

                    /** 
                     * Get the 'Purchase' element value.
                     * 
                     * @return value
                     */
                    public Purchase getPurchase() {
                        return purchase;
                    }

                    /** 
                     * Set the 'Purchase' element value.
                     * 
                     * @param purchase
                     */
                    public void setPurchase(Purchase purchase) {
                        this.purchase = purchase;
                    }

                    /** 
                     * Get the 'Ticketing' element value.
                     * 
                     * @return value
                     */
                    public Ticketing getTicketing() {
                        return ticketing;
                    }

                    /** 
                     * Set the 'Ticketing' element value.
                     * 
                     * @param ticketing
                     */
                    public void setTicketing(Ticketing ticketing) {
                        this.ticketing = ticketing;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoAdvancePurchase" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class NoAdvancePurchase implements
                        Serializable
                    {
                        private boolean ind;

                        /** 
                         * Get the 'Ind' attribute value.
                         * 
                         * @return value
                         */
                        public boolean isInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value.
                         * 
                         * @param ind
                         */
                        public void setInd(boolean ind) {
                            this.ind = ind;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoFareRestrictions" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class NoFareRestrictions implements
                        Serializable
                    {
                        private boolean ind;

                        /** 
                         * Get the 'Ind' attribute value.
                         * 
                         * @return value
                         */
                        public boolean isInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value.
                         * 
                         * @param ind
                         */
                        public void setInd(boolean ind) {
                            this.ind = ind;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoMinMaxStay" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class NoMinMaxStay implements Serializable
                    {
                        private boolean ind;

                        /** 
                         * Get the 'Ind' attribute value.
                         * 
                         * @return value
                         */
                        public boolean isInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value.
                         * 
                         * @param ind
                         */
                        public void setInd(boolean ind) {
                            this.ind = ind;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoPenalty" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class NoPenalty implements Serializable
                    {
                        private boolean ind;

                        /** 
                         * Get the 'Ind' attribute value.
                         * 
                         * @return value
                         */
                        public boolean isInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value.
                         * 
                         * @param ind
                         */
                        public void setInd(boolean ind) {
                            this.ind = ind;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Purchase" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Purchase implements Serializable
                    {
                        private String locationCode;

                        /** 
                         * Get the 'LocationCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getLocationCode() {
                            return locationCode;
                        }

                        /** 
                         * Set the 'LocationCode' attribute value.
                         * 
                         * @param locationCode
                         */
                        public void setLocationCode(String locationCode) {
                            this.locationCode = locationCode;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ticketing" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Ticketing implements Serializable
                    {
                        private String locationCode;

                        /** 
                         * Get the 'LocationCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getLocationCode() {
                            return locationCode;
                        }

                        /** 
                         * Set the 'LocationCode' attribute value.
                         * 
                         * @param locationCode
                         */
                        public void setLocationCode(String locationCode) {
                            this.locationCode = locationCode;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerStatus" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PassengerStatus implements Serializable
                {
                    private String type;

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerType" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Force"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Quantity"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PassengerType implements Serializable
                {
                    private String code;
                    private Boolean force;
                    private String quantity;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'Force' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getForce() {
                        return force;
                    }

                    /** 
                     * Set the 'Force' attribute value.
                     * 
                     * @param force
                     */
                    public void setForce(Boolean force) {
                        this.force = force;
                    }

                    /** 
                     * Get the 'Quantity' attribute value.
                     * 
                     * @return value
                     */
                    public String getQuantity() {
                        return quantity;
                    }

                    /** 
                     * Set the 'Quantity' attribute value.
                     * 
                     * @param quantity
                     */
                    public void setQuantity(String quantity) {
                        this.quantity = quantity;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetailerRuleQualifier" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Qualifier" minOccurs="0" maxOccurs="4"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Force"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class RetailerRuleQualifier implements
                    Serializable
                {
                    private List<String> qualifierList = new ArrayList<String>();
                    private Boolean force;

                    /** 
                     * Get the list of 'Qualifier' element items.
                     * 
                     * @return list
                     */
                    public List<String> getQualifierList() {
                        return qualifierList;
                    }

                    /** 
                     * Set the list of 'Qualifier' element items.
                     * 
                     * @param list
                     */
                    public void setQualifierList(List<String> list) {
                        qualifierList = list;
                    }

                    /** 
                     * Get the 'Force' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getForce() {
                        return force;
                    }

                    /** 
                     * Set the 'Force' attribute value.
                     * 
                     * @param force
                     */
                    public void setForce(Boolean force) {
                        this.force = force;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="1"/>
                 *     &lt;xs:enumeration value="2"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum SpanishLargeFamilyDiscountLevel
                        implements
                            Serializable {
                    _1("1"), _2("2");
                    private final String value;

                    private SpanishLargeFamilyDiscountLevel(String value) {
                        this.value = value;
                    }

                    public String xmlValue() {
                        return value;
                    }

                    public static SpanishLargeFamilyDiscountLevel convert(
                            String value) {
                        for (SpanishLargeFamilyDiscountLevel inst : values()) {
                            if (inst.xmlValue().equals(value)) {
                                return inst;
                            }
                        }
                        return null;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecificPenalty" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Changeable" minOccurs="0">
                 *         &lt;!-- Reference to inner class Changeable -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="EitherOr" minOccurs="0">
                 *         &lt;!-- Reference to inner class EitherOr -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Refundable" minOccurs="0">
                 *         &lt;!-- Reference to inner class Refundable -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="AdditionalInfo"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SpecificPenalty implements Serializable
                {
                    private Changeable changeable;
                    private EitherOr eitherOr;
                    private Refundable refundable;
                    private Boolean additionalInfo;

                    /** 
                     * Get the 'Changeable' element value.
                     * 
                     * @return value
                     */
                    public Changeable getChangeable() {
                        return changeable;
                    }

                    /** 
                     * Set the 'Changeable' element value.
                     * 
                     * @param changeable
                     */
                    public void setChangeable(Changeable changeable) {
                        this.changeable = changeable;
                    }

                    /** 
                     * Get the 'EitherOr' element value.
                     * 
                     * @return value
                     */
                    public EitherOr getEitherOr() {
                        return eitherOr;
                    }

                    /** 
                     * Set the 'EitherOr' element value.
                     * 
                     * @param eitherOr
                     */
                    public void setEitherOr(EitherOr eitherOr) {
                        this.eitherOr = eitherOr;
                    }

                    /** 
                     * Get the 'Refundable' element value.
                     * 
                     * @return value
                     */
                    public Refundable getRefundable() {
                        return refundable;
                    }

                    /** 
                     * Set the 'Refundable' element value.
                     * 
                     * @param refundable
                     */
                    public void setRefundable(Refundable refundable) {
                        this.refundable = refundable;
                    }

                    /** 
                     * Get the 'AdditionalInfo' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getAdditionalInfo() {
                        return additionalInfo;
                    }

                    /** 
                     * Set the 'AdditionalInfo' attribute value.
                     * 
                     * @param additionalInfo
                     */
                    public void setAdditionalInfo(Boolean additionalInfo) {
                        this.additionalInfo = additionalInfo;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Changeable" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Any"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="MaxPenalty"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="BeforeDeparture"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="AfterDeparture"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Changeable implements Serializable
                    {
                        private Boolean any;
                        private String currencyCode;
                        private String maxPenalty;
                        private Boolean beforeDeparture;
                        private Boolean afterDeparture;

                        /** 
                         * Get the 'Any' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getAny() {
                            return any;
                        }

                        /** 
                         * Set the 'Any' attribute value.
                         * 
                         * @param any
                         */
                        public void setAny(Boolean any) {
                            this.any = any;
                        }

                        /** 
                         * Get the 'CurrencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'CurrencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'MaxPenalty' attribute value.
                         * 
                         * @return value
                         */
                        public String getMaxPenalty() {
                            return maxPenalty;
                        }

                        /** 
                         * Set the 'MaxPenalty' attribute value.
                         * 
                         * @param maxPenalty
                         */
                        public void setMaxPenalty(String maxPenalty) {
                            this.maxPenalty = maxPenalty;
                        }

                        /** 
                         * Get the 'BeforeDeparture' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getBeforeDeparture() {
                            return beforeDeparture;
                        }

                        /** 
                         * Set the 'BeforeDeparture' attribute value.
                         * 
                         * @param beforeDeparture
                         */
                        public void setBeforeDeparture(Boolean beforeDeparture) {
                            this.beforeDeparture = beforeDeparture;
                        }

                        /** 
                         * Get the 'AfterDeparture' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getAfterDeparture() {
                            return afterDeparture;
                        }

                        /** 
                         * Set the 'AfterDeparture' attribute value.
                         * 
                         * @param afterDeparture
                         */
                        public void setAfterDeparture(Boolean afterDeparture) {
                            this.afterDeparture = afterDeparture;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EitherOr" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Any"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="MaxPenalty"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="BeforeDeparture"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="AfterDeparture"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class EitherOr implements Serializable
                    {
                        private Boolean any;
                        private String currencyCode;
                        private String maxPenalty;
                        private Boolean beforeDeparture;
                        private Boolean afterDeparture;

                        /** 
                         * Get the 'Any' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getAny() {
                            return any;
                        }

                        /** 
                         * Set the 'Any' attribute value.
                         * 
                         * @param any
                         */
                        public void setAny(Boolean any) {
                            this.any = any;
                        }

                        /** 
                         * Get the 'CurrencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'CurrencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'MaxPenalty' attribute value.
                         * 
                         * @return value
                         */
                        public String getMaxPenalty() {
                            return maxPenalty;
                        }

                        /** 
                         * Set the 'MaxPenalty' attribute value.
                         * 
                         * @param maxPenalty
                         */
                        public void setMaxPenalty(String maxPenalty) {
                            this.maxPenalty = maxPenalty;
                        }

                        /** 
                         * Get the 'BeforeDeparture' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getBeforeDeparture() {
                            return beforeDeparture;
                        }

                        /** 
                         * Set the 'BeforeDeparture' attribute value.
                         * 
                         * @param beforeDeparture
                         */
                        public void setBeforeDeparture(Boolean beforeDeparture) {
                            this.beforeDeparture = beforeDeparture;
                        }

                        /** 
                         * Get the 'AfterDeparture' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getAfterDeparture() {
                            return afterDeparture;
                        }

                        /** 
                         * Set the 'AfterDeparture' attribute value.
                         * 
                         * @param afterDeparture
                         */
                        public void setAfterDeparture(Boolean afterDeparture) {
                            this.afterDeparture = afterDeparture;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Refundable" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Any"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="MaxPenalty"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="BeforeDeparture"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="AfterDeparture"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Refundable implements Serializable
                    {
                        private Boolean any;
                        private String currencyCode;
                        private String maxPenalty;
                        private Boolean beforeDeparture;
                        private Boolean afterDeparture;

                        /** 
                         * Get the 'Any' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getAny() {
                            return any;
                        }

                        /** 
                         * Set the 'Any' attribute value.
                         * 
                         * @param any
                         */
                        public void setAny(Boolean any) {
                            this.any = any;
                        }

                        /** 
                         * Get the 'CurrencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'CurrencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'MaxPenalty' attribute value.
                         * 
                         * @return value
                         */
                        public String getMaxPenalty() {
                            return maxPenalty;
                        }

                        /** 
                         * Set the 'MaxPenalty' attribute value.
                         * 
                         * @param maxPenalty
                         */
                        public void setMaxPenalty(String maxPenalty) {
                            this.maxPenalty = maxPenalty;
                        }

                        /** 
                         * Get the 'BeforeDeparture' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getBeforeDeparture() {
                            return beforeDeparture;
                        }

                        /** 
                         * Set the 'BeforeDeparture' attribute value.
                         * 
                         * @param beforeDeparture
                         */
                        public void setBeforeDeparture(Boolean beforeDeparture) {
                            this.beforeDeparture = beforeDeparture;
                        }

                        /** 
                         * Get the 'AfterDeparture' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getAfterDeparture() {
                            return afterDeparture;
                        }

                        /** 
                         * Set the 'AfterDeparture' attribute value.
                         * 
                         * @param afterDeparture
                         */
                        public void setAfterDeparture(Boolean afterDeparture) {
                            this.afterDeparture = afterDeparture;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="TaxExempt" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class TaxExempt -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="TaxOverride" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class TaxOverride -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="NoTax"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Taxes implements Serializable
                {
                    private List<TaxExempt> taxExemptList = new ArrayList<TaxExempt>();
                    private List<TaxOverride> taxOverrideList = new ArrayList<TaxOverride>();
                    private Boolean noTax;

                    /** 
                     * Get the list of 'TaxExempt' element items.
                     * 
                     * @return list
                     */
                    public List<TaxExempt> getTaxExemptList() {
                        return taxExemptList;
                    }

                    /** 
                     * Set the list of 'TaxExempt' element items.
                     * 
                     * @param list
                     */
                    public void setTaxExemptList(List<TaxExempt> list) {
                        taxExemptList = list;
                    }

                    /** 
                     * Get the list of 'TaxOverride' element items.
                     * 
                     * @return list
                     */
                    public List<TaxOverride> getTaxOverrideList() {
                        return taxOverrideList;
                    }

                    /** 
                     * Set the list of 'TaxOverride' element items.
                     * 
                     * @param list
                     */
                    public void setTaxOverrideList(List<TaxOverride> list) {
                        taxOverrideList = list;
                    }

                    /** 
                     * Get the 'NoTax' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getNoTax() {
                        return noTax;
                    }

                    /** 
                     * Set the 'NoTax' attribute value.
                     * 
                     * @param noTax
                     */
                    public void setNoTax(Boolean noTax) {
                        this.noTax = noTax;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxExempt" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class TaxExempt implements Serializable
                    {
                        private String code;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxOverride" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Amount"/>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class TaxOverride implements Serializable
                    {
                        private String amount;
                        private String code;

                        /** 
                         * Get the 'Amount' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TimeQualifiers" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="ArrivalTime" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class ArrivalTime -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="DepartureTime" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class DepartureTime -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:integer" use="optional" name="MinusDays"/>
             *     &lt;xs:attribute type="xs:integer" use="optional" name="NumHours"/>
             *     &lt;xs:attribute type="xs:integer" use="optional" name="PlusDays"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TimeQualifiers implements Serializable
            {
                private List<ArrivalTime> arrivalTimeList = new ArrayList<ArrivalTime>();
                private List<DepartureTime> departureTimeList = new ArrayList<DepartureTime>();
                private BigInteger minusDays;
                private BigInteger numHours;
                private BigInteger plusDays;

                /** 
                 * Get the list of 'ArrivalTime' element items.
                 * 
                 * @return list
                 */
                public List<ArrivalTime> getArrivalTimeList() {
                    return arrivalTimeList;
                }

                /** 
                 * Set the list of 'ArrivalTime' element items.
                 * 
                 * @param list
                 */
                public void setArrivalTimeList(List<ArrivalTime> list) {
                    arrivalTimeList = list;
                }

                /** 
                 * Get the list of 'DepartureTime' element items.
                 * 
                 * @return list
                 */
                public List<DepartureTime> getDepartureTimeList() {
                    return departureTimeList;
                }

                /** 
                 * Set the list of 'DepartureTime' element items.
                 * 
                 * @param list
                 */
                public void setDepartureTimeList(List<DepartureTime> list) {
                    departureTimeList = list;
                }

                /** 
                 * Get the 'MinusDays' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getMinusDays() {
                    return minusDays;
                }

                /** 
                 * Set the 'MinusDays' attribute value.
                 * 
                 * @param minusDays
                 */
                public void setMinusDays(BigInteger minusDays) {
                    this.minusDays = minusDays;
                }

                /** 
                 * Get the 'NumHours' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getNumHours() {
                    return numHours;
                }

                /** 
                 * Set the 'NumHours' attribute value.
                 * 
                 * @param numHours
                 */
                public void setNumHours(BigInteger numHours) {
                    this.numHours = numHours;
                }

                /** 
                 * Get the 'PlusDays' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getPlusDays() {
                    return plusDays;
                }

                /** 
                 * Set the 'PlusDays' attribute value.
                 * 
                 * @param plusDays
                 */
                public void setPlusDays(BigInteger plusDays) {
                    this.plusDays = plusDays;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ArrivalTime" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="NumHours" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="WindowAfter"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="WindowBefore"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ArrivalTime implements Serializable
                {
                    private String numHours;
                    private BigInteger RPH;
                    private String windowAfter;
                    private String windowBefore;

                    /** 
                     * Get the 'NumHours' element value.
                     * 
                     * @return value
                     */
                    public String getNumHours() {
                        return numHours;
                    }

                    /** 
                     * Set the 'NumHours' element value.
                     * 
                     * @param numHours
                     */
                    public void setNumHours(String numHours) {
                        this.numHours = numHours;
                    }

                    /** 
                     * Get the 'RPH' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value.
                     * 
                     * @param RPH
                     */
                    public void setRPH(BigInteger RPH) {
                        this.RPH = RPH;
                    }

                    /** 
                     * Get the 'WindowAfter' attribute value.
                     * 
                     * @return value
                     */
                    public String getWindowAfter() {
                        return windowAfter;
                    }

                    /** 
                     * Set the 'WindowAfter' attribute value.
                     * 
                     * @param windowAfter
                     */
                    public void setWindowAfter(String windowAfter) {
                        this.windowAfter = windowAfter;
                    }

                    /** 
                     * Get the 'WindowBefore' attribute value.
                     * 
                     * @return value
                     */
                    public String getWindowBefore() {
                        return windowBefore;
                    }

                    /** 
                     * Set the 'WindowBefore' attribute value.
                     * 
                     * @param windowBefore
                     */
                    public void setWindowBefore(String windowBefore) {
                        this.windowBefore = windowBefore;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DepartureTime" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="WindowAfter"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="WindowBefore"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class DepartureTime implements Serializable
                {
                    private BigInteger RPH;
                    private String windowAfter;
                    private String windowBefore;

                    /** 
                     * Get the 'RPH' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value.
                     * 
                     * @param RPH
                     */
                    public void setRPH(BigInteger RPH) {
                        this.RPH = RPH;
                    }

                    /** 
                     * Get the 'WindowAfter' attribute value.
                     * 
                     * @return value
                     */
                    public String getWindowAfter() {
                        return windowAfter;
                    }

                    /** 
                     * Set the 'WindowAfter' attribute value.
                     * 
                     * @param windowAfter
                     */
                    public void setWindowAfter(String windowAfter) {
                        this.windowAfter = windowAfter;
                    }

                    /** 
                     * Get the 'WindowBefore' attribute value.
                     * 
                     * @return value
                     */
                    public String getWindowBefore() {
                        return windowBefore;
                    }

                    /** 
                     * Set the 'WindowBefore' attribute value.
                     * 
                     * @param windowBefore
                     */
                    public void setWindowBefore(String windowBefore) {
                        this.windowBefore = windowBefore;
                    }
                }
            }
        }
    }
}
