
package com.sabre.webservices.sabrexml;

import com.sabre.services.stl.v01.ApplicationResults;
import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BargainFinderPlusRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:ApplicationResults"/>
 *       &lt;xs:element name="PricedItineraries" minOccurs="0">
 *         &lt;!-- Reference to inner class PricedItineraries -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class BargainFinderPlusRS implements Serializable
{
    private ApplicationResults applicationResults;
    private PricedItineraries pricedItineraries;
    private String version;

    /** 
     * Get the 'ApplicationResults' element value.
     * 
     * @return value
     */
    public ApplicationResults getApplicationResults() {
        return applicationResults;
    }

    /** 
     * Set the 'ApplicationResults' element value.
     * 
     * @param applicationResults
     */
    public void setApplicationResults(ApplicationResults applicationResults) {
        this.applicationResults = applicationResults;
    }

    /** 
     * Get the 'PricedItineraries' element value.
     * 
     * @return value
     */
    public PricedItineraries getPricedItineraries() {
        return pricedItineraries;
    }

    /** 
     * Set the 'PricedItineraries' element value.
     * 
     * @param pricedItineraries
     */
    public void setPricedItineraries(PricedItineraries pricedItineraries) {
        this.pricedItineraries = pricedItineraries;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedItineraries" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PricedItinerary" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class PricedItinerary -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PricedItineraries implements Serializable
    {
        private List<PricedItinerary> pricedItineraryList = new ArrayList<PricedItinerary>();

        /** 
         * Get the list of 'PricedItinerary' element items.
         * 
         * @return list
         */
        public List<PricedItinerary> getPricedItineraryList() {
            return pricedItineraryList;
        }

        /** 
         * Set the list of 'PricedItinerary' element items.
         * 
         * @param list
         */
        public void setPricedItineraryList(List<PricedItinerary> list) {
            pricedItineraryList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedItinerary" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AirItineraryPricingInfo" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class AirItineraryPricingInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="HeaderInformation" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class HeaderInformation -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="SolutionInformation" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class SolutionInformation -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="OriginDestinationOption" minOccurs="0">
         *         &lt;!-- Reference to inner class OriginDestinationOption -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="CustomizeRoutingOption"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="MultiTicket"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="MultiTicketShortText"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ServiceFeeAmount"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ServiceFeeCurrencyCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ServiceFeeTax"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="TotalAmount"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PricedItinerary implements Serializable
        {
            private List<AirItineraryPricingInfo> airItineraryPricingInfoList = new ArrayList<AirItineraryPricingInfo>();
            private List<HeaderInformation> headerInformationList = new ArrayList<HeaderInformation>();
            private List<SolutionInformation> solutionInformationList = new ArrayList<SolutionInformation>();
            private OriginDestinationOption originDestinationOption;
            private String currencyCode;
            private Boolean customizeRoutingOption;
            private Boolean multiTicket;
            private String multiTicketShortText;
            private String RPH;
            private String serviceFeeAmount;
            private String serviceFeeCurrencyCode;
            private String serviceFeeTax;
            private String totalAmount;

            /** 
             * Get the list of 'AirItineraryPricingInfo' element items.
             * 
             * @return list
             */
            public List<AirItineraryPricingInfo> getAirItineraryPricingInfoList() {
                return airItineraryPricingInfoList;
            }

            /** 
             * Set the list of 'AirItineraryPricingInfo' element items.
             * 
             * @param list
             */
            public void setAirItineraryPricingInfoList(
                    List<AirItineraryPricingInfo> list) {
                airItineraryPricingInfoList = list;
            }

            /** 
             * Get the list of 'HeaderInformation' element items.
             * 
             * @return list
             */
            public List<HeaderInformation> getHeaderInformationList() {
                return headerInformationList;
            }

            /** 
             * Set the list of 'HeaderInformation' element items.
             * 
             * @param list
             */
            public void setHeaderInformationList(List<HeaderInformation> list) {
                headerInformationList = list;
            }

            /** 
             * Get the list of 'SolutionInformation' element items.
             * 
             * @return list
             */
            public List<SolutionInformation> getSolutionInformationList() {
                return solutionInformationList;
            }

            /** 
             * Set the list of 'SolutionInformation' element items.
             * 
             * @param list
             */
            public void setSolutionInformationList(
                    List<SolutionInformation> list) {
                solutionInformationList = list;
            }

            /** 
             * Get the 'OriginDestinationOption' element value.
             * 
             * @return value
             */
            public OriginDestinationOption getOriginDestinationOption() {
                return originDestinationOption;
            }

            /** 
             * Set the 'OriginDestinationOption' element value.
             * 
             * @param originDestinationOption
             */
            public void setOriginDestinationOption(
                    OriginDestinationOption originDestinationOption) {
                this.originDestinationOption = originDestinationOption;
            }

            /** 
             * Get the 'CurrencyCode' attribute value.
             * 
             * @return value
             */
            public String getCurrencyCode() {
                return currencyCode;
            }

            /** 
             * Set the 'CurrencyCode' attribute value.
             * 
             * @param currencyCode
             */
            public void setCurrencyCode(String currencyCode) {
                this.currencyCode = currencyCode;
            }

            /** 
             * Get the 'CustomizeRoutingOption' attribute value.
             * 
             * @return value
             */
            public Boolean getCustomizeRoutingOption() {
                return customizeRoutingOption;
            }

            /** 
             * Set the 'CustomizeRoutingOption' attribute value.
             * 
             * @param customizeRoutingOption
             */
            public void setCustomizeRoutingOption(Boolean customizeRoutingOption) {
                this.customizeRoutingOption = customizeRoutingOption;
            }

            /** 
             * Get the 'MultiTicket' attribute value.
             * 
             * @return value
             */
            public Boolean getMultiTicket() {
                return multiTicket;
            }

            /** 
             * Set the 'MultiTicket' attribute value.
             * 
             * @param multiTicket
             */
            public void setMultiTicket(Boolean multiTicket) {
                this.multiTicket = multiTicket;
            }

            /** 
             * Get the 'MultiTicketShortText' attribute value.
             * 
             * @return value
             */
            public String getMultiTicketShortText() {
                return multiTicketShortText;
            }

            /** 
             * Set the 'MultiTicketShortText' attribute value.
             * 
             * @param multiTicketShortText
             */
            public void setMultiTicketShortText(String multiTicketShortText) {
                this.multiTicketShortText = multiTicketShortText;
            }

            /** 
             * Get the 'RPH' attribute value.
             * 
             * @return value
             */
            public String getRPH() {
                return RPH;
            }

            /** 
             * Set the 'RPH' attribute value.
             * 
             * @param RPH
             */
            public void setRPH(String RPH) {
                this.RPH = RPH;
            }

            /** 
             * Get the 'ServiceFeeAmount' attribute value.
             * 
             * @return value
             */
            public String getServiceFeeAmount() {
                return serviceFeeAmount;
            }

            /** 
             * Set the 'ServiceFeeAmount' attribute value.
             * 
             * @param serviceFeeAmount
             */
            public void setServiceFeeAmount(String serviceFeeAmount) {
                this.serviceFeeAmount = serviceFeeAmount;
            }

            /** 
             * Get the 'ServiceFeeCurrencyCode' attribute value.
             * 
             * @return value
             */
            public String getServiceFeeCurrencyCode() {
                return serviceFeeCurrencyCode;
            }

            /** 
             * Set the 'ServiceFeeCurrencyCode' attribute value.
             * 
             * @param serviceFeeCurrencyCode
             */
            public void setServiceFeeCurrencyCode(String serviceFeeCurrencyCode) {
                this.serviceFeeCurrencyCode = serviceFeeCurrencyCode;
            }

            /** 
             * Get the 'ServiceFeeTax' attribute value.
             * 
             * @return value
             */
            public String getServiceFeeTax() {
                return serviceFeeTax;
            }

            /** 
             * Set the 'ServiceFeeTax' attribute value.
             * 
             * @param serviceFeeTax
             */
            public void setServiceFeeTax(String serviceFeeTax) {
                this.serviceFeeTax = serviceFeeTax;
            }

            /** 
             * Get the 'TotalAmount' attribute value.
             * 
             * @return value
             */
            public String getTotalAmount() {
                return totalAmount;
            }

            /** 
             * Set the 'TotalAmount' attribute value.
             * 
             * @param totalAmount
             */
            public void setTotalAmount(String totalAmount) {
                this.totalAmount = totalAmount;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirItineraryPricingInfo" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="AncillaryFeeGroups" minOccurs="0">
             *         &lt;!-- Reference to inner class AncillaryFeeGroups -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="FareAdditionalInfo" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class FareAdditionalInfo -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="FareCalculation" minOccurs="0">
             *         &lt;!-- Reference to inner class FareCalculation -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ItinTotalFare" minOccurs="0">
             *         &lt;!-- Reference to inner class ItinTotalFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="PassengerTypeQuantity" minOccurs="0">
             *         &lt;!-- Reference to inner class PassengerTypeQuantity -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="PTC_FareBreakdown" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class PTCFareBreakdown -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SpecificPenalty" minOccurs="0" maxOccurs="4">
             *         &lt;!-- Reference to inner class SpecificPenalty -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TicketingFees" minOccurs="0">
             *         &lt;!-- Reference to inner class TicketingFees -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="SolutionSequenceNmbr"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AirItineraryPricingInfo implements Serializable
            {
                private AncillaryFeeGroups ancillaryFeeGroups;
                private List<FareAdditionalInfo> fareAdditionalInfoList = new ArrayList<FareAdditionalInfo>();
                private FareCalculation fareCalculation;
                private ItinTotalFare itinTotalFare;
                private PassengerTypeQuantity passengerTypeQuantity;
                private List<PTCFareBreakdown> PTCFareBreakdownList = new ArrayList<PTCFareBreakdown>();
                private List<SpecificPenalty> specificPenaltyList = new ArrayList<SpecificPenalty>();
                private TicketingFees ticketingFees;
                private String solutionSequenceNmbr;

                /** 
                 * Get the 'AncillaryFeeGroups' element value.
                 * 
                 * @return value
                 */
                public AncillaryFeeGroups getAncillaryFeeGroups() {
                    return ancillaryFeeGroups;
                }

                /** 
                 * Set the 'AncillaryFeeGroups' element value.
                 * 
                 * @param ancillaryFeeGroups
                 */
                public void setAncillaryFeeGroups(
                        AncillaryFeeGroups ancillaryFeeGroups) {
                    this.ancillaryFeeGroups = ancillaryFeeGroups;
                }

                /** 
                 * Get the list of 'FareAdditionalInfo' element items.
                 * 
                 * @return list
                 */
                public List<FareAdditionalInfo> getFareAdditionalInfoList() {
                    return fareAdditionalInfoList;
                }

                /** 
                 * Set the list of 'FareAdditionalInfo' element items.
                 * 
                 * @param list
                 */
                public void setFareAdditionalInfoList(
                        List<FareAdditionalInfo> list) {
                    fareAdditionalInfoList = list;
                }

                /** 
                 * Get the 'FareCalculation' element value.
                 * 
                 * @return value
                 */
                public FareCalculation getFareCalculation() {
                    return fareCalculation;
                }

                /** 
                 * Set the 'FareCalculation' element value.
                 * 
                 * @param fareCalculation
                 */
                public void setFareCalculation(FareCalculation fareCalculation) {
                    this.fareCalculation = fareCalculation;
                }

                /** 
                 * Get the 'ItinTotalFare' element value.
                 * 
                 * @return value
                 */
                public ItinTotalFare getItinTotalFare() {
                    return itinTotalFare;
                }

                /** 
                 * Set the 'ItinTotalFare' element value.
                 * 
                 * @param itinTotalFare
                 */
                public void setItinTotalFare(ItinTotalFare itinTotalFare) {
                    this.itinTotalFare = itinTotalFare;
                }

                /** 
                 * Get the 'PassengerTypeQuantity' element value.
                 * 
                 * @return value
                 */
                public PassengerTypeQuantity getPassengerTypeQuantity() {
                    return passengerTypeQuantity;
                }

                /** 
                 * Set the 'PassengerTypeQuantity' element value.
                 * 
                 * @param passengerTypeQuantity
                 */
                public void setPassengerTypeQuantity(
                        PassengerTypeQuantity passengerTypeQuantity) {
                    this.passengerTypeQuantity = passengerTypeQuantity;
                }

                /** 
                 * Get the list of 'PTC_FareBreakdown' element items.
                 * 
                 * @return list
                 */
                public List<PTCFareBreakdown> getPTCFareBreakdownList() {
                    return PTCFareBreakdownList;
                }

                /** 
                 * Set the list of 'PTC_FareBreakdown' element items.
                 * 
                 * @param list
                 */
                public void setPTCFareBreakdownList(List<PTCFareBreakdown> list) {
                    PTCFareBreakdownList = list;
                }

                /** 
                 * Get the list of 'SpecificPenalty' element items.
                 * 
                 * @return list
                 */
                public List<SpecificPenalty> getSpecificPenaltyList() {
                    return specificPenaltyList;
                }

                /** 
                 * Set the list of 'SpecificPenalty' element items.
                 * 
                 * @param list
                 */
                public void setSpecificPenaltyList(List<SpecificPenalty> list) {
                    specificPenaltyList = list;
                }

                /** 
                 * Get the 'TicketingFees' element value.
                 * 
                 * @return value
                 */
                public TicketingFees getTicketingFees() {
                    return ticketingFees;
                }

                /** 
                 * Set the 'TicketingFees' element value.
                 * 
                 * @param ticketingFees
                 */
                public void setTicketingFees(TicketingFees ticketingFees) {
                    this.ticketingFees = ticketingFees;
                }

                /** 
                 * Get the 'SolutionSequenceNmbr' attribute value.
                 * 
                 * @return value
                 */
                public String getSolutionSequenceNmbr() {
                    return solutionSequenceNmbr;
                }

                /** 
                 * Set the 'SolutionSequenceNmbr' attribute value.
                 * 
                 * @param solutionSequenceNmbr
                 */
                public void setSolutionSequenceNmbr(String solutionSequenceNmbr) {
                    this.solutionSequenceNmbr = solutionSequenceNmbr;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryFeeGroups" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="AncillaryFeeGroup" minOccurs="0" maxOccurs="50">
                 *         &lt;!-- Reference to inner class AncillaryFeeGroup -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AncillaryFeeGroups implements Serializable
                {
                    private List<AncillaryFeeGroup> ancillaryFeeGroupList = new ArrayList<AncillaryFeeGroup>();

                    /** 
                     * Get the list of 'AncillaryFeeGroup' element items.
                     * 
                     * @return list
                     */
                    public List<AncillaryFeeGroup> getAncillaryFeeGroupList() {
                        return ancillaryFeeGroupList;
                    }

                    /** 
                     * Set the list of 'AncillaryFeeGroup' element items.
                     * 
                     * @param list
                     */
                    public void setAncillaryFeeGroupList(
                            List<AncillaryFeeGroup> list) {
                        ancillaryFeeGroupList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryFeeGroup" minOccurs="0" maxOccurs="50">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="AncillaryFeeItem" minOccurs="0">
                     *         &lt;!-- Reference to inner class AncillaryFeeItem -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Message"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Name"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class AncillaryFeeGroup implements
                        Serializable
                    {
                        private AncillaryFeeItem ancillaryFeeItem;
                        private String code;
                        private String message;
                        private String name;

                        /** 
                         * Get the 'AncillaryFeeItem' element value.
                         * 
                         * @return value
                         */
                        public AncillaryFeeItem getAncillaryFeeItem() {
                            return ancillaryFeeItem;
                        }

                        /** 
                         * Set the 'AncillaryFeeItem' element value.
                         * 
                         * @param ancillaryFeeItem
                         */
                        public void setAncillaryFeeItem(
                                AncillaryFeeItem ancillaryFeeItem) {
                            this.ancillaryFeeItem = ancillaryFeeItem;
                        }

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'Message' attribute value.
                         * 
                         * @return value
                         */
                        public String getMessage() {
                            return message;
                        }

                        /** 
                         * Set the 'Message' attribute value.
                         * 
                         * @param message
                         */
                        public void setMessage(String message) {
                            this.message = message;
                        }

                        /** 
                         * Get the 'Name' attribute value.
                         * 
                         * @return value
                         */
                        public String getName() {
                            return name;
                        }

                        /** 
                         * Set the 'Name' attribute value.
                         * 
                         * @param name
                         */
                        public void setName(String name) {
                            this.name = name;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryFeeItem" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Carrier"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Date"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Description"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="DestinationAirport"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="EndSegment"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="OriginAirport"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="PassengerCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="StartSegment"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class AncillaryFeeItem implements
                            Serializable
                        {
                            private String amount;
                            private String carrier;
                            private String date;
                            private String description;
                            private String destinationAirport;
                            private String endSegment;
                            private String originAirport;
                            private String passengerCode;
                            private String startSegment;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }

                            /** 
                             * Get the 'Carrier' attribute value.
                             * 
                             * @return value
                             */
                            public String getCarrier() {
                                return carrier;
                            }

                            /** 
                             * Set the 'Carrier' attribute value.
                             * 
                             * @param carrier
                             */
                            public void setCarrier(String carrier) {
                                this.carrier = carrier;
                            }

                            /** 
                             * Get the 'Date' attribute value.
                             * 
                             * @return value
                             */
                            public String getDate() {
                                return date;
                            }

                            /** 
                             * Set the 'Date' attribute value.
                             * 
                             * @param date
                             */
                            public void setDate(String date) {
                                this.date = date;
                            }

                            /** 
                             * Get the 'Description' attribute value.
                             * 
                             * @return value
                             */
                            public String getDescription() {
                                return description;
                            }

                            /** 
                             * Set the 'Description' attribute value.
                             * 
                             * @param description
                             */
                            public void setDescription(String description) {
                                this.description = description;
                            }

                            /** 
                             * Get the 'DestinationAirport' attribute value.
                             * 
                             * @return value
                             */
                            public String getDestinationAirport() {
                                return destinationAirport;
                            }

                            /** 
                             * Set the 'DestinationAirport' attribute value.
                             * 
                             * @param destinationAirport
                             */
                            public void setDestinationAirport(
                                    String destinationAirport) {
                                this.destinationAirport = destinationAirport;
                            }

                            /** 
                             * Get the 'EndSegment' attribute value.
                             * 
                             * @return value
                             */
                            public String getEndSegment() {
                                return endSegment;
                            }

                            /** 
                             * Set the 'EndSegment' attribute value.
                             * 
                             * @param endSegment
                             */
                            public void setEndSegment(String endSegment) {
                                this.endSegment = endSegment;
                            }

                            /** 
                             * Get the 'OriginAirport' attribute value.
                             * 
                             * @return value
                             */
                            public String getOriginAirport() {
                                return originAirport;
                            }

                            /** 
                             * Set the 'OriginAirport' attribute value.
                             * 
                             * @param originAirport
                             */
                            public void setOriginAirport(String originAirport) {
                                this.originAirport = originAirport;
                            }

                            /** 
                             * Get the 'PassengerCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getPassengerCode() {
                                return passengerCode;
                            }

                            /** 
                             * Set the 'PassengerCode' attribute value.
                             * 
                             * @param passengerCode
                             */
                            public void setPassengerCode(String passengerCode) {
                                this.passengerCode = passengerCode;
                            }

                            /** 
                             * Get the 'StartSegment' attribute value.
                             * 
                             * @return value
                             */
                            public String getStartSegment() {
                                return startSegment;
                            }

                            /** 
                             * Set the 'StartSegment' attribute value.
                             * 
                             * @param startSegment
                             */
                            public void setStartSegment(String startSegment) {
                                this.startSegment = startSegment;
                            }
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareAdditionalInfo" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="RetailerRules" minOccurs="0">
                 *         &lt;!-- Reference to inner class RetailerRules -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareAdditionalInfo implements Serializable
                {
                    private RetailerRules retailerRules;

                    /** 
                     * Get the 'RetailerRules' element value.
                     * 
                     * @return value
                     */
                    public RetailerRules getRetailerRules() {
                        return retailerRules;
                    }

                    /** 
                     * Set the 'RetailerRules' element value.
                     * 
                     * @param retailerRules
                     */
                    public void setRetailerRules(RetailerRules retailerRules) {
                        this.retailerRules = retailerRules;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetailerRules" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="DepartureAirportCode" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="ArrivalAirportCode" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="FareBasisCode" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="AdjustmentSellingLevel" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="PricingTransaction" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:integer" use="optional" name="FareBreakComponentSequenceNmbr"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class RetailerRules implements Serializable
                    {
                        private String departureAirportCode;
                        private String arrivalAirportCode;
                        private String fareBasisCode;
                        private String adjustmentSellingLevel;
                        private String pricingTransaction;
                        private BigInteger fareBreakComponentSequenceNmbr;

                        /** 
                         * Get the 'DepartureAirportCode' element value.
                         * 
                         * @return value
                         */
                        public String getDepartureAirportCode() {
                            return departureAirportCode;
                        }

                        /** 
                         * Set the 'DepartureAirportCode' element value.
                         * 
                         * @param departureAirportCode
                         */
                        public void setDepartureAirportCode(
                                String departureAirportCode) {
                            this.departureAirportCode = departureAirportCode;
                        }

                        /** 
                         * Get the 'ArrivalAirportCode' element value.
                         * 
                         * @return value
                         */
                        public String getArrivalAirportCode() {
                            return arrivalAirportCode;
                        }

                        /** 
                         * Set the 'ArrivalAirportCode' element value.
                         * 
                         * @param arrivalAirportCode
                         */
                        public void setArrivalAirportCode(
                                String arrivalAirportCode) {
                            this.arrivalAirportCode = arrivalAirportCode;
                        }

                        /** 
                         * Get the 'FareBasisCode' element value.
                         * 
                         * @return value
                         */
                        public String getFareBasisCode() {
                            return fareBasisCode;
                        }

                        /** 
                         * Set the 'FareBasisCode' element value.
                         * 
                         * @param fareBasisCode
                         */
                        public void setFareBasisCode(String fareBasisCode) {
                            this.fareBasisCode = fareBasisCode;
                        }

                        /** 
                         * Get the 'AdjustmentSellingLevel' element value.
                         * 
                         * @return value
                         */
                        public String getAdjustmentSellingLevel() {
                            return adjustmentSellingLevel;
                        }

                        /** 
                         * Set the 'AdjustmentSellingLevel' element value.
                         * 
                         * @param adjustmentSellingLevel
                         */
                        public void setAdjustmentSellingLevel(
                                String adjustmentSellingLevel) {
                            this.adjustmentSellingLevel = adjustmentSellingLevel;
                        }

                        /** 
                         * Get the 'PricingTransaction' element value.
                         * 
                         * @return value
                         */
                        public String getPricingTransaction() {
                            return pricingTransaction;
                        }

                        /** 
                         * Set the 'PricingTransaction' element value.
                         * 
                         * @param pricingTransaction
                         */
                        public void setPricingTransaction(
                                String pricingTransaction) {
                            this.pricingTransaction = pricingTransaction;
                        }

                        /** 
                         * Get the 'FareBreakComponentSequenceNmbr' attribute value.
                         * 
                         * @return value
                         */
                        public BigInteger getFareBreakComponentSequenceNmbr() {
                            return fareBreakComponentSequenceNmbr;
                        }

                        /** 
                         * Set the 'FareBreakComponentSequenceNmbr' attribute value.
                         * 
                         * @param fareBreakComponentSequenceNmbr
                         */
                        public void setFareBreakComponentSequenceNmbr(
                                BigInteger fareBreakComponentSequenceNmbr) {
                            this.fareBreakComponentSequenceNmbr = fareBreakComponentSequenceNmbr;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareCalculation" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareCalculation implements Serializable
                {
                    private String text;

                    /** 
                     * Get the 'Text' element value.
                     * 
                     * @return value
                     */
                    public String getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value.
                     * 
                     * @param text
                     */
                    public void setText(String text) {
                        this.text = text;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItinTotalFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="BaseFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class BaseFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Commission" minOccurs="0">
                 *         &lt;!-- Reference to inner class Commission -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="DiscountTypeMessage" minOccurs="0"/>
                 *       &lt;xs:element name="Endorsements" minOccurs="0">
                 *         &lt;!-- Reference to inner class Endorsements -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="EquivFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class EquivFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Taxes" minOccurs="0">
                 *         &lt;!-- Reference to inner class Taxes -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                 *       &lt;xs:element name="TotalFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class TotalFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Warnings" minOccurs="0">
                 *         &lt;!-- Reference to inner class Warnings -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="SellingFareData" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class SellingFareData -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ASLFlag"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ItinTotalFare implements Serializable
                {
                    private BaseFare baseFare;
                    private Commission commission;
                    private String discountTypeMessage;
                    private Endorsements endorsements;
                    private EquivFare equivFare;
                    private Taxes taxes;
                    private List<String> textList = new ArrayList<String>();
                    private TotalFare totalFare;
                    private Warnings warnings;
                    private List<SellingFareData> sellingFareDataList = new ArrayList<SellingFareData>();
                    private Boolean ASLFlag;

                    /** 
                     * Get the 'BaseFare' element value.
                     * 
                     * @return value
                     */
                    public BaseFare getBaseFare() {
                        return baseFare;
                    }

                    /** 
                     * Set the 'BaseFare' element value.
                     * 
                     * @param baseFare
                     */
                    public void setBaseFare(BaseFare baseFare) {
                        this.baseFare = baseFare;
                    }

                    /** 
                     * Get the 'Commission' element value.
                     * 
                     * @return value
                     */
                    public Commission getCommission() {
                        return commission;
                    }

                    /** 
                     * Set the 'Commission' element value.
                     * 
                     * @param commission
                     */
                    public void setCommission(Commission commission) {
                        this.commission = commission;
                    }

                    /** 
                     * Get the 'DiscountTypeMessage' element value.
                     * 
                     * @return value
                     */
                    public String getDiscountTypeMessage() {
                        return discountTypeMessage;
                    }

                    /** 
                     * Set the 'DiscountTypeMessage' element value.
                     * 
                     * @param discountTypeMessage
                     */
                    public void setDiscountTypeMessage(
                            String discountTypeMessage) {
                        this.discountTypeMessage = discountTypeMessage;
                    }

                    /** 
                     * Get the 'Endorsements' element value.
                     * 
                     * @return value
                     */
                    public Endorsements getEndorsements() {
                        return endorsements;
                    }

                    /** 
                     * Set the 'Endorsements' element value.
                     * 
                     * @param endorsements
                     */
                    public void setEndorsements(Endorsements endorsements) {
                        this.endorsements = endorsements;
                    }

                    /** 
                     * Get the 'EquivFare' element value.
                     * 
                     * @return value
                     */
                    public EquivFare getEquivFare() {
                        return equivFare;
                    }

                    /** 
                     * Set the 'EquivFare' element value.
                     * 
                     * @param equivFare
                     */
                    public void setEquivFare(EquivFare equivFare) {
                        this.equivFare = equivFare;
                    }

                    /** 
                     * Get the 'Taxes' element value.
                     * 
                     * @return value
                     */
                    public Taxes getTaxes() {
                        return taxes;
                    }

                    /** 
                     * Set the 'Taxes' element value.
                     * 
                     * @param taxes
                     */
                    public void setTaxes(Taxes taxes) {
                        this.taxes = taxes;
                    }

                    /** 
                     * Get the list of 'Text' element items.
                     * 
                     * @return list
                     */
                    public List<String> getTextList() {
                        return textList;
                    }

                    /** 
                     * Set the list of 'Text' element items.
                     * 
                     * @param list
                     */
                    public void setTextList(List<String> list) {
                        textList = list;
                    }

                    /** 
                     * Get the 'TotalFare' element value.
                     * 
                     * @return value
                     */
                    public TotalFare getTotalFare() {
                        return totalFare;
                    }

                    /** 
                     * Set the 'TotalFare' element value.
                     * 
                     * @param totalFare
                     */
                    public void setTotalFare(TotalFare totalFare) {
                        this.totalFare = totalFare;
                    }

                    /** 
                     * Get the 'Warnings' element value.
                     * 
                     * @return value
                     */
                    public Warnings getWarnings() {
                        return warnings;
                    }

                    /** 
                     * Set the 'Warnings' element value.
                     * 
                     * @param warnings
                     */
                    public void setWarnings(Warnings warnings) {
                        this.warnings = warnings;
                    }

                    /** 
                     * Get the list of 'SellingFareData' element items.
                     * 
                     * @return list
                     */
                    public List<SellingFareData> getSellingFareDataList() {
                        return sellingFareDataList;
                    }

                    /** 
                     * Set the list of 'SellingFareData' element items.
                     * 
                     * @param list
                     */
                    public void setSellingFareDataList(
                            List<SellingFareData> list) {
                        sellingFareDataList = list;
                    }

                    /** 
                     * Get the 'ASLFlag' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getASLFlag() {
                        return ASLFlag;
                    }

                    /** 
                     * Set the 'ASLFlag' attribute value.
                     * 
                     * @param ASLFlag
                     */
                    public void setASLFlag(Boolean ASLFlag) {
                        this.ASLFlag = ASLFlag;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class BaseFare implements Serializable
                    {
                        private String amount;
                        private String currencyCode;

                        /** 
                         * Get the 'Amount' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'CurrencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'CurrencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Percent"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Commission implements Serializable
                    {
                        private String amount;
                        private String percent;

                        /** 
                         * Get the 'Amount' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'Percent' attribute value.
                         * 
                         * @return value
                         */
                        public String getPercent() {
                            return percent;
                        }

                        /** 
                         * Set the 'Percent' attribute value.
                         * 
                         * @param percent
                         */
                        public void setPercent(String percent) {
                            this.percent = percent;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Endorsements" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="20"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Endorsements implements Serializable
                    {
                        private List<String> textList = new ArrayList<String>();

                        /** 
                         * Get the list of 'Text' element items.
                         * 
                         * @return list
                         */
                        public List<String> getTextList() {
                            return textList;
                        }

                        /** 
                         * Set the list of 'Text' element items.
                         * 
                         * @param list
                         */
                        public void setTextList(List<String> list) {
                            textList = list;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class EquivFare implements Serializable
                    {
                        private String amount;
                        private String currencyCode;

                        /** 
                         * Get the 'Amount' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'CurrencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'CurrencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class Tax -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Taxes implements Serializable
                    {
                        private List<Tax> taxList = new ArrayList<Tax>();

                        /** 
                         * Get the list of 'Tax' element items.
                         * 
                         * @return list
                         */
                        public List<Tax> getTaxList() {
                            return taxList;
                        }

                        /** 
                         * Set the list of 'Tax' element items.
                         * 
                         * @param list
                         */
                        public void setTaxList(List<Tax> list) {
                            taxList = list;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="TaxCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="TaxName"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="TicketingTaxCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Tax implements Serializable
                        {
                            private String amount;
                            private String taxCode;
                            private String taxName;
                            private String ticketingTaxCode;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }

                            /** 
                             * Get the 'TaxCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getTaxCode() {
                                return taxCode;
                            }

                            /** 
                             * Set the 'TaxCode' attribute value.
                             * 
                             * @param taxCode
                             */
                            public void setTaxCode(String taxCode) {
                                this.taxCode = taxCode;
                            }

                            /** 
                             * Get the 'TaxName' attribute value.
                             * 
                             * @return value
                             */
                            public String getTaxName() {
                                return taxName;
                            }

                            /** 
                             * Set the 'TaxName' attribute value.
                             * 
                             * @param taxName
                             */
                            public void setTaxName(String taxName) {
                                this.taxName = taxName;
                            }

                            /** 
                             * Get the 'TicketingTaxCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getTicketingTaxCode() {
                                return ticketingTaxCode;
                            }

                            /** 
                             * Set the 'TicketingTaxCode' attribute value.
                             * 
                             * @param ticketingTaxCode
                             */
                            public void setTicketingTaxCode(
                                    String ticketingTaxCode) {
                                this.ticketingTaxCode = ticketingTaxCode;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class TotalFare implements Serializable
                    {
                        private String amount;
                        private String currencyCode;

                        /** 
                         * Get the 'Amount' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'CurrencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'CurrencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Warnings" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Warning" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class Warning -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Warnings implements Serializable
                    {
                        private List<Warning> warningList = new ArrayList<Warning>();

                        /** 
                         * Get the list of 'Warning' element items.
                         * 
                         * @return list
                         */
                        public List<Warning> getWarningList() {
                            return warningList;
                        }

                        /** 
                         * Set the list of 'Warning' element items.
                         * 
                         * @param list
                         */
                        public void setWarningList(List<Warning> list) {
                            warningList = list;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Warning" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ShortText"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Warning implements Serializable
                        {
                            private String shortText;

                            /** 
                             * Get the 'ShortText' attribute value.
                             * 
                             * @return value
                             */
                            public String getShortText() {
                                return shortText;
                            }

                            /** 
                             * Set the 'ShortText' attribute value.
                             * 
                             * @param shortText
                             */
                            public void setShortText(String shortText) {
                                this.shortText = shortText;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SellingFareData" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="BaseFare" minOccurs="0">
                     *         &lt;!-- Reference to inner class BaseFare -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="ConstructedTotal" minOccurs="0">
                     *         &lt;!-- Reference to inner class ConstructedTotal -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Equivalent" minOccurs="0">
                     *         &lt;!-- Reference to inner class Equivalent -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="TotalTaxes" minOccurs="0">
                     *         &lt;!-- Reference to inner class TotalTaxes -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="TotalPerPassenger" minOccurs="0">
                     *         &lt;!-- Reference to inner class TotalPerPassenger -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="FareCalculation" minOccurs="0">
                     *         &lt;!-- Reference to inner class FareCalculation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="SellingFareTaxData" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class SellingFareTaxData -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="SellingFareTaxBreakdown" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class SellingFareTaxBreakdown -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Summary" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class Summary -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="LayerTypeName"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class SellingFareData implements Serializable
                    {
                        private BaseFare baseFare;
                        private ConstructedTotal constructedTotal;
                        private Equivalent equivalent;
                        private TotalTaxes totalTaxes;
                        private TotalPerPassenger totalPerPassenger;
                        private FareCalculation fareCalculation;
                        private List<SellingFareTaxData> sellingFareTaxDataList = new ArrayList<SellingFareTaxData>();
                        private List<SellingFareTaxBreakdown> sellingFareTaxBreakdownList = new ArrayList<SellingFareTaxBreakdown>();
                        private List<Summary> summaryList = new ArrayList<Summary>();
                        private String layerTypeName;

                        /** 
                         * Get the 'BaseFare' element value.
                         * 
                         * @return value
                         */
                        public BaseFare getBaseFare() {
                            return baseFare;
                        }

                        /** 
                         * Set the 'BaseFare' element value.
                         * 
                         * @param baseFare
                         */
                        public void setBaseFare(BaseFare baseFare) {
                            this.baseFare = baseFare;
                        }

                        /** 
                         * Get the 'ConstructedTotal' element value.
                         * 
                         * @return value
                         */
                        public ConstructedTotal getConstructedTotal() {
                            return constructedTotal;
                        }

                        /** 
                         * Set the 'ConstructedTotal' element value.
                         * 
                         * @param constructedTotal
                         */
                        public void setConstructedTotal(
                                ConstructedTotal constructedTotal) {
                            this.constructedTotal = constructedTotal;
                        }

                        /** 
                         * Get the 'Equivalent' element value.
                         * 
                         * @return value
                         */
                        public Equivalent getEquivalent() {
                            return equivalent;
                        }

                        /** 
                         * Set the 'Equivalent' element value.
                         * 
                         * @param equivalent
                         */
                        public void setEquivalent(Equivalent equivalent) {
                            this.equivalent = equivalent;
                        }

                        /** 
                         * Get the 'TotalTaxes' element value.
                         * 
                         * @return value
                         */
                        public TotalTaxes getTotalTaxes() {
                            return totalTaxes;
                        }

                        /** 
                         * Set the 'TotalTaxes' element value.
                         * 
                         * @param totalTaxes
                         */
                        public void setTotalTaxes(TotalTaxes totalTaxes) {
                            this.totalTaxes = totalTaxes;
                        }

                        /** 
                         * Get the 'TotalPerPassenger' element value.
                         * 
                         * @return value
                         */
                        public TotalPerPassenger getTotalPerPassenger() {
                            return totalPerPassenger;
                        }

                        /** 
                         * Set the 'TotalPerPassenger' element value.
                         * 
                         * @param totalPerPassenger
                         */
                        public void setTotalPerPassenger(
                                TotalPerPassenger totalPerPassenger) {
                            this.totalPerPassenger = totalPerPassenger;
                        }

                        /** 
                         * Get the 'FareCalculation' element value.
                         * 
                         * @return value
                         */
                        public FareCalculation getFareCalculation() {
                            return fareCalculation;
                        }

                        /** 
                         * Set the 'FareCalculation' element value.
                         * 
                         * @param fareCalculation
                         */
                        public void setFareCalculation(
                                FareCalculation fareCalculation) {
                            this.fareCalculation = fareCalculation;
                        }

                        /** 
                         * Get the list of 'SellingFareTaxData' element items.
                         * 
                         * @return list
                         */
                        public List<SellingFareTaxData> getSellingFareTaxDataList() {
                            return sellingFareTaxDataList;
                        }

                        /** 
                         * Set the list of 'SellingFareTaxData' element items.
                         * 
                         * @param list
                         */
                        public void setSellingFareTaxDataList(
                                List<SellingFareTaxData> list) {
                            sellingFareTaxDataList = list;
                        }

                        /** 
                         * Get the list of 'SellingFareTaxBreakdown' element items.
                         * 
                         * @return list
                         */
                        public List<SellingFareTaxBreakdown> getSellingFareTaxBreakdownList() {
                            return sellingFareTaxBreakdownList;
                        }

                        /** 
                         * Set the list of 'SellingFareTaxBreakdown' element items.
                         * 
                         * @param list
                         */
                        public void setSellingFareTaxBreakdownList(
                                List<SellingFareTaxBreakdown> list) {
                            sellingFareTaxBreakdownList = list;
                        }

                        /** 
                         * Get the list of 'Summary' element items.
                         * 
                         * @return list
                         */
                        public List<Summary> getSummaryList() {
                            return summaryList;
                        }

                        /** 
                         * Set the list of 'Summary' element items.
                         * 
                         * @param list
                         */
                        public void setSummaryList(List<Summary> list) {
                            summaryList = list;
                        }

                        /** 
                         * Get the 'LayerTypeName' attribute value.
                         * 
                         * @return value
                         */
                        public String getLayerTypeName() {
                            return layerTypeName;
                        }

                        /** 
                         * Set the 'LayerTypeName' attribute value.
                         * 
                         * @param layerTypeName
                         */
                        public void setLayerTypeName(String layerTypeName) {
                            this.layerTypeName = layerTypeName;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class BaseFare implements Serializable
                        {
                            private String amount;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConstructedTotal" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class ConstructedTotal implements
                            Serializable
                        {
                            private String amount;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Equivalent" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Equivalent implements Serializable
                        {
                            private String amount;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTaxes" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class TotalTaxes implements Serializable
                        {
                            private String amount;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalPerPassenger" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class TotalPerPassenger implements
                            Serializable
                        {
                            private String amount;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareCalculation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class FareCalculation implements
                            Serializable
                        {
                            private String text;

                            /** 
                             * Get the 'Text' element value.
                             * 
                             * @return value
                             */
                            public String getText() {
                                return text;
                            }

                            /** 
                             * Set the 'Text' element value.
                             * 
                             * @param text
                             */
                            public void setText(String text) {
                                this.text = text;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SellingFareTaxData" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Tax" minOccurs="0">
                         *         &lt;!-- Reference to inner class Tax -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class SellingFareTaxData implements
                            Serializable
                        {
                            private Tax tax;

                            /** 
                             * Get the 'Tax' element value.
                             * 
                             * @return value
                             */
                            public Tax getTax() {
                                return tax;
                            }

                            /** 
                             * Set the 'Tax' element value.
                             * 
                             * @param tax
                             */
                            public void setTax(Tax tax) {
                                this.tax = tax;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Description"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="AmountPublished"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="PublishedCurrencyCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="StationCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CountryCode"/>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="GoodAndServicesInd"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Tax implements Serializable
                            {
                                private String code;
                                private String description;
                                private String amount;
                                private String currencyCode;
                                private String amountPublished;
                                private String publishedCurrencyCode;
                                private String stationCode;
                                private String countryCode;
                                private Boolean goodAndServicesInd;

                                /** 
                                 * Get the 'Code' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCode() {
                                    return code;
                                }

                                /** 
                                 * Set the 'Code' attribute value.
                                 * 
                                 * @param code
                                 */
                                public void setCode(String code) {
                                    this.code = code;
                                }

                                /** 
                                 * Get the 'Description' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getDescription() {
                                    return description;
                                }

                                /** 
                                 * Set the 'Description' attribute value.
                                 * 
                                 * @param description
                                 */
                                public void setDescription(String description) {
                                    this.description = description;
                                }

                                /** 
                                 * Get the 'Amount' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value.
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(String amount) {
                                    this.amount = amount;
                                }

                                /** 
                                 * Get the 'CurrencyCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCurrencyCode() {
                                    return currencyCode;
                                }

                                /** 
                                 * Set the 'CurrencyCode' attribute value.
                                 * 
                                 * @param currencyCode
                                 */
                                public void setCurrencyCode(String currencyCode) {
                                    this.currencyCode = currencyCode;
                                }

                                /** 
                                 * Get the 'AmountPublished' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getAmountPublished() {
                                    return amountPublished;
                                }

                                /** 
                                 * Set the 'AmountPublished' attribute value.
                                 * 
                                 * @param amountPublished
                                 */
                                public void setAmountPublished(
                                        String amountPublished) {
                                    this.amountPublished = amountPublished;
                                }

                                /** 
                                 * Get the 'PublishedCurrencyCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getPublishedCurrencyCode() {
                                    return publishedCurrencyCode;
                                }

                                /** 
                                 * Set the 'PublishedCurrencyCode' attribute value.
                                 * 
                                 * @param publishedCurrencyCode
                                 */
                                public void setPublishedCurrencyCode(
                                        String publishedCurrencyCode) {
                                    this.publishedCurrencyCode = publishedCurrencyCode;
                                }

                                /** 
                                 * Get the 'StationCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getStationCode() {
                                    return stationCode;
                                }

                                /** 
                                 * Set the 'StationCode' attribute value.
                                 * 
                                 * @param stationCode
                                 */
                                public void setStationCode(String stationCode) {
                                    this.stationCode = stationCode;
                                }

                                /** 
                                 * Get the 'CountryCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCountryCode() {
                                    return countryCode;
                                }

                                /** 
                                 * Set the 'CountryCode' attribute value.
                                 * 
                                 * @param countryCode
                                 */
                                public void setCountryCode(String countryCode) {
                                    this.countryCode = countryCode;
                                }

                                /** 
                                 * Get the 'GoodAndServicesInd' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getGoodAndServicesInd() {
                                    return goodAndServicesInd;
                                }

                                /** 
                                 * Set the 'GoodAndServicesInd' attribute value.
                                 * 
                                 * @param goodAndServicesInd
                                 */
                                public void setGoodAndServicesInd(
                                        Boolean goodAndServicesInd) {
                                    this.goodAndServicesInd = goodAndServicesInd;
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SellingFareTaxBreakdown" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="TaxBreakDown" minOccurs="0">
                         *         &lt;!-- Reference to inner class TaxBreakDown -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class SellingFareTaxBreakdown implements
                            Serializable
                        {
                            private TaxBreakDown taxBreakDown;

                            /** 
                             * Get the 'TaxBreakDown' element value.
                             * 
                             * @return value
                             */
                            public TaxBreakDown getTaxBreakDown() {
                                return taxBreakDown;
                            }

                            /** 
                             * Set the 'TaxBreakDown' element value.
                             * 
                             * @param taxBreakDown
                             */
                            public void setTaxBreakDown(
                                    TaxBreakDown taxBreakDown) {
                                this.taxBreakDown = taxBreakDown;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxBreakDown" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Description"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="AmountPublished"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="PublishedCurrencyCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="StationCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CountryCode"/>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="GoodAndServicesInd"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="AirlineCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="TaxType"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class TaxBreakDown implements
                                Serializable
                            {
                                private String code;
                                private String description;
                                private String amount;
                                private String currencyCode;
                                private String amountPublished;
                                private String publishedCurrencyCode;
                                private String stationCode;
                                private String countryCode;
                                private Boolean goodAndServicesInd;
                                private String airlineCode;
                                private String taxType;

                                /** 
                                 * Get the 'Code' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCode() {
                                    return code;
                                }

                                /** 
                                 * Set the 'Code' attribute value.
                                 * 
                                 * @param code
                                 */
                                public void setCode(String code) {
                                    this.code = code;
                                }

                                /** 
                                 * Get the 'Description' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getDescription() {
                                    return description;
                                }

                                /** 
                                 * Set the 'Description' attribute value.
                                 * 
                                 * @param description
                                 */
                                public void setDescription(String description) {
                                    this.description = description;
                                }

                                /** 
                                 * Get the 'Amount' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value.
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(String amount) {
                                    this.amount = amount;
                                }

                                /** 
                                 * Get the 'CurrencyCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCurrencyCode() {
                                    return currencyCode;
                                }

                                /** 
                                 * Set the 'CurrencyCode' attribute value.
                                 * 
                                 * @param currencyCode
                                 */
                                public void setCurrencyCode(String currencyCode) {
                                    this.currencyCode = currencyCode;
                                }

                                /** 
                                 * Get the 'AmountPublished' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getAmountPublished() {
                                    return amountPublished;
                                }

                                /** 
                                 * Set the 'AmountPublished' attribute value.
                                 * 
                                 * @param amountPublished
                                 */
                                public void setAmountPublished(
                                        String amountPublished) {
                                    this.amountPublished = amountPublished;
                                }

                                /** 
                                 * Get the 'PublishedCurrencyCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getPublishedCurrencyCode() {
                                    return publishedCurrencyCode;
                                }

                                /** 
                                 * Set the 'PublishedCurrencyCode' attribute value.
                                 * 
                                 * @param publishedCurrencyCode
                                 */
                                public void setPublishedCurrencyCode(
                                        String publishedCurrencyCode) {
                                    this.publishedCurrencyCode = publishedCurrencyCode;
                                }

                                /** 
                                 * Get the 'StationCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getStationCode() {
                                    return stationCode;
                                }

                                /** 
                                 * Set the 'StationCode' attribute value.
                                 * 
                                 * @param stationCode
                                 */
                                public void setStationCode(String stationCode) {
                                    this.stationCode = stationCode;
                                }

                                /** 
                                 * Get the 'CountryCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCountryCode() {
                                    return countryCode;
                                }

                                /** 
                                 * Set the 'CountryCode' attribute value.
                                 * 
                                 * @param countryCode
                                 */
                                public void setCountryCode(String countryCode) {
                                    this.countryCode = countryCode;
                                }

                                /** 
                                 * Get the 'GoodAndServicesInd' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getGoodAndServicesInd() {
                                    return goodAndServicesInd;
                                }

                                /** 
                                 * Set the 'GoodAndServicesInd' attribute value.
                                 * 
                                 * @param goodAndServicesInd
                                 */
                                public void setGoodAndServicesInd(
                                        Boolean goodAndServicesInd) {
                                    this.goodAndServicesInd = goodAndServicesInd;
                                }

                                /** 
                                 * Get the 'AirlineCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getAirlineCode() {
                                    return airlineCode;
                                }

                                /** 
                                 * Set the 'AirlineCode' attribute value.
                                 * 
                                 * @param airlineCode
                                 */
                                public void setAirlineCode(String airlineCode) {
                                    this.airlineCode = airlineCode;
                                }

                                /** 
                                 * Get the 'TaxType' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getTaxType() {
                                    return taxType;
                                }

                                /** 
                                 * Set the 'TaxType' attribute value.
                                 * 
                                 * @param taxType
                                 */
                                public void setTaxType(String taxType) {
                                    this.taxType = taxType;
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Summary" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Markup" minOccurs="0">
                         *         &lt;!-- Reference to inner class Markup -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Summary implements Serializable
                        {
                            private Markup markup;

                            /** 
                             * Get the 'Markup' element value.
                             * 
                             * @return value
                             */
                            public Markup getMarkup() {
                                return markup;
                            }

                            /** 
                             * Set the 'Markup' element value.
                             * 
                             * @param markup
                             */
                            public void setMarkup(Markup markup) {
                                this.markup = markup;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Markup" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Description"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Markup implements Serializable
                            {
                                private String code;
                                private String description;
                                private String amount;

                                /** 
                                 * Get the 'Code' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCode() {
                                    return code;
                                }

                                /** 
                                 * Set the 'Code' attribute value.
                                 * 
                                 * @param code
                                 */
                                public void setCode(String code) {
                                    this.code = code;
                                }

                                /** 
                                 * Get the 'Description' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getDescription() {
                                    return description;
                                }

                                /** 
                                 * Set the 'Description' attribute value.
                                 * 
                                 * @param description
                                 */
                                public void setDescription(String description) {
                                    this.description = description;
                                }

                                /** 
                                 * Get the 'Amount' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value.
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(String amount) {
                                    this.amount = amount;
                                }
                            }
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerTypeQuantity" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Group"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Quantity"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PassengerTypeQuantity implements
                    Serializable
                {
                    private String code;
                    private String group;
                    private String quantity;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'Group' attribute value.
                     * 
                     * @return value
                     */
                    public String getGroup() {
                        return group;
                    }

                    /** 
                     * Set the 'Group' attribute value.
                     * 
                     * @param group
                     */
                    public void setGroup(String group) {
                        this.group = group;
                    }

                    /** 
                     * Get the 'Quantity' attribute value.
                     * 
                     * @return value
                     */
                    public String getQuantity() {
                        return quantity;
                    }

                    /** 
                     * Set the 'Quantity' attribute value.
                     * 
                     * @param quantity
                     */
                    public void setQuantity(String quantity) {
                        this.quantity = quantity;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PTC_FareBreakdown" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="BrandedFareInformation" minOccurs="0">
                 *         &lt;!-- Reference to inner class BrandedFareInformation -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="Cabin" minOccurs="0"/>
                 *       &lt;xs:element name="FareBasis" minOccurs="0">
                 *         &lt;!-- Reference to inner class FareBasis -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Surcharges" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Surcharges -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PTCFareBreakdown implements Serializable
                {
                    private BrandedFareInformation brandedFareInformation;
                    private String cabin;
                    private FareBasis fareBasis;
                    private List<Surcharges> surchargeList = new ArrayList<Surcharges>();

                    /** 
                     * Get the 'BrandedFareInformation' element value.
                     * 
                     * @return value
                     */
                    public BrandedFareInformation getBrandedFareInformation() {
                        return brandedFareInformation;
                    }

                    /** 
                     * Set the 'BrandedFareInformation' element value.
                     * 
                     * @param brandedFareInformation
                     */
                    public void setBrandedFareInformation(
                            BrandedFareInformation brandedFareInformation) {
                        this.brandedFareInformation = brandedFareInformation;
                    }

                    /** 
                     * Get the 'Cabin' element value.
                     * 
                     * @return value
                     */
                    public String getCabin() {
                        return cabin;
                    }

                    /** 
                     * Set the 'Cabin' element value.
                     * 
                     * @param cabin
                     */
                    public void setCabin(String cabin) {
                        this.cabin = cabin;
                    }

                    /** 
                     * Get the 'FareBasis' element value.
                     * 
                     * @return value
                     */
                    public FareBasis getFareBasis() {
                        return fareBasis;
                    }

                    /** 
                     * Set the 'FareBasis' element value.
                     * 
                     * @param fareBasis
                     */
                    public void setFareBasis(FareBasis fareBasis) {
                        this.fareBasis = fareBasis;
                    }

                    /** 
                     * Get the list of 'Surcharges' element items.
                     * 
                     * @return list
                     */
                    public List<Surcharges> getSurchargeList() {
                        return surchargeList;
                    }

                    /** 
                     * Set the list of 'Surcharges' element items.
                     * 
                     * @param list
                     */
                    public void setSurchargeList(List<Surcharges> list) {
                        surchargeList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BrandedFareInformation" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="BrandCode" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class BrandedFareInformation implements
                        Serializable
                    {
                        private String brandCode;

                        /** 
                         * Get the 'BrandCode' element value.
                         * 
                         * @return value
                         */
                        public String getBrandCode() {
                            return brandCode;
                        }

                        /** 
                         * Set the 'BrandCode' element value.
                         * 
                         * @param brandCode
                         */
                        public void setBrandCode(String brandCode) {
                            this.brandCode = brandCode;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBasis" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ContractNumber"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CorporateID"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="FarePassengerType"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="FareType"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="FilingCarrier"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="GlobalInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Market"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="PrivateFareInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="TicketDesignator"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FareBasis implements Serializable
                    {
                        private String code;
                        private String contractNumber;
                        private String corporateID;
                        private String farePassengerType;
                        private String fareType;
                        private String filingCarrier;
                        private String globalInd;
                        private String market;
                        private String privateFareInd;
                        private String ticketDesignator;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'ContractNumber' attribute value.
                         * 
                         * @return value
                         */
                        public String getContractNumber() {
                            return contractNumber;
                        }

                        /** 
                         * Set the 'ContractNumber' attribute value.
                         * 
                         * @param contractNumber
                         */
                        public void setContractNumber(String contractNumber) {
                            this.contractNumber = contractNumber;
                        }

                        /** 
                         * Get the 'CorporateID' attribute value.
                         * 
                         * @return value
                         */
                        public String getCorporateID() {
                            return corporateID;
                        }

                        /** 
                         * Set the 'CorporateID' attribute value.
                         * 
                         * @param corporateID
                         */
                        public void setCorporateID(String corporateID) {
                            this.corporateID = corporateID;
                        }

                        /** 
                         * Get the 'FarePassengerType' attribute value.
                         * 
                         * @return value
                         */
                        public String getFarePassengerType() {
                            return farePassengerType;
                        }

                        /** 
                         * Set the 'FarePassengerType' attribute value.
                         * 
                         * @param farePassengerType
                         */
                        public void setFarePassengerType(
                                String farePassengerType) {
                            this.farePassengerType = farePassengerType;
                        }

                        /** 
                         * Get the 'FareType' attribute value.
                         * 
                         * @return value
                         */
                        public String getFareType() {
                            return fareType;
                        }

                        /** 
                         * Set the 'FareType' attribute value.
                         * 
                         * @param fareType
                         */
                        public void setFareType(String fareType) {
                            this.fareType = fareType;
                        }

                        /** 
                         * Get the 'FilingCarrier' attribute value.
                         * 
                         * @return value
                         */
                        public String getFilingCarrier() {
                            return filingCarrier;
                        }

                        /** 
                         * Set the 'FilingCarrier' attribute value.
                         * 
                         * @param filingCarrier
                         */
                        public void setFilingCarrier(String filingCarrier) {
                            this.filingCarrier = filingCarrier;
                        }

                        /** 
                         * Get the 'GlobalInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getGlobalInd() {
                            return globalInd;
                        }

                        /** 
                         * Set the 'GlobalInd' attribute value.
                         * 
                         * @param globalInd
                         */
                        public void setGlobalInd(String globalInd) {
                            this.globalInd = globalInd;
                        }

                        /** 
                         * Get the 'Market' attribute value.
                         * 
                         * @return value
                         */
                        public String getMarket() {
                            return market;
                        }

                        /** 
                         * Set the 'Market' attribute value.
                         * 
                         * @param market
                         */
                        public void setMarket(String market) {
                            this.market = market;
                        }

                        /** 
                         * Get the 'PrivateFareInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getPrivateFareInd() {
                            return privateFareInd;
                        }

                        /** 
                         * Set the 'PrivateFareInd' attribute value.
                         * 
                         * @param privateFareInd
                         */
                        public void setPrivateFareInd(String privateFareInd) {
                            this.privateFareInd = privateFareInd;
                        }

                        /** 
                         * Get the 'TicketDesignator' attribute value.
                         * 
                         * @return value
                         */
                        public String getTicketDesignator() {
                            return ticketDesignator;
                        }

                        /** 
                         * Set the 'TicketDesignator' attribute value.
                         * 
                         * @param ticketDesignator
                         */
                        public void setTicketDesignator(String ticketDesignator) {
                            this.ticketDesignator = ticketDesignator;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharges" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:string">
                     *         &lt;xs:attribute type="xs:string" use="optional" name="Ind"/>
                     *         &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Surcharges implements Serializable
                    {
                        private String string;
                        private String ind;
                        private String type;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public String getString() {
                            return string;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param string
                         */
                        public void setString(String string) {
                            this.string = string;
                        }

                        /** 
                         * Get the 'Ind' attribute value.
                         * 
                         * @return value
                         */
                        public String getInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value.
                         * 
                         * @param ind
                         */
                        public void setInd(String ind) {
                            this.ind = ind;
                        }

                        /** 
                         * Get the 'Type' attribute value.
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value.
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecificPenalty" minOccurs="0" maxOccurs="4">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="PenaltyInformation" minOccurs="0">
                 *         &lt;!-- Reference to inner class PenaltyInformation -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SpecificPenalty implements Serializable
                {
                    private PenaltyInformation penaltyInformation;

                    /** 
                     * Get the 'PenaltyInformation' element value.
                     * 
                     * @return value
                     */
                    public PenaltyInformation getPenaltyInformation() {
                        return penaltyInformation;
                    }

                    /** 
                     * Set the 'PenaltyInformation' element value.
                     * 
                     * @param penaltyInformation
                     */
                    public void setPenaltyInformation(
                            PenaltyInformation penaltyInformation) {
                        this.penaltyInformation = penaltyInformation;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PenaltyInformation" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="FareBasisCode" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element type="xs:string" name="FareComponent" minOccurs="0" maxOccurs="unbounded"/>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Cat16"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Currency"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="NotApplicable"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class PenaltyInformation implements
                        Serializable
                    {
                        private List<String> fareBasisCodeList = new ArrayList<String>();
                        private List<String> fareComponentList = new ArrayList<String>();
                        private String amount;
                        private Boolean cat16;
                        private String currency;
                        private Boolean notApplicable;
                        private String type;

                        /** 
                         * Get the list of 'FareBasisCode' element items.
                         * 
                         * @return list
                         */
                        public List<String> getFareBasisCodeList() {
                            return fareBasisCodeList;
                        }

                        /** 
                         * Set the list of 'FareBasisCode' element items.
                         * 
                         * @param list
                         */
                        public void setFareBasisCodeList(List<String> list) {
                            fareBasisCodeList = list;
                        }

                        /** 
                         * Get the list of 'FareComponent' element items.
                         * 
                         * @return list
                         */
                        public List<String> getFareComponentList() {
                            return fareComponentList;
                        }

                        /** 
                         * Set the list of 'FareComponent' element items.
                         * 
                         * @param list
                         */
                        public void setFareComponentList(List<String> list) {
                            fareComponentList = list;
                        }

                        /** 
                         * Get the 'Amount' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'Cat16' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getCat16() {
                            return cat16;
                        }

                        /** 
                         * Set the 'Cat16' attribute value.
                         * 
                         * @param cat16
                         */
                        public void setCat16(Boolean cat16) {
                            this.cat16 = cat16;
                        }

                        /** 
                         * Get the 'Currency' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrency() {
                            return currency;
                        }

                        /** 
                         * Set the 'Currency' attribute value.
                         * 
                         * @param currency
                         */
                        public void setCurrency(String currency) {
                            this.currency = currency;
                        }

                        /** 
                         * Get the 'NotApplicable' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getNotApplicable() {
                            return notApplicable;
                        }

                        /** 
                         * Set the 'NotApplicable' attribute value.
                         * 
                         * @param notApplicable
                         */
                        public void setNotApplicable(Boolean notApplicable) {
                            this.notApplicable = notApplicable;
                        }

                        /** 
                         * Get the 'Type' attribute value.
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value.
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingFees" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="FeeInformation" minOccurs="0">
                 *         &lt;!-- Reference to inner class FeeInformation -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TicketingFees implements Serializable
                {
                    private FeeInformation feeInformation;

                    /** 
                     * Get the 'FeeInformation' element value.
                     * 
                     * @return value
                     */
                    public FeeInformation getFeeInformation() {
                        return feeInformation;
                    }

                    /** 
                     * Set the 'FeeInformation' element value.
                     * 
                     * @param feeInformation
                     */
                    public void setFeeInformation(FeeInformation feeInformation) {
                        this.feeInformation = feeInformation;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeeInformation" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FeeInformation implements Serializable
                    {
                        private String amount;

                        /** 
                         * Get the 'Amount' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HeaderInformation" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:date" name="DepartureDate" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="LastTicketingDate" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element name="ValidatingCarrier" minOccurs="0">
             *         &lt;!-- Reference to inner class ValidatingCarrier -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="SolutionSequenceNmbr"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class HeaderInformation implements Serializable
            {
                private Date departureDate;
                private String lastTicketingDate;
                private List<String> textList = new ArrayList<String>();
                private ValidatingCarrier validatingCarrier;
                private String solutionSequenceNmbr;

                /** 
                 * Get the 'DepartureDate' element value.
                 * 
                 * @return value
                 */
                public Date getDepartureDate() {
                    return departureDate;
                }

                /** 
                 * Set the 'DepartureDate' element value.
                 * 
                 * @param departureDate
                 */
                public void setDepartureDate(Date departureDate) {
                    this.departureDate = departureDate;
                }

                /** 
                 * Get the 'LastTicketingDate' element value.
                 * 
                 * @return value
                 */
                public String getLastTicketingDate() {
                    return lastTicketingDate;
                }

                /** 
                 * Set the 'LastTicketingDate' element value.
                 * 
                 * @param lastTicketingDate
                 */
                public void setLastTicketingDate(String lastTicketingDate) {
                    this.lastTicketingDate = lastTicketingDate;
                }

                /** 
                 * Get the list of 'Text' element items.
                 * 
                 * @return list
                 */
                public List<String> getTextList() {
                    return textList;
                }

                /** 
                 * Set the list of 'Text' element items.
                 * 
                 * @param list
                 */
                public void setTextList(List<String> list) {
                    textList = list;
                }

                /** 
                 * Get the 'ValidatingCarrier' element value.
                 * 
                 * @return value
                 */
                public ValidatingCarrier getValidatingCarrier() {
                    return validatingCarrier;
                }

                /** 
                 * Set the 'ValidatingCarrier' element value.
                 * 
                 * @param validatingCarrier
                 */
                public void setValidatingCarrier(
                        ValidatingCarrier validatingCarrier) {
                    this.validatingCarrier = validatingCarrier;
                }

                /** 
                 * Get the 'SolutionSequenceNmbr' attribute value.
                 * 
                 * @return value
                 */
                public String getSolutionSequenceNmbr() {
                    return solutionSequenceNmbr;
                }

                /** 
                 * Set the 'SolutionSequenceNmbr' attribute value.
                 * 
                 * @param solutionSequenceNmbr
                 */
                public void setSolutionSequenceNmbr(String solutionSequenceNmbr) {
                    this.solutionSequenceNmbr = solutionSequenceNmbr;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidatingCarrier" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ValidatingCarrier implements Serializable
                {
                    private String code;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SolutionInformation" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="CurrencyCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="FareStatus" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="FulfillmentPseudoCityCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="SegmentNumber" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="xs:string" name="ServiceFeeCurrency" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="xs:string" name="TicketNumber" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="TotalAmount" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="TotalServiceFeeAmount" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="TotalServiceTax" minOccurs="0"/>
             *       &lt;xs:element name="ValidatingCarrier" minOccurs="0" maxOccurs="9">
             *         &lt;!-- Reference to inner class ValidatingCarrier -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="AggregatedContent"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="FlexFaresSequenceNmbr"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="PricingSubSource"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="SolutionSequenceNmbr"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SolutionInformation implements Serializable
            {
                private String currencyCode;
                private String fareStatus;
                private String fulfillmentPseudoCityCode;
                private List<String> segmentNumberList = new ArrayList<String>();
                private String serviceFeeCurrency;
                private List<String> textList = new ArrayList<String>();
                private String ticketNumber;
                private String totalAmount;
                private String totalServiceFeeAmount;
                private String totalServiceTax;
                private List<ValidatingCarrier> validatingCarrierList = new ArrayList<ValidatingCarrier>();
                private Boolean aggregatedContent;
                private String flexFaresSequenceNmbr;
                private String pricingSubSource;
                private String solutionSequenceNmbr;

                /** 
                 * Get the 'CurrencyCode' element value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' element value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'FareStatus' element value.
                 * 
                 * @return value
                 */
                public String getFareStatus() {
                    return fareStatus;
                }

                /** 
                 * Set the 'FareStatus' element value.
                 * 
                 * @param fareStatus
                 */
                public void setFareStatus(String fareStatus) {
                    this.fareStatus = fareStatus;
                }

                /** 
                 * Get the 'FulfillmentPseudoCityCode' element value.
                 * 
                 * @return value
                 */
                public String getFulfillmentPseudoCityCode() {
                    return fulfillmentPseudoCityCode;
                }

                /** 
                 * Set the 'FulfillmentPseudoCityCode' element value.
                 * 
                 * @param fulfillmentPseudoCityCode
                 */
                public void setFulfillmentPseudoCityCode(
                        String fulfillmentPseudoCityCode) {
                    this.fulfillmentPseudoCityCode = fulfillmentPseudoCityCode;
                }

                /** 
                 * Get the list of 'SegmentNumber' element items.
                 * 
                 * @return list
                 */
                public List<String> getSegmentNumberList() {
                    return segmentNumberList;
                }

                /** 
                 * Set the list of 'SegmentNumber' element items.
                 * 
                 * @param list
                 */
                public void setSegmentNumberList(List<String> list) {
                    segmentNumberList = list;
                }

                /** 
                 * Get the 'ServiceFeeCurrency' element value.
                 * 
                 * @return value
                 */
                public String getServiceFeeCurrency() {
                    return serviceFeeCurrency;
                }

                /** 
                 * Set the 'ServiceFeeCurrency' element value.
                 * 
                 * @param serviceFeeCurrency
                 */
                public void setServiceFeeCurrency(String serviceFeeCurrency) {
                    this.serviceFeeCurrency = serviceFeeCurrency;
                }

                /** 
                 * Get the list of 'Text' element items.
                 * 
                 * @return list
                 */
                public List<String> getTextList() {
                    return textList;
                }

                /** 
                 * Set the list of 'Text' element items.
                 * 
                 * @param list
                 */
                public void setTextList(List<String> list) {
                    textList = list;
                }

                /** 
                 * Get the 'TicketNumber' element value.
                 * 
                 * @return value
                 */
                public String getTicketNumber() {
                    return ticketNumber;
                }

                /** 
                 * Set the 'TicketNumber' element value.
                 * 
                 * @param ticketNumber
                 */
                public void setTicketNumber(String ticketNumber) {
                    this.ticketNumber = ticketNumber;
                }

                /** 
                 * Get the 'TotalAmount' element value.
                 * 
                 * @return value
                 */
                public String getTotalAmount() {
                    return totalAmount;
                }

                /** 
                 * Set the 'TotalAmount' element value.
                 * 
                 * @param totalAmount
                 */
                public void setTotalAmount(String totalAmount) {
                    this.totalAmount = totalAmount;
                }

                /** 
                 * Get the 'TotalServiceFeeAmount' element value.
                 * 
                 * @return value
                 */
                public String getTotalServiceFeeAmount() {
                    return totalServiceFeeAmount;
                }

                /** 
                 * Set the 'TotalServiceFeeAmount' element value.
                 * 
                 * @param totalServiceFeeAmount
                 */
                public void setTotalServiceFeeAmount(
                        String totalServiceFeeAmount) {
                    this.totalServiceFeeAmount = totalServiceFeeAmount;
                }

                /** 
                 * Get the 'TotalServiceTax' element value.
                 * 
                 * @return value
                 */
                public String getTotalServiceTax() {
                    return totalServiceTax;
                }

                /** 
                 * Set the 'TotalServiceTax' element value.
                 * 
                 * @param totalServiceTax
                 */
                public void setTotalServiceTax(String totalServiceTax) {
                    this.totalServiceTax = totalServiceTax;
                }

                /** 
                 * Get the list of 'ValidatingCarrier' element items.
                 * 
                 * @return list
                 */
                public List<ValidatingCarrier> getValidatingCarrierList() {
                    return validatingCarrierList;
                }

                /** 
                 * Set the list of 'ValidatingCarrier' element items.
                 * 
                 * @param list
                 */
                public void setValidatingCarrierList(
                        List<ValidatingCarrier> list) {
                    validatingCarrierList = list;
                }

                /** 
                 * Get the 'AggregatedContent' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getAggregatedContent() {
                    return aggregatedContent;
                }

                /** 
                 * Set the 'AggregatedContent' attribute value.
                 * 
                 * @param aggregatedContent
                 */
                public void setAggregatedContent(Boolean aggregatedContent) {
                    this.aggregatedContent = aggregatedContent;
                }

                /** 
                 * Get the 'FlexFaresSequenceNmbr' attribute value.
                 * 
                 * @return value
                 */
                public String getFlexFaresSequenceNmbr() {
                    return flexFaresSequenceNmbr;
                }

                /** 
                 * Set the 'FlexFaresSequenceNmbr' attribute value.
                 * 
                 * @param flexFaresSequenceNmbr
                 */
                public void setFlexFaresSequenceNmbr(
                        String flexFaresSequenceNmbr) {
                    this.flexFaresSequenceNmbr = flexFaresSequenceNmbr;
                }

                /** 
                 * Get the 'PricingSubSource' attribute value.
                 * 
                 * @return value
                 */
                public String getPricingSubSource() {
                    return pricingSubSource;
                }

                /** 
                 * Set the 'PricingSubSource' attribute value.
                 * 
                 * @param pricingSubSource
                 */
                public void setPricingSubSource(String pricingSubSource) {
                    this.pricingSubSource = pricingSubSource;
                }

                /** 
                 * Get the 'SolutionSequenceNmbr' attribute value.
                 * 
                 * @return value
                 */
                public String getSolutionSequenceNmbr() {
                    return solutionSequenceNmbr;
                }

                /** 
                 * Set the 'SolutionSequenceNmbr' attribute value.
                 * 
                 * @param solutionSequenceNmbr
                 */
                public void setSolutionSequenceNmbr(String solutionSequenceNmbr) {
                    this.solutionSequenceNmbr = solutionSequenceNmbr;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidatingCarrier" minOccurs="0" maxOccurs="9">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="SettlementMethod" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="DefaultValidatingCarrier" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="AlternateValidatingCarrier" minOccurs="0" maxOccurs="24"/>
                 *       &lt;xs:element type="xs:string" name="IETCheckedValidatingCarrier" minOccurs="0" maxOccurs="24"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="NewValidatingProcess"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ValidatingCarrier implements Serializable
                {
                    private String settlementMethod;
                    private String defaultValidatingCarrier;
                    private List<String> alternateValidatingCarrierList = new ArrayList<String>();
                    private List<String> IETCheckedValidatingCarrierList = new ArrayList<String>();
                    private Boolean newValidatingProcess;

                    /** 
                     * Get the 'SettlementMethod' element value.
                     * 
                     * @return value
                     */
                    public String getSettlementMethod() {
                        return settlementMethod;
                    }

                    /** 
                     * Set the 'SettlementMethod' element value.
                     * 
                     * @param settlementMethod
                     */
                    public void setSettlementMethod(String settlementMethod) {
                        this.settlementMethod = settlementMethod;
                    }

                    /** 
                     * Get the 'DefaultValidatingCarrier' element value.
                     * 
                     * @return value
                     */
                    public String getDefaultValidatingCarrier() {
                        return defaultValidatingCarrier;
                    }

                    /** 
                     * Set the 'DefaultValidatingCarrier' element value.
                     * 
                     * @param defaultValidatingCarrier
                     */
                    public void setDefaultValidatingCarrier(
                            String defaultValidatingCarrier) {
                        this.defaultValidatingCarrier = defaultValidatingCarrier;
                    }

                    /** 
                     * Get the list of 'AlternateValidatingCarrier' element items.
                     * 
                     * @return list
                     */
                    public List<String> getAlternateValidatingCarrierList() {
                        return alternateValidatingCarrierList;
                    }

                    /** 
                     * Set the list of 'AlternateValidatingCarrier' element items.
                     * 
                     * @param list
                     */
                    public void setAlternateValidatingCarrierList(
                            List<String> list) {
                        alternateValidatingCarrierList = list;
                    }

                    /** 
                     * Get the list of 'IETCheckedValidatingCarrier' element items.
                     * 
                     * @return list
                     */
                    public List<String> getIETCheckedValidatingCarrierList() {
                        return IETCheckedValidatingCarrierList;
                    }

                    /** 
                     * Set the list of 'IETCheckedValidatingCarrier' element items.
                     * 
                     * @param list
                     */
                    public void setIETCheckedValidatingCarrierList(
                            List<String> list) {
                        IETCheckedValidatingCarrierList = list;
                    }

                    /** 
                     * Get the 'NewValidatingProcess' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getNewValidatingProcess() {
                        return newValidatingProcess;
                    }

                    /** 
                     * Set the 'NewValidatingProcess' attribute value.
                     * 
                     * @param newValidatingProcess
                     */
                    public void setNewValidatingProcess(
                            Boolean newValidatingProcess) {
                        this.newValidatingProcess = newValidatingProcess;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationOption" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class FlightSegment -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OriginDestinationOption implements Serializable
            {
                private List<FlightSegment> flightSegmentList = new ArrayList<FlightSegment>();

                /** 
                 * Get the list of 'FlightSegment' element items.
                 * 
                 * @return list
                 */
                public List<FlightSegment> getFlightSegmentList() {
                    return flightSegmentList;
                }

                /** 
                 * Set the list of 'FlightSegment' element items.
                 * 
                 * @param list
                 */
                public void setFlightSegmentList(List<FlightSegment> list) {
                    flightSegmentList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="DestinationLocation" minOccurs="0">
                 *         &lt;!-- Reference to inner class DestinationLocation -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Equipment" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Equipment -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FlightDetails" minOccurs="0">
                 *         &lt;!-- Reference to inner class FlightDetails -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="IntermediatePointInfo" minOccurs="0">
                 *         &lt;!-- Reference to inner class IntermediatePointInfo -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="MarketingAirline" minOccurs="0">
                 *         &lt;!-- Reference to inner class MarketingAirline -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="MarriageGrp" minOccurs="0">
                 *         &lt;!-- Reference to inner class MarriageGrp -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Meal" minOccurs="0" maxOccurs="5">
                 *         &lt;!-- Reference to inner class Meal -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="OperatingAirline" minOccurs="0">
                 *         &lt;!-- Reference to inner class OperatingAirline -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="OriginLocation" minOccurs="0">
                 *         &lt;!-- Reference to inner class OriginLocation -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="AirMilesFlown"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ArrivalDateTime"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ConnectionInd"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="DestinationTimeZone"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="DivideResBookDesigCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ElapsedTime"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="eTicket"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="MarketingCabin"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="OnTimeRate"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="OriginTimeZone"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="SmokingAllowed"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="StopQuantity"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FlightSegment implements Serializable
                {
                    private DestinationLocation destinationLocation;
                    private List<Equipment> equipmentList = new ArrayList<Equipment>();
                    private FlightDetails flightDetails;
                    private IntermediatePointInfo intermediatePointInfo;
                    private MarketingAirline marketingAirline;
                    private MarriageGrp marriageGrp;
                    private List<Meal> mealList = new ArrayList<Meal>();
                    private OperatingAirline operatingAirline;
                    private OriginLocation originLocation;
                    private String airMilesFlown;
                    private String arrivalDateTime;
                    private String connectionInd;
                    private String departureDateTime;
                    private String destinationTimeZone;
                    private String divideResBookDesigCode;
                    private String elapsedTime;
                    private Boolean ETicket;
                    private String flightNumber;
                    private String marketingCabin;
                    private String onTimeRate;
                    private String originTimeZone;
                    private String resBookDesigCode;
                    private String RPH;
                    private Boolean smokingAllowed;
                    private String stopQuantity;

                    /** 
                     * Get the 'DestinationLocation' element value.
                     * 
                     * @return value
                     */
                    public DestinationLocation getDestinationLocation() {
                        return destinationLocation;
                    }

                    /** 
                     * Set the 'DestinationLocation' element value.
                     * 
                     * @param destinationLocation
                     */
                    public void setDestinationLocation(
                            DestinationLocation destinationLocation) {
                        this.destinationLocation = destinationLocation;
                    }

                    /** 
                     * Get the list of 'Equipment' element items.
                     * 
                     * @return list
                     */
                    public List<Equipment> getEquipmentList() {
                        return equipmentList;
                    }

                    /** 
                     * Set the list of 'Equipment' element items.
                     * 
                     * @param list
                     */
                    public void setEquipmentList(List<Equipment> list) {
                        equipmentList = list;
                    }

                    /** 
                     * Get the 'FlightDetails' element value.
                     * 
                     * @return value
                     */
                    public FlightDetails getFlightDetails() {
                        return flightDetails;
                    }

                    /** 
                     * Set the 'FlightDetails' element value.
                     * 
                     * @param flightDetails
                     */
                    public void setFlightDetails(FlightDetails flightDetails) {
                        this.flightDetails = flightDetails;
                    }

                    /** 
                     * Get the 'IntermediatePointInfo' element value.
                     * 
                     * @return value
                     */
                    public IntermediatePointInfo getIntermediatePointInfo() {
                        return intermediatePointInfo;
                    }

                    /** 
                     * Set the 'IntermediatePointInfo' element value.
                     * 
                     * @param intermediatePointInfo
                     */
                    public void setIntermediatePointInfo(
                            IntermediatePointInfo intermediatePointInfo) {
                        this.intermediatePointInfo = intermediatePointInfo;
                    }

                    /** 
                     * Get the 'MarketingAirline' element value.
                     * 
                     * @return value
                     */
                    public MarketingAirline getMarketingAirline() {
                        return marketingAirline;
                    }

                    /** 
                     * Set the 'MarketingAirline' element value.
                     * 
                     * @param marketingAirline
                     */
                    public void setMarketingAirline(
                            MarketingAirline marketingAirline) {
                        this.marketingAirline = marketingAirline;
                    }

                    /** 
                     * Get the 'MarriageGrp' element value.
                     * 
                     * @return value
                     */
                    public MarriageGrp getMarriageGrp() {
                        return marriageGrp;
                    }

                    /** 
                     * Set the 'MarriageGrp' element value.
                     * 
                     * @param marriageGrp
                     */
                    public void setMarriageGrp(MarriageGrp marriageGrp) {
                        this.marriageGrp = marriageGrp;
                    }

                    /** 
                     * Get the list of 'Meal' element items.
                     * 
                     * @return list
                     */
                    public List<Meal> getMealList() {
                        return mealList;
                    }

                    /** 
                     * Set the list of 'Meal' element items.
                     * 
                     * @param list
                     */
                    public void setMealList(List<Meal> list) {
                        mealList = list;
                    }

                    /** 
                     * Get the 'OperatingAirline' element value.
                     * 
                     * @return value
                     */
                    public OperatingAirline getOperatingAirline() {
                        return operatingAirline;
                    }

                    /** 
                     * Set the 'OperatingAirline' element value.
                     * 
                     * @param operatingAirline
                     */
                    public void setOperatingAirline(
                            OperatingAirline operatingAirline) {
                        this.operatingAirline = operatingAirline;
                    }

                    /** 
                     * Get the 'OriginLocation' element value.
                     * 
                     * @return value
                     */
                    public OriginLocation getOriginLocation() {
                        return originLocation;
                    }

                    /** 
                     * Set the 'OriginLocation' element value.
                     * 
                     * @param originLocation
                     */
                    public void setOriginLocation(OriginLocation originLocation) {
                        this.originLocation = originLocation;
                    }

                    /** 
                     * Get the 'AirMilesFlown' attribute value.
                     * 
                     * @return value
                     */
                    public String getAirMilesFlown() {
                        return airMilesFlown;
                    }

                    /** 
                     * Set the 'AirMilesFlown' attribute value.
                     * 
                     * @param airMilesFlown
                     */
                    public void setAirMilesFlown(String airMilesFlown) {
                        this.airMilesFlown = airMilesFlown;
                    }

                    /** 
                     * Get the 'ArrivalDateTime' attribute value.
                     * 
                     * @return value
                     */
                    public String getArrivalDateTime() {
                        return arrivalDateTime;
                    }

                    /** 
                     * Set the 'ArrivalDateTime' attribute value.
                     * 
                     * @param arrivalDateTime
                     */
                    public void setArrivalDateTime(String arrivalDateTime) {
                        this.arrivalDateTime = arrivalDateTime;
                    }

                    /** 
                     * Get the 'ConnectionInd' attribute value.
                     * 
                     * @return value
                     */
                    public String getConnectionInd() {
                        return connectionInd;
                    }

                    /** 
                     * Set the 'ConnectionInd' attribute value.
                     * 
                     * @param connectionInd
                     */
                    public void setConnectionInd(String connectionInd) {
                        this.connectionInd = connectionInd;
                    }

                    /** 
                     * Get the 'DepartureDateTime' attribute value.
                     * 
                     * @return value
                     */
                    public String getDepartureDateTime() {
                        return departureDateTime;
                    }

                    /** 
                     * Set the 'DepartureDateTime' attribute value.
                     * 
                     * @param departureDateTime
                     */
                    public void setDepartureDateTime(String departureDateTime) {
                        this.departureDateTime = departureDateTime;
                    }

                    /** 
                     * Get the 'DestinationTimeZone' attribute value.
                     * 
                     * @return value
                     */
                    public String getDestinationTimeZone() {
                        return destinationTimeZone;
                    }

                    /** 
                     * Set the 'DestinationTimeZone' attribute value.
                     * 
                     * @param destinationTimeZone
                     */
                    public void setDestinationTimeZone(
                            String destinationTimeZone) {
                        this.destinationTimeZone = destinationTimeZone;
                    }

                    /** 
                     * Get the 'DivideResBookDesigCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getDivideResBookDesigCode() {
                        return divideResBookDesigCode;
                    }

                    /** 
                     * Set the 'DivideResBookDesigCode' attribute value.
                     * 
                     * @param divideResBookDesigCode
                     */
                    public void setDivideResBookDesigCode(
                            String divideResBookDesigCode) {
                        this.divideResBookDesigCode = divideResBookDesigCode;
                    }

                    /** 
                     * Get the 'ElapsedTime' attribute value.
                     * 
                     * @return value
                     */
                    public String getElapsedTime() {
                        return elapsedTime;
                    }

                    /** 
                     * Set the 'ElapsedTime' attribute value.
                     * 
                     * @param elapsedTime
                     */
                    public void setElapsedTime(String elapsedTime) {
                        this.elapsedTime = elapsedTime;
                    }

                    /** 
                     * Get the 'eTicket' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getETicket() {
                        return ETicket;
                    }

                    /** 
                     * Set the 'eTicket' attribute value.
                     * 
                     * @param eTicket
                     */
                    public void setETicket(Boolean eTicket) {
                        ETicket = eTicket;
                    }

                    /** 
                     * Get the 'FlightNumber' attribute value.
                     * 
                     * @return value
                     */
                    public String getFlightNumber() {
                        return flightNumber;
                    }

                    /** 
                     * Set the 'FlightNumber' attribute value.
                     * 
                     * @param flightNumber
                     */
                    public void setFlightNumber(String flightNumber) {
                        this.flightNumber = flightNumber;
                    }

                    /** 
                     * Get the 'MarketingCabin' attribute value.
                     * 
                     * @return value
                     */
                    public String getMarketingCabin() {
                        return marketingCabin;
                    }

                    /** 
                     * Set the 'MarketingCabin' attribute value.
                     * 
                     * @param marketingCabin
                     */
                    public void setMarketingCabin(String marketingCabin) {
                        this.marketingCabin = marketingCabin;
                    }

                    /** 
                     * Get the 'OnTimeRate' attribute value.
                     * 
                     * @return value
                     */
                    public String getOnTimeRate() {
                        return onTimeRate;
                    }

                    /** 
                     * Set the 'OnTimeRate' attribute value.
                     * 
                     * @param onTimeRate
                     */
                    public void setOnTimeRate(String onTimeRate) {
                        this.onTimeRate = onTimeRate;
                    }

                    /** 
                     * Get the 'OriginTimeZone' attribute value.
                     * 
                     * @return value
                     */
                    public String getOriginTimeZone() {
                        return originTimeZone;
                    }

                    /** 
                     * Set the 'OriginTimeZone' attribute value.
                     * 
                     * @param originTimeZone
                     */
                    public void setOriginTimeZone(String originTimeZone) {
                        this.originTimeZone = originTimeZone;
                    }

                    /** 
                     * Get the 'ResBookDesigCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getResBookDesigCode() {
                        return resBookDesigCode;
                    }

                    /** 
                     * Set the 'ResBookDesigCode' attribute value.
                     * 
                     * @param resBookDesigCode
                     */
                    public void setResBookDesigCode(String resBookDesigCode) {
                        this.resBookDesigCode = resBookDesigCode;
                    }

                    /** 
                     * Get the 'RPH' attribute value.
                     * 
                     * @return value
                     */
                    public String getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value.
                     * 
                     * @param RPH
                     */
                    public void setRPH(String RPH) {
                        this.RPH = RPH;
                    }

                    /** 
                     * Get the 'SmokingAllowed' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getSmokingAllowed() {
                        return smokingAllowed;
                    }

                    /** 
                     * Set the 'SmokingAllowed' attribute value.
                     * 
                     * @param smokingAllowed
                     */
                    public void setSmokingAllowed(Boolean smokingAllowed) {
                        this.smokingAllowed = smokingAllowed;
                    }

                    /** 
                     * Get the 'StopQuantity' attribute value.
                     * 
                     * @return value
                     */
                    public String getStopQuantity() {
                        return stopQuantity;
                    }

                    /** 
                     * Set the 'StopQuantity' attribute value.
                     * 
                     * @param stopQuantity
                     */
                    public void setStopQuantity(String stopQuantity) {
                        this.stopQuantity = stopQuantity;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class DestinationLocation implements
                        Serializable
                    {
                        private String locationCode;

                        /** 
                         * Get the 'LocationCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getLocationCode() {
                            return locationCode;
                        }

                        /** 
                         * Set the 'LocationCode' attribute value.
                         * 
                         * @param locationCode
                         */
                        public void setLocationCode(String locationCode) {
                            this.locationCode = locationCode;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Equipment" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="AirEquipType"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Equipment implements Serializable
                    {
                        private String airEquipType;

                        /** 
                         * Get the 'AirEquipType' attribute value.
                         * 
                         * @return value
                         */
                        public String getAirEquipType() {
                            return airEquipType;
                        }

                        /** 
                         * Set the 'AirEquipType' attribute value.
                         * 
                         * @param airEquipType
                         */
                        public void setAirEquipType(String airEquipType) {
                            this.airEquipType = airEquipType;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightDetails" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="TrafficRestrictionCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FlightDetails implements Serializable
                    {
                        private String text;
                        private String trafficRestrictionCode;

                        /** 
                         * Get the 'Text' element value.
                         * 
                         * @return value
                         */
                        public String getText() {
                            return text;
                        }

                        /** 
                         * Set the 'Text' element value.
                         * 
                         * @param text
                         */
                        public void setText(String text) {
                            this.text = text;
                        }

                        /** 
                         * Get the 'TrafficRestrictionCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getTrafficRestrictionCode() {
                            return trafficRestrictionCode;
                        }

                        /** 
                         * Set the 'TrafficRestrictionCode' attribute value.
                         * 
                         * @param trafficRestrictionCode
                         */
                        public void setTrafficRestrictionCode(
                                String trafficRestrictionCode) {
                            this.trafficRestrictionCode = trafficRestrictionCode;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IntermediatePointInfo" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class FlightSegmentInner -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class IntermediatePointInfo implements
                        Serializable
                    {
                        private List<FlightSegmentInner> flightSegmentList = new ArrayList<FlightSegmentInner>();

                        /** 
                         * Get the list of 'FlightSegment' element items.
                         * 
                         * @return list
                         */
                        public List<FlightSegmentInner> getFlightSegmentList() {
                            return flightSegmentList;
                        }

                        /** 
                         * Set the list of 'FlightSegment' element items.
                         * 
                         * @param list
                         */
                        public void setFlightSegmentList(
                                List<FlightSegmentInner> list) {
                            flightSegmentList = list;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Equipment" minOccurs="0">
                         *         &lt;!-- Reference to inner class Equipment -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="IntermediateLocation" minOccurs="0">
                         *         &lt;!-- Reference to inner class IntermediateLocation -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ArrivalDateTime"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Duration"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ElapsedTime"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="IntermediateTimeZone"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class FlightSegmentInner implements
                            Serializable
                        {
                            private Equipment equipment;
                            private IntermediateLocation intermediateLocation;
                            private String arrivalDateTime;
                            private String departureDateTime;
                            private String duration;
                            private String elapsedTime;
                            private String intermediateTimeZone;
                            private String RPH;

                            /** 
                             * Get the 'Equipment' element value.
                             * 
                             * @return value
                             */
                            public Equipment getEquipment() {
                                return equipment;
                            }

                            /** 
                             * Set the 'Equipment' element value.
                             * 
                             * @param equipment
                             */
                            public void setEquipment(Equipment equipment) {
                                this.equipment = equipment;
                            }

                            /** 
                             * Get the 'IntermediateLocation' element value.
                             * 
                             * @return value
                             */
                            public IntermediateLocation getIntermediateLocation() {
                                return intermediateLocation;
                            }

                            /** 
                             * Set the 'IntermediateLocation' element value.
                             * 
                             * @param intermediateLocation
                             */
                            public void setIntermediateLocation(
                                    IntermediateLocation intermediateLocation) {
                                this.intermediateLocation = intermediateLocation;
                            }

                            /** 
                             * Get the 'ArrivalDateTime' attribute value.
                             * 
                             * @return value
                             */
                            public String getArrivalDateTime() {
                                return arrivalDateTime;
                            }

                            /** 
                             * Set the 'ArrivalDateTime' attribute value.
                             * 
                             * @param arrivalDateTime
                             */
                            public void setArrivalDateTime(
                                    String arrivalDateTime) {
                                this.arrivalDateTime = arrivalDateTime;
                            }

                            /** 
                             * Get the 'DepartureDateTime' attribute value.
                             * 
                             * @return value
                             */
                            public String getDepartureDateTime() {
                                return departureDateTime;
                            }

                            /** 
                             * Set the 'DepartureDateTime' attribute value.
                             * 
                             * @param departureDateTime
                             */
                            public void setDepartureDateTime(
                                    String departureDateTime) {
                                this.departureDateTime = departureDateTime;
                            }

                            /** 
                             * Get the 'Duration' attribute value.
                             * 
                             * @return value
                             */
                            public String getDuration() {
                                return duration;
                            }

                            /** 
                             * Set the 'Duration' attribute value.
                             * 
                             * @param duration
                             */
                            public void setDuration(String duration) {
                                this.duration = duration;
                            }

                            /** 
                             * Get the 'ElapsedTime' attribute value.
                             * 
                             * @return value
                             */
                            public String getElapsedTime() {
                                return elapsedTime;
                            }

                            /** 
                             * Set the 'ElapsedTime' attribute value.
                             * 
                             * @param elapsedTime
                             */
                            public void setElapsedTime(String elapsedTime) {
                                this.elapsedTime = elapsedTime;
                            }

                            /** 
                             * Get the 'IntermediateTimeZone' attribute value.
                             * 
                             * @return value
                             */
                            public String getIntermediateTimeZone() {
                                return intermediateTimeZone;
                            }

                            /** 
                             * Set the 'IntermediateTimeZone' attribute value.
                             * 
                             * @param intermediateTimeZone
                             */
                            public void setIntermediateTimeZone(
                                    String intermediateTimeZone) {
                                this.intermediateTimeZone = intermediateTimeZone;
                            }

                            /** 
                             * Get the 'RPH' attribute value.
                             * 
                             * @return value
                             */
                            public String getRPH() {
                                return RPH;
                            }

                            /** 
                             * Set the 'RPH' attribute value.
                             * 
                             * @param RPH
                             */
                            public void setRPH(String RPH) {
                                this.RPH = RPH;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Equipment" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="AirEquipType"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Equipment implements
                                Serializable
                            {
                                private String airEquipType;

                                /** 
                                 * Get the 'AirEquipType' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getAirEquipType() {
                                    return airEquipType;
                                }

                                /** 
                                 * Set the 'AirEquipType' attribute value.
                                 * 
                                 * @param airEquipType
                                 */
                                public void setAirEquipType(String airEquipType) {
                                    this.airEquipType = airEquipType;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IntermediateLocation" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class IntermediateLocation implements
                                Serializable
                            {
                                private String locationCode;

                                /** 
                                 * Get the 'LocationCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getLocationCode() {
                                    return locationCode;
                                }

                                /** 
                                 * Set the 'LocationCode' attribute value.
                                 * 
                                 * @param locationCode
                                 */
                                public void setLocationCode(String locationCode) {
                                    this.locationCode = locationCode;
                                }
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingAirline" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class MarketingAirline implements
                        Serializable
                    {
                        private String code;
                        private String flightNumber;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'FlightNumber' attribute value.
                         * 
                         * @return value
                         */
                        public String getFlightNumber() {
                            return flightNumber;
                        }

                        /** 
                         * Set the 'FlightNumber' attribute value.
                         * 
                         * @param flightNumber
                         */
                        public void setFlightNumber(String flightNumber) {
                            this.flightNumber = flightNumber;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarriageGrp" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class MarriageGrp implements Serializable
                    {
                        private String ind;

                        /** 
                         * Get the 'Ind' attribute value.
                         * 
                         * @return value
                         */
                        public String getInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value.
                         * 
                         * @param ind
                         */
                        public void setInd(String ind) {
                            this.ind = ind;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Meal" minOccurs="0" maxOccurs="5">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="MealCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Meal implements Serializable
                    {
                        private String mealCode;

                        /** 
                         * Get the 'MealCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getMealCode() {
                            return mealCode;
                        }

                        /** 
                         * Set the 'MealCode' attribute value.
                         * 
                         * @param mealCode
                         */
                        public void setMealCode(String mealCode) {
                            this.mealCode = mealCode;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperatingAirline" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CompanyShortName"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class OperatingAirline implements
                        Serializable
                    {
                        private String code;
                        private String companyShortName;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'CompanyShortName' attribute value.
                         * 
                         * @return value
                         */
                        public String getCompanyShortName() {
                            return companyShortName;
                        }

                        /** 
                         * Set the 'CompanyShortName' attribute value.
                         * 
                         * @param companyShortName
                         */
                        public void setCompanyShortName(String companyShortName) {
                            this.companyShortName = companyShortName;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class OriginLocation implements Serializable
                    {
                        private String locationCode;

                        /** 
                         * Get the 'LocationCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getLocationCode() {
                            return locationCode;
                        }

                        /** 
                         * Set the 'LocationCode' attribute value.
                         * 
                         * @param locationCode
                         */
                        public void setLocationCode(String locationCode) {
                            this.locationCode = locationCode;
                        }
                    }
                }
            }
        }
    }
}
